// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package logger

import (
	"testing"
)

func Test_Logger(t *testing.T) {
	for _, testCase := range []struct {
		expected string
		level    Level
		call     func(MessageInterface, string, ...any)
	}{
		{expected: "level=INFO ", level: Info, call: func(logger MessageInterface, message string, args ...any) { logger.Message(message, args...) }},
		{expected: "level=DEBUG-1 ", level: Trace, call: func(logger MessageInterface, message string, args ...any) { logger.Trace(message, args...) }},
		{expected: "level=DEBUG ", level: Debug, call: func(logger MessageInterface, message string, args ...any) { logger.Debug(message, args...) }},
		{expected: "level=INFO ", level: Info, call: func(logger MessageInterface, message string, args ...any) { logger.Info(message, args...) }},
		{expected: "level=WARN ", level: Warn, call: func(logger MessageInterface, message string, args ...any) { logger.Warn(message, args...) }},
		{expected: "level=ERROR ", level: Error, call: func(logger MessageInterface, message string, args ...any) { logger.Error(message, args...) }},
		{expected: "level=ERROR+1 ", level: Fatal, call: func(logger MessageInterface, message string, args ...any) { logger.Fatal(message, args...) }},
	} {
		t.Run(testCase.expected+testCase.level.String(), func(t *testing.T) {
			testLoggerCase(t, testCase.expected, testCase.level, testCase.call)
		})
	}
}
