//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armauthorization

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccessReviewActorIdentity.
func (a AccessReviewActorIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", a.PrincipalID)
	populate(objectMap, "principalName", a.PrincipalName)
	populate(objectMap, "principalType", a.PrincipalType)
	populate(objectMap, "userPrincipalName", a.UserPrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewActorIdentity.
func (a *AccessReviewActorIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &a.PrincipalID)
			delete(rawMsg, key)
		case "principalName":
			err = unpopulate(val, "PrincipalName", &a.PrincipalName)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &a.PrincipalType)
			delete(rawMsg, key)
		case "userPrincipalName":
			err = unpopulate(val, "UserPrincipalName", &a.UserPrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewContactedReviewer.
func (a AccessReviewContactedReviewer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewContactedReviewer.
func (a *AccessReviewContactedReviewer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewContactedReviewerListResult.
func (a AccessReviewContactedReviewerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewContactedReviewerListResult.
func (a *AccessReviewContactedReviewerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewContactedReviewerProperties.
func (a AccessReviewContactedReviewerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDateTime", a.CreatedDateTime)
	populate(objectMap, "userDisplayName", a.UserDisplayName)
	populate(objectMap, "userPrincipalName", a.UserPrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewContactedReviewerProperties.
func (a *AccessReviewContactedReviewerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDateTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateTime", &a.CreatedDateTime)
			delete(rawMsg, key)
		case "userDisplayName":
			err = unpopulate(val, "UserDisplayName", &a.UserDisplayName)
			delete(rawMsg, key)
		case "userPrincipalName":
			err = unpopulate(val, "UserPrincipalName", &a.UserPrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecision.
func (a AccessReviewDecision) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecision.
func (a *AccessReviewDecision) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecisionIdentity.
func (a AccessReviewDecisionIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "id", a.ID)
	objectMap["type"] = a.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecisionIdentity.
func (a *AccessReviewDecisionIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecisionInsight.
func (a AccessReviewDecisionInsight) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecisionInsight.
func (a *AccessReviewDecisionInsight) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			a.Properties, err = unmarshalAccessReviewDecisionInsightPropertiesClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecisionInsightProperties.
func (a AccessReviewDecisionInsightProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "insightCreatedDateTime", a.InsightCreatedDateTime)
	objectMap["type"] = a.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecisionInsightProperties.
func (a *AccessReviewDecisionInsightProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "insightCreatedDateTime":
			err = unpopulate(val, "InsightCreatedDateTime", &a.InsightCreatedDateTime)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecisionListResult.
func (a AccessReviewDecisionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecisionListResult.
func (a *AccessReviewDecisionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecisionPrincipalResourceMembership.
func (a AccessReviewDecisionPrincipalResourceMembership) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "membershipTypes", a.MembershipTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecisionPrincipalResourceMembership.
func (a *AccessReviewDecisionPrincipalResourceMembership) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "membershipTypes":
			err = unpopulate(val, "MembershipTypes", &a.MembershipTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecisionProperties.
func (a AccessReviewDecisionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedBy", a.AppliedBy)
	populateDateTimeRFC3339(objectMap, "appliedDateTime", a.AppliedDateTime)
	populate(objectMap, "applyResult", a.ApplyResult)
	populate(objectMap, "decision", a.Decision)
	populate(objectMap, "insights", a.Insights)
	populate(objectMap, "justification", a.Justification)
	populate(objectMap, "principal", a.Principal)
	populate(objectMap, "principalResourceMembership", a.PrincipalResourceMembership)
	populate(objectMap, "recommendation", a.Recommendation)
	populate(objectMap, "resource", a.Resource)
	populate(objectMap, "reviewedBy", a.ReviewedBy)
	populateDateTimeRFC3339(objectMap, "reviewedDateTime", a.ReviewedDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecisionProperties.
func (a *AccessReviewDecisionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedBy":
			err = unpopulate(val, "AppliedBy", &a.AppliedBy)
			delete(rawMsg, key)
		case "appliedDateTime":
			err = unpopulateDateTimeRFC3339(val, "AppliedDateTime", &a.AppliedDateTime)
			delete(rawMsg, key)
		case "applyResult":
			err = unpopulate(val, "ApplyResult", &a.ApplyResult)
			delete(rawMsg, key)
		case "decision":
			err = unpopulate(val, "Decision", &a.Decision)
			delete(rawMsg, key)
		case "insights":
			err = unpopulate(val, "Insights", &a.Insights)
			delete(rawMsg, key)
		case "justification":
			err = unpopulate(val, "Justification", &a.Justification)
			delete(rawMsg, key)
		case "principal":
			a.Principal, err = unmarshalAccessReviewDecisionIdentityClassification(val)
			delete(rawMsg, key)
		case "principalResourceMembership":
			err = unpopulate(val, "PrincipalResourceMembership", &a.PrincipalResourceMembership)
			delete(rawMsg, key)
		case "recommendation":
			err = unpopulate(val, "Recommendation", &a.Recommendation)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &a.Resource)
			delete(rawMsg, key)
		case "reviewedBy":
			err = unpopulate(val, "ReviewedBy", &a.ReviewedBy)
			delete(rawMsg, key)
		case "reviewedDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewedDateTime", &a.ReviewedDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecisionResource.
func (a AccessReviewDecisionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecisionResource.
func (a *AccessReviewDecisionResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecisionServicePrincipalIdentity.
func (a AccessReviewDecisionServicePrincipalIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", a.AppID)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "id", a.ID)
	objectMap["type"] = DecisionTargetTypeServicePrincipal
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecisionServicePrincipalIdentity.
func (a *AccessReviewDecisionServicePrincipalIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &a.AppID)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecisionUserIdentity.
func (a AccessReviewDecisionUserIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "id", a.ID)
	objectMap["type"] = DecisionTargetTypeUser
	populate(objectMap, "userPrincipalName", a.UserPrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecisionUserIdentity.
func (a *AccessReviewDecisionUserIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "userPrincipalName":
			err = unpopulate(val, "UserPrincipalName", &a.UserPrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDecisionUserSignInInsightProperties.
func (a AccessReviewDecisionUserSignInInsightProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "insightCreatedDateTime", a.InsightCreatedDateTime)
	populateAny(objectMap, "lastSignInDateTime", a.LastSignInDateTime)
	objectMap["type"] = AccessReviewDecisionInsightTypeUserSignInInsight
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDecisionUserSignInInsightProperties.
func (a *AccessReviewDecisionUserSignInInsightProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "insightCreatedDateTime":
			err = unpopulate(val, "InsightCreatedDateTime", &a.InsightCreatedDateTime)
			delete(rawMsg, key)
		case "lastSignInDateTime":
			err = unpopulate(val, "LastSignInDateTime", &a.LastSignInDateTime)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewDefaultSettings.
func (a AccessReviewDefaultSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewDefaultSettings.
func (a *AccessReviewDefaultSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewHistoryDefinition.
func (a AccessReviewHistoryDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewHistoryDefinition.
func (a *AccessReviewHistoryDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewHistoryDefinitionInstanceListResult.
func (a AccessReviewHistoryDefinitionInstanceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewHistoryDefinitionInstanceListResult.
func (a *AccessReviewHistoryDefinitionInstanceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewHistoryDefinitionListResult.
func (a AccessReviewHistoryDefinitionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewHistoryDefinitionListResult.
func (a *AccessReviewHistoryDefinitionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewHistoryDefinitionProperties.
func (a AccessReviewHistoryDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createdBy", a.CreatedBy)
	populateDateTimeRFC3339(objectMap, "createdDateTime", a.CreatedDateTime)
	populate(objectMap, "decisions", a.Decisions)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "instances", a.Instances)
	populateDateTimeRFC3339(objectMap, "reviewHistoryPeriodEndDateTime", a.ReviewHistoryPeriodEndDateTime)
	populateDateTimeRFC3339(objectMap, "reviewHistoryPeriodStartDateTime", a.ReviewHistoryPeriodStartDateTime)
	populate(objectMap, "scopes", a.Scopes)
	populate(objectMap, "settings", a.Settings)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewHistoryDefinitionProperties.
func (a *AccessReviewHistoryDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &a.CreatedBy)
			delete(rawMsg, key)
		case "createdDateTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateTime", &a.CreatedDateTime)
			delete(rawMsg, key)
		case "decisions":
			err = unpopulate(val, "Decisions", &a.Decisions)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "instances":
			err = unpopulate(val, "Instances", &a.Instances)
			delete(rawMsg, key)
		case "reviewHistoryPeriodEndDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewHistoryPeriodEndDateTime", &a.ReviewHistoryPeriodEndDateTime)
			delete(rawMsg, key)
		case "reviewHistoryPeriodStartDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewHistoryPeriodStartDateTime", &a.ReviewHistoryPeriodStartDateTime)
			delete(rawMsg, key)
		case "scopes":
			err = unpopulate(val, "Scopes", &a.Scopes)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &a.Settings)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewHistoryInstance.
func (a AccessReviewHistoryInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewHistoryInstance.
func (a *AccessReviewHistoryInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewHistoryInstanceProperties.
func (a AccessReviewHistoryInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "downloadUri", a.DownloadURI)
	populateDateTimeRFC3339(objectMap, "expiration", a.Expiration)
	populateDateTimeRFC3339(objectMap, "fulfilledDateTime", a.FulfilledDateTime)
	populateDateTimeRFC3339(objectMap, "reviewHistoryPeriodEndDateTime", a.ReviewHistoryPeriodEndDateTime)
	populateDateTimeRFC3339(objectMap, "reviewHistoryPeriodStartDateTime", a.ReviewHistoryPeriodStartDateTime)
	populateDateTimeRFC3339(objectMap, "runDateTime", a.RunDateTime)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewHistoryInstanceProperties.
func (a *AccessReviewHistoryInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "downloadUri":
			err = unpopulate(val, "DownloadURI", &a.DownloadURI)
			delete(rawMsg, key)
		case "expiration":
			err = unpopulateDateTimeRFC3339(val, "Expiration", &a.Expiration)
			delete(rawMsg, key)
		case "fulfilledDateTime":
			err = unpopulateDateTimeRFC3339(val, "FulfilledDateTime", &a.FulfilledDateTime)
			delete(rawMsg, key)
		case "reviewHistoryPeriodEndDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewHistoryPeriodEndDateTime", &a.ReviewHistoryPeriodEndDateTime)
			delete(rawMsg, key)
		case "reviewHistoryPeriodStartDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewHistoryPeriodStartDateTime", &a.ReviewHistoryPeriodStartDateTime)
			delete(rawMsg, key)
		case "runDateTime":
			err = unpopulateDateTimeRFC3339(val, "RunDateTime", &a.RunDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewHistoryScheduleSettings.
func (a AccessReviewHistoryScheduleSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "pattern", a.Pattern)
	populate(objectMap, "range", a.Range)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewHistoryScheduleSettings.
func (a *AccessReviewHistoryScheduleSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "pattern":
			err = unpopulate(val, "Pattern", &a.Pattern)
			delete(rawMsg, key)
		case "range":
			err = unpopulate(val, "Range", &a.Range)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewInstance.
func (a AccessReviewInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewInstance.
func (a *AccessReviewInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewInstanceListResult.
func (a AccessReviewInstanceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewInstanceListResult.
func (a *AccessReviewInstanceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewInstanceProperties.
func (a AccessReviewInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupReviewers", a.BackupReviewers)
	populateDateTimeRFC3339(objectMap, "endDateTime", a.EndDateTime)
	populate(objectMap, "reviewers", a.Reviewers)
	populate(objectMap, "reviewersType", a.ReviewersType)
	populateDateTimeRFC3339(objectMap, "startDateTime", a.StartDateTime)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewInstanceProperties.
func (a *AccessReviewInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupReviewers":
			err = unpopulate(val, "BackupReviewers", &a.BackupReviewers)
			delete(rawMsg, key)
		case "endDateTime":
			err = unpopulateDateTimeRFC3339(val, "EndDateTime", &a.EndDateTime)
			delete(rawMsg, key)
		case "reviewers":
			err = unpopulate(val, "Reviewers", &a.Reviewers)
			delete(rawMsg, key)
		case "reviewersType":
			err = unpopulate(val, "ReviewersType", &a.ReviewersType)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateDateTimeRFC3339(val, "StartDateTime", &a.StartDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewRecurrencePattern.
func (a AccessReviewRecurrencePattern) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "interval", a.Interval)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewRecurrencePattern.
func (a *AccessReviewRecurrencePattern) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "interval":
			err = unpopulate(val, "Interval", &a.Interval)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewRecurrenceRange.
func (a AccessReviewRecurrenceRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endDate", a.EndDate)
	populate(objectMap, "numberOfOccurrences", a.NumberOfOccurrences)
	populateDateTimeRFC3339(objectMap, "startDate", a.StartDate)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewRecurrenceRange.
func (a *AccessReviewRecurrenceRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endDate":
			err = unpopulateDateTimeRFC3339(val, "EndDate", &a.EndDate)
			delete(rawMsg, key)
		case "numberOfOccurrences":
			err = unpopulate(val, "NumberOfOccurrences", &a.NumberOfOccurrences)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateTimeRFC3339(val, "StartDate", &a.StartDate)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewRecurrenceSettings.
func (a AccessReviewRecurrenceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "pattern", a.Pattern)
	populate(objectMap, "range", a.Range)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewRecurrenceSettings.
func (a *AccessReviewRecurrenceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "pattern":
			err = unpopulate(val, "Pattern", &a.Pattern)
			delete(rawMsg, key)
		case "range":
			err = unpopulate(val, "Range", &a.Range)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewReviewer.
func (a AccessReviewReviewer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", a.PrincipalID)
	populate(objectMap, "principalType", a.PrincipalType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewReviewer.
func (a *AccessReviewReviewer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &a.PrincipalID)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &a.PrincipalType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewScheduleDefinition.
func (a AccessReviewScheduleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewScheduleDefinition.
func (a *AccessReviewScheduleDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewScheduleDefinitionListResult.
func (a AccessReviewScheduleDefinitionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewScheduleDefinitionListResult.
func (a *AccessReviewScheduleDefinitionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewScheduleDefinitionProperties.
func (a AccessReviewScheduleDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupReviewers", a.BackupReviewers)
	populate(objectMap, "createdBy", a.CreatedBy)
	populate(objectMap, "descriptionForAdmins", a.DescriptionForAdmins)
	populate(objectMap, "descriptionForReviewers", a.DescriptionForReviewers)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "instances", a.Instances)
	populate(objectMap, "reviewers", a.Reviewers)
	populate(objectMap, "reviewersType", a.ReviewersType)
	populate(objectMap, "scope", a.Scope)
	populate(objectMap, "settings", a.Settings)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewScheduleDefinitionProperties.
func (a *AccessReviewScheduleDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupReviewers":
			err = unpopulate(val, "BackupReviewers", &a.BackupReviewers)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &a.CreatedBy)
			delete(rawMsg, key)
		case "descriptionForAdmins":
			err = unpopulate(val, "DescriptionForAdmins", &a.DescriptionForAdmins)
			delete(rawMsg, key)
		case "descriptionForReviewers":
			err = unpopulate(val, "DescriptionForReviewers", &a.DescriptionForReviewers)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "instances":
			err = unpopulate(val, "Instances", &a.Instances)
			delete(rawMsg, key)
		case "reviewers":
			err = unpopulate(val, "Reviewers", &a.Reviewers)
			delete(rawMsg, key)
		case "reviewersType":
			err = unpopulate(val, "ReviewersType", &a.ReviewersType)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &a.Scope)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &a.Settings)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewScheduleSettings.
func (a AccessReviewScheduleSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoApplyDecisionsEnabled", a.AutoApplyDecisionsEnabled)
	populate(objectMap, "defaultDecision", a.DefaultDecision)
	populate(objectMap, "defaultDecisionEnabled", a.DefaultDecisionEnabled)
	populate(objectMap, "instanceDurationInDays", a.InstanceDurationInDays)
	populate(objectMap, "justificationRequiredOnApproval", a.JustificationRequiredOnApproval)
	populate(objectMap, "mailNotificationsEnabled", a.MailNotificationsEnabled)
	populate(objectMap, "recommendationLookBackDuration", a.RecommendationLookBackDuration)
	populate(objectMap, "recommendationsEnabled", a.RecommendationsEnabled)
	populate(objectMap, "recurrence", a.Recurrence)
	populate(objectMap, "reminderNotificationsEnabled", a.ReminderNotificationsEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewScheduleSettings.
func (a *AccessReviewScheduleSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoApplyDecisionsEnabled":
			err = unpopulate(val, "AutoApplyDecisionsEnabled", &a.AutoApplyDecisionsEnabled)
			delete(rawMsg, key)
		case "defaultDecision":
			err = unpopulate(val, "DefaultDecision", &a.DefaultDecision)
			delete(rawMsg, key)
		case "defaultDecisionEnabled":
			err = unpopulate(val, "DefaultDecisionEnabled", &a.DefaultDecisionEnabled)
			delete(rawMsg, key)
		case "instanceDurationInDays":
			err = unpopulate(val, "InstanceDurationInDays", &a.InstanceDurationInDays)
			delete(rawMsg, key)
		case "justificationRequiredOnApproval":
			err = unpopulate(val, "JustificationRequiredOnApproval", &a.JustificationRequiredOnApproval)
			delete(rawMsg, key)
		case "mailNotificationsEnabled":
			err = unpopulate(val, "MailNotificationsEnabled", &a.MailNotificationsEnabled)
			delete(rawMsg, key)
		case "recommendationLookBackDuration":
			err = unpopulate(val, "RecommendationLookBackDuration", &a.RecommendationLookBackDuration)
			delete(rawMsg, key)
		case "recommendationsEnabled":
			err = unpopulate(val, "RecommendationsEnabled", &a.RecommendationsEnabled)
			delete(rawMsg, key)
		case "recurrence":
			err = unpopulate(val, "Recurrence", &a.Recurrence)
			delete(rawMsg, key)
		case "reminderNotificationsEnabled":
			err = unpopulate(val, "ReminderNotificationsEnabled", &a.ReminderNotificationsEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessReviewScope.
func (a AccessReviewScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignmentState", a.AssignmentState)
	populate(objectMap, "excludeResourceId", a.ExcludeResourceID)
	populate(objectMap, "excludeRoleDefinitionId", a.ExcludeRoleDefinitionID)
	populate(objectMap, "expandNestedMemberships", a.ExpandNestedMemberships)
	populate(objectMap, "inactiveDuration", a.InactiveDuration)
	populate(objectMap, "includeAccessBelowResource", a.IncludeAccessBelowResource)
	populate(objectMap, "includeInheritedAccess", a.IncludeInheritedAccess)
	populate(objectMap, "principalType", a.PrincipalType)
	populate(objectMap, "resourceId", a.ResourceID)
	populate(objectMap, "roleDefinitionId", a.RoleDefinitionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessReviewScope.
func (a *AccessReviewScope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignmentState":
			err = unpopulate(val, "AssignmentState", &a.AssignmentState)
			delete(rawMsg, key)
		case "excludeResourceId":
			err = unpopulate(val, "ExcludeResourceID", &a.ExcludeResourceID)
			delete(rawMsg, key)
		case "excludeRoleDefinitionId":
			err = unpopulate(val, "ExcludeRoleDefinitionID", &a.ExcludeRoleDefinitionID)
			delete(rawMsg, key)
		case "expandNestedMemberships":
			err = unpopulate(val, "ExpandNestedMemberships", &a.ExpandNestedMemberships)
			delete(rawMsg, key)
		case "inactiveDuration":
			err = unpopulate(val, "InactiveDuration", &a.InactiveDuration)
			delete(rawMsg, key)
		case "includeAccessBelowResource":
			err = unpopulate(val, "IncludeAccessBelowResource", &a.IncludeAccessBelowResource)
			delete(rawMsg, key)
		case "includeInheritedAccess":
			err = unpopulate(val, "IncludeInheritedAccess", &a.IncludeInheritedAccess)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &a.PrincipalType)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &a.ResourceID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &a.RoleDefinitionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Alert.
func (a *Alert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertConfiguration.
func (a AlertConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertConfiguration.
func (a *AlertConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			a.Properties, err = unmarshalAlertConfigurationPropertiesClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertConfigurationListResult.
func (a AlertConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertConfigurationListResult.
func (a *AlertConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertConfigurationProperties.
func (a AlertConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["alertConfigurationType"] = a.AlertConfigurationType
	populate(objectMap, "alertDefinition", a.AlertDefinition)
	populate(objectMap, "alertDefinitionId", a.AlertDefinitionID)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populate(objectMap, "scope", a.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertConfigurationProperties.
func (a *AlertConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertConfigurationType":
			err = unpopulate(val, "AlertConfigurationType", &a.AlertConfigurationType)
			delete(rawMsg, key)
		case "alertDefinition":
			err = unpopulate(val, "AlertDefinition", &a.AlertDefinition)
			delete(rawMsg, key)
		case "alertDefinitionId":
			err = unpopulate(val, "AlertDefinitionID", &a.AlertDefinitionID)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &a.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertDefinition.
func (a AlertDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertDefinition.
func (a *AlertDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertDefinitionListResult.
func (a AlertDefinitionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertDefinitionListResult.
func (a *AlertDefinitionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertDefinitionProperties.
func (a AlertDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "howToPrevent", a.HowToPrevent)
	populate(objectMap, "isConfigurable", a.IsConfigurable)
	populate(objectMap, "isRemediatable", a.IsRemediatable)
	populate(objectMap, "mitigationSteps", a.MitigationSteps)
	populate(objectMap, "scope", a.Scope)
	populate(objectMap, "securityImpact", a.SecurityImpact)
	populate(objectMap, "severityLevel", a.SeverityLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertDefinitionProperties.
func (a *AlertDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "howToPrevent":
			err = unpopulate(val, "HowToPrevent", &a.HowToPrevent)
			delete(rawMsg, key)
		case "isConfigurable":
			err = unpopulate(val, "IsConfigurable", &a.IsConfigurable)
			delete(rawMsg, key)
		case "isRemediatable":
			err = unpopulate(val, "IsRemediatable", &a.IsRemediatable)
			delete(rawMsg, key)
		case "mitigationSteps":
			err = unpopulate(val, "MitigationSteps", &a.MitigationSteps)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &a.Scope)
			delete(rawMsg, key)
		case "securityImpact":
			err = unpopulate(val, "SecurityImpact", &a.SecurityImpact)
			delete(rawMsg, key)
		case "severityLevel":
			err = unpopulate(val, "SeverityLevel", &a.SeverityLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertIncident.
func (a AlertIncident) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertIncident.
func (a *AlertIncident) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			a.Properties, err = unmarshalAlertIncidentPropertiesClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertIncidentListResult.
func (a AlertIncidentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertIncidentListResult.
func (a *AlertIncidentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertIncidentProperties.
func (a AlertIncidentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["alertIncidentType"] = a.AlertIncidentType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertIncidentProperties.
func (a *AlertIncidentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertIncidentType":
			err = unpopulate(val, "AlertIncidentType", &a.AlertIncidentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertListResult.
func (a AlertListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertListResult.
func (a *AlertListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertOperationResult.
func (a AlertOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDateTime", a.CreatedDateTime)
	populate(objectMap, "id", a.ID)
	populateDateTimeRFC3339(objectMap, "lastActionDateTime", a.LastActionDateTime)
	populate(objectMap, "resourceLocation", a.ResourceLocation)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "statusDetail", a.StatusDetail)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertOperationResult.
func (a *AlertOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDateTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateTime", &a.CreatedDateTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "lastActionDateTime":
			err = unpopulateDateTimeRFC3339(val, "LastActionDateTime", &a.LastActionDateTime)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &a.ResourceLocation)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "statusDetail":
			err = unpopulate(val, "StatusDetail", &a.StatusDetail)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertProperties.
func (a AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertConfiguration", a.AlertConfiguration)
	populate(objectMap, "alertDefinition", a.AlertDefinition)
	populate(objectMap, "alertIncidents", a.AlertIncidents)
	populate(objectMap, "incidentCount", a.IncidentCount)
	populate(objectMap, "isActive", a.IsActive)
	populateDateTimeRFC3339(objectMap, "lastModifiedDateTime", a.LastModifiedDateTime)
	populateDateTimeRFC3339(objectMap, "lastScannedDateTime", a.LastScannedDateTime)
	populate(objectMap, "scope", a.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertProperties.
func (a *AlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertConfiguration":
			err = unpopulate(val, "AlertConfiguration", &a.AlertConfiguration)
			delete(rawMsg, key)
		case "alertDefinition":
			err = unpopulate(val, "AlertDefinition", &a.AlertDefinition)
			delete(rawMsg, key)
		case "alertIncidents":
			err = unpopulate(val, "AlertIncidents", &a.AlertIncidents)
			delete(rawMsg, key)
		case "incidentCount":
			err = unpopulate(val, "IncidentCount", &a.IncidentCount)
			delete(rawMsg, key)
		case "isActive":
			err = unpopulate(val, "IsActive", &a.IsActive)
			delete(rawMsg, key)
		case "lastModifiedDateTime":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedDateTime", &a.LastModifiedDateTime)
			delete(rawMsg, key)
		case "lastScannedDateTime":
			err = unpopulateDateTimeRFC3339(val, "LastScannedDateTime", &a.LastScannedDateTime)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &a.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApprovalSettings.
func (a ApprovalSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "approvalMode", a.ApprovalMode)
	populate(objectMap, "approvalStages", a.ApprovalStages)
	populate(objectMap, "isApprovalRequired", a.IsApprovalRequired)
	populate(objectMap, "isApprovalRequiredForExtension", a.IsApprovalRequiredForExtension)
	populate(objectMap, "isRequestorJustificationRequired", a.IsRequestorJustificationRequired)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApprovalSettings.
func (a *ApprovalSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "approvalMode":
			err = unpopulate(val, "ApprovalMode", &a.ApprovalMode)
			delete(rawMsg, key)
		case "approvalStages":
			err = unpopulate(val, "ApprovalStages", &a.ApprovalStages)
			delete(rawMsg, key)
		case "isApprovalRequired":
			err = unpopulate(val, "IsApprovalRequired", &a.IsApprovalRequired)
			delete(rawMsg, key)
		case "isApprovalRequiredForExtension":
			err = unpopulate(val, "IsApprovalRequiredForExtension", &a.IsApprovalRequiredForExtension)
			delete(rawMsg, key)
		case "isRequestorJustificationRequired":
			err = unpopulate(val, "IsRequestorJustificationRequired", &a.IsRequestorJustificationRequired)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApprovalStage.
func (a ApprovalStage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "approvalStageTimeOutInDays", a.ApprovalStageTimeOutInDays)
	populate(objectMap, "escalationApprovers", a.EscalationApprovers)
	populate(objectMap, "escalationTimeInMinutes", a.EscalationTimeInMinutes)
	populate(objectMap, "isApproverJustificationRequired", a.IsApproverJustificationRequired)
	populate(objectMap, "isEscalationEnabled", a.IsEscalationEnabled)
	populate(objectMap, "primaryApprovers", a.PrimaryApprovers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApprovalStage.
func (a *ApprovalStage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "approvalStageTimeOutInDays":
			err = unpopulate(val, "ApprovalStageTimeOutInDays", &a.ApprovalStageTimeOutInDays)
			delete(rawMsg, key)
		case "escalationApprovers":
			err = unpopulate(val, "EscalationApprovers", &a.EscalationApprovers)
			delete(rawMsg, key)
		case "escalationTimeInMinutes":
			err = unpopulate(val, "EscalationTimeInMinutes", &a.EscalationTimeInMinutes)
			delete(rawMsg, key)
		case "isApproverJustificationRequired":
			err = unpopulate(val, "IsApproverJustificationRequired", &a.IsApproverJustificationRequired)
			delete(rawMsg, key)
		case "isEscalationEnabled":
			err = unpopulate(val, "IsEscalationEnabled", &a.IsEscalationEnabled)
			delete(rawMsg, key)
		case "primaryApprovers":
			err = unpopulate(val, "PrimaryApprovers", &a.PrimaryApprovers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureRolesAssignedOutsidePimAlertConfigurationProperties.
func (a AzureRolesAssignedOutsidePimAlertConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["alertConfigurationType"] = "AzureRolesAssignedOutsidePimAlertConfiguration"
	populate(objectMap, "alertDefinition", a.AlertDefinition)
	populate(objectMap, "alertDefinitionId", a.AlertDefinitionID)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populate(objectMap, "scope", a.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureRolesAssignedOutsidePimAlertConfigurationProperties.
func (a *AzureRolesAssignedOutsidePimAlertConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertConfigurationType":
			err = unpopulate(val, "AlertConfigurationType", &a.AlertConfigurationType)
			delete(rawMsg, key)
		case "alertDefinition":
			err = unpopulate(val, "AlertDefinition", &a.AlertDefinition)
			delete(rawMsg, key)
		case "alertDefinitionId":
			err = unpopulate(val, "AlertDefinitionID", &a.AlertDefinitionID)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &a.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureRolesAssignedOutsidePimAlertIncidentProperties.
func (a AzureRolesAssignedOutsidePimAlertIncidentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["alertIncidentType"] = "AzureRolesAssignedOutsidePimAlertIncident"
	populate(objectMap, "assigneeDisplayName", a.AssigneeDisplayName)
	populate(objectMap, "assigneeId", a.AssigneeID)
	populate(objectMap, "assigneeUserPrincipalName", a.AssigneeUserPrincipalName)
	populateDateTimeRFC3339(objectMap, "assignmentActivatedDate", a.AssignmentActivatedDate)
	populate(objectMap, "requestorDisplayName", a.RequestorDisplayName)
	populate(objectMap, "requestorId", a.RequestorID)
	populate(objectMap, "requestorUserPrincipalName", a.RequestorUserPrincipalName)
	populate(objectMap, "roleDefinitionId", a.RoleDefinitionID)
	populate(objectMap, "roleDisplayName", a.RoleDisplayName)
	populate(objectMap, "roleTemplateId", a.RoleTemplateID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureRolesAssignedOutsidePimAlertIncidentProperties.
func (a *AzureRolesAssignedOutsidePimAlertIncidentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertIncidentType":
			err = unpopulate(val, "AlertIncidentType", &a.AlertIncidentType)
			delete(rawMsg, key)
		case "assigneeDisplayName":
			err = unpopulate(val, "AssigneeDisplayName", &a.AssigneeDisplayName)
			delete(rawMsg, key)
		case "assigneeId":
			err = unpopulate(val, "AssigneeID", &a.AssigneeID)
			delete(rawMsg, key)
		case "assigneeUserPrincipalName":
			err = unpopulate(val, "AssigneeUserPrincipalName", &a.AssigneeUserPrincipalName)
			delete(rawMsg, key)
		case "assignmentActivatedDate":
			err = unpopulateDateTimeRFC3339(val, "AssignmentActivatedDate", &a.AssignmentActivatedDate)
			delete(rawMsg, key)
		case "requestorDisplayName":
			err = unpopulate(val, "RequestorDisplayName", &a.RequestorDisplayName)
			delete(rawMsg, key)
		case "requestorId":
			err = unpopulate(val, "RequestorID", &a.RequestorID)
			delete(rawMsg, key)
		case "requestorUserPrincipalName":
			err = unpopulate(val, "RequestorUserPrincipalName", &a.RequestorUserPrincipalName)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &a.RoleDefinitionID)
			delete(rawMsg, key)
		case "roleDisplayName":
			err = unpopulate(val, "RoleDisplayName", &a.RoleDisplayName)
			delete(rawMsg, key)
		case "roleTemplateId":
			err = unpopulate(val, "RoleTemplateID", &a.RoleTemplateID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClassicAdministrator.
func (c ClassicAdministrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClassicAdministrator.
func (c *ClassicAdministrator) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClassicAdministratorListResult.
func (c ClassicAdministratorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClassicAdministratorListResult.
func (c *ClassicAdministratorListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClassicAdministratorProperties.
func (c ClassicAdministratorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "emailAddress", c.EmailAddress)
	populate(objectMap, "role", c.Role)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClassicAdministratorProperties.
func (c *ClassicAdministratorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "emailAddress":
			err = unpopulate(val, "EmailAddress", &c.EmailAddress)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &c.Role)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DenyAssignment.
func (d DenyAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DenyAssignment.
func (d *DenyAssignment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DenyAssignmentFilter.
func (d DenyAssignmentFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "denyAssignmentName", d.DenyAssignmentName)
	populate(objectMap, "gdprExportPrincipalId", d.GdprExportPrincipalID)
	populate(objectMap, "principalId", d.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DenyAssignmentFilter.
func (d *DenyAssignmentFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "denyAssignmentName":
			err = unpopulate(val, "DenyAssignmentName", &d.DenyAssignmentName)
			delete(rawMsg, key)
		case "gdprExportPrincipalId":
			err = unpopulate(val, "GdprExportPrincipalID", &d.GdprExportPrincipalID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &d.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DenyAssignmentListResult.
func (d DenyAssignmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DenyAssignmentListResult.
func (d *DenyAssignmentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DenyAssignmentPermission.
func (d DenyAssignmentPermission) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", d.Actions)
	populate(objectMap, "condition", d.Condition)
	populate(objectMap, "conditionVersion", d.ConditionVersion)
	populate(objectMap, "dataActions", d.DataActions)
	populate(objectMap, "notActions", d.NotActions)
	populate(objectMap, "notDataActions", d.NotDataActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DenyAssignmentPermission.
func (d *DenyAssignmentPermission) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &d.Actions)
			delete(rawMsg, key)
		case "condition":
			err = unpopulate(val, "Condition", &d.Condition)
			delete(rawMsg, key)
		case "conditionVersion":
			err = unpopulate(val, "ConditionVersion", &d.ConditionVersion)
			delete(rawMsg, key)
		case "dataActions":
			err = unpopulate(val, "DataActions", &d.DataActions)
			delete(rawMsg, key)
		case "notActions":
			err = unpopulate(val, "NotActions", &d.NotActions)
			delete(rawMsg, key)
		case "notDataActions":
			err = unpopulate(val, "NotDataActions", &d.NotDataActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DenyAssignmentProperties.
func (d DenyAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "condition", d.Condition)
	populate(objectMap, "conditionVersion", d.ConditionVersion)
	populate(objectMap, "createdBy", d.CreatedBy)
	populateDateTimeRFC3339(objectMap, "createdOn", d.CreatedOn)
	populate(objectMap, "denyAssignmentName", d.DenyAssignmentName)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "doNotApplyToChildScopes", d.DoNotApplyToChildScopes)
	populate(objectMap, "excludePrincipals", d.ExcludePrincipals)
	populate(objectMap, "isSystemProtected", d.IsSystemProtected)
	populate(objectMap, "permissions", d.Permissions)
	populate(objectMap, "principals", d.Principals)
	populate(objectMap, "scope", d.Scope)
	populate(objectMap, "updatedBy", d.UpdatedBy)
	populateDateTimeRFC3339(objectMap, "updatedOn", d.UpdatedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DenyAssignmentProperties.
func (d *DenyAssignmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "condition":
			err = unpopulate(val, "Condition", &d.Condition)
			delete(rawMsg, key)
		case "conditionVersion":
			err = unpopulate(val, "ConditionVersion", &d.ConditionVersion)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &d.CreatedBy)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &d.CreatedOn)
			delete(rawMsg, key)
		case "denyAssignmentName":
			err = unpopulate(val, "DenyAssignmentName", &d.DenyAssignmentName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "doNotApplyToChildScopes":
			err = unpopulate(val, "DoNotApplyToChildScopes", &d.DoNotApplyToChildScopes)
			delete(rawMsg, key)
		case "excludePrincipals":
			err = unpopulate(val, "ExcludePrincipals", &d.ExcludePrincipals)
			delete(rawMsg, key)
		case "isSystemProtected":
			err = unpopulate(val, "IsSystemProtected", &d.IsSystemProtected)
			delete(rawMsg, key)
		case "permissions":
			err = unpopulate(val, "Permissions", &d.Permissions)
			delete(rawMsg, key)
		case "principals":
			err = unpopulate(val, "Principals", &d.Principals)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &d.Scope)
			delete(rawMsg, key)
		case "updatedBy":
			err = unpopulate(val, "UpdatedBy", &d.UpdatedBy)
			delete(rawMsg, key)
		case "updatedOn":
			err = unpopulateDateTimeRFC3339(val, "UpdatedOn", &d.UpdatedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DuplicateRoleCreatedAlertConfigurationProperties.
func (d DuplicateRoleCreatedAlertConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["alertConfigurationType"] = "DuplicateRoleCreatedAlertConfiguration"
	populate(objectMap, "alertDefinition", d.AlertDefinition)
	populate(objectMap, "alertDefinitionId", d.AlertDefinitionID)
	populate(objectMap, "isEnabled", d.IsEnabled)
	populate(objectMap, "scope", d.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DuplicateRoleCreatedAlertConfigurationProperties.
func (d *DuplicateRoleCreatedAlertConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertConfigurationType":
			err = unpopulate(val, "AlertConfigurationType", &d.AlertConfigurationType)
			delete(rawMsg, key)
		case "alertDefinition":
			err = unpopulate(val, "AlertDefinition", &d.AlertDefinition)
			delete(rawMsg, key)
		case "alertDefinitionId":
			err = unpopulate(val, "AlertDefinitionID", &d.AlertDefinitionID)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &d.IsEnabled)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &d.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DuplicateRoleCreatedAlertIncidentProperties.
func (d DuplicateRoleCreatedAlertIncidentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["alertIncidentType"] = "DuplicateRoleCreatedAlertIncident"
	populate(objectMap, "duplicateRoles", d.DuplicateRoles)
	populate(objectMap, "reason", d.Reason)
	populate(objectMap, "roleName", d.RoleName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DuplicateRoleCreatedAlertIncidentProperties.
func (d *DuplicateRoleCreatedAlertIncidentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertIncidentType":
			err = unpopulate(val, "AlertIncidentType", &d.AlertIncidentType)
			delete(rawMsg, key)
		case "duplicateRoles":
			err = unpopulate(val, "DuplicateRoles", &d.DuplicateRoles)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &d.Reason)
			delete(rawMsg, key)
		case "roleName":
			err = unpopulate(val, "RoleName", &d.RoleName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EligibleChildResource.
func (e EligibleChildResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EligibleChildResource.
func (e *EligibleChildResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EligibleChildResourcesListResult.
func (e EligibleChildResourcesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EligibleChildResourcesListResult.
func (e *EligibleChildResourcesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDefinition.
func (e ErrorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDefinition.
func (e *ErrorDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDefinitionProperties.
func (e ErrorDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDefinitionProperties.
func (e *ErrorDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpandedProperties.
func (e ExpandedProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principal", e.Principal)
	populate(objectMap, "roleDefinition", e.RoleDefinition)
	populate(objectMap, "scope", e.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpandedProperties.
func (e *ExpandedProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principal":
			err = unpopulate(val, "Principal", &e.Principal)
			delete(rawMsg, key)
		case "roleDefinition":
			err = unpopulate(val, "RoleDefinition", &e.RoleDefinition)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &e.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpandedPropertiesPrincipal.
func (e ExpandedPropertiesPrincipal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", e.DisplayName)
	populate(objectMap, "email", e.Email)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpandedPropertiesPrincipal.
func (e *ExpandedPropertiesPrincipal) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &e.DisplayName)
			delete(rawMsg, key)
		case "email":
			err = unpopulate(val, "Email", &e.Email)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpandedPropertiesRoleDefinition.
func (e ExpandedPropertiesRoleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", e.DisplayName)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpandedPropertiesRoleDefinition.
func (e *ExpandedPropertiesRoleDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &e.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpandedPropertiesScope.
func (e ExpandedPropertiesScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", e.DisplayName)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpandedPropertiesScope.
func (e *ExpandedPropertiesScope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &e.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Permission.
func (p Permission) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", p.Actions)
	populate(objectMap, "condition", p.Condition)
	populate(objectMap, "conditionVersion", p.ConditionVersion)
	populate(objectMap, "dataActions", p.DataActions)
	populate(objectMap, "notActions", p.NotActions)
	populate(objectMap, "notDataActions", p.NotDataActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Permission.
func (p *Permission) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &p.Actions)
			delete(rawMsg, key)
		case "condition":
			err = unpopulate(val, "Condition", &p.Condition)
			delete(rawMsg, key)
		case "conditionVersion":
			err = unpopulate(val, "ConditionVersion", &p.ConditionVersion)
			delete(rawMsg, key)
		case "dataActions":
			err = unpopulate(val, "DataActions", &p.DataActions)
			delete(rawMsg, key)
		case "notActions":
			err = unpopulate(val, "NotActions", &p.NotActions)
			delete(rawMsg, key)
		case "notDataActions":
			err = unpopulate(val, "NotDataActions", &p.NotDataActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PermissionGetResult.
func (p PermissionGetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PermissionGetResult.
func (p *PermissionGetResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyAssignmentProperties.
func (p PolicyAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policy", p.Policy)
	populate(objectMap, "roleDefinition", p.RoleDefinition)
	populate(objectMap, "scope", p.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyAssignmentProperties.
func (p *PolicyAssignmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policy":
			err = unpopulate(val, "Policy", &p.Policy)
			delete(rawMsg, key)
		case "roleDefinition":
			err = unpopulate(val, "RoleDefinition", &p.RoleDefinition)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &p.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyAssignmentPropertiesPolicy.
func (p PolicyAssignmentPropertiesPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "lastModifiedBy", p.LastModifiedBy)
	populateDateTimeRFC3339(objectMap, "lastModifiedDateTime", p.LastModifiedDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyAssignmentPropertiesPolicy.
func (p *PolicyAssignmentPropertiesPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &p.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedDateTime":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedDateTime", &p.LastModifiedDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyAssignmentPropertiesRoleDefinition.
func (p PolicyAssignmentPropertiesRoleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyAssignmentPropertiesRoleDefinition.
func (p *PolicyAssignmentPropertiesRoleDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyAssignmentPropertiesScope.
func (p PolicyAssignmentPropertiesScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyAssignmentPropertiesScope.
func (p *PolicyAssignmentPropertiesScope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyProperties.
func (p PolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scope", p.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyProperties.
func (p *PolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scope":
			err = unpopulate(val, "Scope", &p.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyPropertiesScope.
func (p PolicyPropertiesScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyPropertiesScope.
func (p *PolicyPropertiesScope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Principal.
func (p Principal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "email", p.Email)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Principal.
func (p *Principal) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "email":
			err = unpopulate(val, "Email", &p.Email)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderOperation.
func (p ProviderOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "isDataAction", p.IsDataAction)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "origin", p.Origin)
	populateAny(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderOperation.
func (p *ProviderOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &p.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &p.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderOperationsMetadata.
func (p ProviderOperationsMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "operations", p.Operations)
	populate(objectMap, "resourceTypes", p.ResourceTypes)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderOperationsMetadata.
func (p *ProviderOperationsMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "operations":
			err = unpopulate(val, "Operations", &p.Operations)
			delete(rawMsg, key)
		case "resourceTypes":
			err = unpopulate(val, "ResourceTypes", &p.ResourceTypes)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderOperationsMetadataListResult.
func (p ProviderOperationsMetadataListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderOperationsMetadataListResult.
func (p *ProviderOperationsMetadataListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecordAllDecisionsProperties.
func (r RecordAllDecisionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "decision", r.Decision)
	populate(objectMap, "justification", r.Justification)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "resourceId", r.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecordAllDecisionsProperties.
func (r *RecordAllDecisionsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "decision":
			err = unpopulate(val, "Decision", &r.Decision)
			delete(rawMsg, key)
		case "justification":
			err = unpopulate(val, "Justification", &r.Justification)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &r.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceType.
func (r ResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "operations", r.Operations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceType.
func (r *ResourceType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "operations":
			err = unpopulate(val, "Operations", &r.Operations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignment.
func (r RoleAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignment.
func (r *RoleAssignment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentCreateParameters.
func (r RoleAssignmentCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentCreateParameters.
func (r *RoleAssignmentCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentFilter.
func (r RoleAssignmentFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentFilter.
func (r *RoleAssignmentFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentListResult.
func (r RoleAssignmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentListResult.
func (r *RoleAssignmentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentProperties.
func (r RoleAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "condition", r.Condition)
	populate(objectMap, "conditionVersion", r.ConditionVersion)
	populate(objectMap, "createdBy", r.CreatedBy)
	populateDateTimeRFC3339(objectMap, "createdOn", r.CreatedOn)
	populate(objectMap, "delegatedManagedIdentityResourceId", r.DelegatedManagedIdentityResourceID)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "principalType", r.PrincipalType)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "scope", r.Scope)
	populate(objectMap, "updatedBy", r.UpdatedBy)
	populateDateTimeRFC3339(objectMap, "updatedOn", r.UpdatedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentProperties.
func (r *RoleAssignmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "condition":
			err = unpopulate(val, "Condition", &r.Condition)
			delete(rawMsg, key)
		case "conditionVersion":
			err = unpopulate(val, "ConditionVersion", &r.ConditionVersion)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &r.CreatedBy)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "delegatedManagedIdentityResourceId":
			err = unpopulate(val, "DelegatedManagedIdentityResourceID", &r.DelegatedManagedIdentityResourceID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &r.PrincipalType)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "updatedBy":
			err = unpopulate(val, "UpdatedBy", &r.UpdatedBy)
			delete(rawMsg, key)
		case "updatedOn":
			err = unpopulateDateTimeRFC3339(val, "UpdatedOn", &r.UpdatedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentSchedule.
func (r RoleAssignmentSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentSchedule.
func (r *RoleAssignmentSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleFilter.
func (r RoleAssignmentScheduleFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleFilter.
func (r *RoleAssignmentScheduleFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleInstance.
func (r RoleAssignmentScheduleInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleInstance.
func (r *RoleAssignmentScheduleInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleInstanceFilter.
func (r RoleAssignmentScheduleInstanceFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "roleAssignmentScheduleId", r.RoleAssignmentScheduleID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleInstanceFilter.
func (r *RoleAssignmentScheduleInstanceFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "roleAssignmentScheduleId":
			err = unpopulate(val, "RoleAssignmentScheduleID", &r.RoleAssignmentScheduleID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleInstanceListResult.
func (r RoleAssignmentScheduleInstanceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleInstanceListResult.
func (r *RoleAssignmentScheduleInstanceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleInstanceProperties.
func (r RoleAssignmentScheduleInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignmentType", r.AssignmentType)
	populate(objectMap, "condition", r.Condition)
	populate(objectMap, "conditionVersion", r.ConditionVersion)
	populateDateTimeRFC3339(objectMap, "createdOn", r.CreatedOn)
	populateDateTimeRFC3339(objectMap, "endDateTime", r.EndDateTime)
	populate(objectMap, "expandedProperties", r.ExpandedProperties)
	populate(objectMap, "linkedRoleEligibilityScheduleId", r.LinkedRoleEligibilityScheduleID)
	populate(objectMap, "linkedRoleEligibilityScheduleInstanceId", r.LinkedRoleEligibilityScheduleInstanceID)
	populate(objectMap, "memberType", r.MemberType)
	populate(objectMap, "originRoleAssignmentId", r.OriginRoleAssignmentID)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "principalType", r.PrincipalType)
	populate(objectMap, "roleAssignmentScheduleId", r.RoleAssignmentScheduleID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "scope", r.Scope)
	populateDateTimeRFC3339(objectMap, "startDateTime", r.StartDateTime)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleInstanceProperties.
func (r *RoleAssignmentScheduleInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignmentType":
			err = unpopulate(val, "AssignmentType", &r.AssignmentType)
			delete(rawMsg, key)
		case "condition":
			err = unpopulate(val, "Condition", &r.Condition)
			delete(rawMsg, key)
		case "conditionVersion":
			err = unpopulate(val, "ConditionVersion", &r.ConditionVersion)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "endDateTime":
			err = unpopulateDateTimeRFC3339(val, "EndDateTime", &r.EndDateTime)
			delete(rawMsg, key)
		case "expandedProperties":
			err = unpopulate(val, "ExpandedProperties", &r.ExpandedProperties)
			delete(rawMsg, key)
		case "linkedRoleEligibilityScheduleId":
			err = unpopulate(val, "LinkedRoleEligibilityScheduleID", &r.LinkedRoleEligibilityScheduleID)
			delete(rawMsg, key)
		case "linkedRoleEligibilityScheduleInstanceId":
			err = unpopulate(val, "LinkedRoleEligibilityScheduleInstanceID", &r.LinkedRoleEligibilityScheduleInstanceID)
			delete(rawMsg, key)
		case "memberType":
			err = unpopulate(val, "MemberType", &r.MemberType)
			delete(rawMsg, key)
		case "originRoleAssignmentId":
			err = unpopulate(val, "OriginRoleAssignmentID", &r.OriginRoleAssignmentID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &r.PrincipalType)
			delete(rawMsg, key)
		case "roleAssignmentScheduleId":
			err = unpopulate(val, "RoleAssignmentScheduleID", &r.RoleAssignmentScheduleID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateDateTimeRFC3339(val, "StartDateTime", &r.StartDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleListResult.
func (r RoleAssignmentScheduleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleListResult.
func (r *RoleAssignmentScheduleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleProperties.
func (r RoleAssignmentScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignmentType", r.AssignmentType)
	populate(objectMap, "condition", r.Condition)
	populate(objectMap, "conditionVersion", r.ConditionVersion)
	populateDateTimeRFC3339(objectMap, "createdOn", r.CreatedOn)
	populateDateTimeRFC3339(objectMap, "endDateTime", r.EndDateTime)
	populate(objectMap, "expandedProperties", r.ExpandedProperties)
	populate(objectMap, "linkedRoleEligibilityScheduleId", r.LinkedRoleEligibilityScheduleID)
	populate(objectMap, "memberType", r.MemberType)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "principalType", r.PrincipalType)
	populate(objectMap, "roleAssignmentScheduleRequestId", r.RoleAssignmentScheduleRequestID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "scope", r.Scope)
	populateDateTimeRFC3339(objectMap, "startDateTime", r.StartDateTime)
	populate(objectMap, "status", r.Status)
	populateDateTimeRFC3339(objectMap, "updatedOn", r.UpdatedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleProperties.
func (r *RoleAssignmentScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignmentType":
			err = unpopulate(val, "AssignmentType", &r.AssignmentType)
			delete(rawMsg, key)
		case "condition":
			err = unpopulate(val, "Condition", &r.Condition)
			delete(rawMsg, key)
		case "conditionVersion":
			err = unpopulate(val, "ConditionVersion", &r.ConditionVersion)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "endDateTime":
			err = unpopulateDateTimeRFC3339(val, "EndDateTime", &r.EndDateTime)
			delete(rawMsg, key)
		case "expandedProperties":
			err = unpopulate(val, "ExpandedProperties", &r.ExpandedProperties)
			delete(rawMsg, key)
		case "linkedRoleEligibilityScheduleId":
			err = unpopulate(val, "LinkedRoleEligibilityScheduleID", &r.LinkedRoleEligibilityScheduleID)
			delete(rawMsg, key)
		case "memberType":
			err = unpopulate(val, "MemberType", &r.MemberType)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &r.PrincipalType)
			delete(rawMsg, key)
		case "roleAssignmentScheduleRequestId":
			err = unpopulate(val, "RoleAssignmentScheduleRequestID", &r.RoleAssignmentScheduleRequestID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateDateTimeRFC3339(val, "StartDateTime", &r.StartDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "updatedOn":
			err = unpopulateDateTimeRFC3339(val, "UpdatedOn", &r.UpdatedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleRequest.
func (r RoleAssignmentScheduleRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleRequest.
func (r *RoleAssignmentScheduleRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleRequestFilter.
func (r RoleAssignmentScheduleRequestFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "requestorId", r.RequestorID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleRequestFilter.
func (r *RoleAssignmentScheduleRequestFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "requestorId":
			err = unpopulate(val, "RequestorID", &r.RequestorID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleRequestListResult.
func (r RoleAssignmentScheduleRequestListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleRequestListResult.
func (r *RoleAssignmentScheduleRequestListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleRequestProperties.
func (r RoleAssignmentScheduleRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "approvalId", r.ApprovalID)
	populate(objectMap, "condition", r.Condition)
	populate(objectMap, "conditionVersion", r.ConditionVersion)
	populateDateTimeRFC3339(objectMap, "createdOn", r.CreatedOn)
	populate(objectMap, "expandedProperties", r.ExpandedProperties)
	populate(objectMap, "justification", r.Justification)
	populate(objectMap, "linkedRoleEligibilityScheduleId", r.LinkedRoleEligibilityScheduleID)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "principalType", r.PrincipalType)
	populate(objectMap, "requestType", r.RequestType)
	populate(objectMap, "requestorId", r.RequestorID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "scheduleInfo", r.ScheduleInfo)
	populate(objectMap, "scope", r.Scope)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "targetRoleAssignmentScheduleId", r.TargetRoleAssignmentScheduleID)
	populate(objectMap, "targetRoleAssignmentScheduleInstanceId", r.TargetRoleAssignmentScheduleInstanceID)
	populate(objectMap, "ticketInfo", r.TicketInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleRequestProperties.
func (r *RoleAssignmentScheduleRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "approvalId":
			err = unpopulate(val, "ApprovalID", &r.ApprovalID)
			delete(rawMsg, key)
		case "condition":
			err = unpopulate(val, "Condition", &r.Condition)
			delete(rawMsg, key)
		case "conditionVersion":
			err = unpopulate(val, "ConditionVersion", &r.ConditionVersion)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "expandedProperties":
			err = unpopulate(val, "ExpandedProperties", &r.ExpandedProperties)
			delete(rawMsg, key)
		case "justification":
			err = unpopulate(val, "Justification", &r.Justification)
			delete(rawMsg, key)
		case "linkedRoleEligibilityScheduleId":
			err = unpopulate(val, "LinkedRoleEligibilityScheduleID", &r.LinkedRoleEligibilityScheduleID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &r.PrincipalType)
			delete(rawMsg, key)
		case "requestType":
			err = unpopulate(val, "RequestType", &r.RequestType)
			delete(rawMsg, key)
		case "requestorId":
			err = unpopulate(val, "RequestorID", &r.RequestorID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "scheduleInfo":
			err = unpopulate(val, "ScheduleInfo", &r.ScheduleInfo)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "targetRoleAssignmentScheduleId":
			err = unpopulate(val, "TargetRoleAssignmentScheduleID", &r.TargetRoleAssignmentScheduleID)
			delete(rawMsg, key)
		case "targetRoleAssignmentScheduleInstanceId":
			err = unpopulate(val, "TargetRoleAssignmentScheduleInstanceID", &r.TargetRoleAssignmentScheduleInstanceID)
			delete(rawMsg, key)
		case "ticketInfo":
			err = unpopulate(val, "TicketInfo", &r.TicketInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleRequestPropertiesScheduleInfo.
func (r RoleAssignmentScheduleRequestPropertiesScheduleInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expiration", r.Expiration)
	populateDateTimeRFC3339(objectMap, "startDateTime", r.StartDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleRequestPropertiesScheduleInfo.
func (r *RoleAssignmentScheduleRequestPropertiesScheduleInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiration":
			err = unpopulate(val, "Expiration", &r.Expiration)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateDateTimeRFC3339(val, "StartDateTime", &r.StartDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration.
func (r RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "duration", r.Duration)
	populateDateTimeRFC3339(objectMap, "endDateTime", r.EndDateTime)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration.
func (r *RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &r.Duration)
			delete(rawMsg, key)
		case "endDateTime":
			err = unpopulateDateTimeRFC3339(val, "EndDateTime", &r.EndDateTime)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentScheduleRequestPropertiesTicketInfo.
func (r RoleAssignmentScheduleRequestPropertiesTicketInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ticketNumber", r.TicketNumber)
	populate(objectMap, "ticketSystem", r.TicketSystem)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentScheduleRequestPropertiesTicketInfo.
func (r *RoleAssignmentScheduleRequestPropertiesTicketInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ticketNumber":
			err = unpopulate(val, "TicketNumber", &r.TicketNumber)
			delete(rawMsg, key)
		case "ticketSystem":
			err = unpopulate(val, "TicketSystem", &r.TicketSystem)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleDefinition.
func (r RoleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleDefinition.
func (r *RoleDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleDefinitionFilter.
func (r RoleDefinitionFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "roleName", r.RoleName)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleDefinitionFilter.
func (r *RoleDefinitionFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "roleName":
			err = unpopulate(val, "RoleName", &r.RoleName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleDefinitionListResult.
func (r RoleDefinitionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleDefinitionListResult.
func (r *RoleDefinitionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleDefinitionProperties.
func (r RoleDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignableScopes", r.AssignableScopes)
	populate(objectMap, "createdBy", r.CreatedBy)
	populateDateTimeRFC3339(objectMap, "createdOn", r.CreatedOn)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "permissions", r.Permissions)
	populate(objectMap, "roleName", r.RoleName)
	populate(objectMap, "type", r.RoleType)
	populate(objectMap, "updatedBy", r.UpdatedBy)
	populateDateTimeRFC3339(objectMap, "updatedOn", r.UpdatedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleDefinitionProperties.
func (r *RoleDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignableScopes":
			err = unpopulate(val, "AssignableScopes", &r.AssignableScopes)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &r.CreatedBy)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "permissions":
			err = unpopulate(val, "Permissions", &r.Permissions)
			delete(rawMsg, key)
		case "roleName":
			err = unpopulate(val, "RoleName", &r.RoleName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "RoleType", &r.RoleType)
			delete(rawMsg, key)
		case "updatedBy":
			err = unpopulate(val, "UpdatedBy", &r.UpdatedBy)
			delete(rawMsg, key)
		case "updatedOn":
			err = unpopulateDateTimeRFC3339(val, "UpdatedOn", &r.UpdatedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilitySchedule.
func (r RoleEligibilitySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilitySchedule.
func (r *RoleEligibilitySchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleFilter.
func (r RoleEligibilityScheduleFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleFilter.
func (r *RoleEligibilityScheduleFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleInstance.
func (r RoleEligibilityScheduleInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleInstance.
func (r *RoleEligibilityScheduleInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleInstanceFilter.
func (r RoleEligibilityScheduleInstanceFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "roleEligibilityScheduleId", r.RoleEligibilityScheduleID)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleInstanceFilter.
func (r *RoleEligibilityScheduleInstanceFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "roleEligibilityScheduleId":
			err = unpopulate(val, "RoleEligibilityScheduleID", &r.RoleEligibilityScheduleID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleInstanceListResult.
func (r RoleEligibilityScheduleInstanceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleInstanceListResult.
func (r *RoleEligibilityScheduleInstanceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleInstanceProperties.
func (r RoleEligibilityScheduleInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "condition", r.Condition)
	populate(objectMap, "conditionVersion", r.ConditionVersion)
	populateDateTimeRFC3339(objectMap, "createdOn", r.CreatedOn)
	populateDateTimeRFC3339(objectMap, "endDateTime", r.EndDateTime)
	populate(objectMap, "expandedProperties", r.ExpandedProperties)
	populate(objectMap, "memberType", r.MemberType)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "principalType", r.PrincipalType)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "roleEligibilityScheduleId", r.RoleEligibilityScheduleID)
	populate(objectMap, "scope", r.Scope)
	populateDateTimeRFC3339(objectMap, "startDateTime", r.StartDateTime)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleInstanceProperties.
func (r *RoleEligibilityScheduleInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "condition":
			err = unpopulate(val, "Condition", &r.Condition)
			delete(rawMsg, key)
		case "conditionVersion":
			err = unpopulate(val, "ConditionVersion", &r.ConditionVersion)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "endDateTime":
			err = unpopulateDateTimeRFC3339(val, "EndDateTime", &r.EndDateTime)
			delete(rawMsg, key)
		case "expandedProperties":
			err = unpopulate(val, "ExpandedProperties", &r.ExpandedProperties)
			delete(rawMsg, key)
		case "memberType":
			err = unpopulate(val, "MemberType", &r.MemberType)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &r.PrincipalType)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "roleEligibilityScheduleId":
			err = unpopulate(val, "RoleEligibilityScheduleID", &r.RoleEligibilityScheduleID)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateDateTimeRFC3339(val, "StartDateTime", &r.StartDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleListResult.
func (r RoleEligibilityScheduleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleListResult.
func (r *RoleEligibilityScheduleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleProperties.
func (r RoleEligibilityScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "condition", r.Condition)
	populate(objectMap, "conditionVersion", r.ConditionVersion)
	populateDateTimeRFC3339(objectMap, "createdOn", r.CreatedOn)
	populateDateTimeRFC3339(objectMap, "endDateTime", r.EndDateTime)
	populate(objectMap, "expandedProperties", r.ExpandedProperties)
	populate(objectMap, "memberType", r.MemberType)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "principalType", r.PrincipalType)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "roleEligibilityScheduleRequestId", r.RoleEligibilityScheduleRequestID)
	populate(objectMap, "scope", r.Scope)
	populateDateTimeRFC3339(objectMap, "startDateTime", r.StartDateTime)
	populate(objectMap, "status", r.Status)
	populateDateTimeRFC3339(objectMap, "updatedOn", r.UpdatedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleProperties.
func (r *RoleEligibilityScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "condition":
			err = unpopulate(val, "Condition", &r.Condition)
			delete(rawMsg, key)
		case "conditionVersion":
			err = unpopulate(val, "ConditionVersion", &r.ConditionVersion)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "endDateTime":
			err = unpopulateDateTimeRFC3339(val, "EndDateTime", &r.EndDateTime)
			delete(rawMsg, key)
		case "expandedProperties":
			err = unpopulate(val, "ExpandedProperties", &r.ExpandedProperties)
			delete(rawMsg, key)
		case "memberType":
			err = unpopulate(val, "MemberType", &r.MemberType)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &r.PrincipalType)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "roleEligibilityScheduleRequestId":
			err = unpopulate(val, "RoleEligibilityScheduleRequestID", &r.RoleEligibilityScheduleRequestID)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateDateTimeRFC3339(val, "StartDateTime", &r.StartDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "updatedOn":
			err = unpopulateDateTimeRFC3339(val, "UpdatedOn", &r.UpdatedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleRequest.
func (r RoleEligibilityScheduleRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleRequest.
func (r *RoleEligibilityScheduleRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleRequestFilter.
func (r RoleEligibilityScheduleRequestFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "requestorId", r.RequestorID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleRequestFilter.
func (r *RoleEligibilityScheduleRequestFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "requestorId":
			err = unpopulate(val, "RequestorID", &r.RequestorID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleRequestListResult.
func (r RoleEligibilityScheduleRequestListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleRequestListResult.
func (r *RoleEligibilityScheduleRequestListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleRequestProperties.
func (r RoleEligibilityScheduleRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "approvalId", r.ApprovalID)
	populate(objectMap, "condition", r.Condition)
	populate(objectMap, "conditionVersion", r.ConditionVersion)
	populateDateTimeRFC3339(objectMap, "createdOn", r.CreatedOn)
	populate(objectMap, "expandedProperties", r.ExpandedProperties)
	populate(objectMap, "justification", r.Justification)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "principalType", r.PrincipalType)
	populate(objectMap, "requestType", r.RequestType)
	populate(objectMap, "requestorId", r.RequestorID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "scheduleInfo", r.ScheduleInfo)
	populate(objectMap, "scope", r.Scope)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "targetRoleEligibilityScheduleId", r.TargetRoleEligibilityScheduleID)
	populate(objectMap, "targetRoleEligibilityScheduleInstanceId", r.TargetRoleEligibilityScheduleInstanceID)
	populate(objectMap, "ticketInfo", r.TicketInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleRequestProperties.
func (r *RoleEligibilityScheduleRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "approvalId":
			err = unpopulate(val, "ApprovalID", &r.ApprovalID)
			delete(rawMsg, key)
		case "condition":
			err = unpopulate(val, "Condition", &r.Condition)
			delete(rawMsg, key)
		case "conditionVersion":
			err = unpopulate(val, "ConditionVersion", &r.ConditionVersion)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &r.CreatedOn)
			delete(rawMsg, key)
		case "expandedProperties":
			err = unpopulate(val, "ExpandedProperties", &r.ExpandedProperties)
			delete(rawMsg, key)
		case "justification":
			err = unpopulate(val, "Justification", &r.Justification)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &r.PrincipalType)
			delete(rawMsg, key)
		case "requestType":
			err = unpopulate(val, "RequestType", &r.RequestType)
			delete(rawMsg, key)
		case "requestorId":
			err = unpopulate(val, "RequestorID", &r.RequestorID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "scheduleInfo":
			err = unpopulate(val, "ScheduleInfo", &r.ScheduleInfo)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "targetRoleEligibilityScheduleId":
			err = unpopulate(val, "TargetRoleEligibilityScheduleID", &r.TargetRoleEligibilityScheduleID)
			delete(rawMsg, key)
		case "targetRoleEligibilityScheduleInstanceId":
			err = unpopulate(val, "TargetRoleEligibilityScheduleInstanceID", &r.TargetRoleEligibilityScheduleInstanceID)
			delete(rawMsg, key)
		case "ticketInfo":
			err = unpopulate(val, "TicketInfo", &r.TicketInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleRequestPropertiesScheduleInfo.
func (r RoleEligibilityScheduleRequestPropertiesScheduleInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expiration", r.Expiration)
	populateDateTimeRFC3339(objectMap, "startDateTime", r.StartDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleRequestPropertiesScheduleInfo.
func (r *RoleEligibilityScheduleRequestPropertiesScheduleInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiration":
			err = unpopulate(val, "Expiration", &r.Expiration)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateDateTimeRFC3339(val, "StartDateTime", &r.StartDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration.
func (r RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "duration", r.Duration)
	populateDateTimeRFC3339(objectMap, "endDateTime", r.EndDateTime)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration.
func (r *RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &r.Duration)
			delete(rawMsg, key)
		case "endDateTime":
			err = unpopulateDateTimeRFC3339(val, "EndDateTime", &r.EndDateTime)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleEligibilityScheduleRequestPropertiesTicketInfo.
func (r RoleEligibilityScheduleRequestPropertiesTicketInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ticketNumber", r.TicketNumber)
	populate(objectMap, "ticketSystem", r.TicketSystem)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleEligibilityScheduleRequestPropertiesTicketInfo.
func (r *RoleEligibilityScheduleRequestPropertiesTicketInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ticketNumber":
			err = unpopulate(val, "TicketNumber", &r.TicketNumber)
			delete(rawMsg, key)
		case "ticketSystem":
			err = unpopulate(val, "TicketSystem", &r.TicketSystem)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicy.
func (r RoleManagementPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicy.
func (r *RoleManagementPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyApprovalRule.
func (r RoleManagementPolicyApprovalRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	objectMap["ruleType"] = RoleManagementPolicyRuleTypeRoleManagementPolicyApprovalRule
	populate(objectMap, "setting", r.Setting)
	populate(objectMap, "target", r.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyApprovalRule.
func (r *RoleManagementPolicyApprovalRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &r.RuleType)
			delete(rawMsg, key)
		case "setting":
			err = unpopulate(val, "Setting", &r.Setting)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &r.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyAssignment.
func (r RoleManagementPolicyAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyAssignment.
func (r *RoleManagementPolicyAssignment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyAssignmentListResult.
func (r RoleManagementPolicyAssignmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyAssignmentListResult.
func (r *RoleManagementPolicyAssignmentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyAssignmentProperties.
func (r RoleManagementPolicyAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyAssignmentProperties", r.PolicyAssignmentProperties)
	populate(objectMap, "policyId", r.PolicyID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "scope", r.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyAssignmentProperties.
func (r *RoleManagementPolicyAssignmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyAssignmentProperties":
			err = unpopulate(val, "PolicyAssignmentProperties", &r.PolicyAssignmentProperties)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &r.PolicyID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyAuthenticationContextRule.
func (r RoleManagementPolicyAuthenticationContextRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "claimValue", r.ClaimValue)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "isEnabled", r.IsEnabled)
	objectMap["ruleType"] = RoleManagementPolicyRuleTypeRoleManagementPolicyAuthenticationContextRule
	populate(objectMap, "target", r.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyAuthenticationContextRule.
func (r *RoleManagementPolicyAuthenticationContextRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "claimValue":
			err = unpopulate(val, "ClaimValue", &r.ClaimValue)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &r.IsEnabled)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &r.RuleType)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &r.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyEnablementRule.
func (r RoleManagementPolicyEnablementRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabledRules", r.EnabledRules)
	populate(objectMap, "id", r.ID)
	objectMap["ruleType"] = RoleManagementPolicyRuleTypeRoleManagementPolicyEnablementRule
	populate(objectMap, "target", r.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyEnablementRule.
func (r *RoleManagementPolicyEnablementRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabledRules":
			err = unpopulate(val, "EnabledRules", &r.EnabledRules)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &r.RuleType)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &r.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyExpirationRule.
func (r RoleManagementPolicyExpirationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "isExpirationRequired", r.IsExpirationRequired)
	populate(objectMap, "maximumDuration", r.MaximumDuration)
	objectMap["ruleType"] = RoleManagementPolicyRuleTypeRoleManagementPolicyExpirationRule
	populate(objectMap, "target", r.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyExpirationRule.
func (r *RoleManagementPolicyExpirationRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "isExpirationRequired":
			err = unpopulate(val, "IsExpirationRequired", &r.IsExpirationRequired)
			delete(rawMsg, key)
		case "maximumDuration":
			err = unpopulate(val, "MaximumDuration", &r.MaximumDuration)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &r.RuleType)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &r.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyListResult.
func (r RoleManagementPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyListResult.
func (r *RoleManagementPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyNotificationRule.
func (r RoleManagementPolicyNotificationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "isDefaultRecipientsEnabled", r.IsDefaultRecipientsEnabled)
	populate(objectMap, "notificationLevel", r.NotificationLevel)
	populate(objectMap, "notificationRecipients", r.NotificationRecipients)
	populate(objectMap, "notificationType", r.NotificationType)
	populate(objectMap, "recipientType", r.RecipientType)
	objectMap["ruleType"] = RoleManagementPolicyRuleTypeRoleManagementPolicyNotificationRule
	populate(objectMap, "target", r.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyNotificationRule.
func (r *RoleManagementPolicyNotificationRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "isDefaultRecipientsEnabled":
			err = unpopulate(val, "IsDefaultRecipientsEnabled", &r.IsDefaultRecipientsEnabled)
			delete(rawMsg, key)
		case "notificationLevel":
			err = unpopulate(val, "NotificationLevel", &r.NotificationLevel)
			delete(rawMsg, key)
		case "notificationRecipients":
			err = unpopulate(val, "NotificationRecipients", &r.NotificationRecipients)
			delete(rawMsg, key)
		case "notificationType":
			err = unpopulate(val, "NotificationType", &r.NotificationType)
			delete(rawMsg, key)
		case "recipientType":
			err = unpopulate(val, "RecipientType", &r.RecipientType)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &r.RuleType)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &r.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyProperties.
func (r RoleManagementPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "effectiveRules", r.EffectiveRules)
	populate(objectMap, "isOrganizationDefault", r.IsOrganizationDefault)
	populate(objectMap, "lastModifiedBy", r.LastModifiedBy)
	populateDateTimeRFC3339(objectMap, "lastModifiedDateTime", r.LastModifiedDateTime)
	populate(objectMap, "policyProperties", r.PolicyProperties)
	populate(objectMap, "rules", r.Rules)
	populate(objectMap, "scope", r.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyProperties.
func (r *RoleManagementPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "effectiveRules":
			r.EffectiveRules, err = unmarshalRoleManagementPolicyRuleClassificationArray(val)
			delete(rawMsg, key)
		case "isOrganizationDefault":
			err = unpopulate(val, "IsOrganizationDefault", &r.IsOrganizationDefault)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &r.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedDateTime":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedDateTime", &r.LastModifiedDateTime)
			delete(rawMsg, key)
		case "policyProperties":
			err = unpopulate(val, "PolicyProperties", &r.PolicyProperties)
			delete(rawMsg, key)
		case "rules":
			r.Rules, err = unmarshalRoleManagementPolicyRuleClassificationArray(val)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyRule.
func (r RoleManagementPolicyRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	objectMap["ruleType"] = r.RuleType
	populate(objectMap, "target", r.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyRule.
func (r *RoleManagementPolicyRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &r.RuleType)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &r.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleManagementPolicyRuleTarget.
func (r RoleManagementPolicyRuleTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caller", r.Caller)
	populate(objectMap, "enforcedSettings", r.EnforcedSettings)
	populate(objectMap, "inheritableSettings", r.InheritableSettings)
	populate(objectMap, "level", r.Level)
	populate(objectMap, "operations", r.Operations)
	populate(objectMap, "targetObjects", r.TargetObjects)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleManagementPolicyRuleTarget.
func (r *RoleManagementPolicyRuleTarget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caller":
			err = unpopulate(val, "Caller", &r.Caller)
			delete(rawMsg, key)
		case "enforcedSettings":
			err = unpopulate(val, "EnforcedSettings", &r.EnforcedSettings)
			delete(rawMsg, key)
		case "inheritableSettings":
			err = unpopulate(val, "InheritableSettings", &r.InheritableSettings)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &r.Level)
			delete(rawMsg, key)
		case "operations":
			err = unpopulate(val, "Operations", &r.Operations)
			delete(rawMsg, key)
		case "targetObjects":
			err = unpopulate(val, "TargetObjects", &r.TargetObjects)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TooManyOwnersAssignedToResourceAlertConfigurationProperties.
func (t TooManyOwnersAssignedToResourceAlertConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["alertConfigurationType"] = "TooManyOwnersAssignedToResourceAlertConfiguration"
	populate(objectMap, "alertDefinition", t.AlertDefinition)
	populate(objectMap, "alertDefinitionId", t.AlertDefinitionID)
	populate(objectMap, "isEnabled", t.IsEnabled)
	populate(objectMap, "scope", t.Scope)
	populate(objectMap, "thresholdNumberOfOwners", t.ThresholdNumberOfOwners)
	populate(objectMap, "thresholdPercentageOfOwnersOutOfAllRoleMembers", t.ThresholdPercentageOfOwnersOutOfAllRoleMembers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TooManyOwnersAssignedToResourceAlertConfigurationProperties.
func (t *TooManyOwnersAssignedToResourceAlertConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertConfigurationType":
			err = unpopulate(val, "AlertConfigurationType", &t.AlertConfigurationType)
			delete(rawMsg, key)
		case "alertDefinition":
			err = unpopulate(val, "AlertDefinition", &t.AlertDefinition)
			delete(rawMsg, key)
		case "alertDefinitionId":
			err = unpopulate(val, "AlertDefinitionID", &t.AlertDefinitionID)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &t.IsEnabled)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &t.Scope)
			delete(rawMsg, key)
		case "thresholdNumberOfOwners":
			err = unpopulate(val, "ThresholdNumberOfOwners", &t.ThresholdNumberOfOwners)
			delete(rawMsg, key)
		case "thresholdPercentageOfOwnersOutOfAllRoleMembers":
			err = unpopulate(val, "ThresholdPercentageOfOwnersOutOfAllRoleMembers", &t.ThresholdPercentageOfOwnersOutOfAllRoleMembers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TooManyOwnersAssignedToResourceAlertIncidentProperties.
func (t TooManyOwnersAssignedToResourceAlertIncidentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["alertIncidentType"] = "TooManyOwnersAssignedToResourceAlertIncident"
	populate(objectMap, "assigneeName", t.AssigneeName)
	populate(objectMap, "assigneeType", t.AssigneeType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TooManyOwnersAssignedToResourceAlertIncidentProperties.
func (t *TooManyOwnersAssignedToResourceAlertIncidentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertIncidentType":
			err = unpopulate(val, "AlertIncidentType", &t.AlertIncidentType)
			delete(rawMsg, key)
		case "assigneeName":
			err = unpopulate(val, "AssigneeName", &t.AssigneeName)
			delete(rawMsg, key)
		case "assigneeType":
			err = unpopulate(val, "AssigneeType", &t.AssigneeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TooManyPermanentOwnersAssignedToResourceAlertConfigurationProperties.
func (t TooManyPermanentOwnersAssignedToResourceAlertConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["alertConfigurationType"] = "TooManyPermanentOwnersAssignedToResourceAlertConfiguration"
	populate(objectMap, "alertDefinition", t.AlertDefinition)
	populate(objectMap, "alertDefinitionId", t.AlertDefinitionID)
	populate(objectMap, "isEnabled", t.IsEnabled)
	populate(objectMap, "scope", t.Scope)
	populate(objectMap, "thresholdNumberOfPermanentOwners", t.ThresholdNumberOfPermanentOwners)
	populate(objectMap, "thresholdPercentageOfPermanentOwnersOutOfAllOwners", t.ThresholdPercentageOfPermanentOwnersOutOfAllOwners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TooManyPermanentOwnersAssignedToResourceAlertConfigurationProperties.
func (t *TooManyPermanentOwnersAssignedToResourceAlertConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertConfigurationType":
			err = unpopulate(val, "AlertConfigurationType", &t.AlertConfigurationType)
			delete(rawMsg, key)
		case "alertDefinition":
			err = unpopulate(val, "AlertDefinition", &t.AlertDefinition)
			delete(rawMsg, key)
		case "alertDefinitionId":
			err = unpopulate(val, "AlertDefinitionID", &t.AlertDefinitionID)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &t.IsEnabled)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &t.Scope)
			delete(rawMsg, key)
		case "thresholdNumberOfPermanentOwners":
			err = unpopulate(val, "ThresholdNumberOfPermanentOwners", &t.ThresholdNumberOfPermanentOwners)
			delete(rawMsg, key)
		case "thresholdPercentageOfPermanentOwnersOutOfAllOwners":
			err = unpopulate(val, "ThresholdPercentageOfPermanentOwnersOutOfAllOwners", &t.ThresholdPercentageOfPermanentOwnersOutOfAllOwners)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TooManyPermanentOwnersAssignedToResourceAlertIncidentProperties.
func (t TooManyPermanentOwnersAssignedToResourceAlertIncidentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["alertIncidentType"] = "TooManyPermanentOwnersAssignedToResourceAlertIncident"
	populate(objectMap, "assigneeName", t.AssigneeName)
	populate(objectMap, "assigneeType", t.AssigneeType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TooManyPermanentOwnersAssignedToResourceAlertIncidentProperties.
func (t *TooManyPermanentOwnersAssignedToResourceAlertIncidentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertIncidentType":
			err = unpopulate(val, "AlertIncidentType", &t.AlertIncidentType)
			delete(rawMsg, key)
		case "assigneeName":
			err = unpopulate(val, "AssigneeName", &t.AssigneeName)
			delete(rawMsg, key)
		case "assigneeType":
			err = unpopulate(val, "AssigneeType", &t.AssigneeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserSet.
func (u UserSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", u.Description)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "isBackup", u.IsBackup)
	populate(objectMap, "userType", u.UserType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserSet.
func (u *UserSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &u.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "isBackup":
			err = unpopulate(val, "IsBackup", &u.IsBackup)
			delete(rawMsg, key)
		case "userType":
			err = unpopulate(val, "UserType", &u.UserType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationResponse.
func (v ValidationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorInfo", v.ErrorInfo)
	populate(objectMap, "isValid", v.IsValid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationResponse.
func (v *ValidationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorInfo":
			err = unpopulate(val, "ErrorInfo", &v.ErrorInfo)
			delete(rawMsg, key)
		case "isValid":
			err = unpopulate(val, "IsValid", &v.IsValid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationResponseErrorInfo.
func (v ValidationResponseErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", v.Code)
	populate(objectMap, "message", v.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationResponseErrorInfo.
func (v *ValidationResponseErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
