//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragecache

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ManagementClient contains the methods for the StorageCacheManagementClient group.
// Don't use this type directly, use NewManagementClient() instead.
type ManagementClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewManagementClient creates a new instance of ManagementClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewManagementClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagementClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ManagementClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CheckAmlFSSubnets - Check that subnets will be valid for AML file system create calls.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-05-01
//   - options - ManagementClientCheckAmlFSSubnetsOptions contains the optional parameters for the ManagementClient.CheckAmlFSSubnets
//     method.
func (client *ManagementClient) CheckAmlFSSubnets(ctx context.Context, options *ManagementClientCheckAmlFSSubnetsOptions) (ManagementClientCheckAmlFSSubnetsResponse, error) {
	var err error
	const operationName = "ManagementClient.CheckAmlFSSubnets"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.checkAmlFSSubnetsCreateRequest(ctx, options)
	if err != nil {
		return ManagementClientCheckAmlFSSubnetsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementClientCheckAmlFSSubnetsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagementClientCheckAmlFSSubnetsResponse{}, err
	}
	return ManagementClientCheckAmlFSSubnetsResponse{}, nil
}

// checkAmlFSSubnetsCreateRequest creates the CheckAmlFSSubnets request.
func (client *ManagementClient) checkAmlFSSubnetsCreateRequest(ctx context.Context, options *ManagementClientCheckAmlFSSubnetsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.StorageCache/checkAmlFSSubnets"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.AmlFilesystemSubnetInfo != nil {
		if err := runtime.MarshalAsJSON(req, *options.AmlFilesystemSubnetInfo); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// GetRequiredAmlFSSubnetsSize - Get the number of available IP addresses needed for the AML file system information provided.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-05-01
//   - options - ManagementClientGetRequiredAmlFSSubnetsSizeOptions contains the optional parameters for the ManagementClient.GetRequiredAmlFSSubnetsSize
//     method.
func (client *ManagementClient) GetRequiredAmlFSSubnetsSize(ctx context.Context, options *ManagementClientGetRequiredAmlFSSubnetsSizeOptions) (ManagementClientGetRequiredAmlFSSubnetsSizeResponse, error) {
	var err error
	const operationName = "ManagementClient.GetRequiredAmlFSSubnetsSize"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getRequiredAmlFSSubnetsSizeCreateRequest(ctx, options)
	if err != nil {
		return ManagementClientGetRequiredAmlFSSubnetsSizeResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementClientGetRequiredAmlFSSubnetsSizeResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagementClientGetRequiredAmlFSSubnetsSizeResponse{}, err
	}
	resp, err := client.getRequiredAmlFSSubnetsSizeHandleResponse(httpResp)
	return resp, err
}

// getRequiredAmlFSSubnetsSizeCreateRequest creates the GetRequiredAmlFSSubnetsSize request.
func (client *ManagementClient) getRequiredAmlFSSubnetsSizeCreateRequest(ctx context.Context, options *ManagementClientGetRequiredAmlFSSubnetsSizeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.StorageCache/getRequiredAmlFSSubnetsSize"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.RequiredAMLFilesystemSubnetsSizeInfo != nil {
		if err := runtime.MarshalAsJSON(req, *options.RequiredAMLFilesystemSubnetsSizeInfo); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// getRequiredAmlFSSubnetsSizeHandleResponse handles the GetRequiredAmlFSSubnetsSize response.
func (client *ManagementClient) getRequiredAmlFSSubnetsSizeHandleResponse(resp *http.Response) (ManagementClientGetRequiredAmlFSSubnetsSizeResponse, error) {
	result := ManagementClientGetRequiredAmlFSSubnetsSizeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RequiredAmlFilesystemSubnetsSize); err != nil {
		return ManagementClientGetRequiredAmlFSSubnetsSizeResponse{}, err
	}
	return result, nil
}
