/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ElectricObject {
    private HashMap vars;
    private static HashMap varKeys = new HashMap();
    private static HashMap varLowCaseKeys = new HashMap();

    protected ElectricObject() {
    }

    public Variable getVar(String name) {
        Variable.Key key = ElectricObject.findKey(name);
        return key != null ? this.getVar(key) : null;
    }

    public Variable getVar(Variable.Key key) {
        if (this.vars == null) {
            return null;
        }
        Variable var = (Variable)this.vars.get(key);
        return var;
    }

    public Variable getVar(String name, Class type) {
        Variable.Key key = ElectricObject.findKey(name);
        return key != null ? this.getVar(key, type) : null;
    }

    public Variable getVar(Variable.Key key, Class type) {
        if (this.vars == null) {
            return null;
        }
        Variable var = (Variable)this.vars.get(key);
        if (var == null) {
            return null;
        }
        if (!type.isInstance(var.getObject())) {
            return null;
        }
        return var;
    }

    public int numDisplayableVariables(boolean multipleStrings) {
        if (this.vars == null) {
            return 0;
        }
        int numVars = 0;
        Iterator it = this.vars.values().iterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isDisplay()) continue;
            int len = var.getLength();
            if (!multipleStrings) {
                len = 1;
            }
            numVars += len;
        }
        return numVars;
    }

    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow wnd, boolean multipleStrings) {
        int numAddedVariables = 0;
        if (this.vars == null) {
            return numAddedVariables;
        }
        double cX = rect.getCenterX();
        double cY = rect.getCenterY();
        Iterator it = this.vars.values().iterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isDisplay()) continue;
            Poly[] polyList = this.getPolyList(var, cX, cY, wnd, multipleStrings);
            for (int i = 0; i < polyList.length; ++i) {
                int index = start + numAddedVariables;
                polys[index] = polyList[i];
                ++numAddedVariables;
            }
        }
        return numAddedVariables;
    }

    public Poly computeTextPoly(EditWindow wnd, Variable var, Name name) {
        Poly poly = null;
        if (var != null) {
            if (this instanceof Export) {
                Export pp = (Export)this;
                PortInst pi = pp.getOriginalPort();
                Rectangle2D bounds = pi.getPoly().getBounds2D();
                Poly[] polys = pp.getPolyList(var, bounds.getCenterX(), bounds.getCenterY(), wnd, false);
                if (polys != null) {
                    poly = polys[0];
                    poly.transform(pi.getNodeInst().rotateOut());
                }
            } else if (this instanceof PortInst) {
                PortInst pi = (PortInst)this;
                Rectangle2D bounds = pi.getPoly().getBounds2D();
                Poly[] polys = pi.getPolyList(var, bounds.getCenterX(), bounds.getCenterY(), wnd, false);
                if (polys != null) {
                    poly = polys[0];
                    poly.transform(pi.getNodeInst().rotateOut());
                }
            } else if (this instanceof Geometric) {
                Geometric geom = (Geometric)this;
                Poly[] polys = geom.getPolyList(var, geom.getTrueCenterX(), geom.getTrueCenterY(), wnd, false);
                if (polys != null) {
                    poly = polys[0];
                    if (geom instanceof NodeInst) {
                        poly.transform(((NodeInst)geom).rotateOut());
                    }
                }
            } else if (this instanceof Cell) {
                Cell cell = (Cell)this;
                Rectangle2D bounds = cell.getBounds();
                Poly[] polys = cell.getPolyList(var, 0.0, 0.0, wnd, false);
                if (polys != null) {
                    poly = polys[0];
                }
            }
        } else if (name != null) {
            if (!(this instanceof Geometric)) {
                return null;
            }
            Geometric geom = (Geometric)this;
            TextDescriptor td = geom.getNameTextDescriptor();
            Poly.Type style = td.getPos().getPolyType();
            Point2D[] pointList = null;
            pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(geom.getBounds()) : new Point2D.Double[]{new Point2D.Double(geom.getTrueCenterX() + td.getXOff(), geom.getTrueCenterY() + td.getYOff())};
            poly = new Poly(pointList);
            poly.setStyle(style);
            if (geom instanceof NodeInst) {
                poly.transform(((NodeInst)geom).rotateOut());
            }
            poly.setTextDescriptor(td);
            poly.setString(name.toString());
        } else if (this instanceof Export) {
            Export pp = (Export)this;
            Rectangle2D bounds = pp.getOriginalPort().getBounds();
            TextDescriptor td = pp.getTextDescriptor();
            Poly.Type style = td.getPos().getPolyType();
            Point2D[] pointList = new Point2D.Double[]{new Point2D.Double(bounds.getCenterX() + td.getXOff(), bounds.getCenterY() + td.getYOff())};
            poly = new Poly(pointList);
            poly.setStyle(style);
            poly.setTextDescriptor(td);
            poly.setString(pp.getName());
        } else {
            if (!(this instanceof NodeInst)) {
                return null;
            }
            NodeInst ni = (NodeInst)this;
            TextDescriptor td = ni.getProtoTextDescriptor();
            Poly.Type style = td.getPos().getPolyType();
            Point2D[] pointList = null;
            pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(ni.getBounds()) : new Point2D.Double[]{new Point2D.Double(ni.getTrueCenterX() + td.getXOff(), ni.getTrueCenterY() + td.getYOff())};
            poly = new Poly(pointList);
            poly.setStyle(style);
            poly.setTextDescriptor(td);
            poly.setString(ni.getProto().describe());
        }
        if (poly != null) {
            poly.setExactTextBounds(wnd, this);
        }
        return poly;
    }

    public Poly[] getPolyList(Variable var, double cX, double cY, EditWindow wnd, boolean multipleStrings) {
        TextDescriptor td = var.getTextDescriptor();
        double offX = td.getXOff();
        double offY = td.getYOff();
        int varLength = var.getLength();
        double height = 0.0;
        Poly.Type style = td.getPos().getPolyType();
        if (varLength > 1) {
            Font font = wnd.getFont(td);
            if (font == null) {
                varLength = 0;
            } else {
                height = (double)font.getSize2D() / wnd.getScale();
                if (multipleStrings) {
                    if (style == Poly.Type.TEXTCENT || style == Poly.Type.TEXTBOX || style == Poly.Type.TEXTLEFT || style == Poly.Type.TEXTRIGHT) {
                        cY += height * (double)(varLength - 1) / 2.0;
                    }
                    if (style == Poly.Type.TEXTBOT || style == Poly.Type.TEXTBOTLEFT || style == Poly.Type.TEXTBOTRIGHT) {
                        cY += height * (double)(varLength - 1);
                    }
                } else {
                    if (style == Poly.Type.TEXTCENT || style == Poly.Type.TEXTBOX || style == Poly.Type.TEXTLEFT || style == Poly.Type.TEXTRIGHT) {
                        cY -= height * (double)(varLength - 1) / 2.0;
                    }
                    if (style == Poly.Type.TEXTTOP || style == Poly.Type.TEXTTOPLEFT || style == Poly.Type.TEXTTOPRIGHT) {
                        cY -= height * (double)(varLength - 1);
                    }
                    varLength = 1;
                }
            }
        }
        Poly[] polys = new Poly[varLength];
        for (int i = 0; i < varLength; ++i) {
            Point2D[] pointList = null;
            if (style == Poly.Type.TEXTBOX && this instanceof Geometric) {
                Geometric geom = (Geometric)this;
                Rectangle2D bounds = geom.getBounds();
                pointList = Poly.makePoints(bounds);
            } else {
                pointList = new Point2D.Double[]{new Point2D.Double(cX + offX, cY + offY)};
            }
            polys[i] = new Poly(pointList);
            polys[i].setStyle(style);
            VarContext context = null;
            if (wnd != null) {
                context = wnd.getVarContext();
            }
            polys[i].setString(var.describe(i, -1, context, this));
            polys[i].setTextDescriptor(td);
            polys[i].setLayer(null);
            polys[i].setVariable(var);
            cY -= height;
        }
        return polys;
    }

    public Variable newVar(String name, Object value) {
        return this.newVar(ElectricObject.newKey(name), value);
    }

    public Variable newVar(Variable.Key key, Object value) {
        Variable oldVar;
        this.checkChanging();
        if (this.vars == null) {
            this.vars = new HashMap();
        }
        if ((oldVar = (Variable)this.vars.get(key)) != null) {
            this.lowLevelUnlinkVar(oldVar);
            if (this.inDatabase()) {
                Undo.killVariable(this, oldVar);
            }
        }
        TextDescriptor td = null;
        td = this instanceof Cell ? TextDescriptor.getCellTextDescriptor(this) : (this instanceof Export ? TextDescriptor.getExportTextDescriptor(this) : (this instanceof NodeInst ? TextDescriptor.getNodeTextDescriptor(this) : (this instanceof ArcInst ? TextDescriptor.getArcTextDescriptor(this) : TextDescriptor.getAnnotationTextDescriptor(this))));
        Variable v = new Variable(this, value, td, key);
        this.lowLevelLinkVar(v);
        if (this.inDatabase()) {
            Undo.newVariable(this, v);
        }
        return v;
    }

    public Variable updateVar(String name, Object value) {
        return this.updateVar(ElectricObject.newKey(name), value);
    }

    public Variable updateVar(Variable.Key key, Object value) {
        Variable var = this.getVar(key);
        if (var == null) {
            return this.newVar(key, value);
        }
        boolean oldCantSet = var.isCantSet();
        Variable.Code oldCode = var.getCode();
        boolean oldDisplay = var.isDisplay();
        boolean oldTemporary = var.isDontSave();
        TextDescriptor td = var.getTextDescriptor();
        Variable newVar = this.newVar(key, value);
        if (newVar == null) {
            return null;
        }
        newVar.setTextDescriptor(td);
        if (oldCantSet) {
            newVar.setCantSet();
        }
        newVar.setCode(oldCode);
        if (oldDisplay) {
            newVar.setDisplay(oldDisplay);
        }
        if (oldTemporary) {
            newVar.setDontSave();
        }
        return newVar;
    }

    public Variable renameVar(String name, String newName) {
        return this.renameVar(ElectricObject.findKey(name), newName);
    }

    public Variable renameVar(Variable.Key key, String newName) {
        Variable var = this.getVar(newName);
        if (var != null) {
            return null;
        }
        Variable oldvar = this.getVar(key);
        if (oldvar == null) {
            return null;
        }
        Variable newVar = this.newVar(newName, oldvar.getObject());
        if (newVar == null) {
            return null;
        }
        newVar.setTextDescriptor(oldvar.getTextDescriptor());
        newVar.copyFlags(oldvar);
        this.delVar(oldvar.getKey());
        return newVar;
    }

    public void delVar(Variable.Key key) {
        this.checkChanging();
        if (this.vars == null) {
            return;
        }
        Variable v = this.getVar(key);
        if (v == null) {
            return;
        }
        this.lowLevelUnlinkVar(v);
        if (this.inDatabase()) {
            Undo.killVariable(this, v);
        }
    }

    public void lowLevelLinkVar(Variable var) {
        this.vars.put(var.getKey(), var);
    }

    public void lowLevelUnlinkVar(Variable var) {
        this.vars.remove(var.getKey());
    }

    public void setVar(Variable.Key key, Object value, int index) {
        this.checkChanging();
        Variable v = this.getVar(key);
        if (v == null) {
            return;
        }
        Object addr = v.getObject();
        if (addr instanceof Object[]) {
            Object[] arr = (Object[])addr;
            Object oldVal = arr[index];
            arr[index] = value;
            if (this.inDatabase()) {
                Undo.modifyVariable(this, v, index, oldVal);
            }
        }
    }

    public void insertInVar(Variable.Key key, int index, Object value) {
        this.checkChanging();
        Variable v = this.getVar(key);
        if (v == null) {
            return;
        }
        Object addr = v.getObject();
        if (addr instanceof Object[]) {
            v.lowLevelInsert(index, value);
            if (this.inDatabase()) {
                Undo.insertVariable(this, v, index);
            }
        }
    }

    public void deleteFromVar(Variable.Key key, int index) {
        this.checkChanging();
        Variable v = this.getVar(key);
        if (v == null) {
            return;
        }
        Object addr = v.getObject();
        if (addr instanceof Object[]) {
            Object oldVal = ((Object[])addr)[index];
            v.lowLevelDelete(index);
            if (this.inDatabase()) {
                Undo.deleteVariable(this, v, index, oldVal);
            }
        }
    }

    public void copyVars(ElectricObject other) {
        this.checkChanging();
        Iterator it = other.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            Variable.Key key = var.getKey();
            Object obj = var.getObject();
            int flags = var.lowLevelGetFlags();
            TextDescriptor td = var.getTextDescriptor();
            Variable newVar = this.newVar(key, obj);
            if (newVar == null) continue;
            newVar.copyFlags(var);
            newVar.setTextDescriptor(td);
        }
    }

    public static String uniqueObjectName(String name, Cell cell, Class cls) {
        int startPos;
        int nextIndex;
        int endPos;
        int minusMinusPos;
        if (cell.isUniqueName(name, cls, null)) {
            return name;
        }
        int plusPlusPos = name.indexOf("++");
        if (plusPlusPos >= 0) {
            int numStart;
            for (numStart = plusPlusPos; numStart > 0 && Character.isDigit(name.charAt(numStart - 1)); --numStart) {
            }
            if (numStart < plusPlusPos) {
                int nextIndex2 = TextUtils.atoi(name.substring(numStart)) + 1;
                while (true) {
                    String newname;
                    if (cell.isUniqueName(newname = name.substring(0, numStart) + nextIndex2 + name.substring(plusPlusPos), cls, null)) {
                        return newname;
                    }
                    ++nextIndex2;
                }
            }
        }
        if ((minusMinusPos = name.indexOf("--")) >= 0) {
            int numStart;
            for (numStart = minusMinusPos; numStart > 0 && Character.isDigit(name.charAt(numStart - 1)); --numStart) {
            }
            if (numStart < minusMinusPos) {
                for (int nextIndex3 = TextUtils.atoi(name.substring(numStart)) - 1; nextIndex3 >= 0; --nextIndex3) {
                    String newname = name.substring(0, numStart) + nextIndex3 + name.substring(minusMinusPos);
                    if (!cell.isUniqueName(newname, cls, null)) continue;
                    return newname;
                }
            }
        }
        char separateChar = '_';
        int possibleEnd = 0;
        int nameLen = name.length();
        if (name.endsWith("]")) {
            int startPos2;
            int possibleStart = -1;
            endPos = nameLen - 1;
            while ((startPos2 = name.lastIndexOf(91, endPos)) >= 0) {
                int i = name.indexOf(44, startPos2);
                if (i >= 0 && i < endPos) {
                    if (startPos2 <= 0 || name.charAt(startPos2 - 1) != ']') break;
                    endPos = startPos2 - 1;
                    continue;
                }
                i = name.indexOf(58, startPos2);
                if (i >= 0 && i < endPos) {
                    String firstIndex = name.substring(startPos2 + 1, i);
                    String secondIndex = name.substring(i + 1, endPos);
                    if (TextUtils.isANumber(firstIndex) && TextUtils.isANumber(secondIndex)) {
                        int startIndex = TextUtils.atoi(firstIndex);
                        int endIndex = TextUtils.atoi(secondIndex);
                        int spacing = Math.abs(endIndex - startIndex) + 1;
                        int nextIndex4 = 1;
                        while (true) {
                            String newname;
                            if (cell.isUniqueName(newname = name.substring(0, startPos2) + "[" + (startIndex + spacing * nextIndex4) + ":" + (endIndex + spacing * nextIndex4) + name.substring(endPos), cls, null)) {
                                return newname;
                            }
                            ++nextIndex4;
                        }
                    }
                    if (startPos2 <= 0 || name.charAt(startPos2 - 1) != ']') break;
                    endPos = startPos2 - 1;
                    continue;
                }
                String bracketedExpression = name.substring(startPos2 + 1, endPos);
                if (TextUtils.isANumber(bracketedExpression)) {
                    int nextIndex5 = TextUtils.atoi(bracketedExpression) + 1;
                    while (true) {
                        String newname;
                        if (cell.isUniqueName(newname = name.substring(0, startPos2) + "[" + nextIndex5 + name.substring(endPos), cls, null)) {
                            return newname;
                        }
                        ++nextIndex5;
                    }
                }
                if (possibleStart < 0) {
                    possibleStart = startPos2;
                    possibleEnd = endPos;
                }
                if (startPos2 <= 0 || name.charAt(startPos2 - 1) != ']') break;
                endPos = startPos2 - 1;
            }
            if (possibleStart >= 0) {
                int i;
                for (i = possibleEnd - 1; i > possibleStart && Character.isDigit(name.charAt(i)); --i) {
                }
                nextIndex = TextUtils.atoi(name.substring(i + 1)) + 1;
                int startPos3 = i + 1;
                if (name.charAt(startPos3 - 1) == separateChar) {
                    --startPos3;
                }
                while (true) {
                    String newname;
                    if (cell.isUniqueName(newname = name.substring(0, startPos3) + separateChar + nextIndex + name.substring(possibleEnd), cls, null)) {
                        return newname;
                    }
                    ++nextIndex;
                }
            }
        }
        for (startPos = 0; startPos < name.length() && name.charAt(startPos) != '['; ++startPos) {
        }
        endPos = startPos;
        String localSepString = String.valueOf(separateChar);
        while (startPos > 0 && Character.isDigit(name.charAt(startPos - 1))) {
            --startPos;
        }
        nextIndex = 1;
        if (startPos >= endPos) {
            if (startPos > 0 && name.charAt(startPos - 1) == separateChar) {
                --startPos;
            }
        } else {
            nextIndex = TextUtils.atoi(name.substring(startPos)) + 1;
            localSepString = "";
        }
        String newName;
        while (!cell.isUniqueName(newName = name.substring(0, startPos) + localSepString + nextIndex + name.substring(endPos), cls, null)) {
            ++nextIndex;
        }
        return newName;
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        return false;
    }

    public Iterator getVariables() {
        if (this.vars == null) {
            return new ArrayList().iterator();
        }
        return this.vars.values().iterator();
    }

    public int getNumVariables() {
        if (this.vars == null) {
            return 0;
        }
        return this.vars.entrySet().size();
    }

    public static Iterator getVariableKeys() {
        return varKeys.values().iterator();
    }

    public static int getNumVariableKeys() {
        return varKeys.keySet().size();
    }

    public void checkChanging() {
        Job.checkChanging();
    }

    protected boolean inDatabase() {
        return true;
    }

    private static Variable.Key findKey(String name) {
        String lowCaseName;
        Variable.Key key = (Variable.Key)varKeys.get(name);
        if (key == null && !(lowCaseName = name.toLowerCase()).equals(name)) {
            key = (Variable.Key)varKeys.get(lowCaseName);
        }
        return key;
    }

    public static Variable.Key newKey(String name) {
        Variable.Key key = ElectricObject.findKey(name);
        if (key != null) {
            return key;
        }
        key = new Variable.Key(name);
        varKeys.put(name, key);
        varLowCaseKeys.put(name.toLowerCase(), key);
        return key;
    }

    public Cell whichCell() {
        return null;
    }

    public void getInfo() {
        if (this.vars == null) {
            return;
        }
        boolean firstvar = true;
        Iterator it = this.vars.keySet().iterator();
        while (it.hasNext()) {
            String par;
            Variable.Key key = (Variable.Key)it.next();
            Variable val = (Variable)this.vars.get(key);
            if (val == null) continue;
            if (firstvar) {
                System.out.println("Variables:");
            }
            firstvar = false;
            Object addr = val.getObject();
            TextDescriptor td = val.getTextDescriptor();
            String string = par = td.isParam() ? "(param)" : "";
            if (addr instanceof Object[]) {
                Object[] ary = (Object[])addr;
                System.out.print("   " + key.getName() + "(" + ary.length + ") = [");
                for (int i = 0; i < ary.length; ++i) {
                    if (i > 4) {
                        System.out.print("...");
                        break;
                    }
                    if (ary[i] instanceof String) {
                        System.out.print("\"");
                    }
                    System.out.print(ary[i]);
                    if (ary[i] instanceof String) {
                        System.out.print("\"");
                    }
                    if (i >= ary.length - 1) continue;
                    System.out.print(", ");
                }
                System.out.println("] " + par);
                continue;
            }
            System.out.println("   " + key.getName() + "= " + addr + " " + par);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

