/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nand2LT_sy {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double inbY = -4.0;
    private static final double inaY = 4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i;
        int i2;
        double totWid;
        sz = stdCell.roundSize(sz);
        String nm = "nand2LT_sy";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 3.0 * 2.0, 2);
        Nand2LT_sy.error(fwP == null, "can't make nand2LT_sy this small: " + sz);
        int nbStacked = 2;
        spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        totWid = sz * 3.0 * (double)nbStacked;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nand2LT_sy.error(fwN == null, "can't make nand2LT_sy this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inbX = 3.5;
        double mosX = inbX + 2.0 + 3.0 + 2.0;
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fwN.nbFolds, nbStacked, fwN.gateWid, nand);
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[fwP.nbFolds / 2];
        for (int i3 = 0; i3 < pmoss.length; ++i3) {
            double pmosPitch = 26.0;
            double pmosX = mosX + pmosPitch * (double)i3;
            pmoss[i3] = new FoldedPmos(pmosX, pmosY, 2, 1, fwP.gateWid, nand);
        }
        stdCell.fillDiffNotches(pmoss);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(pmoss, StdCellParams.EVEN, nand);
        LayoutLib.newExport(nand, "inb", PortProto.Characteristic.IN, Tech.m1, 4.0, inbX, -4.0);
        TrackRouterH inB = new TrackRouterH(Tech.m1, 3.0, -4.0, nand);
        inB.connect(nand.findExport("inb"));
        for (i2 = 0; i2 < nmos.nbGates(); i2 += 2) {
            inB.connect(nmos.getGate(i2, 'T'), -1.5);
        }
        for (i2 = 0; i2 < pmoss.length; ++i2) {
            inB.connect(pmoss[i2].getGate(0, 'B'), -1.5);
        }
        double inaX = StdCellParams.getRightDiffX(pmoss, nmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "ina", PortProto.Characteristic.IN, Tech.m1, 4.0, inaX, 4.0);
        TrackRouterH ina = new TrackRouterH(Tech.m1, 3.0, 4.0, nand);
        ina.connect(nand.findExport("ina"));
        for (i = 1; i < nmos.nbGates(); i += 2) {
            ina.connect(nmos.getGate(i, 'T'), 1.5);
        }
        for (i = 0; i < pmoss.length; ++i) {
            ina.connect(pmoss[i].getGate(1, 'B'), -1.5);
        }
        double outX = inaX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", PortProto.Characteristic.OUT, Tech.m1, 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(Tech.m2, 4.0, 11.0, nand);
        outHi.connect(nand.findExport("out"));
        for (int i4 = 0; i4 < pmoss.length; ++i4) {
            outHi.connect(pmoss[i4].getSrcDrn(1));
        }
        TrackRouterH outLo = new TrackRouterH(Tech.m2, 4.0, -11.0, nand);
        outLo.connect(nand.findExport("out"));
        for (int i5 = 1; i5 < nmos.nbSrcDrns(); i5 += 2) {
            outLo.connect(nmos.getSrcDrn(i5));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

