/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class ELIB
extends LibraryFiles {
    private int magic;
    private boolean bytesSwapped;
    private int sizeOfBig;
    private int sizeOfSmall;
    private int sizeOfChar;
    private int clippedIntegers;
    private int toolCount;
    private int toolBCount;
    private Tool[] toolList;
    private String[] toolError;
    private boolean toolBitsMessed;
    private int techCount;
    private Technology[] techList;
    private String[] techError;
    private double[] techScale;
    private int arcProtoCount;
    private PrimitiveArc[] arcProtoList;
    private String[] arcProtoError;
    private int primNodeProtoCount;
    private PrimitiveNode[] primNodeProtoList;
    private boolean[] primNodeProtoError;
    private String[] primNodeProtoOrig;
    private int[] primNodeProtoTech;
    private int primPortProtoCount;
    private PrimitivePort[] primPortProtoList;
    private String[] primPortProtoError;
    private Technology layoutTech;
    private int cellCount;
    private int curCell;
    private Input.FakeCell[] fakeCellList;
    private int[] nodeCounts;
    private int[] firstNodeIndex;
    private int[] arcCounts;
    private int[] firstArcIndex;
    private int[] portCounts;
    private int[] firstPortIndex;
    private int[] cellXOff;
    private int[] cellYOff;
    private boolean[] xLibRefSatisfied;
    private HashMap viewMapping;
    private int nodeCount;
    private LibraryFiles.NodeInstList nodeInstList;
    private int arcCount;
    private ArcInst[] arcList;
    private ArcProto[] arcTypeList;
    private Name[] arcNameList;
    private int[] arcWidthList;
    private int[] arcHeadXPosList;
    private int[] arcHeadYPosList;
    private int[] arcHeadNodeList;
    private Object[] arcHeadPortList;
    private int[] arcTailXPosList;
    private int[] arcTailYPosList;
    private int[] arcTailNodeList;
    private Object[] arcTailPortList;
    private int[] arcUserBits;
    private int portProtoCount;
    private int portProtoIndex;
    private Object[] portProtoList;
    private int[] portProtoSubNodeList;
    private Object[] portProtoSubPortList;
    private String[] portProtoNameList;
    private int[] portProtoUserbits;
    private int geomCount;
    private boolean[] geomType;
    private int[] geomMoreUp;
    private int nameCount;
    private Variable.Key[] realKey;
    private boolean convertTextDescriptors;
    private boolean alwaysTextDescriptors;
    private static ByteBuffer bb = ByteBuffer.allocateDirect(8);
    private static byte[] rawData = new byte[8];

    ELIB() {
    }

    protected boolean readLib() {
        try {
            return this.readTheLibrary();
        }
        catch (IOException e) {
            System.out.println("End of file reached while reading " + this.filePath);
            return true;
        }
    }

    private boolean readTheLibrary() throws IOException {
        int i;
        int cellIndex;
        int i2;
        int i3;
        String name;
        int i4;
        this.clippedIntegers = 0;
        this.byteCount = 0;
        this.layoutTech = null;
        if (this.readHeader()) {
            System.out.println("Error reading header");
            return true;
        }
        this.toolCount = this.readBigInteger();
        this.techCount = this.readBigInteger();
        this.primNodeProtoCount = this.readBigInteger();
        this.primPortProtoCount = this.readBigInteger();
        this.arcProtoCount = this.readBigInteger();
        this.nodeProtoCount = this.readBigInteger();
        this.nodeCount = this.readBigInteger();
        this.portProtoCount = this.readBigInteger();
        this.arcCount = this.readBigInteger();
        this.geomCount = this.readBigInteger();
        this.cellCount = this.magic <= -1589 && this.magic >= -1593 ? this.readBigInteger() : this.nodeProtoCount;
        this.curCell = this.readBigInteger();
        String versionString = this.magic <= -1587 ? this.readString() : "3.35";
        this.version = Version.parseVersion(versionString);
        this.emajor = this.version.getMajor();
        this.eminor = this.version.getMinor();
        this.edetail = this.version.getDetail();
        this.convertMosisCmosTechnologies = false;
        if (this.emajor < 6 || this.emajor == 6 && this.eminor < 3 || this.emajor == 6 && this.eminor == 3 && this.edetail < 17) {
            this.convertMosisCmosTechnologies = true;
        }
        this.convertTextDescriptors = false;
        if (this.emajor < 6 || this.emajor == 6 && this.eminor < 4 || this.emajor == 6 && this.eminor == 4 && this.edetail < 3) {
            this.convertTextDescriptors = true;
        }
        this.alwaysTextDescriptors = true;
        if (this.emajor < 6 || this.emajor == 6 && this.eminor < 5 || this.emajor == 6 && this.eminor == 5 && this.edetail < 24) {
            this.alwaysTextDescriptors = false;
        }
        this.viewMapping = new HashMap();
        this.viewMapping.put(new Integer(-1), View.UNKNOWN);
        this.viewMapping.put(new Integer(-2), View.LAYOUT);
        this.viewMapping.put(new Integer(-3), View.SCHEMATIC);
        this.viewMapping.put(new Integer(-4), View.ICON);
        this.viewMapping.put(new Integer(-5), View.DOCWAVE);
        this.viewMapping.put(new Integer(-6), View.LAYOUTSKEL);
        this.viewMapping.put(new Integer(-7), View.VHDL);
        this.viewMapping.put(new Integer(-8), View.NETLIST);
        this.viewMapping.put(new Integer(-9), View.DOC);
        this.viewMapping.put(new Integer(-10), View.NETLISTNETLISP);
        this.viewMapping.put(new Integer(-11), View.NETLISTALS);
        this.viewMapping.put(new Integer(-12), View.NETLISTQUISC);
        this.viewMapping.put(new Integer(-13), View.NETLISTRSIM);
        this.viewMapping.put(new Integer(-14), View.NETLISTSILOS);
        this.viewMapping.put(new Integer(-15), View.VERILOG);
        this.viewMapping.put(new Integer(-16), View.LAYOUTCOMP);
        if (this.magic <= -1589) {
            int numExtraViews = this.readBigInteger();
            for (int i5 = 0; i5 < numExtraViews; ++i5) {
                String viewName = this.readString();
                String viewShortName = this.readString();
                View view = View.findView(viewName);
                if (view == null && (view = this.findOldViewName(viewName)) == null && (view = View.newInstance(viewName, viewShortName)) == null) {
                    return true;
                }
                this.viewMapping.put(new Integer(i5 + 1), view);
            }
        }
        this.toolBCount = this.magic <= -1577 && this.magic >= -1583 ? this.readBigInteger() : this.toolCount;
        this.lib.erase();
        this.techList = new Technology[this.techCount];
        this.techError = new String[this.techCount];
        this.techScale = new double[this.techCount];
        this.arcProtoList = new PrimitiveArc[this.arcProtoCount];
        this.arcProtoError = new String[this.arcProtoCount];
        this.primNodeProtoList = new PrimitiveNode[this.primNodeProtoCount];
        this.primNodeProtoError = new boolean[this.primNodeProtoCount];
        this.primNodeProtoOrig = new String[this.primNodeProtoCount];
        this.primNodeProtoTech = new int[this.primNodeProtoCount];
        this.primPortProtoList = new PrimitivePort[this.primPortProtoCount];
        this.primPortProtoError = new String[this.primPortProtoCount];
        this.toolList = new Tool[this.toolCount];
        this.toolError = new String[this.toolCount];
        this.nodeProtoList = new Cell[this.nodeProtoCount];
        this.nodeCounts = new int[this.nodeProtoCount];
        this.firstNodeIndex = new int[this.nodeProtoCount + 1];
        this.arcCounts = new int[this.nodeProtoCount];
        this.firstArcIndex = new int[this.nodeProtoCount + 1];
        this.portCounts = new int[this.nodeProtoCount];
        this.firstPortIndex = new int[this.nodeProtoCount];
        this.cellLambda = new double[this.nodeProtoCount];
        this.cellXOff = new int[this.nodeProtoCount];
        this.cellYOff = new int[this.nodeProtoCount];
        this.xLibRefSatisfied = new boolean[this.nodeProtoCount];
        this.nodeInstList = new LibraryFiles.NodeInstList();
        this.nodeInstList.theNode = new NodeInst[this.nodeCount];
        this.nodeInstList.protoType = new NodeProto[this.nodeCount];
        this.nodeInstList.name = new Name[this.nodeCount];
        this.nodeInstList.lowX = new int[this.nodeCount];
        this.nodeInstList.highX = new int[this.nodeCount];
        this.nodeInstList.lowY = new int[this.nodeCount];
        this.nodeInstList.highY = new int[this.nodeCount];
        this.nodeInstList.anchorX = new int[this.nodeCount];
        this.nodeInstList.anchorY = new int[this.nodeCount];
        this.nodeInstList.rotation = new short[this.nodeCount];
        this.nodeInstList.transpose = new int[this.nodeCount];
        this.nodeInstList.userBits = new int[this.nodeCount];
        this.arcList = new ArcInst[this.arcCount];
        this.arcTypeList = new ArcProto[this.arcCount];
        this.arcNameList = new Name[this.arcCount];
        this.arcWidthList = new int[this.arcCount];
        this.arcHeadXPosList = new int[this.arcCount];
        this.arcHeadYPosList = new int[this.arcCount];
        this.arcHeadNodeList = new int[this.arcCount];
        this.arcHeadPortList = new Object[this.arcCount];
        this.arcTailXPosList = new int[this.arcCount];
        this.arcTailYPosList = new int[this.arcCount];
        this.arcTailNodeList = new int[this.arcCount];
        this.arcTailPortList = new Object[this.arcCount];
        this.arcUserBits = new int[this.arcCount];
        for (i4 = 0; i4 < this.arcCount; ++i4) {
            this.arcHeadNodeList[i4] = -1;
            this.arcHeadPortList[i4] = null;
            this.arcTailNodeList[i4] = -1;
            this.arcTailPortList[i4] = null;
            this.arcNameList[i4] = null;
            this.arcUserBits[i4] = 0;
        }
        this.portProtoList = new Object[this.portProtoCount];
        this.portProtoSubNodeList = new int[this.portProtoCount];
        this.portProtoSubPortList = new Object[this.portProtoCount];
        this.portProtoNameList = new String[this.portProtoCount];
        this.portProtoUserbits = new int[this.portProtoCount];
        if (this.magic <= -1589 && this.magic >= -1593) {
            this.fakeCellList = new Input.FakeCell[this.cellCount];
            for (i4 = 0; i4 < this.cellCount; ++i4) {
                this.fakeCellList[i4] = new Input.FakeCell();
            }
        }
        if (this.magic > -1581) {
            this.geomType = new boolean[this.geomCount];
            this.geomMoreUp = new int[this.geomCount];
        }
        if (this.magic != -1573) {
            int nodeInstPos = 0;
            int arcInstPos = 0;
            int portProtoPos = 0;
            for (int i6 = 0; i6 < this.nodeProtoCount; ++i6) {
                this.arcCounts[i6] = this.readBigInteger();
                this.nodeCounts[i6] = this.readBigInteger();
                this.portCounts[i6] = this.readBigInteger();
                if (this.arcCounts[i6] > 0 || this.nodeCounts[i6] > 0) {
                    arcInstPos += this.arcCounts[i6];
                    nodeInstPos += this.nodeCounts[i6];
                }
                portProtoPos += this.portCounts[i6];
            }
            if (nodeInstPos != this.nodeCount) {
                System.out.println("Error: cells have " + nodeInstPos + " nodes but library has " + this.nodeCount);
                return true;
            }
            if (arcInstPos != this.arcCount) {
                System.out.println("Error: cells have " + arcInstPos + " arcs but library has " + this.arcCount);
                return true;
            }
            if (portProtoPos != this.portProtoCount) {
                System.out.println("Error: cells have " + portProtoPos + " ports but library has " + this.portProtoCount);
                return true;
            }
        } else {
            this.arcCounts[0] = this.arcCount;
            this.nodeCounts[0] = this.nodeCount;
            this.portCounts[0] = this.portProtoCount;
            for (i4 = 1; i4 < this.nodeProtoCount; ++i4) {
                this.portCounts[i4] = 0;
                this.nodeCounts[i4] = 0;
                this.arcCounts[i4] = 0;
            }
        }
        for (i4 = 0; i4 < this.nodeProtoCount; ++i4) {
            if (this.arcCounts[i4] < 0 && this.nodeCounts[i4] < 0) {
                this.nodeProtoList[i4] = null;
                this.xLibRefSatisfied[i4] = false;
                continue;
            }
            this.nodeProtoList[i4] = Cell.lowLevelAllocate(this.lib);
            if (this.nodeProtoList[i4] == null) {
                return true;
            }
            this.xLibRefSatisfied[i4] = true;
        }
        int nodeinstpos = 0;
        int arcinstpos = 0;
        int portprotopos = 0;
        for (int cellIndex2 = 0; cellIndex2 < this.nodeProtoCount; ++cellIndex2) {
            int thisone;
            int i7;
            Cell cell = this.nodeProtoList[cellIndex2];
            if (cell == null) {
                for (i7 = 0; i7 < this.portCounts[cellIndex2]; ++i7) {
                    this.portProtoList[portprotopos + i7] = null;
                }
                portprotopos += this.portCounts[cellIndex2];
                continue;
            }
            for (i7 = 0; i7 < this.nodeCounts[cellIndex2]; ++i7) {
                thisone = i7 + nodeinstpos;
                this.nodeInstList.theNode[thisone] = NodeInst.lowLevelAllocate();
                if (this.nodeInstList.theNode[thisone] != null) continue;
                return true;
            }
            nodeinstpos += this.nodeCounts[cellIndex2];
            for (i7 = 0; i7 < this.portCounts[cellIndex2]; ++i7) {
                thisone = i7 + portprotopos;
                this.portProtoList[thisone] = Export.lowLevelAllocate();
                if (this.portProtoList[thisone] != null) continue;
                return true;
            }
            portprotopos += this.portCounts[cellIndex2];
            for (i7 = 0; i7 < this.arcCounts[cellIndex2]; ++i7) {
                thisone = i7 + arcinstpos;
                this.arcList[thisone] = ArcInst.lowLevelAllocate();
                if (this.arcList[thisone] != null) continue;
                return true;
            }
            arcinstpos += this.arcCounts[cellIndex2];
        }
        this.primNodeProtoCount = 0;
        this.primPortProtoCount = 0;
        this.arcProtoCount = 0;
        for (int techIndex = 0; techIndex < this.techCount; ++techIndex) {
            name = this.readString();
            Technology tech = this.findTechnologyName(name);
            boolean imosconv = false;
            if (name.equals("imos")) {
                tech = MoCMOS.tech;
                imosconv = true;
            }
            if (tech == null) {
                Iterator it = Technology.getTechnologies();
                tech = (Technology)it.next();
                this.techError[techIndex] = name;
            } else {
                this.techError[techIndex] = null;
            }
            this.techList[techIndex] = tech;
            int numPrimNodes = this.readBigInteger();
            for (int j = 0; j < numPrimNodes; ++j) {
                PrimitiveNode pnp;
                this.primNodeProtoOrig[this.primNodeProtoCount] = null;
                this.primNodeProtoError[this.primNodeProtoCount] = false;
                name = this.readString();
                if (imosconv) {
                    name = name.substring(6);
                }
                if ((pnp = tech.findNodeProto(name)) == null && name.equals("Active-Node")) {
                    pnp = tech.findNodeProto("P-Active-Node");
                }
                if (pnp == null) {
                    String primName;
                    PrimitiveNode opnp;
                    boolean advise = true;
                    Iterator it = tech.getNodes();
                    while (it.hasNext()) {
                        opnp = (PrimitiveNode)it.next();
                        primName = opnp.getName();
                        if (!primName.startsWith(name) && !name.startsWith(primName)) continue;
                        pnp = opnp;
                        break;
                    }
                    if (pnp == null) {
                        it = tech.getNodes();
                        while (it.hasNext()) {
                            opnp = (PrimitiveNode)it.next();
                            primName = opnp.getName();
                            if (!primName.endsWith(name) && !name.endsWith(primName)) continue;
                            pnp = opnp;
                            break;
                        }
                    }
                    if (pnp == null && (pnp = tech.convertOldNodeName(name)) != null) {
                        advise = false;
                    }
                    if (pnp == null) {
                        it = tech.getNodes();
                        pnp = (PrimitiveNode)it.next();
                    }
                    if (advise) {
                        String errorMessage = this.techError[techIndex] != null ? this.techError[techIndex] : tech.getTechName();
                        this.primNodeProtoOrig[this.primNodeProtoCount] = errorMessage = errorMessage + ":" + name;
                        this.primNodeProtoError[this.primNodeProtoCount] = true;
                    }
                }
                this.primNodeProtoTech[this.primNodeProtoCount] = techIndex;
                this.primNodeProtoList[this.primNodeProtoCount] = pnp;
                int numPrimPorts = this.readBigInteger();
                for (int i8 = 0; i8 < numPrimPorts; ++i8) {
                    this.primPortProtoError[this.primPortProtoCount] = null;
                    name = this.readString();
                    PrimitivePort pp = (PrimitivePort)pnp.findPortProto(name);
                    if (pp == null) {
                        pp = tech.convertOldPortName(name, pnp);
                    }
                    if (pp == null) {
                        Iterator it = pnp.getPorts();
                        pp = (PrimitivePort)it.next();
                        if (!this.primNodeProtoError[this.primNodeProtoCount]) {
                            String errorMessage = name + " on ";
                            if (this.primNodeProtoOrig[this.primNodeProtoCount] != null) {
                                errorMessage = errorMessage + this.primNodeProtoOrig[this.primNodeProtoCount];
                            } else {
                                errorMessage = this.techError[techIndex] != null ? errorMessage + this.techError[techIndex] : errorMessage + tech.getTechName();
                                errorMessage = errorMessage + ":" + pnp.getName();
                            }
                            this.primPortProtoError[this.primPortProtoCount] = errorMessage;
                        }
                    }
                    this.primPortProtoList[this.primPortProtoCount++] = pp;
                }
                ++this.primNodeProtoCount;
            }
            int numArcProtos = this.readBigInteger();
            for (int j = 0; j < numArcProtos; ++j) {
                PrimitiveArc ap;
                this.arcProtoError[this.arcProtoCount] = null;
                name = this.readString();
                if (imosconv) {
                    name = name.substring(6);
                }
                if ((ap = tech.findArcProto(name)) == null) {
                    ap = tech.convertOldArcName(name);
                }
                if (ap == null) {
                    Iterator it = tech.getArcs();
                    ap = (PrimitiveArc)it.next();
                    String errorMessage = this.techError[techIndex] != null ? this.techError[techIndex] : tech.getTechName();
                    this.arcProtoError[this.arcProtoCount] = errorMessage = errorMessage + ":" + name;
                }
                this.arcProtoList[this.arcProtoCount++] = ap;
            }
        }
        this.toolBitsMessed = false;
        for (i3 = 0; i3 < this.toolCount; ++i3) {
            name = this.readString();
            this.toolError[i3] = null;
            Tool t = Tool.findTool(name);
            int toolIndex = -1;
            if (t == null) {
                this.toolError[i3] = name;
            } else {
                toolIndex = t.getIndex();
            }
            if (i3 != toolIndex) {
                this.toolBitsMessed = true;
            }
            this.toolList[i3] = t;
        }
        if (this.magic <= -1577 && this.magic >= -1583) {
            for (i3 = 0; i3 < this.toolBCount; ++i3) {
                this.readString();
            }
        }
        int userBits = 0;
        if (this.magic <= -1585) {
            userBits = this.readBigInteger();
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i9 = 1; i9 < this.toolBCount; ++i9) {
                this.readBigInteger();
            }
        }
        this.lib.lowLevelSetUserBits(userBits);
        this.lib.clearChangedMajor();
        this.lib.clearChangedMinor();
        this.lib.setFromDisk();
        for (i2 = 0; i2 < this.techCount; ++i2) {
            String varName;
            Pref.Meaning meaning;
            int lambda = this.readBigInteger();
            if (this.techError[i2] != null) continue;
            Technology tech = this.techList[i2];
            if (this.emajor <= 4) {
                lambda *= 20;
            }
            int index = tech.getIndex();
            this.techScale[index] = lambda;
            if (!this.topLevelLibrary || (meaning = Pref.getMeaningVariable(tech, varName = tech.getScaleVariableName())) == null) continue;
            Variable var = tech.newVar(varName, (Object)new Double(lambda / 2));
            Pref.changedMeaningVariable(meaning);
        }
        if (this.readNameSpace()) {
            System.out.println("Error reading namespace");
            return true;
        }
        if (this.readVariables(this.lib, -1) < 0) {
            return true;
        }
        Input.getFontAssociationVariable(this.lib);
        Input.fixVariableFont(this.lib);
        for (i2 = 0; i2 < this.toolCount; ++i2) {
            Tool tool = this.toolList[i2];
            if (tool == null) {
                this.ignoreVariables();
                continue;
            }
            if (this.readVariables(tool, -1) < 0) {
                return true;
            }
            Input.fixVariableFont(tool);
        }
        for (i2 = 0; i2 < this.techCount; ++i2) {
            Technology tech = this.techList[i2];
            if (tech == null) {
                this.ignoreVariables();
                continue;
            }
            int j = this.readVariables(tech, -1);
            if (j < 0) {
                return true;
            }
            if (j > 0) {
                this.getTechList(i2);
            }
            Input.fixVariableFont(tech);
        }
        for (i2 = 0; i2 < this.arcProtoCount; ++i2) {
            PrimitiveArc ap = this.arcProtoList[i2];
            int j = this.readVariables(ap, -1);
            if (j < 0) {
                return true;
            }
            if (j > 0) {
                this.getArcProtoList(i2);
            }
            Input.fixVariableFont(ap);
        }
        for (i2 = 0; i2 < this.primNodeProtoCount; ++i2) {
            PrimitiveNode np = this.primNodeProtoList[i2];
            int j = this.readVariables(np, -1);
            if (j < 0) {
                return true;
            }
            if (j > 0) {
                this.getPrimNodeProtoList(i2);
            }
            Input.fixVariableFont(np);
        }
        for (i2 = 0; i2 < this.primPortProtoCount; ++i2) {
            PrimitivePort pp = this.primPortProtoList[i2];
            int j = this.readVariables(pp, -1);
            if (j < 0) {
                return true;
            }
            if (j <= 0) continue;
            this.getPrimPortProtoList(i2);
        }
        if (this.magic <= -1589) {
            int count = this.readBigInteger();
            for (int i10 = 0; i10 < count; ++i10) {
                int j = this.readBigInteger();
                View v = this.getView(j);
                if (v != null) {
                    if (this.readVariables(v, -1) < 0) {
                        return true;
                    }
                    Input.fixVariableFont(v);
                    continue;
                }
                System.out.println("View index " + j + " not found");
                this.ignoreVariables();
            }
        }
        if (this.magic <= -1589 && this.magic >= -1593) {
            for (i2 = 0; i2 < this.cellCount; ++i2) {
                String thecellname = this.readString();
                this.ignoreVariables();
                this.fakeCellList[i2].cellName = thecellname;
            }
        }
        this.portProtoIndex = 0;
        for (i2 = 0; i2 < this.nodeProtoCount; ++i2) {
            Cell cell = this.nodeProtoList[i2];
            if (cell == null || !this.readNodeProto(cell, i2)) continue;
            System.out.println("Error reading cell");
            return true;
        }
        FlagSet cellFlag = NodeProto.getFlagSet(1);
        for (cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            Cell cell = this.nodeProtoList[cellIndex];
            if (cell == null) continue;
            cell.clearBit(cellFlag);
        }
        block30: for (cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            Cell cell;
            if (this.magic <= -1589 && this.magic >= -1593 || (cell = this.nodeProtoList[cellIndex]) == null || cell.isBit(cellFlag)) continue;
            Cell.CellGroup cg = new Cell.CellGroup();
            while (true) {
                Cell otherCell;
                cell.setBit(cellFlag);
                cell.setCellGroup(cg);
                Object other = cell.getTempObj();
                if (other == null || !(other instanceof Cell) || (otherCell = (Cell)other) == null || otherCell.isBit(cellFlag)) continue block30;
                cell = otherCell;
            }
        }
        cellFlag.freeFlagSet();
        for (cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            Cell cell = this.nodeProtoList[cellIndex];
            if (cell == null) continue;
            cell.setTempObj(null);
            cell.lowLevelLink();
        }
        for (i = 0; i < this.nodeProtoCount; ++i) {
            Cell cell = this.nodeProtoList[i];
            if (cell != null || !this.readExternalNodeProto(this.lib, i)) continue;
            System.out.println("Error reading external cell");
            return true;
        }
        this.fixExternalVariables(this.lib);
        for (i = 0; i < this.toolCount; ++i) {
            Tool tool = this.toolList[i];
            this.fixExternalVariables(tool);
        }
        for (i = 0; i < this.techCount; ++i) {
            Technology tech = this.techList[i];
            this.fixExternalVariables(tech);
        }
        for (i = 0; i < this.arcProtoCount; ++i) {
            PrimitiveArc ap = this.arcProtoList[i];
            this.fixExternalVariables(ap);
        }
        for (i = 0; i < this.primNodeProtoCount; ++i) {
            PrimitiveNode np = this.primNodeProtoList[i];
            this.fixExternalVariables(np);
        }
        for (i = 0; i < this.primPortProtoCount; ++i) {
            PrimitivePort pp = this.primPortProtoList[i];
            this.fixExternalVariables(pp);
        }
        Iterator it = View.getViews();
        while (it.hasNext()) {
            View view = (View)it.next();
            this.fixExternalVariables(view);
        }
        for (int i11 = 0; i11 < this.nodeProtoCount; ++i11) {
            Cell cell = this.nodeProtoList[i11];
            this.fixExternalVariables(cell);
        }
        int nodeIndex = 0;
        int arcIndex = 0;
        int geomIndex = 0;
        for (int cellIndex3 = 0; cellIndex3 < this.nodeProtoCount; ++cellIndex3) {
            int j;
            Cell cell = this.nodeProtoList[cellIndex3];
            this.firstNodeIndex[cellIndex3] = nodeIndex;
            this.firstArcIndex[cellIndex3] = arcIndex;
            if (this.magic > -1581) {
                j = geomIndex;
                this.readGeom(this.geomType, this.geomMoreUp, j);
                this.readGeom(this.geomType, this.geomMoreUp, ++j);
                int top = ++j;
                this.readGeom(this.geomType, this.geomMoreUp, j);
                int bot = ++j;
                this.readGeom(this.geomType, this.geomMoreUp, j);
                ++j;
                do {
                    this.readGeom(this.geomType, this.geomMoreUp, j);
                } while (this.geomMoreUp[++j - 1] != top);
                geomIndex = j;
                int look = bot;
                while (look != top) {
                    if (!this.geomType[look]) {
                        if (this.readArcInst(arcIndex)) {
                            System.out.println("Error reading arc");
                            return true;
                        }
                        ++arcIndex;
                    } else {
                        if (this.readNodeInst(nodeIndex, cellIndex3)) {
                            System.out.println("Error reading node");
                            return true;
                        }
                        ++nodeIndex;
                    }
                    look = this.geomMoreUp[look];
                }
                continue;
            }
            for (j = 0; j < this.arcCounts[cellIndex3]; ++j) {
                if (this.readArcInst(arcIndex)) {
                    System.out.println("Error reading arc");
                    return true;
                }
                ++arcIndex;
            }
            for (j = 0; j < this.nodeCounts[cellIndex3]; ++j) {
                if (this.readNodeInst(nodeIndex, cellIndex3)) {
                    System.out.println("Error reading node index " + nodeIndex + " in cell " + cell.describe() + " of library " + this.lib.getName());
                    return true;
                }
                ++nodeIndex;
            }
        }
        this.firstNodeIndex[this.nodeProtoCount] = nodeIndex;
        this.firstArcIndex[this.nodeProtoCount] = arcIndex;
        if (this.curCell >= 0 && this.curCell < this.nodeProtoCount) {
            NodeProto currentCell = this.convertNodeProto(this.curCell);
            this.lib.setCurCell((Cell)currentCell);
        }
        Iterator it2 = this.lib.getCells();
        while (it2.hasNext()) {
            Cell c = (Cell)it2.next();
            if (c.getVar(IO_DUMMY_OBJECT) == null) continue;
            System.out.println("WARNING: Library " + this.lib.getName() + " contains DUMMY cell " + c.noLibDescribe());
        }
        return false;
    }

    protected void realizeCellsRecursively(Cell cell, FlagSet recursiveSetupFlag, String scaledCellName, double scaleX, double scaleY) {
        int i;
        double lambdaX;
        int j;
        boolean dummyCell;
        if (cell.getLibrary() != this.lib) {
            return;
        }
        boolean bl = dummyCell = cell.getVar(IO_DUMMY_OBJECT) != null;
        if (dummyCell) {
            return;
        }
        int cellIndex = cell.getTempInt();
        if (cellIndex + 1 >= this.firstNodeIndex.length) {
            return;
        }
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        block0: for (int i2 = startNode; i2 < endNode; ++i2) {
            Cell subCell;
            NodeProto np = this.nodeInstList.protoType[i2];
            if (np instanceof PrimitiveNode || (subCell = (Cell)np).getLibrary() == this.lib) continue;
            for (int cI = 0; cI < this.nodeProtoCount; ++cI) {
                LibraryFiles reader;
                if (this.nodeProtoList[cI] != subCell) continue;
                if (this.xLibRefSatisfied[cI]) continue block0;
                if (!subCell.isBit(recursiveSetupFlag) && (reader = this.getReaderForLib(subCell.getLibrary())) != null) {
                    reader.realizeCellsRecursively(subCell, recursiveSetupFlag, null, 0.0, 0.0);
                }
                int startPort = this.firstPortIndex[cI];
                int endPort = startPort + this.portCounts[cI];
                for (j = startPort; j < endPort; ++j) {
                    Object obj = this.portProtoList[j];
                    Export pp = null;
                    Cell otherCell = null;
                    if (!(obj instanceof Cell) || (pp = (otherCell = (Cell)obj).findExport(this.portProtoNameList[j])) == null) continue;
                    this.portProtoList[j] = pp;
                }
                this.xLibRefSatisfied[cI] = true;
                continue block0;
            }
        }
        this.scanNodesForRecursion(cell, recursiveSetupFlag, this.nodeInstList.protoType, startNode, endNode);
        progress.setProgress(++cellsConstructed * 100 / totalCells);
        double lambdaY = lambdaX = this.cellLambda[cellIndex];
        NodeInst[] oldNodes = null;
        if (scaledCellName != null) {
            Cell oldCell = cell;
            cell = Cell.lowLevelAllocate(cell.getLibrary());
            cell.lowLevelPopulate(scaledCellName);
            cell.lowLevelLink();
            cell.setTempInt(cellIndex);
            cell.setBit(recursiveSetupFlag);
            cell.joinGroup(oldCell);
            if (scaleX != scaleY) {
                this.skewedCells.add(cell);
            } else {
                this.scaledCells.add(cell);
            }
            lambdaX /= scaleX;
            lambdaY /= scaleY;
            oldNodes = new NodeInst[endNode - startNode];
            j = 0;
            for (int i3 = startNode; i3 < endNode; ++i3) {
                oldNodes[j] = this.nodeInstList.theNode[i3];
                this.nodeInstList.theNode[i3] = NodeInst.lowLevelAllocate();
                ++j;
            }
        } else {
            scaleY = 1.0;
            scaleX = 1.0;
        }
        int xoff = 0;
        int yoff = 0;
        for (i = startNode; i < endNode; ++i) {
            if (this.nodeInstList.protoType[i] != Generic.tech.cellCenterNode) continue;
            this.realizeNode(i, xoff, yoff, lambdaX, lambdaY, cell, recursiveSetupFlag);
            xoff = (this.nodeInstList.lowX[i] + this.nodeInstList.highX[i]) / 2;
            yoff = (this.nodeInstList.lowY[i] + this.nodeInstList.highY[i]) / 2;
            break;
        }
        this.cellXOff[cellIndex] = xoff;
        this.cellYOff[cellIndex] = yoff;
        for (i = startNode; i < endNode; ++i) {
            if (this.nodeInstList.protoType[i] == Generic.tech.cellCenterNode) continue;
            this.realizeNode(i, xoff, yoff, lambdaX, lambdaY, cell, recursiveSetupFlag);
        }
        this.realizeExports(cell, cellIndex, scaledCellName);
        this.realizeArcs(cell, cellIndex, scaledCellName, scaleX, scaleY);
        if (scaledCellName != null) {
            int j2 = 0;
            for (int i4 = startNode; i4 < endNode; ++i4) {
                this.nodeInstList.theNode[i4] = oldNodes[j2++];
            }
        }
    }

    protected boolean spreadLambda(Cell cell, int cellIndex) {
        boolean changed = false;
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        double thisLambda = this.cellLambda[cellIndex];
        for (int i = startNode; i < endNode; ++i) {
            int subCellIndex;
            double subLambda;
            Cell subCell;
            NodeProto np = this.nodeInstList.protoType[i];
            if (np instanceof PrimitiveNode || (subCell = (Cell)np).getVar(IO_DUMMY_OBJECT) != null) continue;
            LibraryFiles reader = this;
            if (subCell.getLibrary() != this.lib && (reader = this.getReaderForLib(subCell.getLibrary())) == null || !((subLambda = reader.cellLambda[subCellIndex = subCell.getTempInt()]) < thisLambda)) continue;
            reader.cellLambda[subCellIndex] = thisLambda;
            changed = true;
        }
        return changed;
    }

    protected double computeLambda(Cell cell, int cellIndex) {
        double lambda = 1.0;
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        int startArc = this.firstArcIndex[cellIndex];
        int endArc = this.firstArcIndex[cellIndex + 1];
        Technology cellTech = Technology.whatTechnology(cell, this.nodeInstList.protoType, startNode, endNode, this.arcTypeList, startArc, endArc);
        cell.setTechnology(cellTech);
        if (cellTech != null) {
            lambda = this.techScale[cellTech.getIndex()];
        }
        return lambda;
    }

    private void realizeExports(Cell cell, int cellIndex, String scaledCellName) {
        int startPort = this.firstPortIndex[cellIndex];
        int endPort = startPort + this.portCounts[cellIndex];
        for (int i = startPort; i < endPort; ++i) {
            int nodeIndex;
            if (!(this.portProtoList[i] instanceof Export)) {
                if (cell.getVar(IO_DUMMY_OBJECT) != null) continue;
                System.out.println("ERROR: Cell " + cell.describe() + ": export " + this.portProtoNameList[i] + " is unresolved");
                continue;
            }
            Export pp = (Export)this.portProtoList[i];
            if (scaledCellName != null) {
                String oldName = pp.getName();
                pp = Export.lowLevelAllocate();
                pp.lowLevelName(cell, oldName);
            }
            if ((nodeIndex = this.portProtoSubNodeList[i]) < 0) {
                System.out.println("ERROR: Cell " + cell.describe() + ": cannot find the node on which export " + pp.getName() + " resides");
                continue;
            }
            NodeInst subNodeInst = this.nodeInstList.theNode[nodeIndex];
            if (this.portProtoSubPortList[i] instanceof Integer) {
                int index = (Integer)this.portProtoSubPortList[i];
                this.portProtoSubPortList[i] = this.convertPortProto(index);
            }
            PortProto subPortProto = (PortProto)this.portProtoSubPortList[i];
            if (subNodeInst == null || subPortProto == null) {
                System.out.println("ERROR: Cell " + cell.describe() + ": export " + this.portProtoNameList[i] + " could not be created");
                continue;
            }
            if (subNodeInst.getProto() == null) {
                System.out.println("ERROR: Cell " + cell.describe() + ": export " + this.portProtoNameList[i] + " could not be created...proto bad!");
                continue;
            }
            String exportName = this.portProtoNameList[i];
            PortInst pi = subNodeInst.findPortInst(subPortProto.getName());
            if (pp.lowLevelPopulate(pi)) {
                return;
            }
            if (pp.lowLevelLink(null)) {
                return;
            }
            pp.lowLevelSetUserbits(this.portProtoUserbits[i]);
        }
        int startNode = this.firstNodeIndex[cellIndex];
        int endNode = this.firstNodeIndex[cellIndex + 1];
        for (int i = startNode; i < endNode; ++i) {
            NodeInst ni = this.nodeInstList.theNode[i];
            boolean found = true;
            block2: while (found) {
                found = false;
                Iterator it = ni.getVariables();
                while (it.hasNext()) {
                    String thePortName;
                    PortInst pi;
                    Variable origVar = (Variable)it.next();
                    Variable.Key origVarKey = origVar.getKey();
                    String origVarName = origVarKey.getName();
                    if (!origVarName.startsWith("ATTRP_")) continue;
                    StringBuffer portName = new StringBuffer();
                    String varName = null;
                    int len = origVarName.length();
                    for (int j = 6; j < len; ++j) {
                        char ch = origVarName.charAt(j);
                        if (ch == '\\') {
                            portName.append(origVarName.charAt(++j));
                            continue;
                        }
                        if (ch == '_') {
                            varName = origVarName.substring(j + 1);
                            break;
                        }
                        portName.append(ch);
                    }
                    if (varName == null || (pi = ni.findPortInst(thePortName = portName.toString())) == null) continue;
                    Variable var = pi.newVar(varName, origVar.getObject());
                    if (var != null) {
                        if (origVar.isDisplay()) {
                            var.setDisplay(true);
                        }
                        var.setCode(origVar.getCode());
                        var.setTextDescriptor(origVar.getTextDescriptor());
                    }
                    ni.delVar(origVarKey);
                    found = true;
                    continue block2;
                }
            }
        }
    }

    private void realizeArcs(Cell cell, int cellIndex, String scaledCellName, double scaleX, double scaleY) {
        double lambdaX = this.cellLambda[cellIndex] / scaleX;
        double lambdaY = this.cellLambda[cellIndex] / scaleY;
        int xoff = this.cellXOff[cellIndex];
        int yoff = this.cellYOff[cellIndex];
        boolean arcInfoError = false;
        int startArc = this.firstArcIndex[cellIndex];
        int endArc = this.firstArcIndex[cellIndex + 1];
        for (int i = startArc; i < endArc; ++i) {
            Connection con;
            ArcInst ai = this.arcList[i];
            if (scaledCellName != null) {
                ai = ArcInst.lowLevelAllocate();
            }
            ArcProto ap = this.arcTypeList[i];
            Name name = this.arcNameList[i];
            double width = (double)this.arcWidthList[i] / lambdaX;
            double headX = (double)(this.arcHeadXPosList[i] - xoff) / lambdaX;
            double headY = (double)(this.arcHeadYPosList[i] - yoff) / lambdaY;
            double tailX = (double)(this.arcTailXPosList[i] - xoff) / lambdaX;
            double tailY = (double)(this.arcTailYPosList[i] - yoff) / lambdaY;
            if (this.arcHeadNodeList[i] < 0) {
                System.out.println("ERROR: head of arc " + ap.describe() + " not known");
                continue;
            }
            NodeInst headNode = this.nodeInstList.theNode[this.arcHeadNodeList[i]];
            Object headPort = this.arcHeadPortList[i];
            int headPortIntValue = -1;
            String headname = "Port name not found";
            if (headPort instanceof Integer) {
                headPortIntValue = (Integer)headPort;
                headPort = this.convertPortProto(headPortIntValue);
            }
            if (headPort != null) {
                headname = ((PortProto)headPort).getName();
            } else if (headPortIntValue >= 0 && headPortIntValue < this.portProtoNameList.length) {
                headname = this.portProtoNameList[headPortIntValue];
            }
            if (this.arcTailNodeList[i] < 0) {
                System.out.println("ERROR: tail of arc " + ap.describe() + " not known");
                continue;
            }
            NodeInst tailNode = this.nodeInstList.theNode[this.arcTailNodeList[i]];
            Object tailPort = this.arcTailPortList[i];
            int tailPortIntValue = -1;
            String tailname = "Port name not found";
            if (tailPort instanceof Integer) {
                tailPortIntValue = (Integer)tailPort;
                tailPort = this.convertPortProto(tailPortIntValue);
                if (tailPortIntValue > 0 && tailPortIntValue < this.portProtoNameList.length) {
                    tailname = this.portProtoNameList[tailPortIntValue];
                }
            }
            if (tailPort != null) {
                tailname = ((PortProto)tailPort).getName();
            } else if (tailPortIntValue >= 0 && tailPortIntValue < this.portProtoNameList.length) {
                tailname = this.portProtoNameList[tailPortIntValue];
            }
            PortInst headPortInst = this.getArcEnd(ai, ap, headNode, headname, headX, headY, cell);
            PortInst tailPortInst = this.getArcEnd(ai, ap, tailNode, tailname, tailX, tailY, cell);
            if (headPortInst == null || tailPortInst == null) {
                System.out.println("Cannot create arc of type " + ap.getName() + " in cell " + cell.getName() + " because ends are unknown");
                continue;
            }
            ai.lowLevelSetUserbits(this.arcUserBits[i]);
            int defAngle = ai.lowLevelGetArcAngle() * 10;
            ai.lowLevelPopulate(ap, width, tailPortInst, new Point2D.Double(tailX, tailY), headPortInst, new Point2D.Double(headX, headY), defAngle);
            if (name != null) {
                ai.setNameKey(name);
            }
            if ((this.arcUserBits[i] & 0x40000) != 0) {
                con = ai.getTail();
                if (ai.isReverseEnds()) {
                    con = ai.getHead();
                }
                con.setNegated(true);
            }
            if ((this.arcUserBits[i] & 0x10000) != 0) {
                con = ai.getHead();
                if (ai.isReverseEnds()) {
                    con = ai.getTail();
                }
                con.setNegated(true);
            }
            ai.lowLevelLink();
        }
    }

    private void realizeNode(int i, int xoff, int yoff, double lambdaX, double lambdaY, Cell cell, FlagSet recursiveSetupFlag) {
        Cell subCell;
        Rectangle2D bounds;
        NodeInst ni = this.nodeInstList.theNode[i];
        NodeProto np = this.nodeInstList.protoType[i];
        Name name = this.nodeInstList.name[i];
        double lowX = this.nodeInstList.lowX[i] - xoff;
        double lowY = this.nodeInstList.lowY[i] - yoff;
        double highX = this.nodeInstList.highX[i] - xoff;
        double highY = this.nodeInstList.highY[i] - yoff;
        Point2D.Double center = new Point2D.Double((lowX + highX) / 2.0 / lambdaX, (lowY + highY) / 2.0 / lambdaY);
        double width = (highX - lowX) / lambdaX;
        double height = (highY - lowY) / lambdaY;
        double anchorX = (double)this.nodeInstList.anchorX[i] / lambdaX;
        double anchorY = (double)this.nodeInstList.anchorY[i] / lambdaY;
        if (np instanceof Cell && ((bounds = (subCell = (Cell)np).getBounds()).getWidth() != width || bounds.getHeight() != height)) {
            if (Math.abs(bounds.getWidth() - width) > 0.5 || Math.abs(bounds.getHeight() - height) > 0.5) {
                double scaleX = width / bounds.getWidth();
                double scaleY = height / bounds.getHeight();
                String scaledCellName = subCell.getName() + "-SCALED-BY-" + scaleX + "{" + subCell.getView().getAbbreviation() + "}";
                if (!DBMath.doublesClose(scaleX, scaleY)) {
                    scaledCellName = subCell.getName() + "-SCALED-BY-" + scaleX + "-AND-" + scaleY + "{" + subCell.getView().getAbbreviation() + "}";
                } else {
                    Cell scaledCell = subCell.getLibrary().findNodeProto(scaledCellName);
                    if (scaledCell == null) {
                        LibraryFiles reader = this;
                        if (subCell.getLibrary() != this.lib) {
                            reader = this.getReaderForLib(subCell.getLibrary());
                        }
                        if (reader != null) {
                            ((LibraryFiles)reader).realizeCellsRecursively(subCell, recursiveSetupFlag, scaledCellName, scaleX, scaleY);
                        }
                        if ((scaledCell = subCell.getLibrary().findNodeProto(scaledCellName)) == null) {
                            System.out.println("Error scaling cell " + subCell.describe() + " by " + scaleX);
                        }
                    }
                    if (scaledCell != null) {
                        bounds = scaledCell.getBounds();
                        np = scaledCell;
                    }
                    if (Math.abs(bounds.getWidth() - width) > 0.5 || Math.abs(bounds.getHeight() - height) > 0.5) {
                        Cell dummyCell = null;
                        if (dummyCell == null) {
                            System.out.println("Cell " + cell.describe() + ": adjusting size of instance of " + subCell.describe() + " (cell is " + bounds.getWidth() + "x" + bounds.getHeight() + " but instance is " + width + "x" + height + ")");
                        } else {
                            np = dummyCell;
                            bounds = dummyCell.getBounds();
                        }
                    }
                }
            }
            width = bounds.getWidth();
            height = bounds.getHeight();
        }
        int rotation = this.nodeInstList.rotation[i];
        if (this.emajor > 7 || this.emajor == 7 && this.eminor >= 1) {
            if ((this.nodeInstList.transpose[i] & 1) != 0) {
                height = -height;
                rotation = (rotation + 900) % 3600;
            }
            if ((this.nodeInstList.transpose[i] & 2) != 0) {
                width = -width;
            }
            if ((this.nodeInstList.transpose[i] & 4) != 0) {
                height = -height;
            }
        } else if (this.nodeInstList.transpose[i] != 0) {
            height = -height;
            rotation = (rotation + 900) % 3600;
        }
        if (np instanceof Cell) {
            Cell subCell2 = (Cell)np;
            Rectangle2D bounds2 = subCell2.getBounds();
            Point2D.Double shift = new Point2D.Double(-bounds2.getCenterX(), -bounds2.getCenterY());
            AffineTransform trans = NodeInst.pureRotate(rotation, width < 0.0, height < 0.0);
            trans.transform(shift, shift);
            if (this.magic <= -1597) {
                ((Point2D)center).setLocation(anchorX, anchorY);
            } else {
                ((Point2D)center).setLocation(((Point2D)center).getX() + ((Point2D)shift).getX(), ((Point2D)center).getY() + ((Point2D)shift).getY());
            }
        }
        ni.lowLevelSetUserbits(this.nodeInstList.userBits[i]);
        ni.lowLevelPopulate(np, center, width, height, rotation, cell);
        if (name != null) {
            ni.setNameKey(name);
        }
        ni.lowLevelLink();
        if (np.getVar(IO_DUMMY_OBJECT) != null) {
            ErrorLogger.ErrorLog error = Input.errorLogger.logError("Instance of dummy cell " + np.getName(), cell, 1);
            error.addGeom(ni, true, cell, null);
        }
        this.scaleOutlineInformation(ni, np, lambdaX, lambdaY);
    }

    protected boolean readerHasExport(Cell c, String portName) {
        for (int cellIndex = 0; cellIndex < this.nodeProtoCount; ++cellIndex) {
            Cell cell = this.nodeProtoList[cellIndex];
            if (cell != c) continue;
            int startPort = this.firstPortIndex[cellIndex];
            int endPort = startPort + this.portCounts[cellIndex];
            for (int i = startPort; i < endPort; ++i) {
                String exportName = this.portProtoNameList[i];
                if (!exportName.equalsIgnoreCase(portName)) continue;
                return true;
            }
            break;
        }
        return false;
    }

    protected PortInst getArcEnd(ArcInst ai, ArcProto ap, NodeInst node, String portname, double x, double y, Cell cell) {
        PortInst pi = null;
        String whatHappenedToPort = "not found";
        String nodeName = "missing node";
        if (node != null) {
            pi = node.findPortInst(portname);
            nodeName = node.getName();
            if (pi != null) {
                Poly portLocation = pi.getPoly();
                String extra = "";
                if (portLocation.contains(x, y)) {
                    return pi;
                }
                Rectangle2D box = portLocation.getBox();
                if (box != null) {
                    extra = "...expected (" + x + "," + y + "), found (" + box.getCenterX() + "," + box.getCenterY() + ")";
                }
                whatHappenedToPort = "has moved" + extra;
                pi = null;
            } else {
                Iterator it = node.getPortInsts();
                while (it.hasNext()) {
                    pi = (PortInst)it.next();
                    Poly portLocation = pi.getPoly();
                    if (portLocation.contains(x, y) && pi.getPortProto().connectsTo(ap)) {
                        String msg = "Cell " + cell.describe() + ": Port '" + portname + "' on '" + nodeName + "' not found, connecting to port '" + pi.getPortProto().getName() + "' at the same location";
                        System.out.println("ERROR: " + msg);
                        ErrorLogger.ErrorLog error = Input.errorLogger.logError(msg, cell, 0);
                        error.addGeom(ai, true, cell, null);
                        return pi;
                    }
                    pi = null;
                }
                whatHappenedToPort = "is missing";
            }
            Cell c = null;
            if (node.getProto() != null && node.getProto().getVar(IO_DUMMY_OBJECT) != null) {
                c = (Cell)node.getProto();
            }
            if (c != null) {
                double anchorX = node.getAnchorCenterX();
                double anchorY = node.getAnchorCenterY();
                Point2D expected = new Point2D.Double(x, y);
                PrimitiveNode pn = Generic.tech.universalPinNode;
                AffineTransform trans = node.rotateIn();
                expected = trans.transform(expected, expected);
                Point2D.Double center = new Point2D.Double(expected.getX() - anchorX, expected.getY() - anchorY);
                NodeInst ni = NodeInst.newInstance(pn, center, 0.0, 0.0, 0, c, "");
                Export ex = Export.newInstance(c, ni.getOnlyPortInst(), portname);
                if (ex != null) {
                    return node.findPortInst(portname);
                }
            }
        }
        String msg = "Cell " + cell.describe() + ": Port '" + portname + "' on '" + nodeName + "' " + whatHappenedToPort + ": leaving arc disconnected";
        System.out.println("ERROR: " + msg);
        ErrorLogger.ErrorLog error = Input.errorLogger.logError(msg, cell, 0);
        error.addGeom(ai, true, cell, null);
        PrimitiveNode pn = ((PrimitiveArc)ap).findOverridablePinProto();
        node = NodeInst.newInstance(pn, new Point2D.Double(x, y), pn.getDefWidth(), pn.getDefHeight(), 0, cell, null);
        error.addGeom(node, true, cell, null);
        return node.getOnlyPortInst();
    }

    private boolean readHeader() throws IOException {
        this.bytesSwapped = false;
        byte byte1 = this.readByte();
        byte byte2 = this.readByte();
        byte byte3 = this.readByte();
        byte byte4 = this.readByte();
        this.magic = (byte4 & 0xFF) << 24 | (byte3 & 0xFF) << 16 | (byte2 & 0xFF) << 8 | byte1 & 0xFF;
        if (this.magic != -1573 && this.magic != -1575 && this.magic != -1577 && this.magic != -1579 && this.magic != -1581 && this.magic != -1583 && this.magic != -1585 && this.magic != -1587 && this.magic != -1589 && this.magic != -1591 && this.magic != -1593 && this.magic != -1595 && this.magic != -1597) {
            this.magic = (byte1 & 0xFF) << 24 | (byte2 & 0xFF) << 16 | (byte3 & 0xFF) << 8 | byte4 & 0xFF;
            if (this.magic != -1573 && this.magic != -1575 && this.magic != -1577 && this.magic != -1579 && this.magic != -1581 && this.magic != -1583 && this.magic != -1585 && this.magic != -1587 && this.magic != -1589 && this.magic != -1591 && this.magic != -1593 && this.magic != -1595 && this.magic != -1597) {
                System.out.println("Bad file format: does not start with proper magic number");
                return true;
            }
            this.bytesSwapped = true;
        }
        if (this.magic <= -1591) {
            this.sizeOfSmall = this.readByte();
            this.sizeOfBig = this.readByte();
        } else {
            this.sizeOfSmall = 2;
            this.sizeOfBig = 4;
        }
        this.sizeOfChar = this.magic <= -1593 ? (int)this.readByte() : 1;
        return false;
    }

    private boolean readNodeProto(Cell cell, int cellIndex) throws IOException {
        String theProtoName;
        if (this.magic <= -1589) {
            int k;
            if (this.magic >= -1593) {
                k = this.readBigInteger();
                theProtoName = this.fakeCellList[k].cellName;
            } else {
                theProtoName = this.readString();
                k = this.readBigInteger();
                cell.setTempObj(this.nodeProtoList[k]);
                k = this.readBigInteger();
            }
            View v = this.getView(this.readBigInteger());
            if (v == null) {
                v = View.UNKNOWN;
            }
            int version = this.readBigInteger();
            theProtoName = theProtoName + ";" + version + "{" + v.getAbbreviation() + "}";
            int creationDate = this.readBigInteger();
            int revisionDate = this.readBigInteger();
            cell.lowLevelSetCreationDate(ELIBConstants.secondsToDate(creationDate));
            cell.lowLevelSetRevisionDate(ELIBConstants.secondsToDate(revisionDate));
        } else {
            theProtoName = this.readString();
        }
        cell.lowLevelPopulate(theProtoName);
        int lowX = this.readBigInteger();
        int highX = this.readBigInteger();
        int lowY = this.readBigInteger();
        int highY = this.readBigInteger();
        if (this.magic >= -1581) {
            int prevIndex = this.readBigInteger();
            int nextIndex = this.readBigInteger();
        }
        this.firstPortIndex[cellIndex] = this.portProtoIndex;
        int portCount = this.readBigInteger();
        if (portCount != this.portCounts[cellIndex]) {
            System.out.println("Error! Cell header lists " + this.portCounts[cellIndex] + " exports, but body lists " + portCount);
        }
        for (int j = 0; j < portCount; ++j) {
            String exportName;
            Export pp = (Export)this.portProtoList[this.portProtoIndex];
            this.portProtoSubNodeList[this.portProtoIndex] = -1;
            int whichNode = this.readBigInteger();
            if (whichNode >= 0 && whichNode < this.nodeCount) {
                this.portProtoSubNodeList[this.portProtoIndex] = whichNode;
            }
            this.portProtoSubPortList[this.portProtoIndex] = null;
            int whichPort = this.readBigInteger();
            if (whichPort < 0 || this.portProtoList[whichPort] != null) {
                this.portProtoSubPortList[this.portProtoIndex] = this.convertPortProto(whichPort);
            }
            if (this.portProtoSubPortList[this.portProtoIndex] == null) {
                this.portProtoSubPortList[this.portProtoIndex] = new Integer(whichPort);
            }
            this.portProtoNameList[this.portProtoIndex] = exportName = this.readString();
            if (pp.lowLevelName(cell, exportName)) {
                return true;
            }
            if (this.portProtoSubNodeList[this.portProtoIndex] == -1) {
                System.out.println("Error: Export '" + exportName + "' of cell " + theProtoName + " cannot be read properly");
            }
            int descript0 = 0;
            int descript1 = 0;
            if (this.magic <= -1589) {
                if (this.convertTextDescriptors) {
                    descript0 = this.readBigInteger();
                    descript1 = 0;
                } else {
                    descript0 = this.readBigInteger();
                    descript1 = this.readBigInteger();
                }
            }
            TextDescriptor descript = new TextDescriptor(null, descript0, descript1);
            Input.fixTextDescriptorFont(descript);
            pp.setTextDescriptor(descript);
            if (this.magic > -1589) {
                this.readBigInteger();
            }
            this.portProtoUserbits[this.portProtoIndex] = 0;
            if (this.magic <= -1585) {
                this.portProtoUserbits[this.portProtoIndex] = this.readBigInteger();
                if (this.magic >= -1587) {
                    this.readBigInteger();
                }
            } else {
                if (this.toolBCount >= 1) {
                    this.portProtoUserbits[this.portProtoIndex] = this.readBigInteger();
                }
                for (int i = 1; i < this.toolBCount; ++i) {
                    this.readBigInteger();
                }
            }
            if (this.readVariables(pp, -1) < 0) {
                return true;
            }
            Input.fixVariableFont(pp);
            ++this.portProtoIndex;
        }
        if (this.magic > -1581) {
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
            this.readBigInteger();
        }
        int dirty = this.readBigInteger();
        int userBits = 0;
        if (this.magic <= -1585) {
            userBits = this.readBigInteger();
            if (this.magic >= -1587) {
                this.readBigInteger();
            }
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i = 1; i < this.toolBCount; ++i) {
                this.readBigInteger();
            }
        }
        cell.lowLevelSetUserbits(userBits);
        if (this.readVariables(cell, -1) < 0) {
            return true;
        }
        Input.fixVariableFont(cell);
        return false;
    }

    private boolean readExternalNodeProto(Library lib, int cellIndex) throws IOException {
        String theProtoName;
        int k;
        if (this.magic >= -1593) {
            k = this.readBigInteger();
            theProtoName = this.fakeCellList[k].cellName;
        } else {
            theProtoName = this.readString();
            k = this.readBigInteger();
            k = this.readBigInteger();
        }
        View v = this.getView(this.readBigInteger());
        if (v == null) {
            v = View.UNKNOWN;
        }
        int version = this.readBigInteger();
        String fullCellName = theProtoName + ";" + version + "{" + v.getAbbreviation() + "}";
        if (version <= 1) {
            fullCellName = theProtoName + "{" + v.getAbbreviation() + "}";
        }
        Date creationDate = ELIBConstants.secondsToDate(this.readBigInteger());
        Date revisionDate = ELIBConstants.secondsToDate(this.readBigInteger());
        int lowX = this.readBigInteger();
        int highX = this.readBigInteger();
        int lowY = this.readBigInteger();
        int highY = this.readBigInteger();
        Library elib = this.readExternalLibraryFromFilename(this.readString());
        int portCount = this.readBigInteger();
        String[] localPortNames = new String[portCount];
        for (int j = 0; j < portCount; ++j) {
            localPortNames[j] = this.readString();
        }
        Cell c = elib.findNodeProto(fullCellName);
        String dummyName = fullCellName;
        if (c == null) {
            c = elib.findNodeProto(dummyName);
        }
        if (c == null) {
            System.out.println("ERROR: Cannot find cell " + fullCellName + " in library " + elib.getName());
        }
        if (c != null && revisionDate.compareTo(c.getRevisionDate()) != 0) {
            System.out.println("Warning: cell " + c.noLibDescribe() + " in library " + elib.getName() + " has changed since its use in library " + lib.getName());
        }
        boolean newCell = false;
        Object fakeNodeInst = null;
        if (c == null) {
            c = Cell.newInstance(elib, dummyName);
            if (c == null) {
                return true;
            }
            c.lowLevelSetCreationDate(creationDate);
            c.lowLevelSetRevisionDate(revisionDate);
            Technology tech = MoCMOS.tech;
            if (v == View.ICON) {
                tech = Artwork.tech;
            } else if (v == View.SCHEMATIC) {
                tech = Schematics.tech;
            }
            double lambda = this.techScale[tech.getIndex()];
            int cX = (lowX + highX) / 2;
            int cY = (lowY + highY) / 2;
            double width = (double)(highX - lowX) / lambda;
            double height = (double)(highY - lowY) / lambda;
            Point2D.Double center = new Point2D.Double((double)cX / lambda, (double)cY / lambda);
            NodeInst.newInstance(Generic.tech.drcNode, center, width, height, 0, c, null);
            newCell = true;
            System.out.println("...Creating dummy cell '" + dummyName + "' in library " + elib.getName() + ". Instances will be logged as Errors.");
            c.newVar(IO_TRUE_LIBRARY, (Object)elib.getName());
            c.newVar(IO_DUMMY_OBJECT, (Object)fullCellName);
        }
        this.nodeProtoList[cellIndex] = c;
        this.firstPortIndex[cellIndex] = this.portProtoIndex;
        if (portCount != this.portCounts[cellIndex]) {
            System.out.println("Error! Cell header lists " + this.portCounts[cellIndex] + " exports, but body lists " + portCount);
        }
        for (int j = 0; j < portCount; ++j) {
            String protoName = localPortNames[j];
            this.portProtoList[this.portProtoIndex] = c;
            this.portProtoNameList[this.portProtoIndex] = protoName;
            ++this.portProtoIndex;
        }
        return false;
    }

    private boolean readNodeInst(int nodeIndex, int cellIndex) throws IOException {
        String instName;
        Cell parent = this.nodeProtoList[cellIndex];
        NodeInst ni = this.nodeInstList.theNode[nodeIndex];
        int protoIndex = this.readBigInteger();
        NodeProto np = this.convertNodeProto(protoIndex);
        if (np == null) {
            return true;
        }
        this.nodeInstList.protoType[nodeIndex] = np;
        this.nodeInstList.lowX[nodeIndex] = this.readBigInteger();
        this.nodeInstList.lowY[nodeIndex] = this.readBigInteger();
        this.nodeInstList.highX[nodeIndex] = this.readBigInteger();
        this.nodeInstList.highY[nodeIndex] = this.readBigInteger();
        if (this.magic <= -1597 && np instanceof Cell) {
            this.nodeInstList.anchorX[nodeIndex] = this.readBigInteger();
            this.nodeInstList.anchorY[nodeIndex] = this.readBigInteger();
        }
        this.nodeInstList.transpose[nodeIndex] = this.readBigInteger();
        this.nodeInstList.rotation[nodeIndex] = (short)this.readBigInteger();
        this.nodeInstList.name[nodeIndex] = null;
        int descript0 = 0;
        int descript1 = 0;
        if (this.magic <= -1589) {
            if (this.convertTextDescriptors) {
                descript0 = this.readBigInteger();
            } else {
                descript0 = this.readBigInteger();
                descript1 = this.readBigInteger();
            }
        }
        TextDescriptor descript = new TextDescriptor(null, descript0, descript1);
        Input.fixTextDescriptorFont(descript);
        ni.setProtoTextDescriptor(descript);
        if (this.magic >= -1577 && (instName = this.readString()).length() > 0) {
            ni.setName(instName);
        }
        if (this.magic > -1581) {
            this.readBigInteger();
        }
        int numPorts = this.readBigInteger();
        for (int j = 0; j < numPorts; ++j) {
            int k = this.readBigInteger();
            int arcIndex = k >> 1;
            if (k < 0 || arcIndex >= this.arcCount) {
                return true;
            }
            int portIndex = this.readBigInteger();
            Object pp = this.convertPortProto(portIndex);
            if (pp == null) {
                pp = new Integer(portIndex);
            }
            if ((k & 1) == 0) {
                this.arcHeadPortList[arcIndex] = pp;
            } else {
                this.arcTailPortList[arcIndex] = pp;
            }
            this.ignoreVariables();
        }
        int numExports = this.readBigInteger();
        for (int j = 0; j < numExports; ++j) {
            this.readBigInteger();
            this.readBigInteger();
            this.ignoreVariables();
        }
        if (this.magic > -1589) {
            this.readBigInteger();
        }
        int userBits = 0;
        if (this.magic <= -1585) {
            userBits = this.readBigInteger();
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i = 1; i < this.toolBCount; ++i) {
                this.readBigInteger();
            }
        }
        this.nodeInstList.userBits[nodeIndex] = userBits;
        if (this.readVariables(ni, nodeIndex) < 0) {
            return true;
        }
        Input.fixVariableFont(ni);
        return false;
    }

    private boolean readArcInst(int arcIndex) throws IOException {
        String instName;
        ArcInst ai = this.arcList[arcIndex];
        int protoIndex = this.readBigInteger();
        PrimitiveArc ap = this.convertArcProto(protoIndex);
        this.arcTypeList[arcIndex] = ap;
        if (this.magic >= -1581) {
            this.readBigInteger();
        }
        this.arcWidthList[arcIndex] = this.readBigInteger();
        if (this.magic <= -1583 && this.magic >= -1587) {
            this.readBigInteger();
        }
        if (this.magic >= -1577 && (instName = this.readString()).length() > 0) {
            ai.setName(instName);
        }
        this.arcHeadXPosList[arcIndex] = this.readBigInteger();
        this.arcHeadYPosList[arcIndex] = this.readBigInteger();
        int nodeIndex = this.readBigInteger();
        if (nodeIndex >= 0 && nodeIndex < this.nodeCount) {
            this.arcHeadNodeList[arcIndex] = nodeIndex;
        }
        this.arcTailXPosList[arcIndex] = this.readBigInteger();
        this.arcTailYPosList[arcIndex] = this.readBigInteger();
        nodeIndex = this.readBigInteger();
        if (nodeIndex >= 0 && nodeIndex < this.nodeCount) {
            this.arcTailNodeList[arcIndex] = nodeIndex;
        }
        if (this.magic > -1581) {
            this.readBigInteger();
        }
        if (this.magic > -1589) {
            this.readBigInteger();
        }
        int userBits = 0;
        if (this.magic <= -1585) {
            userBits = this.readBigInteger();
            if (this.magic >= -1587) {
                this.readBigInteger();
            }
        } else {
            if (this.toolBCount >= 1) {
                userBits = this.readBigInteger();
            }
            for (int i = 1; i < this.toolBCount; ++i) {
                this.readBigInteger();
            }
        }
        this.arcUserBits[arcIndex] = userBits;
        if (this.readVariables(ai, arcIndex) < 0) {
            return true;
        }
        Input.fixVariableFont(ai);
        return false;
    }

    private void readGeom(boolean[] isNode, int[] moreup, int index) throws IOException {
        int type = this.readBigInteger();
        isNode[index] = type != 0;
        if (isNode[index]) {
            this.readBigInteger();
        }
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        moreup[index] = this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.readBigInteger();
        this.ignoreVariables();
    }

    private boolean readNameSpace() throws IOException {
        this.nameCount = this.readBigInteger();
        if (this.nameCount == 0) {
            return false;
        }
        this.realKey = new Variable.Key[this.nameCount];
        for (int i = 0; i < this.nameCount; ++i) {
            this.realKey[i] = ElectricObject.newKey(this.readString());
        }
        return false;
    }

    private int readVariables(ElectricObject obj, int index) throws IOException {
        int count = this.readBigInteger();
        for (int i = 0; i < count; ++i) {
            Variable var;
            Object[] newAddr;
            short key = this.readSmallInteger();
            int newtype = this.readBigInteger();
            boolean definedDescript = false;
            int descript0 = 0;
            int descript1 = 0;
            if (this.magic <= -1589) {
                if (this.alwaysTextDescriptors) {
                    descript0 = this.readBigInteger();
                    descript1 = this.readBigInteger();
                    definedDescript = true;
                } else if ((newtype & 0x40) != 0) {
                    if (this.convertTextDescriptors) {
                        descript0 = this.readBigInteger();
                    } else {
                        descript0 = this.readBigInteger();
                        descript1 = this.readBigInteger();
                    }
                    definedDescript = true;
                }
            }
            if (!definedDescript) {
                // empty if block
            }
            if ((newtype & 0x80) != 0) {
                int j;
                int len;
                int cou = len = this.readBigInteger();
                if ((newtype & 0x1FFFFE00) == 0) {
                    ++cou;
                }
                Object[] newAddrArray = null;
                switch (newtype & 0x1F) {
                    case 1: 
                    case 2: {
                        newAddrArray = new Integer[cou];
                        break;
                    }
                    case 5: 
                    case 19: {
                        newAddrArray = new Float[cou];
                        break;
                    }
                    case 6: {
                        newAddrArray = new Double[cou];
                        break;
                    }
                    case 25: {
                        newAddrArray = new Short[cou];
                        break;
                    }
                    case 3: 
                    case 30: {
                        newAddrArray = new Byte[cou];
                        break;
                    }
                    case 4: {
                        newAddrArray = new String[cou];
                        break;
                    }
                    case 7: {
                        newAddrArray = new NodeInst[cou];
                        break;
                    }
                    case 8: {
                        newAddrArray = new NodeProto[cou];
                        break;
                    }
                    case 13: {
                        newAddrArray = new ArcProto[cou];
                        break;
                    }
                    case 11: {
                        newAddrArray = new PortProto[cou];
                        break;
                    }
                    case 12: {
                        newAddrArray = new ArcInst[cou];
                        break;
                    }
                    case 16: {
                        newAddrArray = new Technology[cou];
                        break;
                    }
                    case 15: {
                        newAddrArray = new Library[cou];
                        break;
                    }
                    case 17: {
                        newAddrArray = new Tool[cou];
                    }
                }
                if (newAddrArray == null) {
                    System.out.println("Cannot figure out the type for code " + (newtype & 0x1F));
                }
                newAddr = newAddrArray;
                if ((newtype & 0x1F) == 27) {
                    for (j = 0; j < len; j += 2) {
                        int type = this.readBigInteger();
                        int addr = this.readBigInteger();
                        if (newAddrArray == null) continue;
                        newAddrArray[j] = null;
                    }
                } else {
                    for (j = 0; j < len; ++j) {
                        Object ret = this.getInVar(newtype);
                        if (ret == null) {
                            System.out.println("Error reading array variable type");
                            return -1;
                        }
                        if (newAddrArray == null) continue;
                        newAddrArray[j] = ret;
                    }
                }
            } else {
                newAddr = this.getInVar(newtype);
                if (newAddr == null) {
                    System.out.println("Error reading variable type " + newtype);
                    return -1;
                }
            }
            if (key < 0 || key >= this.nameCount) {
                System.out.println("Bad variable index (" + key + ", limit is " + this.nameCount + ") on " + obj + " object");
                return -1;
            }
            if (newAddr instanceof String && (obj instanceof NodeInst && this.realKey[key] == NodeInst.NODE_NAME || obj instanceof ArcInst && this.realKey[key] == ArcInst.ARC_NAME)) {
                Geometric geom = (Geometric)obj;
                TextDescriptor nameDescript = new TextDescriptor(null, descript0, descript1);
                Input.fixTextDescriptorFont(nameDescript);
                geom.setNameTextDescriptor(nameDescript);
                Name name = this.makeGeomName(geom, newAddr, newtype);
                if (obj instanceof NodeInst) {
                    this.nodeInstList.name[index] = name;
                    continue;
                }
                this.arcNameList[index] = name;
                continue;
            }
            Variable.Key varKey = this.realKey[key];
            if (obj.isDeprecatedVariable(varKey)) continue;
            Pref.Meaning meaning = Pref.getMeaningVariable(obj, varKey.getName());
            if (meaning != null) {
                if (!this.topLevelLibrary) continue;
                Pref.changedMeaningVariable(meaning);
            }
            if ((var = obj.newVar(varKey, (Object)newAddr)) == null) {
                System.out.println("Error reading variable");
                return -1;
            }
            var.setTextDescriptor(new TextDescriptor(null, descript0, descript1));
            var.lowLevelSetFlags(newtype);
        }
        return count;
    }

    private void ignoreVariables() throws IOException {
        NodeInst ni = NodeInst.lowLevelAllocate();
        this.readVariables(ni, -1);
    }

    private void fixExternalVariables(ElectricObject obj) {
    }

    private Object getInVar(int ty) throws IOException {
        if ((ty & 0x20000020) != 0) {
            ty = 4;
        }
        switch (ty & 0x1F) {
            case 1: 
            case 2: {
                return new Integer(this.readBigInteger());
            }
            case 19: {
                return new Float((float)this.readBigInteger() / 120.0f);
            }
            case 5: {
                return new Float(this.readFloat());
            }
            case 6: {
                return new Double(this.readDouble());
            }
            case 25: {
                return new Short(this.readSmallInteger());
            }
            case 3: 
            case 30: {
                return new Byte(this.readByte());
            }
            case 4: {
                return this.readString();
            }
            case 7: {
                int i = this.readBigInteger();
                if (i < 0 || i >= this.nodeCount) {
                    System.out.println("Variable of type NodeInst has index " + i + " when range is 0 to " + this.nodeCount);
                    return null;
                }
                return this.nodeInstList.theNode[i];
            }
            case 8: {
                int i = this.readBigInteger();
                return this.convertNodeProto(i);
            }
            case 13: {
                int i = this.readBigInteger();
                return this.convertArcProto(i);
            }
            case 11: {
                int i = this.readBigInteger();
                return this.convertPortProto(i);
            }
            case 12: {
                int i = this.readBigInteger();
                if (i < 0 || i >= this.arcCount) {
                    System.out.println("Variable of type ArcInst has index " + i + " when range is 0 to " + this.arcCount);
                    return null;
                }
                return this.arcList[i];
            }
            case 14: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type Geometric");
                return null;
            }
            case 16: {
                int i = this.readBigInteger();
                if (i == -1) {
                    System.out.println("Variable of type Technology has negative index");
                    return null;
                }
                return this.getTechList(i);
            }
            case 9: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type PortArcInst");
                return null;
            }
            case 10: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type PortExpInst");
                return null;
            }
            case 15: {
                String libName = this.readString();
                return Library.findLibrary(libName);
            }
            case 17: {
                int i = this.readBigInteger();
                if (i < 0 || i >= this.toolCount) {
                    return null;
                }
                Tool tool = this.toolList[i];
                if (tool == null && this.toolError[i = 0] != null) {
                    System.out.println("WARNING: no tool called '" + this.toolError[i] + "', using 'user'");
                    this.toolError[i] = null;
                }
                return tool;
            }
            case 18: {
                this.readBigInteger();
                System.out.println("Cannot read variable of type RTNode");
                return null;
            }
        }
        System.out.println("Cannot read variable of type " + (ty & 0x1F));
        return null;
    }

    private NodeProto convertNodeProto(int i) {
        boolean error = false;
        if (i < 0) {
            int nindex = -i - 2;
            if (nindex >= this.primNodeProtoCount) {
                System.out.println("Error: want primitive node index " + nindex + " when limit is " + this.primNodeProtoCount);
                nindex = 0;
                error = true;
            }
            return this.getPrimNodeProtoList(nindex);
        }
        if (i >= this.nodeProtoCount) {
            System.out.println("Error: want cell index " + i + " when limit is " + this.nodeProtoCount);
            return null;
        }
        return this.nodeProtoList[i];
    }

    private PrimitiveArc convertArcProto(int i) {
        int aindex = -i - 2;
        if (aindex >= this.arcProtoCount || aindex < 0) {
            System.out.println("Want primitive arc index " + aindex + " when range is 0 to " + this.arcProtoCount);
            aindex = 0;
        }
        return this.getArcProtoList(aindex);
    }

    private PortProto convertPortProto(int i) {
        if (i < 0) {
            int pindex = -i - 2;
            if (pindex >= this.primPortProtoCount) {
                System.out.println("Error: want primitive port index " + pindex + " when limit is " + this.primPortProtoCount);
                pindex = 0;
            }
            return this.getPrimPortProtoList(pindex);
        }
        if (i >= this.portProtoCount) {
            System.out.println("Error: want port index " + i + " when limit is " + this.portProtoCount);
            i = 0;
        }
        if (this.portProtoList[i] instanceof Cell) {
            return null;
        }
        return (Export)this.portProtoList[i];
    }

    private NodeProto getPrimNodeProtoList(int i) {
        this.getTechList(this.primNodeProtoTech[i]);
        if (this.primNodeProtoError[i]) {
            System.out.println("Cannot find primitive '" + this.primNodeProtoOrig[i] + "', using " + this.primNodeProtoList[i].getName());
            this.primNodeProtoError[i] = false;
        }
        return this.primNodeProtoList[i];
    }

    private PrimitiveArc getArcProtoList(int i) {
        if (this.arcProtoError[i] != null) {
            System.out.println("Cannot find arc '" + this.arcProtoError[i] + "', using " + this.arcProtoList[i].getName());
            this.arcProtoError[i] = null;
        }
        return this.arcProtoList[i];
    }

    private PortProto getPrimPortProtoList(int i) {
        if (this.primPortProtoError[i] != null) {
            System.out.println("WARNING: port " + this.primPortProtoError[i] + " not found, using " + this.primPortProtoList[i].getName());
            this.primPortProtoError[i] = null;
        }
        return this.primPortProtoList[i];
    }

    private Technology getTechList(int i) {
        if (this.techError[i] != null) {
            System.out.println("WARNING: technology '" + this.techError[i] + "' does not exist, using '" + this.techList[i].getTechName() + "'");
            this.techError[i] = null;
        }
        return this.techList[i];
    }

    private View getView(int i) {
        View v = (View)this.viewMapping.get(new Integer(i));
        return v;
    }

    private byte readByte() throws IOException {
        int value = this.dataInputStream.read();
        if (value == -1) {
            throw new IOException();
        }
        this.updateProgressDialog(1);
        return (byte)value;
    }

    private int readBigInteger() throws IOException {
        if (this.sizeOfBig == 4) {
            this.updateProgressDialog(4);
            int data = this.dataInputStream.readInt();
            if (!this.bytesSwapped) {
                data = data >> 24 & 0xFF | data >> 8 & 0xFF00 | (data & 0xFF00) << 8 | (data & 0xFF) << 24;
            }
            return data;
        }
        this.readBytes(rawData, this.sizeOfBig, 4, true);
        if (this.bytesSwapped) {
            bb.put(0, rawData[0]);
            bb.put(1, rawData[1]);
            bb.put(2, rawData[2]);
            bb.put(3, rawData[3]);
        } else {
            bb.put(0, rawData[3]);
            bb.put(1, rawData[2]);
            bb.put(2, rawData[1]);
            bb.put(3, rawData[0]);
        }
        return bb.getInt(0);
    }

    private float readFloat() throws IOException {
        if (this.bytesSwapped) {
            this.updateProgressDialog(4);
            return this.dataInputStream.readFloat();
        }
        this.readBytes(rawData, this.sizeOfBig, 4, true);
        bb.put(0, rawData[3]);
        bb.put(1, rawData[2]);
        bb.put(2, rawData[1]);
        bb.put(3, rawData[0]);
        return bb.getFloat(0);
    }

    private double readDouble() throws IOException {
        if (this.bytesSwapped) {
            this.updateProgressDialog(8);
            return this.dataInputStream.readDouble();
        }
        this.readBytes(rawData, this.sizeOfBig, 8, true);
        bb.put(0, rawData[7]);
        bb.put(1, rawData[2]);
        bb.put(2, rawData[3]);
        bb.put(3, rawData[4]);
        bb.put(4, rawData[3]);
        bb.put(5, rawData[2]);
        bb.put(6, rawData[1]);
        bb.put(7, rawData[0]);
        return bb.getDouble(0);
    }

    private short readSmallInteger() throws IOException {
        if (this.sizeOfSmall == 2) {
            this.updateProgressDialog(2);
            int data = this.dataInputStream.readShort();
            if (!this.bytesSwapped) {
                data = data >> 8 & 0xFF | (data & 0xFF) << 8;
            }
            return (short)data;
        }
        this.readBytes(rawData, this.sizeOfSmall, 2, true);
        if (this.bytesSwapped) {
            bb.put(0, rawData[0]);
            bb.put(1, rawData[1]);
        } else {
            bb.put(0, rawData[1]);
            bb.put(1, rawData[0]);
        }
        return bb.getShort(0);
    }

    private String readString() throws IOException {
        if (this.sizeOfChar != 1) {
            System.out.println("Cannot handle library files with unicode strings");
            return null;
        }
        int len = this.readBigInteger();
        if (len <= 0) {
            return "";
        }
        byte[] stringBytes = new byte[len];
        int ret = this.dataInputStream.read(stringBytes, 0, len);
        if (ret != len) {
            throw new IOException();
        }
        this.updateProgressDialog(len);
        String theString = new String(stringBytes);
        return theString;
    }

    private void readBytes(byte[] data, int diskSize, int memorySize, boolean signExtend) throws IOException {
        if (diskSize == memorySize) {
            int ret = this.dataInputStream.read(data, 0, diskSize);
            if (ret != diskSize) {
                throw new IOException();
            }
        } else {
            int ret = this.dataInputStream.read(rawData, 0, diskSize);
            if (ret != diskSize) {
                throw new IOException();
            }
            if (diskSize > memorySize) {
                int i;
                for (i = 0; i < memorySize; ++i) {
                    data[i] = rawData[i];
                }
                for (i = memorySize; i < diskSize; ++i) {
                    if (rawData[i] == 0 || rawData[i] == 255) continue;
                    ++this.clippedIntegers;
                }
            } else {
                int i;
                if (!signExtend || (rawData[diskSize - 1] & 0x80) == 0) {
                    for (i = diskSize; i < memorySize; ++i) {
                        ELIB.rawData[i] = 0;
                    }
                } else {
                    for (i = diskSize; i < memorySize; ++i) {
                        ELIB.rawData[i] = -1;
                    }
                }
                for (i = 0; i < memorySize; ++i) {
                    data[i] = rawData[i];
                }
            }
        }
        this.updateProgressDialog(diskSize);
    }
}

