/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.tool.ncc.NccGlobals;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

class NccCellInfo
extends HierarchyEnumerator.CellInfo {
    private HashSet nodablesToDiscard = new HashSet();
    private HashMap nodableSizeMultipliers = new HashMap();
    private NccGlobals globals;

    private int computeNodableHashCode(Nodable no, Netlist netlist) {
        Cell c = (Cell)no.getProto();
        int hash = c.hashCode();
        Iterator it = c.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            int[] netIDs = this.getPortNetIDs(no, e);
            for (int i = 0; i < netIDs.length; ++i) {
                int netID = netIDs[i];
                hash = hash << 1 ^ netID;
            }
        }
        return hash;
    }

    private HashMap hashNodablesBasedOnConnectivity(Netlist netlist) {
        HashMap<Integer, LinkedList<Nodable>> codeToNodable = new HashMap<Integer, LinkedList<Nodable>>();
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            NodeProto np = no.getProto();
            if (!(np instanceof Cell)) continue;
            Integer c = new Integer(this.computeNodableHashCode(no, netlist));
            LinkedList<Nodable> ll = (LinkedList<Nodable>)codeToNodable.get(c);
            if (ll == null) {
                ll = new LinkedList<Nodable>();
                codeToNodable.put(c, ll);
            }
            ll.add(no);
        }
        return codeToNodable;
    }

    private boolean areParalleled(Nodable n1, Nodable n2, Netlist netlist) {
        Cell c = (Cell)n1.getProto();
        Cell c2 = (Cell)n2.getProto();
        if (c2 != c) {
            return false;
        }
        Iterator it = c.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            int[] netIDs1 = this.getPortNetIDs(n1, e);
            int[] netIDs2 = this.getPortNetIDs(n2, e);
            for (int i = 0; i < netIDs1.length; ++i) {
                if (netIDs1[i] == netIDs2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private void findParallelNodables(LinkedList ll, Netlist netlist) {
        Iterator it = ll.iterator();
        while (it.hasNext()) {
            Nodable first = (Nodable)it.next();
            it.remove();
            int count = 1;
            while (it.hasNext()) {
                Nodable no = (Nodable)it.next();
                if (!this.areParalleled(first, no, netlist)) continue;
                it.remove();
                this.nodablesToDiscard.add(no);
                ++count;
            }
            if (count < 2) continue;
            this.nodableSizeMultipliers.put(first, new Integer(count));
        }
    }

    private int getSizeMultiplier(Nodable no) {
        Integer i = (Integer)this.nodableSizeMultipliers.get(no);
        return i == null ? 1 : i;
    }

    public NccCellInfo(NccGlobals globals) {
        this.globals = globals;
    }

    public void recordMergeParallelInfo() {
        Netlist netlist = this.getNetlist();
        HashMap codeToNodables = this.hashNodablesBasedOnConnectivity(netlist);
        Iterator it = codeToNodables.keySet().iterator();
        while (it.hasNext()) {
            LinkedList ll = (LinkedList)codeToNodables.get(it.next());
            this.findParallelNodables(ll, netlist);
        }
    }

    public boolean isDiscardable(Nodable no) {
        return this.nodablesToDiscard.contains(no);
    }

    public int getSizeMultiplier() {
        if (this.isRootCell()) {
            return 1;
        }
        NccCellInfo parentInfo = (NccCellInfo)this.getParentInfo();
        int parentMult = parentInfo.getSizeMultiplier();
        int nodableMult = parentInfo.getSizeMultiplier(this.getParentInst());
        return parentMult * nodableMult;
    }
}

