/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;

public class StratHashWires
extends Strategy {
    private int numWiresProcessed;
    private int numEquivProcessed;

    private StratHashWires(NccGlobals globals) {
        super(globals);
    }

    private void preamble(int nbWires) {
        this.startTime("StratHashWires", nbWires + " Wires");
    }

    private void summary(LeafList offspring) {
        this.globals.println(" processed " + this.numWiresProcessed + " Wires from " + this.numEquivProcessed + " leaf records");
        this.globals.println(this.offspringStats(offspring));
        this.globals.println(offspring.sizeInfoString());
        this.elapsedTime();
    }

    public LeafList doFor(EquivRecord g) {
        LeafList out;
        if (g.isLeaf()) {
            ++this.numEquivProcessed;
            out = super.doFor(g);
        } else {
            out = super.doFor(g);
        }
        return out;
    }

    public Integer doFor(NetObject n) {
        this.error(!(n instanceof Wire), "StratHashWires expects wires only");
        ++this.numWiresProcessed;
        Wire w = (Wire)n;
        return w.computeHashCode();
    }

    public static LeafList doYourJob(RecordList l, NccGlobals globals) {
        if (l.size() == 0) {
            return new LeafList();
        }
        StratHashWires hwa = new StratHashWires(globals);
        hwa.preamble(l.size());
        LeafList el = hwa.doFor(l);
        hwa.summary(el);
        return el;
    }
}

