/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class MimicStitch {
    static InteractiveRouter router = new SimpleWirer();

    public static void mimicStitch(boolean forced) {
        Routing.Activity lastActivity = Routing.tool.getLastActivity();
        if (lastActivity == null) {
            System.out.println("No wiring activity to mimic");
            return;
        }
        if (lastActivity.numDeletedArcs == 1 && Routing.isMimicStitchCanUnstitch()) {
            ArcProto ap = lastActivity.deletedArcs[0].getProto();
            MimicStitch.ro_mimicdelete(ap, lastActivity);
            lastActivity.numDeletedArcs = 0;
            return;
        }
        if (lastActivity.numCreatedArcs == 1) {
            ArcInst ai = lastActivity.createdArcs[0];
            MimicStitchJob job = new MimicStitchJob(ai.getHead(), ai.getTail(), ai.getWidth(), ai.getProto(), 0.0, 0.0, forced);
            lastActivity.numCreatedArcs = 0;
            return;
        }
        if (lastActivity.numCreatedArcs > 1 && lastActivity.numCreatedNodes > 0) {
            FlagSet nodeGotOne = NodeInst.getFlagSet(1);
            FlagSet nodeGotMany = NodeInst.getFlagSet(1);
            ArcProto proto = lastActivity.createdArcs[0].getProto();
            Cell parent = lastActivity.createdArcs[0].getParent();
            Iterator it = parent.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                ni.clearBit(nodeGotOne);
                ni.clearBit(nodeGotMany);
            }
            for (int i = 0; i < lastActivity.numCreatedArcs; ++i) {
                ArcInst ai = lastActivity.createdArcs[i];
                for (int e = 0; e < 2; ++e) {
                    NodeInst ni = ai.getConnection(e).getPortInst().getNodeInst();
                    if (ni.isBit(nodeGotMany)) continue;
                    if (!ni.isBit(nodeGotOne)) {
                        ni.setBit(nodeGotOne);
                        continue;
                    }
                    ni.clearBit(nodeGotOne);
                    ni.setBit(nodeGotMany);
                }
            }
            int foundends = 0;
            Connection[] ends = new Connection[2];
            double width = 0.0;
            for (int i = 0; i < lastActivity.numCreatedArcs; ++i) {
                ArcInst ai = lastActivity.createdArcs[i];
                for (int e = 0; e < 2; ++e) {
                    NodeInst ni = ai.getConnection(e).getPortInst().getNodeInst();
                    if (!ni.isBit(nodeGotOne)) continue;
                    if (foundends < 2) {
                        ends[foundends] = ai.getConnection(e);
                        if (ai.getWidth() > width) {
                            width = ai.getWidth();
                        }
                    }
                    ++foundends;
                }
            }
            nodeGotOne.freeFlagSet();
            nodeGotMany.freeFlagSet();
            if (foundends == 2) {
                Poly portPoly0;
                double prefx = 0.0;
                double prefy = 0.0;
                if (lastActivity.numCreatedNodes == 1) {
                    portPoly0 = ends[0].getPortInst().getPoly();
                    double x0 = portPoly0.getCenterX();
                    double y0 = portPoly0.getCenterY();
                    Poly portPoly1 = ends[1].getPortInst().getPoly();
                    double x1 = portPoly1.getCenterX();
                    double y1 = portPoly1.getCenterY();
                    prefx = lastActivity.createdNodes[0].getAnchorCenterX() - (x0 + x1) / 2.0;
                    prefy = lastActivity.createdNodes[0].getAnchorCenterY() - (y0 + y1) / 2.0;
                } else if (lastActivity.numCreatedNodes == 2) {
                    portPoly0 = ends[0].getPortInst().getPoly();
                    double x0 = portPoly0.getCenterX();
                    double y0 = portPoly0.getCenterY();
                    Poly portPoly1 = ends[1].getPortInst().getPoly();
                    double x1 = portPoly1.getCenterX();
                    double y1 = portPoly1.getCenterY();
                    prefx = (lastActivity.createdNodes[0].getAnchorCenterX() + lastActivity.createdNodes[1].getAnchorCenterX()) / 2.0 - (x0 + x1) / 2.0;
                    prefy = (lastActivity.createdNodes[0].getAnchorCenterY() + lastActivity.createdNodes[1].getAnchorCenterY()) / 2.0 - (y0 + y1) / 2.0;
                }
                MimicStitchJob job = new MimicStitchJob(ends[0], ends[1], width, proto, prefx, prefy, forced);
            }
            lastActivity.numCreatedArcs = 0;
            return;
        }
    }

    private static void ro_mimicdelete(ArcProto typ, Routing.Activity activity) {
        Point2D pt0 = activity.deletedArcs[0].getHead().getLocation();
        Point2D pt1 = activity.deletedArcs[0].getTail().getLocation();
        double dist = pt0.distance(pt1);
        int angle = 0;
        if (dist != 0.0) {
            angle = DBMath.figureAngle(pt0, pt1);
        }
        Cell cell = activity.deletedNodes[0].getParent();
        ArrayList<ArcInst> arcKills = new ArrayList<ArcInst>();
        Iterator it = cell.getArcs();
        while (it.hasNext()) {
            int thisangle;
            Point2D end1;
            Point2D end0;
            double thisdist;
            ArcInst ai = (ArcInst)it.next();
            if (ai.getProto() != typ) continue;
            int match = 0;
            if (ai.getHead().getPortInst().getNodeInst().getProto() == activity.deletedNodes[0].getProto() && ai.getTail().getPortInst().getNodeInst().getProto() == activity.deletedNodes[1].getProto() && ai.getHead().getPortInst().getPortProto() == activity.deletedPorts[0] && ai.getTail().getPortInst().getPortProto() == activity.deletedPorts[1]) {
                match = 1;
            }
            if (ai.getHead().getPortInst().getNodeInst().getProto() == activity.deletedNodes[1].getProto() && ai.getTail().getPortInst().getNodeInst().getProto() == activity.deletedNodes[0].getProto() && ai.getHead().getPortInst().getPortProto() == activity.deletedPorts[1] && ai.getTail().getPortInst().getPortProto() == activity.deletedPorts[0]) {
                match = -1;
            }
            if (match == 0 || dist != (thisdist = (end0 = ai.getHead().getLocation()).distance(end1 = ai.getTail().getLocation())) || dist != 0.0 && angle % 1800 != (thisangle = DBMath.figureAngle(end0, end1)) % 1800) continue;
            arcKills.add(ai);
        }
        MimicUnstitchJob job = new MimicUnstitchJob(arcKills);
    }

    private static class MimicStitchJob
    extends Job {
        private Connection conn1;
        private Connection conn2;
        private double oWidth;
        private ArcProto oProto;
        private double prefX;
        private double prefY;
        private boolean forced;
        FlagSet portMark;
        private static final int LIKELYDIFFPORT = 1;
        private static final int LIKELYDIFFARCCOUNT = 2;
        private static final int LIKELYDIFFNODETYPE = 4;
        private static final int LIKELYDIFFNODESIZE = 8;
        private static final int LIKELYARCSSAMEDIR = 16;
        private static int[] situations = new int[]{0, 16, 8, 2, 1, 4, 24, 18, 17, 20, 10, 9, 12, 3, 6, 5, 26, 25, 28, 19, 22, 21, 11, 14, 13, 7, 27, 30, 29, 23, 15, 31};

        protected MimicStitchJob(Connection conn1, Connection conn2, double oWidth, ArcProto oProto, double prefX, double prefY, boolean forced) {
            super("Mimic-Stitch", Routing.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.conn1 = conn1;
            this.conn2 = conn2;
            this.oWidth = oWidth;
            this.oProto = oProto;
            this.prefX = prefX;
            this.prefY = prefY;
            this.forced = forced;
            this.startJob();
        }

        public boolean doIt() {
            this.portMark = PortProto.getFlagSet(1);
            int result = this.mimic();
            this.portMark.freeFlagSet();
            return true;
        }

        private int mimic() {
            if (this.forced) {
                System.out.println("Mimicing last arc...");
            }
            PortInst[] endPi = new PortInst[]{this.conn1.getPortInst(), this.conn2.getPortInst()};
            Point2D[] endPts = new Point2D[]{this.conn1.getLocation(), this.conn2.getLocation()};
            Cell cell = endPi[0].getNodeInst().getParent();
            Netlist netlist = cell.getUserNetlist();
            boolean mimicInteractive = Routing.isMimicStitchInteractive();
            boolean matchPorts = Routing.isMimicStitchMatchPorts();
            boolean matchArcCount = Routing.isMimicStitchMatchNumArcs();
            boolean matchNodeType = Routing.isMimicStitchMatchNodeType();
            boolean matchNodeSize = Routing.isMimicStitchMatchNodeSize();
            boolean noOtherArcsThisDir = Routing.isMimicStitchNoOtherArcsSameDir();
            int count = 0;
            ArrayList<PossibleArc> possibleArcs = new ArrayList<PossibleArc>();
            int con1 = endPi[0].getNodeInst().getNumConnections() + endPi[1].getNodeInst().getNumConnections() - 2;
            int total = 0;
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                Iterator pIt = ni.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto pp = (PortProto)pIt.next();
                    pp.clearBit(this.portMark);
                    if (!pp.connectsTo(this.oProto)) continue;
                    pp.setBit(this.portMark);
                    ++total;
                }
            }
            if (total == 0) {
                return count;
            }
            Poly[] ro_mimicportpolys = new Poly[total];
            int i = 0;
            Iterator it2 = cell.getNodes();
            while (it2.hasNext()) {
                NodeInst ni = (NodeInst)it2.next();
                ni.setTempInt(i);
                Iterator pIt = ni.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto pp = (PortProto)pIt.next();
                    if (!pp.isBit(this.portMark)) continue;
                    ro_mimicportpolys[i] = ni.getShapeOfPort(pp);
                    ++i;
                }
            }
            for (int end = 0; end < 2; ++end) {
                PortInst pi0 = endPi[end];
                PortInst pi1 = endPi[1 - end];
                NodeInst node0 = pi0.getNodeInst();
                NodeInst node1 = pi1.getNodeInst();
                PortProto port0 = pi0.getPortProto();
                PortProto port1 = pi1.getPortProto();
                Point2D pt0 = endPts[end];
                Point2D pt1 = endPts[1 - end];
                double dist = pt0.distance(pt1);
                int angle = 0;
                if (dist != 0.0) {
                    angle = DBMath.figureAngle(pt0, pt1);
                }
                boolean useFAngle = false;
                double angleRadians = 0.0;
                if (angle % 900 != 0) {
                    angleRadians = DBMath.figureAngleRadians(pt0, pt1);
                    useFAngle = true;
                }
                Poly port0Poly = pi0.getPoly();
                double end0offx = pt0.getX() - port0Poly.getCenterX();
                double end0offy = pt0.getY() - port0Poly.getCenterY();
                SizeOffset so0 = node0.getSizeOffset();
                double node0Wid = node0.getXSize() - so0.getLowXOffset() - so0.getHighXOffset();
                double node0Hei = node0.getYSize() - so0.getLowYOffset() - so0.getHighYOffset();
                SizeOffset so1 = node1.getSizeOffset();
                double node1Wid = node1.getXSize() - so1.getLowXOffset() - so1.getHighXOffset();
                double node1Hei = node1.getYSize() - so1.getLowYOffset() - so1.getHighYOffset();
                Iterator it3 = cell.getNodes();
                while (it3.hasNext()) {
                    NodeInst ni = (NodeInst)it3.next();
                    Rectangle2D bounds = ni.getBounds();
                    Iterator oIt = cell.getNodes();
                    while (oIt.hasNext()) {
                        NodeInst oNi = (NodeInst)oIt.next();
                        Rectangle2D oBounds = ni.getBounds();
                        if (node0 != node1 ? ni == oNi : ni != oNi) continue;
                        if (bounds.getMinX() - oBounds.getMaxX() > dist || oBounds.getMinX() - bounds.getMaxX() > dist || bounds.getMinY() - oBounds.getMaxY() > dist || oBounds.getMinY() - bounds.getMaxY() > dist) continue;
                        int portPos = ni.getTempInt();
                        Iterator pIt = ni.getProto().getPorts();
                        while (pIt.hasNext()) {
                            PortProto pp = (PortProto)pIt.next();
                            if (!pp.isBit(this.portMark)) continue;
                            Poly poly = ro_mimicportpolys[portPos++];
                            double x0 = poly.getCenterX();
                            double y0 = poly.getCenterY();
                            double wantX1 = x0 += end0offx;
                            double wantY1 = y0 += end0offy;
                            if (dist != 0.0) {
                                if (useFAngle) {
                                    wantX1 = x0 + Math.cos(angleRadians) * dist;
                                    wantY1 = y0 + Math.sin(angleRadians) * dist;
                                } else {
                                    wantX1 = x0 + DBMath.cos(angle) * dist;
                                    wantY1 = y0 + DBMath.sin(angle) * dist;
                                }
                            }
                            Point2D.Double xy0 = new Point2D.Double(x0, y0);
                            Point2D.Double want1 = new Point2D.Double(wantX1, wantY1);
                            int oPortPos = oNi.getTempInt();
                            Iterator oPIt = oNi.getProto().getPorts();
                            while (oPIt.hasNext()) {
                                int con2;
                                boolean ptInPoly;
                                PortProto opp = (PortProto)oPIt.next();
                                if (!opp.isBit(this.portMark)) continue;
                                Poly thisPoly = ro_mimicportpolys[oPortPos++];
                                if (ni == node0 && pp == port0 && oNi == node1 && opp == port1 || !(ptInPoly = thisPoly.isInside(want1))) continue;
                                int situation = 0;
                                int desiredAngle = -1;
                                if (x0 != wantX1 || y0 != wantY1) {
                                    desiredAngle = DBMath.figureAngle(xy0, want1);
                                }
                                PortInst piNet0 = null;
                                Iterator pII = ni.getConnections();
                                while (pII.hasNext()) {
                                    int existingAngle;
                                    Connection con = (Connection)pII.next();
                                    PortInst pi = con.getPortInst();
                                    if (pi.getPortProto() != pp) continue;
                                    ArcInst oai = con.getArc();
                                    piNet0 = pi;
                                    if (desiredAngle < 0) {
                                        if (oai.getHead().getLocation().getX() != oai.getTail().getLocation().getX() || oai.getHead().getLocation().getY() != oai.getTail().getLocation().getY()) continue;
                                        situation |= 0x10;
                                        break;
                                    }
                                    if (oai.getHead().getLocation().getX() == oai.getTail().getLocation().getX() && oai.getHead().getLocation().getY() == oai.getTail().getLocation().getY()) continue;
                                    int thisend = 0;
                                    if (oai.getTail().getPortInst() == pi) {
                                        thisend = 1;
                                    }
                                    if ((existingAngle = DBMath.figureAngle(oai.getConnection(thisend).getLocation(), oai.getConnection(1 - thisend).getLocation())) != desiredAngle) continue;
                                    situation |= 0x10;
                                    break;
                                }
                                desiredAngle = -1;
                                if (x0 != wantX1 || y0 != wantY1) {
                                    desiredAngle = DBMath.figureAngle(want1, xy0);
                                }
                                PortInst piNet1 = null;
                                Iterator pII2 = oNi.getConnections();
                                while (pII2.hasNext()) {
                                    int existingAngle;
                                    Connection con = (Connection)pII2.next();
                                    PortInst pi = con.getPortInst();
                                    if (pi.getPortProto() != opp) continue;
                                    ArcInst oai = con.getArc();
                                    piNet1 = pi;
                                    if (desiredAngle < 0) {
                                        if (oai.getHead().getLocation().getX() != oai.getTail().getLocation().getX() || oai.getHead().getLocation().getY() != oai.getTail().getLocation().getY()) continue;
                                        situation |= 0x10;
                                        break;
                                    }
                                    if (oai.getHead().getLocation().getX() == oai.getTail().getLocation().getX() && oai.getHead().getLocation().getY() == oai.getTail().getLocation().getY()) continue;
                                    int thisend = 0;
                                    if (oai.getTail().getPortInst() == pi) {
                                        thisend = 1;
                                    }
                                    if ((existingAngle = DBMath.figureAngle(oai.getConnection(thisend).getLocation(), oai.getConnection(1 - thisend).getLocation())) != desiredAngle) continue;
                                    situation |= 0x10;
                                    break;
                                }
                                if (piNet0 != null && piNet1 != null && netlist.sameNetwork(piNet0.getNodeInst(), piNet0.getPortProto(), piNet1.getNodeInst(), piNet1.getPortProto())) continue;
                                if (pp != port0 || opp != port1) {
                                    situation |= 1;
                                }
                                if (con1 != (con2 = ni.getNumConnections() + oNi.getNumConnections())) {
                                    situation |= 2;
                                }
                                if (ni.getProto() != node0.getProto() || oNi.getProto() != node1.getProto()) {
                                    situation |= 4;
                                }
                                SizeOffset so = ni.getSizeOffset();
                                double wid = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
                                double hei = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
                                if (wid != node0Wid || hei != node0Hei) {
                                    situation |= 8;
                                }
                                so = oNi.getSizeOffset();
                                wid = oNi.getXSize() - so.getLowXOffset() - so.getHighXOffset();
                                hei = oNi.getYSize() - so.getLowYOffset() - so.getHighYOffset();
                                if (wid != node1Wid || hei != node1Hei) {
                                    situation |= 8;
                                }
                                PossibleArc found = null;
                                Iterator paIt = possibleArcs.iterator();
                                while (paIt.hasNext()) {
                                    PossibleArc pa = (PossibleArc)paIt.next();
                                    if (pa.ni1 == ni && pa.pp1 == pp && pa.ni2 == oNi && pa.pp2 == opp) {
                                        found = pa;
                                        break;
                                    }
                                    if (pa.ni2 != ni || pa.pp2 != pp || pa.ni1 != oNi || pa.pp1 != opp) continue;
                                    found = pa;
                                    break;
                                }
                                if (found != null) {
                                    if (found.situation == situation) continue;
                                    int foundIndex = -1;
                                    for (int k = 0; k < situations.length && found.situation != situations[k]; ++k) {
                                        if (situation != situations[k]) continue;
                                        foundIndex = k;
                                        break;
                                    }
                                    if (foundIndex >= 0 && found.situation == situations[foundIndex]) continue;
                                }
                                if (found == null) {
                                    found = new PossibleArc();
                                    possibleArcs.add(found);
                                }
                                found.ni1 = ni;
                                found.pp1 = pp;
                                found.pt1 = xy0;
                                found.ni2 = oNi;
                                found.pp2 = opp;
                                found.pt2 = want1;
                                found.situation = situation;
                            }
                        }
                    }
                }
            }
            int ifIgnorePorts = 0;
            int ifIgnoreArcCount = 0;
            int ifIgnoreNodeType = 0;
            int ifIgnoreNodeSize = 0;
            int ifIgnoreOtherSameDir = 0;
            boolean flushStructureChanges = false;
            for (int j = 0; j < situations.length; ++j) {
                total = 0;
                Iterator it4 = possibleArcs.iterator();
                while (it4.hasNext()) {
                    PossibleArc pa = (PossibleArc)it4.next();
                    if (pa.situation != situations[j]) continue;
                    ++total;
                }
                if (total == 0) continue;
                boolean stopWhenDone = false;
                if (!mimicInteractive) {
                    if (matchPorts && (situations[j] & 1) != 0) {
                        ifIgnorePorts += total;
                        continue;
                    }
                    if (matchArcCount && (situations[j] & 2) != 0) {
                        ifIgnoreArcCount += total;
                        continue;
                    }
                    if (matchNodeType && (situations[j] & 4) != 0) {
                        ifIgnoreNodeType += total;
                        continue;
                    }
                    if (matchNodeSize && (situations[j] & 8) != 0) {
                        ifIgnoreNodeSize += total;
                        continue;
                    }
                    if (noOtherArcsThisDir && (situations[j] & 0x10) != 0) {
                        ifIgnoreOtherSameDir += total;
                        continue;
                    }
                } else {
                    ArrayList saveHighlights = new ArrayList();
                    Iterator it5 = Highlight.getHighlights();
                    while (it5.hasNext()) {
                        saveHighlights.add(it5.next());
                    }
                    Highlight.clear();
                    it5 = possibleArcs.iterator();
                    while (it5.hasNext()) {
                        PossibleArc pa = (PossibleArc)it5.next();
                        if (pa.situation != situations[j]) continue;
                        if (pa.pt1.getX() == pa.pt2.getX() && pa.pt1.getY() == pa.pt2.getY()) {
                            Rectangle2D.Double pointRect = new Rectangle2D.Double(pa.pt1.getX() - 1.0, pa.pt1.getY() - 1.0, 2.0, 2.0);
                            Highlight.addArea(pointRect, cell);
                            continue;
                        }
                        Highlight.addLine(pa.pt1, pa.pt2, cell);
                    }
                    Highlight.finished();
                    if (flushStructureChanges) {
                        EditWindow.repaintAllContents();
                    }
                    Object[] options = new String[]{"Yes", "No", "No, and stop", "Yes, then stop"};
                    int ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Create " + total + " wires shown here?", "Create wires", -1, 2, null, options, options[1]);
                    Highlight.clear();
                    Highlight.setHighlightList(saveHighlights);
                    Highlight.finished();
                    if (ret == 1) continue;
                    if (ret == 2) break;
                    if (ret == 3) {
                        stopWhenDone = true;
                    }
                }
                Iterator it6 = possibleArcs.iterator();
                while (it6.hasNext()) {
                    PossibleArc pa = (PossibleArc)it6.next();
                    if (pa.situation != situations[j]) continue;
                    Poly portPoly1 = pa.ni1.getShapeOfPort(pa.pp1);
                    Poly portPoly2 = pa.ni2.getShapeOfPort(pa.pp2);
                    Point2D.Double bend = new Point2D.Double((portPoly1.getCenterX() + portPoly2.getCenterX()) / 2.0 + this.prefX, (portPoly1.getCenterY() + portPoly2.getCenterY()) / 2.0 + this.prefY);
                    PortInst pi1 = pa.ni1.findPortInstFromProto(pa.pp1);
                    PortInst pi2 = pa.ni2.findPortInstFromProto(pa.pp2);
                    Route route = router.planRoute(pa.ni1.getParent(), pi1, pi2, (Point2D)bend);
                    if (route.size() == 0) {
                        System.out.println("Problem creating arc");
                        return count;
                    }
                    Router.createRouteNoJob(route, pa.ni1.getParent(), false);
                    flushStructureChanges = true;
                    ++count;
                }
                if (stopWhenDone) break;
            }
            if (count != 0) {
                System.out.println("MIMIC ROUTING: Created " + count + " arcs");
            } else if (this.forced) {
                String msg = "No wires added";
                if (ifIgnorePorts != 0) {
                    msg = msg + ", might have added " + ifIgnorePorts + " wires if 'ports must match' were off";
                }
                if (ifIgnoreArcCount != 0) {
                    msg = msg + ", might have added " + ifIgnoreArcCount + " wires if 'number of existing arcs must match' were off";
                }
                if (ifIgnoreNodeType != 0) {
                    msg = msg + ", might have added " + ifIgnoreNodeType + " wires if 'node types must match' were off";
                }
                if (ifIgnoreNodeSize != 0) {
                    msg = msg + ", might have added " + ifIgnoreNodeSize + " wires if 'nodes sizes must match' were off";
                }
                if (ifIgnoreOtherSameDir != 0) {
                    msg = msg + ", might have added " + ifIgnoreOtherSameDir + " wires if 'cannot have other arcs in the same direction' were off";
                }
                System.out.println(msg);
                if (ifIgnorePorts + ifIgnoreArcCount + ifIgnoreNodeType + ifIgnoreNodeSize + ifIgnoreOtherSameDir != 0) {
                    System.out.println(" (settings are in the Tools / Routing tab of the Preferences)");
                }
            }
            return count;
        }

        static class PossibleArc {
            int situation;
            NodeInst ni1;
            NodeInst ni2;
            PortProto pp1;
            PortProto pp2;
            Point2D pt1;
            Point2D pt2;

            PossibleArc() {
            }
        }
    }

    private static class MimicUnstitchJob
    extends Job {
        List arcKills;

        protected MimicUnstitchJob(List arcKills) {
            super("Mimic-Unstitch", Routing.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.arcKills = arcKills;
            this.startJob();
        }

        public boolean doIt() {
            int deleted = 0;
            Iterator it = this.arcKills.iterator();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                ai.kill();
                ++deleted;
            }
            if (deleted != 0) {
                System.out.println("MIMIC ROUTING: deleted " + deleted + "wires");
            }
            return true;
        }
    }
}

