/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.CellLists;
import com.sun.electric.tool.user.dialogs.CellProperties;
import com.sun.electric.tool.user.dialogs.CrossLibCopy;
import com.sun.electric.tool.user.dialogs.NewCell;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class CellMenu {
    protected static void addCellMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu cellMenu = new MenuBar.Menu("Cell", 'C');
        menuBar.add(cellMenu);
        cellMenu.addMenuItem("New Cell...", KeyStroke.getKeyStroke(78, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.newCellCommand();
            }
        });
        cellMenu.addMenuItem("Edit Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.editCell);
            }
        });
        cellMenu.addMenuItem("Place Cell Instance...", KeyStroke.getKeyStroke(78, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.newInstance);
            }
        });
        cellMenu.addMenuItem("Rename Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.renameCell);
            }
        });
        cellMenu.addMenuItem("Duplicate Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.duplicateCell);
            }
        });
        cellMenu.addMenuItem("Delete Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.deleteCell);
            }
        });
        cellMenu.addSeparator();
        cellMenu.addMenuItem("Cross-Library Copy...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.crossLibraryCopyCommand();
            }
        });
        cellMenu.addSeparator();
        cellMenu.addMenuItem("Down Hierarchy", KeyStroke.getKeyStroke(68, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.downHierCommand();
            }
        });
        cellMenu.addMenuItem("Up Hierarchy", KeyStroke.getKeyStroke(85, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.upHierCommand();
            }
        });
        cellMenu.addSeparator();
        cellMenu.addMenuItem("New Version of Current Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.newCellVersionCommand();
            }
        });
        cellMenu.addMenuItem("Duplicate Current Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.duplicateCellCommand();
            }
        });
        cellMenu.addMenuItem("Delete Unused Old Versions", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.deleteOldCellVersionsCommand();
            }
        });
        cellMenu.addSeparator();
        MenuBar.Menu cellInfoSubMenu = new MenuBar.Menu("Cell Info");
        cellMenu.add(cellInfoSubMenu);
        cellInfoSubMenu.addMenuItem("Describe this Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellLists.describeThisCellCommand();
            }
        });
        cellInfoSubMenu.addMenuItem("General Cell Lists...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellLists.generalCellListsCommand();
            }
        });
        cellInfoSubMenu.addSeparator();
        cellInfoSubMenu.addMenuItem("List Nodes in this Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellLists.listNodesInCellCommand();
            }
        });
        cellInfoSubMenu.addMenuItem("List Cell Instances", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellLists.listCellInstancesCommand();
            }
        });
        cellInfoSubMenu.addMenuItem("List Cell Usage", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellLists.listCellUsageCommand();
            }
        });
        cellInfoSubMenu.addSeparator();
        cellInfoSubMenu.addMenuItem("Graphically, Entire Library", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.graphCellsInLibrary();
            }
        });
        cellInfoSubMenu.addMenuItem("Graphically, From Current Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.graphCellsFromCell();
            }
        });
        cellMenu.addMenuItem("Cell Properties...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellControlCommand();
            }
        });
        cellMenu.addSeparator();
        MenuBar.Menu expandListSubMenu = new MenuBar.Menu("Expand Cell Instances");
        cellMenu.add(expandListSubMenu);
        expandListSubMenu.addMenuItem("One Level Down", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.expandOneLevelDownCommand();
            }
        });
        expandListSubMenu.addMenuItem("All the Way", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.expandFullCommand();
            }
        });
        expandListSubMenu.addMenuItem("Specified Amount...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.expandSpecificCommand();
            }
        });
        MenuBar.Menu unExpandListSubMenu = new MenuBar.Menu("Unexpand Cell Instances");
        cellMenu.add(unExpandListSubMenu);
        unExpandListSubMenu.addMenuItem("One Level Up", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.unexpandOneLevelUpCommand();
            }
        });
        unExpandListSubMenu.addMenuItem("All the Way", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.unexpandFullCommand();
            }
        });
        unExpandListSubMenu.addMenuItem("Specified Amount...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.unexpandSpecificCommand();
            }
        });
        cellMenu.addMenuItem("Look Inside Highlighted", KeyStroke.getKeyStroke(80, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.peekCommand();
            }
        });
        cellMenu.addSeparator();
        cellMenu.addMenuItem("Package Into Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.packageIntoCell();
            }
        });
        cellMenu.addMenuItem("Extract Cell Instance", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.extractCells();
            }
        });
    }

    public static void cellControlCommand() {
        CellProperties dialog = new CellProperties((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public static void newCellCommand() {
        NewCell dialog = new NewCell((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public static void cellBrowserCommand(CellBrowser.DoAction action) {
        CellBrowser dialog = new CellBrowser((Frame)TopLevel.getCurrentJFrame(), true, action);
        dialog.setVisible(true);
    }

    public static void crossLibraryCopyCommand() {
        CrossLibCopy dialog = new CrossLibCopy((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public static void downHierCommand() {
        EditWindow curEdit = EditWindow.needCurrent();
        curEdit.downHierarchy();
    }

    public static void upHierCommand() {
        EditWindow curEdit = EditWindow.needCurrent();
        curEdit.upHierarchy();
    }

    public static void newCellVersionCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        CircuitChanges.newVersionOfCell(curCell);
    }

    public static void duplicateCellCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        String newName = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Name of duplicated cell", curCell.getName() + "NEW");
        if (newName == null) {
            return;
        }
        CircuitChanges.duplicateCell(curCell, newName);
    }

    public static void deleteOldCellVersionsCommand() {
        CircuitChanges.deleteUnusedOldVersions();
    }
}

