/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.constraint;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellUsage;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

class LayoutCell {
    private static final Integer AI_RIGID = new Integer(0);
    private static final Integer AI_FLEX = new Integer(1);
    final Cell cell;
    private HashMap<Export, PortInst> oldExports;
    private HashMap<ArcInst, ImmutableArcInst> oldArcs;
    private LinkedHashMap<NodeInst, ImmutableNodeInst> oldNodes = new LinkedHashMap();
    private boolean modified;
    private boolean exportsModified;
    private boolean computed;
    private final CellBackup oldBackup;
    private HashSet<NodeInst> movedNodes;

    LayoutCell(Cell cell, CellBackup oldBackup) {
        this.cell = cell;
        this.oldBackup = oldBackup;
    }

    void compute() {
        CellBackup newBackup;
        CellUsage u;
        if (this.computed) {
            return;
        }
        this.computed = true;
        Iterator<CellUsage> it = this.cell.getUsagesIn();
        while (it.hasNext()) {
            u = it.next();
            Layout.getCellInfo(u.getProto()).compute();
        }
        if (this.modified || this.exportsModified) {
            this.doCompute();
            if (this.exportsModified) {
                it = this.cell.getUsagesOf();
                while (it.hasNext()) {
                    u = it.next();
                    Layout.getCellInfo((Cell)u.getParent()).modified = true;
                }
            }
        }
        this.cell.getTechnology();
        boolean justWritten = Layout.librariesWritten.contains(this.cell.getLibrary().getId());
        if (!justWritten && (newBackup = this.cell.backup()) != this.oldBackup) {
            this.cell.lowLevelMadeRevision(Layout.revisionDate, Layout.userName);
            assert (this.cell.isModified(true));
            this.cell.getLibrary().setChanged();
        }
        if (Layout.goodDRCCells != null && Layout.goodDRCCells.contains(this.cell)) {
            this.cell.addVar(Layout.goodDRCDate);
            this.cell.addVar(Layout.goodDRCBit);
        }
        this.cell.getBounds();
        this.oldArcs = null;
        this.movedNodes = null;
    }

    private void doCompute() {
        ImmutableNodeInst d;
        this.movedNodes = new HashSet();
        LinkedHashSet<NodeInst> modifiedInsts = new LinkedHashSet<NodeInst>();
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            boolean portsModified;
            NodeInst nodeInst = it.next();
            if (nodeInst.isCellInstance()) {
                LayoutCell subCell = Layout.getCellInfo((Cell)nodeInst.getProto());
                portsModified = subCell.exportsModified;
            } else {
                d = this.getOldD(nodeInst);
                boolean bl = portsModified = d != null && d.size != nodeInst.getD().size;
            }
            if (!portsModified) continue;
            modifiedInsts.add(nodeInst);
        }
        if (this.oldNodes != null) {
            for (Map.Entry entry : this.oldNodes.entrySet()) {
                NodeInst ni = (NodeInst)entry.getKey();
                d = (ImmutableNodeInst)entry.getValue();
                if (d == null) continue;
                modifiedInsts.add(ni);
                if (ni.getAnchorCenter().equals(d.anchor) && ni.getOrient().equals(d.orient)) continue;
                this.movedNodes.add(ni);
            }
        }
        for (NodeInst nodeInst : modifiedInsts) {
            ImmutableNodeInst d2;
            if (nodeInst.hasExports()) {
                this.exportsModified = true;
            }
            Orientation dOrient = (d2 = this.getOldD(nodeInst)) != null ? nodeInst.getOrient().concatenate(d2.orient.inverse()) : Orientation.IDENT;
            this.modNodeArcs(nodeInst, dOrient);
        }
        if (this.oldArcs != null) {
            ArcInst[] oldArcsCopy;
            for (ArcInst ai : oldArcsCopy = this.oldArcs.keySet().toArray(ArcInst.NULL_ARRAY)) {
                if (!ai.isLinked()) continue;
                this.ensureArcInst(ai, Layout.isRigid(ai) ? AI_RIGID : AI_FLEX);
            }
        }
    }

    private void alterNodeInst(NodeInst ni, double deltaCX, double deltaCY, Orientation dOrient) {
        if (deltaCX == 0.0 && deltaCY == 0.0 && dOrient.equals(Orientation.IDENT)) {
            return;
        }
        if (this.movedNodes.contains(ni)) {
            return;
        }
        ni.modifyInstance(deltaCX, deltaCY, 0.0, 0.0, dOrient);
        this.movedNodes.add(ni);
        if (ni.hasExports()) {
            this.exportsModified = true;
        }
    }

    private void modNodeArcs(NodeInst ni, Orientation dOrient) {
        this.modWithin(ni, dOrient);
        this.modRigid(ni, dOrient);
        this.modFlex(ni, dOrient);
    }

    private void modWithin(NodeInst ni, Orientation dOrient) {
        if (this.getOldD(ni) == null) {
            return;
        }
        ArrayList<ArcInst> interiorArcs = new ArrayList<ArcInst>();
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            ArcInst ai = con.getArc();
            if (ai.getHeadPortInst().getNodeInst() != ai.getTailPortInst().getNodeInst()) continue;
            interiorArcs.add(ai);
        }
        for (ArcInst ai : interiorArcs) {
            if (!ai.isLinked()) continue;
            if (this.arcMoved(ai)) {
                this.ensureArcInst(ai, AI_RIGID);
                continue;
            }
            AffineTransform trans = this.transformByPort(ai.getHeadPortInst());
            Point2D.Double newHead = new Point2D.Double();
            trans.transform(ai.getHeadLocation(), newHead);
            trans = this.transformByPort(ai.getTailPortInst());
            Point2D.Double newTail = new Point2D.Double();
            trans.transform(ai.getTailLocation(), newTail);
            this.doMoveArcInst(ai, newHead, newTail, AI_RIGID);
        }
    }

    private void modRigid(NodeInst ni, Orientation dOrient) {
        ArcInst ai;
        ArrayList<Connection> rigidArcs = new ArrayList<Connection>();
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            ArcInst ai2 = con.getArc();
            if (!Layout.isRigid(ai2) || ai2.getHeadPortInst().getNodeInst() == ai2.getTailPortInst().getNodeInst()) continue;
            rigidArcs.add(con);
        }
        if (rigidArcs.size() == 0) {
            return;
        }
        HashSet<ArcInst> rigidModified = new HashSet<ArcInst>();
        for (Connection thisEnd : rigidArcs) {
            ai = thisEnd.getArc();
            if (!ai.isLinked()) continue;
            if (this.arcMoved(ai)) {
                this.ensureArcInst(ai, AI_RIGID);
                continue;
            }
            int thisEndIndex = thisEnd.getEndIndex();
            int otherEndIndex = 1 - thisEndIndex;
            PortInst opi = ai.getPortInst(otherEndIndex);
            NodeInst ono = opi.getNodeInst();
            EPoint otherLocation = ai.getLocation(otherEndIndex);
            AffineTransform trans = this.transformByPort(thisEnd.getPortInst());
            Point2D.Double[] newPts = new Point2D.Double[]{new Point2D.Double(), new Point2D.Double()};
            trans.transform(thisEnd.getLocation(), newPts[thisEndIndex]);
            trans.transform(otherLocation, newPts[otherEndIndex]);
            boolean locked = false;
            if (this.movedNodes.contains(ono)) {
                locked = true;
            } else if (ono.isLocked()) {
                locked = true;
            } else if (ono.isCellInstance()) {
                if (ono.getParent().isInstancesLocked()) {
                    locked = true;
                }
                if (User.isDisallowModificationComplexNodes()) {
                    locked = true;
                }
            } else {
                PrimitiveNode.Function fun;
                if (User.isDisallowModificationLockedPrims() && ((PrimitiveNode)ono.getProto()).isLockedPrim()) {
                    locked = true;
                }
                if (User.isDisallowModificationComplexNodes() && (fun = ono.getFunction()) != PrimitiveNode.Function.PIN && fun != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.NODE && fun != PrimitiveNode.Function.CONNECT) {
                    locked = true;
                }
            }
            if (!locked) {
                Poly oldPoly = Layout.oldPortPosition(opi);
                Poly oPoly = opi.getPoly();
                if (oldPoly == null) {
                    oldPoly = oPoly;
                }
                double oldX = oldPoly.getCenterX();
                double oldY = oldPoly.getCenterY();
                double dx = oPoly.getCenterX();
                double dy = oPoly.getCenterY();
                double othX = dx - oldX;
                double othY = dy - oldY;
                Point2D.Double ptD = new Point2D.Double();
                trans.transform(ono.getAnchorCenter(), ptD);
                dx = ((Point2D)ptD).getX();
                dy = ((Point2D)ptD).getY();
                dx = dx - ono.getAnchorCenterX() - othX;
                dy = dy - ono.getAnchorCenterY() - othY;
                if (dx != 0.0 || dy != 0.0 || !dOrient.equals(Orientation.IDENT)) {
                    rigidModified.add(ai);
                    this.alterNodeInst(ono, dx, dy, dOrient);
                }
            }
            this.doMoveArcInst(ai, newPts[1], newPts[0], AI_RIGID);
        }
        for (Connection thisEnd : rigidArcs) {
            ai = thisEnd.getArc();
            if (!ai.isLinked() || !rigidModified.contains(ai)) continue;
            NodeInst ono = ai.getPortInst(1 - thisEnd.getEndIndex()).getNodeInst();
            this.modNodeArcs(ono, dOrient);
        }
    }

    private void modFlex(NodeInst ni, Orientation dOrient) {
        ArcInst ai;
        ArrayList<Connection> flexArcs = new ArrayList<Connection>();
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            ai = con.getArc();
            if (Layout.isRigid(ai) || ai.getHeadPortInst().getNodeInst() == ai.getTailPortInst().getNodeInst()) continue;
            flexArcs.add(con);
        }
        if (flexArcs.size() == 0) {
            return;
        }
        for (Connection thisEnd : flexArcs) {
            ai = thisEnd.getArc();
            if (!ai.isLinked()) continue;
            if (this.arcMoved(ai)) {
                this.ensureArcInst(ai, AI_FLEX);
                continue;
            }
            int thisEndIndex = thisEnd.getEndIndex();
            int thatEndIndex = 1 - thisEndIndex;
            EPoint thisLocation = thisEnd.getLocation();
            EPoint thatLocation = ai.getLocation(thatEndIndex);
            if (ai.isSlidable() && ai.stillInPort(thisEndIndex, thisLocation, true)) continue;
            Point2D[] newPts = new Point2D.Double[2];
            for (int i = 0; i < 2; ++i) {
                newPts[i] = new Point2D.Double();
                AffineTransform trans = this.transformByPort(ai.getPortInst(i));
                trans.transform(ai.getLocation(i), newPts[i]);
                ((Point2D)newPts[i]).setLocation(DBMath.round(((Point2D)newPts[i]).getX()), DBMath.round(((Point2D)newPts[i]).getY()));
            }
            Poly poly = thisEnd.getPortInst().getPoly();
            if (!poly.isInside(newPts[thisEndIndex])) {
                Rectangle2D bbox = poly.getBounds2D();
                if (((Point2D)newPts[thisEndIndex]).getY() >= bbox.getMinY() && ((Point2D)newPts[thisEndIndex]).getY() <= bbox.getMaxY()) {
                    if (((Point2D)newPts[thisEndIndex]).getX() < bbox.getMinX()) {
                        ((Point2D)newPts[thisEndIndex]).setLocation(bbox.getMinX(), ((Point2D)newPts[thisEndIndex]).getY());
                    } else if (((Point2D)newPts[thisEndIndex]).getX() > bbox.getMaxX()) {
                        ((Point2D)newPts[thisEndIndex]).setLocation(bbox.getMaxX(), ((Point2D)newPts[thisEndIndex]).getY());
                    }
                } else if (((Point2D)newPts[thisEndIndex]).getX() >= bbox.getMinX() && ((Point2D)newPts[thisEndIndex]).getX() <= bbox.getMaxX()) {
                    if (((Point2D)newPts[thisEndIndex]).getY() < bbox.getMinY()) {
                        ((Point2D)newPts[thisEndIndex]).setLocation(((Point2D)newPts[thisEndIndex]).getX(), bbox.getMinY());
                    } else if (((Point2D)newPts[thisEndIndex]).getY() > bbox.getMaxY()) {
                        ((Point2D)newPts[thisEndIndex]).setLocation(((Point2D)newPts[thisEndIndex]).getX(), bbox.getMaxY());
                    }
                } else {
                    Point2D pt = poly.closestPoint(newPts[thisEndIndex]);
                    newPts[thisEndIndex].setLocation(pt);
                }
            }
            NodeInst ono = ai.getPortInst(thatEndIndex).getNodeInst();
            boolean mangle = true;
            if (this.movedNodes.contains(ono)) {
                mangle = false;
            }
            if (!ai.isFixedAngle()) {
                mangle = false;
            } else if (ono.isLocked()) {
                mangle = false;
            } else if (ono.isCellInstance()) {
                if (ono.getParent().isInstancesLocked()) {
                    mangle = false;
                }
            } else if (User.isDisallowModificationLockedPrims() && ((PrimitiveNode)ono.getProto()).isLockedPrim()) {
                mangle = false;
            }
            if (mangle) {
                double dx = ((Point2D)newPts[thisEndIndex]).getX() - thisLocation.getX();
                double dy = ((Point2D)newPts[thisEndIndex]).getY() - thisLocation.getY();
                double odx = ((Point2D)newPts[thatEndIndex]).getX() - thatLocation.getX();
                double ody = ((Point2D)newPts[thatEndIndex]).getY() - thatLocation.getY();
                if (DBMath.doublesEqual(thisLocation.getX(), thatLocation.getX()) && (!DBMath.doublesEqual(thisLocation.getY(), thatLocation.getY()) || ai.getAngle() == 900 || ai.getAngle() == 2700)) {
                    if (dx == odx) {
                        odx = 0.0;
                        dx = 0.0;
                    }
                    ((Point2D)newPts[thatEndIndex]).setLocation(newPts[thatEndIndex].getX() + dx - odx, newPts[thatEndIndex].getY());
                    if (!DBMath.doublesEqual(dx, odx) && ai.isSlidable() && ai.stillInPort(thatEndIndex, newPts[thatEndIndex], true)) {
                        odx = 0.0;
                        dx = 0.0;
                    }
                    if (this.movedNodes.contains(ono)) {
                        odx = 0.0;
                        dx = 0.0;
                    }
                    if (dx != odx) {
                        double xAmount = DBMath.round(dx - odx);
                        this.alterNodeInst(ono, xAmount, 0.0, Orientation.IDENT);
                    }
                    this.doMoveArcInst(ai, newPts[1], newPts[0], AI_FLEX);
                    if (DBMath.doublesEqual(dx, odx)) continue;
                    this.modNodeArcs(ono, Orientation.IDENT);
                    continue;
                }
                if (DBMath.doublesEqual(thisLocation.getY(), thatLocation.getY())) {
                    if (DBMath.doublesEqual(dy, ody)) {
                        ody = 0.0;
                        dy = 0.0;
                    }
                    ((Point2D)newPts[thatEndIndex]).setLocation(newPts[thatEndIndex].getX(), newPts[thatEndIndex].getY() + dy - ody);
                    if (!DBMath.doublesEqual(dy, ody) && ai.isSlidable() && ai.stillInPort(thatEndIndex, newPts[thatEndIndex], true)) {
                        ody = 0.0;
                        dy = 0.0;
                    }
                    if (this.movedNodes.contains(ono)) {
                        odx = 0.0;
                        dx = 0.0;
                    }
                    if (!DBMath.doublesEqual(dy, ody)) {
                        this.alterNodeInst(ono, 0.0, dy - ody, Orientation.IDENT);
                    }
                    this.doMoveArcInst(ai, newPts[1], newPts[0], AI_FLEX);
                    if (DBMath.doublesEqual(dy, ody)) continue;
                    this.modNodeArcs(ono, Orientation.IDENT);
                    continue;
                }
                this.nonOrthogFixAng(ai, thisEnd, thisEndIndex, thatEndIndex, ono, newPts);
                dx = newPts[thatEndIndex].getX() - thatLocation.getX();
                dy = newPts[thatEndIndex].getY() - thatLocation.getY();
                this.updateArc(ai, newPts[1], newPts[0], AI_FLEX);
                if (this.movedNodes.contains(ono)) {
                    dy = 0.0;
                    dx = 0.0;
                }
                if (dx == 0.0 && dy == 0.0) continue;
                this.alterNodeInst(ono, dx, dy, Orientation.IDENT);
                this.modNodeArcs(ono, Orientation.IDENT);
                continue;
            }
            this.doMoveArcInst(ai, newPts[1], newPts[0], AI_FLEX);
        }
    }

    private void nonOrthogFixAng(ArcInst ai, Connection thisEnd, int thisEndIndex, int thatEndIndex, NodeInst ono, Point2D[] newPts) {
        double bestDist = Double.NEGATIVE_INFINITY;
        ArcInst bestAI = null;
        Iterator<Connection> it = ai.getPortInst(thatEndIndex).getConnections();
        while (it.hasNext()) {
            double length;
            Connection con = it.next();
            ArcInst oai = con.getArc();
            if (oai == ai || (length = oai.getGridLength()) <= bestDist) continue;
            bestDist = length;
            bestAI = oai;
        }
        if (bestAI == null) {
            newPts[thatEndIndex].setLocation(newPts[thatEndIndex].getX() + newPts[thisEndIndex].getX() - thisEnd.getLocation().getX(), newPts[thatEndIndex].getY() + newPts[thisEndIndex].getY() - thisEnd.getLocation().getY());
            return;
        }
        Point2D inter = DBMath.intersect(newPts[thisEndIndex], ai.getAngle(), bestAI.getHeadLocation(), bestAI.getAngle());
        if (inter == null) {
            newPts[thatEndIndex].setLocation(newPts[thatEndIndex].getX() + newPts[thisEndIndex].getX() - thisEnd.getLocation().getX(), newPts[thatEndIndex].getY() + newPts[thisEndIndex].getY() - thisEnd.getLocation().getY());
            return;
        }
        newPts[thatEndIndex].setLocation(inter);
    }

    private void ensureArcInst(ArcInst ai, Integer arctyp) {
        EPoint headPoint = ai.getHeadLocation();
        boolean inside0 = ai.headStillInPort(headPoint, true);
        EPoint tailPoint = ai.getTailLocation();
        boolean inside1 = ai.tailStillInPort(tailPoint, true);
        if (inside0 && inside1) {
            return;
        }
        Poly headPoly = ai.getHeadPortInst().getPoly();
        Poly tailPoly = ai.getTailPortInst().getPoly();
        if (!ai.isFixedAngle()) {
            double fx = headPoly.getCenterX();
            double fy = headPoly.getCenterY();
            double tx = tailPoly.getCenterX();
            double ty = tailPoly.getCenterY();
            this.doMoveArcInst(ai, new Point2D.Double(fx, fy), new Point2D.Double(tx, ty), arctyp);
            return;
        }
        Rectangle2D headBounds = headPoly.getBounds2D();
        Rectangle2D tailBounds = tailPoly.getBounds2D();
        double lx0 = headBounds.getMinX();
        double hx0 = headBounds.getMaxX();
        double ly0 = headBounds.getMinY();
        double hy0 = headBounds.getMaxY();
        double lx1 = tailBounds.getMinX();
        double hx1 = tailBounds.getMaxX();
        double ly1 = tailBounds.getMinY();
        double hy1 = tailBounds.getMaxY();
        if (lx0 <= hx1 && lx1 <= hx0) {
            double tx;
            double fx = tx = (Math.max(lx0, lx1) + Math.min(hx0, hx1)) / 2.0;
            double fy = (ly0 + hy0) / 2.0;
            double ty = (ly1 + hy1) / 2.0;
            Point2D fPt = headPoly.closestPoint(new Point2D.Double(fx, fy));
            Point2D tPt = tailPoly.closestPoint(new Point2D.Double(tx, ty));
            this.doMoveArcInst(ai, fPt, tPt, arctyp);
            return;
        }
        if (ly0 <= hy1 && ly1 <= hy0) {
            double ty;
            double fy = ty = (Math.max(ly0, ly1) + Math.min(hy0, hy1)) / 2.0;
            double fx = (lx0 + hx0) / 2.0;
            double tx = (lx1 + hx1) / 2.0;
            Point2D fPt = headPoly.closestPoint(new Point2D.Double(fx, fy));
            Point2D tPt = tailPoly.closestPoint(new Point2D.Double(tx, ty));
            this.doMoveArcInst(ai, fPt, tPt, arctyp);
            return;
        }
        double fx = headPoly.getCenterX();
        double fy = headPoly.getCenterY();
        double tx = tailPoly.getCenterX();
        double ty = tailPoly.getCenterY();
        this.doMoveArcInst(ai, new Point2D.Double(fx, fy), new Point2D.Double(tx, ty), arctyp);
    }

    private void updateArc(ArcInst ai, Point2D headPt, Point2D tailPt, Integer arctyp) {
        ImmutableArcInst oldD;
        ImmutableArcInst d = oldD = ai.getD();
        d = d.withLocations(EPoint.snap(tailPt), EPoint.snap(headPt));
        ai.lowLevelModify(d);
        if (this.oldArcs == null || !this.oldArcs.containsKey(ai)) {
            Constraints.getCurrent().modifyArcInst(ai, oldD);
            this.setChangeClock(ai, arctyp);
        }
    }

    private void doMoveArcInst(ArcInst ai, Point2D headPt, Point2D tailPt, Integer arctyp) {
        Rectangle2D no2Bounds;
        Point2D.Double no2Pt;
        double oldxB;
        double oldxA;
        double oldyB;
        double oldyA;
        if (headPt.equals(ai.getHeadLocation()) && tailPt.equals(ai.getTailLocation()) && arctyp != 0) {
            return;
        }
        if (!ai.isFixedAngle() || Layout.isRigid(ai) || headPt.equals(tailPt) || ai.getAngle() % 1800 == DBMath.figureAngle(tailPt, headPt) % 1800) {
            this.updateArc(ai, headPt, tailPt, arctyp);
            return;
        }
        PortInst fpi = ai.getHeadPortInst();
        PortInst tpi = ai.getTailPortInst();
        ArcProto ap = ai.getProto();
        Cell pnt = ai.getParent();
        double wid = ai.getLambdaBaseWidth();
        PrimitiveNode np = ap.findOverridablePinProto();
        double psx = np.getDefWidth();
        double psy = np.getDefHeight();
        NodeInst no1 = null;
        NodeInst no2 = null;
        if (DBMath.doublesEqual(ai.getHeadLocation().getX(), ai.getTailLocation().getX())) {
            oldyB = oldyA = (tailPt.getY() + headPt.getY()) / 2.0;
            oldxA = headPt.getX();
            oldxB = tailPt.getX();
            no1 = NodeInst.newInstance(np, new Point2D.Double(oldxB, oldyB), psx, psy, pnt);
            no2 = NodeInst.newInstance(np, new Point2D.Double(oldxA, oldyA), psx, psy, pnt);
        } else {
            oldyA = headPt.getY();
            oldyB = tailPt.getY();
            oldxB = oldxA = (tailPt.getX() + headPt.getX()) / 2.0;
            no1 = NodeInst.newInstance(np, new Point2D.Double(oldxB, oldyB), psx, psy, pnt);
            no2 = NodeInst.newInstance(np, new Point2D.Double(oldxA, oldyA), psx, psy, pnt);
        }
        if (no1 == null || no2 == null) {
            System.out.println("Problem creating jog pins");
            return;
        }
        PortInst no1pi = no1.getOnlyPortInst();
        Rectangle2D no1Bounds = no1pi.getPoly().getBounds2D();
        Point2D.Double no1Pt = new Point2D.Double(no1Bounds.getCenterX(), no1Bounds.getCenterY());
        PortInst no2pi = no2.getOnlyPortInst();
        ArcInst ar1 = ArcInst.newInstanceBase(ap, wid, fpi, no2pi, headPt, no2Pt = new Point2D.Double((no2Bounds = no2pi.getPoly().getBounds2D()).getCenterX(), no2Bounds.getCenterY()), null, 0);
        if (ar1 == null) {
            return;
        }
        ar1.copyConstraintsFrom(ai);
        ArcInst ar2 = ArcInst.newInstanceBase(ap, wid, no2pi, no1pi, no2Pt, no1Pt, null, 0);
        if (ar2 == null) {
            return;
        }
        ar2.copyPropertiesFrom(ai);
        ArcInst ar3 = ArcInst.newInstanceBase(ap, wid, no1pi, tpi, no1Pt, tailPt, null, 0);
        if (ar3 == null) {
            return;
        }
        ar3.copyConstraintsFrom(ai);
        if (ai.isTailNegated()) {
            ar3.setTailNegated(true);
        }
        if (ar1 == null || ar2 == null || ar3 == null) {
            System.out.println("Problem creating jog arcs");
            return;
        }
        this.setChangeClock(ar1, arctyp);
        this.setChangeClock(ar2, arctyp);
        this.setChangeClock(ar3, arctyp);
        ar2.copyTextDescriptorFrom(ai, ArcInst.ARC_NAME);
        ai.kill();
        String oldName = ai.getName();
        if (oldName != null) {
            ar2.setName(oldName);
        }
    }

    private AffineTransform transformByPort(PortInst pi) {
        NodeInst ni = pi.getNodeInst();
        ImmutableNodeInst d = this.getOldD(ni);
        if (d == null) {
            return new AffineTransform();
        }
        if (!ni.getOrient().equals(d.orient)) {
            Orientation dOrient = ni.getOrient().concatenate(d.orient.inverse());
            return dOrient.rotateAbout(ni.getAnchorCenterX(), ni.getAnchorCenterY(), -d.anchor.getX(), -d.anchor.getY());
        }
        PortProto pp = pi.getPortProto();
        Poly oldPoly = Layout.oldPortPosition(pi);
        Poly curPoly = ni.getShapeOfPort(pp);
        if (oldPoly == null) {
            oldPoly = curPoly;
        }
        double scaleX = 1.0;
        double scaleY = 1.0;
        if (oldPoly.getBounds2D().getWidth() > 0.0) {
            scaleX = curPoly.getBounds2D().getWidth() / oldPoly.getBounds2D().getWidth();
        }
        if (oldPoly.getBounds2D().getHeight() > 0.0) {
            scaleY = curPoly.getBounds2D().getHeight() / oldPoly.getBounds2D().getHeight();
        }
        double newX = curPoly.getCenterX() - oldPoly.getCenterX() * scaleX;
        double newY = curPoly.getCenterY() - oldPoly.getCenterY() * scaleY;
        return new AffineTransform(scaleX, 0.0, 0.0, scaleY, newX, newY);
    }

    private void setChangeClock(Geometric geom, Integer typ) {
    }

    void modifyNodeInst(NodeInst ni, ImmutableNodeInst oldD) {
        this.modified = true;
        if (!this.oldNodes.containsKey(ni)) {
            this.oldNodes.put(ni, oldD);
        }
    }

    void modifyArcInst(ArcInst ai, ImmutableArcInst oldD) {
        this.modified = true;
        if (this.oldArcs == null) {
            this.oldArcs = new HashMap();
        }
        if (!this.oldArcs.containsKey(ai)) {
            this.oldArcs.put(ai, oldD);
        }
    }

    void modifyExport(Export pp, PortInst oldPi) {
        this.exportsModified = true;
        if (this.oldExports == null) {
            this.oldExports = new HashMap();
        }
        if (!this.oldExports.containsKey(pp)) {
            this.oldExports.put(pp, oldPi);
        }
    }

    void newObject(ElectricObject obj) {
        if (obj instanceof Export) {
            if (this.oldExports == null) {
                this.oldExports = new HashMap();
            }
            assert (!this.oldExports.containsKey(obj));
            this.oldExports.put((Export)obj, null);
        } else if (obj instanceof NodeInst) {
            assert (!this.oldNodes.containsKey(obj));
            this.oldNodes.put((NodeInst)obj, null);
        } else if (obj instanceof ArcInst) {
            if (this.oldArcs == null) {
                this.oldArcs = new HashMap();
            }
            assert (!this.oldArcs.containsKey(obj));
            this.oldArcs.put((ArcInst)obj, null);
        }
    }

    PortInst getOldOriginalPort(Export e) {
        if (this.oldExports == null || !this.oldExports.containsKey(e)) {
            return e.getOriginalPort();
        }
        return this.oldExports.get(e);
    }

    ImmutableNodeInst getOldD(NodeInst ni) {
        if (this.oldNodes == null || !this.oldNodes.containsKey(ni)) {
            return ni.getD();
        }
        return this.oldNodes.get(ni);
    }

    boolean arcMoved(ArcInst ai) {
        if (this.oldArcs == null || !this.oldArcs.containsKey(ai)) {
            return false;
        }
        ImmutableArcInst oldD = this.oldArcs.get(ai);
        if (oldD == null) {
            return false;
        }
        return ai.getHeadLocation() != oldD.headLocation || ai.getTailLocation() != oldD.tailLocation;
    }
}

