/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.prototype;

import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitivePort;
import java.awt.geom.AffineTransform;

public class PortOriginal {
    private AffineTransform subrot;
    private Orientation orient;
    private PortInst bottomPort;
    private NodeInst bottomNi;
    private PortProto bottomPp;

    public PortOriginal(PortInst startPort) {
        this.bottomPort = startPort;
        this.bottomNi = this.bottomPort.getNodeInst();
        this.bottomPp = this.bottomPort.getPortProto();
        this.subrot = this.bottomNi.rotateOut();
        this.traverse();
    }

    public PortOriginal(PortInst startPort, AffineTransform pre) {
        this.bottomPort = startPort;
        this.bottomNi = this.bottomPort.getNodeInst();
        this.bottomPp = this.bottomPort.getPortProto();
        this.subrot = this.bottomNi.rotateOut(pre);
        this.traverse();
    }

    public PortOriginal(NodeInst ni, PortProto pp) {
        this.bottomPort = null;
        this.bottomNi = ni;
        this.bottomPp = pp;
        this.subrot = this.bottomNi.rotateOut();
        this.traverse();
    }

    private void traverse() {
        this.orient = this.bottomNi.getOrient();
        while (this.bottomNi.isCellInstance()) {
            this.subrot = this.bottomNi.translateOut(this.subrot);
            this.bottomPort = ((Export)this.bottomPp).getOriginalPort();
            this.bottomNi = this.bottomPort.getNodeInst();
            this.bottomPp = this.bottomPort.getPortProto();
            this.subrot = this.bottomNi.rotateOut(this.subrot);
            this.orient = this.orient.concatenate(this.bottomNi.getOrient());
        }
    }

    public NodeInst getBottomNodeInst() {
        return this.bottomNi;
    }

    public PrimitivePort getBottomPortProto() {
        return (PrimitivePort)this.bottomPp;
    }

    public PortInst getBottomPort() {
        if (this.bottomPort == null) {
            this.bottomPort = this.bottomNi.findPortInstFromProto(this.bottomPp);
        }
        return this.bottomPort;
    }

    public AffineTransform getTransformToTop() {
        return this.subrot;
    }

    public Orientation getOrientToTop() {
        return this.orient;
    }
}

