/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.plugins.j3d.View3DWindow;
import com.sun.electric.plugins.j3d.ui.J3DDemoDialog;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.lang.reflect.Method;

public class J3DMenu {
    public static EMenu makeMenu() {
        return new EMenu("_3D Window", new EMenuItem("_3D View"){

            public void run() {
                J3DMenu.create3DViewCommand(false);
            }
        }, new EMenuItem("_Capture Frame/Animate"){

            public void run() {
                J3DDemoDialog.create3DDemoDialog(TopLevel.getCurrentJFrame(), null);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Test Hardware"){

            public void run() {
                J3DMenu.runHardwareTest();
            }
        });
    }

    public static void create3DViewCommand(Boolean transPerNode) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        Technology tech = curCell.getTechnology();
        if (tech != Technology.getMocmosTechnology() && tech != Technology.getTSMC180Technology() && tech != Technology.getCMOS90Technology()) {
            System.out.println("3D View only available for 180nm and 90nm technologies.");
            return;
        }
        WindowContent view2D = WindowFrame.getCurrentWindowFrame(false).getContent();
        if (!(view2D instanceof EditWindow)) {
            return;
        }
        WindowFrame frame = new WindowFrame();
        View3DWindow.create3DWindow(curCell, frame, view2D, transPerNode);
    }

    private static void runHardwareTest() {
        Class app3DClass = Resources.getJMFJ3DClass("J3DQueryProperties");
        try {
            Method queryClass = app3DClass.getDeclaredMethod("queryHardwareAcceleration", new Class[0]);
            queryClass.invoke((Object)queryClass, new Object[0]);
        }
        catch (Exception e) {
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            System.out.println("Cannot call 3D plugin method queryHardwareAcceleration: ");
        }
    }
}

