/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.LibId;
import com.sun.electric.database.TechId;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.ncc.basic.TransitiveRelation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JELIB
extends LibraryFiles {
    private static String[] revisions = new String[]{"8.01aw", "8.04l"};
    private static int defaultArcFlags = ImmutableArcInst.DEFAULT_FLAGS;
    private LinkedHashMap<Cell, CellContents> allCells = new LinkedHashMap();
    private HashMap<String, Rectangle2D> externalCells;
    private HashMap<String, Point2D.Double> externalExports;
    private HashMap<String, TextDescriptor> parsedDescriptorsF = new HashMap();
    private HashMap<String, TextDescriptor> parsedDescriptorsT = new HashMap();
    char escapeChar = (char)92;
    String curLibName;
    String curReadFile;
    private String curExternalLibName = "";
    private String curExternalCellName = "";
    private Technology curTech = null;
    private PrimitiveNode curPrim = null;
    private ArrayList<Cell[]> groupLines;

    JELIB() {
    }

    @Override
    protected boolean readProjectSettings() {
        try {
            this.curLibName = null;
            this.version = null;
            this.curExternalLibName = "";
            this.curExternalCellName = "";
            this.curTech = null;
            this.curPrim = null;
            this.externalCells = new HashMap();
            this.externalExports = new HashMap();
            this.curReadFile = this.filePath;
            this.readFromFile(false, true);
            return false;
        }
        catch (IOException e) {
            Input.errorLogger.logError("End of file reached while reading " + this.filePath, -1);
            return true;
        }
    }

    @Override
    protected boolean readLib() {
        try {
            if (this.readTheLibrary()) {
                return true;
            }
            this.nodeProtoCount = this.allCells.size();
            this.nodeProtoList = new Cell[this.nodeProtoCount];
            this.cellLambda = new double[this.nodeProtoCount];
            int i = 0;
            for (Cell cell : this.allCells.keySet()) {
                this.nodeProtoList[i++] = cell;
            }
            return false;
        }
        catch (IOException e) {
            Input.errorLogger.logError("End of file reached while reading " + this.filePath, -1);
            return true;
        }
    }

    private boolean readTheLibrary() throws IOException {
        Cell firstCell;
        this.lib.erase();
        this.curLibName = null;
        this.version = null;
        this.curExternalLibName = "";
        this.curExternalCellName = "";
        this.curTech = null;
        this.curPrim = null;
        this.externalCells = new HashMap();
        this.externalExports = new HashMap();
        this.groupLines = new ArrayList();
        this.curReadFile = this.filePath;
        this.readFromFile(false, false);
        TransitiveRelation<Object> transitive = new TransitiveRelation<Object>();
        HashMap<String, String> protoNames = new HashMap<String, String>();
        Iterator<Cell> cit = this.lib.getCells();
        while (cit.hasNext()) {
            Cell cell = cit.next();
            String protoName = (String)protoNames.get(cell.getName());
            if (protoName == null) {
                protoName = cell.getName();
                protoNames.put(protoName, protoName);
            }
            transitive.theseAreRelated(cell, protoName);
            String groupName = this.allCells.get((Object)cell).groupName;
            if (groupName == null) continue;
            protoName = (String)protoNames.get(groupName);
            if (protoName == null) {
                protoName = groupName;
                protoNames.put(protoName, protoName);
            }
            transitive.theseAreRelated(cell, protoName);
        }
        for (Cell[] groupLine : this.groupLines) {
            firstCell = null;
            for (int i = 0; i < groupLine.length; ++i) {
                if (groupLine[i] == null) continue;
                if (firstCell == null) {
                    firstCell = groupLine[i];
                    continue;
                }
                transitive.theseAreRelated(firstCell, groupLine[i]);
            }
        }
        Iterator git = transitive.getSetsOfRelatives();
        while (git.hasNext()) {
            Set group = git.next();
            firstCell = null;
            for (Object o : group) {
                if (!(o instanceof Cell)) continue;
                Cell cell = (Cell)o;
                if (firstCell == null) {
                    firstCell = cell;
                    continue;
                }
                cell.joinGroup(firstCell);
            }
        }
        HashMap<String, Cell.CellGroup> cellGroups = new HashMap<String, Cell.CellGroup>();
        Iterator<Cell> it = this.lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            String canonicName = TextUtils.canonicString(cell.getName());
            Cell.CellGroup group = cell.getCellGroup();
            Cell.CellGroup groupOfName = (Cell.CellGroup)cellGroups.get(canonicName);
            if (groupOfName == null) {
                cellGroups.put(canonicName, group);
                continue;
            }
            if (groupOfName == group) continue;
            Input.errorLogger.logError(this.filePath + ", Library has multiple cells named '" + canonicName + "' that are not in the same group", -1);
        }
        this.lib.clearChanged();
        this.lib.setFromDisk();
        return false;
    }

    protected void readFromFile(boolean fromDelib, boolean onlyProjectSettings) throws IOException {
        String line;
        int revision = revisions.length;
        boolean ignoreCvsMergedContent = false;
        while ((line = this.lineReader.readLine()) != null) {
            List<String> pieces;
            char first;
            if (line.length() == 0 || (first = line.charAt(0)) == '#') continue;
            if (line.startsWith("<<<<<<<")) {
                ignoreCvsMergedContent = true;
                Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", CVS conflicts found: " + line, -1);
                continue;
            }
            if (ignoreCvsMergedContent && line.startsWith("=======")) {
                ignoreCvsMergedContent = false;
                continue;
            }
            if (line.startsWith(">>>>>>>") || ignoreCvsMergedContent || onlyProjectSettings && first != 'H' && first != 'O' && first != 'T') continue;
            if (first == 'C') {
                this.readCell(revision, line);
                continue;
            }
            if (first == 'L') {
                pieces = this.parseLine(line);
                if (pieces.size() != 2) {
                    Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", External library declaration needs 2 fields: " + line, -1);
                    continue;
                }
                this.curExternalLibName = this.unQuote(revision, pieces.get(0));
                if (Library.findLibrary(this.curExternalLibName) != null) continue;
                this.readExternalLibraryFromFilename(this.unQuote(revision, pieces.get(1)), this.getPreferredFileType());
                continue;
            }
            if (first == 'R') {
                int numPieces;
                pieces = this.parseLine(line);
                int n = numPieces = revision == 1 ? 7 : 5;
                if (pieces.size() != numPieces) {
                    Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", External cell declaration needs " + numPieces + " fields: " + line, -1);
                    continue;
                }
                double lowX = TextUtils.atof(pieces.get(1));
                double highX = TextUtils.atof(pieces.get(2));
                double lowY = TextUtils.atof(pieces.get(3));
                double highY = TextUtils.atof(pieces.get(4));
                if (revision == 1) {
                    Long.parseLong(pieces.get(5));
                    Long.parseLong(pieces.get(6));
                }
                Rectangle2D.Double bounds = new Rectangle2D.Double(lowX, lowY, highX - lowX, highY - lowY);
                this.curExternalCellName = this.curExternalLibName + ":" + this.unQuote(revision, pieces.get(0));
                this.externalCells.put(this.curExternalCellName, bounds);
                continue;
            }
            if (first == 'F') {
                pieces = this.parseLine(line);
                if (pieces.size() != 3) {
                    Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", External export declaration needs 3 fields: " + line, -1);
                    continue;
                }
                String exportName = this.unQuote(revision, pieces.get(0));
                double posX = TextUtils.atof(pieces.get(1));
                double posY = TextUtils.atof(pieces.get(1));
                this.externalExports.put(this.curExternalCellName + ":" + exportName, new Point2D.Double(posX, posY));
                continue;
            }
            if (first == 'H') {
                pieces = this.parseLine(line);
                if (pieces.size() < 2) {
                    Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Library declaration needs 2 fields: " + line, -1);
                    continue;
                }
                this.version = Version.parseVersion(pieces.get(1));
                if (this.version == null) {
                    Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Badly formed version: " + pieces.get(1), -1);
                    continue;
                }
                for (revision = 0; revision < revisions.length && this.version.compareTo(Version.parseVersion(revisions[revision])) >= 0; ++revision) {
                }
                if (revision < 1) {
                    this.escapeChar = (char)94;
                    pieces = this.parseLine(line);
                }
                this.curLibName = this.unQuote(revision, pieces.get(0));
                if (this.version.compareTo(Version.getVersion()) > 0) {
                    Input.errorLogger.logWarning(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Library " + this.curLibName + " comes from a NEWER version of Electric (" + this.version + ")", null, -1);
                }
                Variable[] vars = this.readVariables(revision, this.lib, pieces, 2, this.filePath, this.lineReader.getLineNumber());
                if (fromDelib || onlyProjectSettings) continue;
                this.realizeVariables(this.lib, vars);
                this.lib.setVersion(this.version);
                continue;
            }
            if (first == 'O') {
                pieces = this.parseLine(line);
                String toolName = this.unQuote(revision, pieces.get(0));
                Tool tool = Tool.findTool(toolName);
                if (tool == null) {
                    Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Cannot identify tool " + toolName, -1);
                    continue;
                }
                Variable[] vars = this.readVariables(revision, null, pieces, 1, this.filePath, this.lineReader.getLineNumber());
                this.realizeMeaningPrefs(tool, vars);
                continue;
            }
            if (first == 'V') {
                String viewAbbr;
                pieces = this.parseLine(line);
                String viewName = this.unQuote(revision, pieces.get(0));
                View view = View.findView(viewName);
                if (view != null || (view = View.newInstance(viewName, viewAbbr = this.unQuote(revision, pieces.get(1)))) != null) continue;
                Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Cannot create view " + viewName, -1);
                continue;
            }
            if (first == 'T') {
                pieces = this.parseLine(line);
                String techName = this.unQuote(revision, pieces.get(0));
                this.curTech = this.findTechnology(techName);
                if (this.curTech == null) {
                    Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Cannot identify technology " + techName, -1);
                    continue;
                }
                this.curPrim = null;
                Variable[] vars = this.readVariables(revision, null, pieces, 1, this.filePath, this.lineReader.getLineNumber());
                this.realizeMeaningPrefs(this.curTech, vars);
                continue;
            }
            if (first == 'D') {
                pieces = this.parseLine(line);
                String primName = this.unQuote(revision, pieces.get(0));
                if (this.curTech == null) {
                    Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Primitive node " + primName + " has no technology before it", -1);
                    continue;
                }
                this.curPrim = this.findPrimitiveNode(this.curTech, primName);
                if (this.curPrim != null) continue;
                Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Cannot identify primitive node " + primName, -1);
                continue;
            }
            if (first == 'P') {
                pieces = this.parseLine(line);
                String primPortName = this.unQuote(revision, pieces.get(0));
                if (this.curPrim == null) {
                    Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Primitive port " + primPortName + " has no primitive node before it", -1);
                    continue;
                }
                PrimitivePort pp = (PrimitivePort)this.curPrim.findPortProto(primPortName);
                if (pp == null) {
                    pp = this.curTech.convertOldPortName(primPortName, this.curPrim);
                }
                if (pp != null) continue;
                Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Cannot identify primitive port " + primPortName, -1);
                continue;
            }
            if (first == 'W') {
                pieces = this.parseLine(line);
                String arcName = this.unQuote(revision, pieces.get(0));
                if (this.curTech == null) {
                    Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Primitive arc " + arcName + " has no technology before it", -1);
                    continue;
                }
                ArcProto ap = this.curTech.findArcProto(arcName);
                if (ap != null) continue;
                Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Cannot identify primitive arc " + arcName, -1);
                continue;
            }
            if (first == 'G') {
                pieces = this.parseLine(line);
                Cell[] groupLine = new Cell[pieces.size()];
                for (int i = 0; i < pieces.size(); ++i) {
                    Cell cell;
                    String cellName = this.unQuote(revision, pieces.get(i));
                    if (cellName.length() == 0) continue;
                    int colonPos = cellName.indexOf(58);
                    if (colonPos >= 0) {
                        cellName = cellName.substring(colonPos + 1);
                    }
                    if ((cell = this.lib.findNodeProto(cellName)) == null) {
                        Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Cannot find cell " + cellName, -1);
                        break;
                    }
                    groupLine[i] = cell;
                }
                this.groupLines.add(groupLine);
                continue;
            }
            Input.errorLogger.logError(this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", Unrecognized line: " + line, -1);
        }
    }

    void readCell(int revision, String line) throws IOException {
        String nextLine;
        Cell newCell;
        String name;
        int numPieces;
        List<String> pieces = this.parseLine(line);
        int n = revision >= 2 ? 6 : (numPieces = revision == 1 ? 5 : 7);
        if (pieces.size() < numPieces) {
            Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Cell declaration needs " + numPieces + " fields: " + line, -1);
            return;
        }
        int fieldIndex = 0;
        String groupName = null;
        if (revision >= 1) {
            String s;
            name = this.unQuote(revision, pieces.get(fieldIndex++));
            if (revision >= 2 && (s = pieces.get(fieldIndex++)).length() > 0) {
                groupName = this.unQuote(revision, s);
            }
        } else {
            name = this.unQuote(revision, pieces.get(fieldIndex++));
            String viewAbbrev = pieces.get(fieldIndex++);
            String versionString = pieces.get(fieldIndex++);
            name = name + ";" + versionString + "{" + viewAbbrev + "}";
        }
        if ((newCell = Cell.newInstance(this.lib, name)) == null) {
            Input.errorLogger.logError(this.filePath + ", line " + this.lineReader.getLineNumber() + ", Unable to create cell " + name, -1);
            return;
        }
        Technology tech = this.findTechnology(this.unQuote(revision, pieces.get(fieldIndex++)));
        newCell.setTechnology(tech);
        long cDate = Long.parseLong(pieces.get(fieldIndex++));
        long rDate = Long.parseLong(pieces.get(fieldIndex++));
        newCell.lowLevelSetCreationDate(new Date(cDate));
        newCell.lowLevelSetRevisionDate(new Date(rDate));
        String stateInfo = pieces.get(fieldIndex++);
        boolean expanded = false;
        boolean allLocked = false;
        boolean instLocked = false;
        boolean cellLib = false;
        boolean techLib = false;
        for (int i = 0; i < stateInfo.length(); ++i) {
            char chr = stateInfo.charAt(i);
            if (chr == 'E') {
                expanded = true;
                continue;
            }
            if (chr == 'L') {
                allLocked = true;
                continue;
            }
            if (chr == 'I') {
                instLocked = true;
                continue;
            }
            if (chr == 'C') {
                cellLib = true;
                continue;
            }
            if (chr != 'T') continue;
            techLib = true;
        }
        if (expanded) {
            newCell.setWantExpanded();
        } else {
            newCell.clearWantExpanded();
        }
        if (allLocked) {
            newCell.setAllLocked();
        } else {
            newCell.clearAllLocked();
        }
        if (instLocked) {
            newCell.setInstancesLocked();
        } else {
            newCell.clearInstancesLocked();
        }
        if (cellLib) {
            newCell.setInCellLibrary();
        } else {
            newCell.clearInCellLibrary();
        }
        if (techLib) {
            newCell.setInTechnologyLibrary();
        } else {
            newCell.clearInTechnologyLibrary();
        }
        assert (fieldIndex == numPieces);
        Variable[] vars = this.readVariables(revision, newCell, pieces, numPieces, this.filePath, this.lineReader.getLineNumber());
        this.realizeVariables(newCell, vars);
        CellContents cc = new CellContents(revision, this.version);
        cc.fileName = this.filePath;
        cc.lineNumber = this.lineReader.getLineNumber() + 1;
        cc.groupName = groupName;
        while ((nextLine = this.lineReader.readLine()) != null) {
            char nextFirst;
            if (nextLine.length() == 0 || (nextFirst = nextLine.charAt(0)) == '#') continue;
            if (nextFirst == 'X') break;
            cc.cellStrings.add(nextLine);
        }
        this.allCells.put(newCell, cc);
    }

    @Override
    protected void realizeCellsRecursively(Cell cell, HashSet<Cell> recursiveSetupFlag, String scaledCellName, double scale) {
        if (scaledCellName != null) {
            return;
        }
        CellContents cc = this.allCells.get(cell);
        if (cc == null || cc.filledIn) {
            return;
        }
        this.instantiateCellContent(cell, cc, recursiveSetupFlag);
        JELIB.setProgressValue(++cellsConstructed * 100 / totalCells);
        recursiveSetupFlag.add(cell);
        cell.loadExpandStatus();
    }

    private void instantiateCellContent(Cell cell, CellContents cc, HashSet<Cell> recursiveSetupFlag) {
        int line;
        List<String> pieces;
        int numStrings = cc.cellStrings.size();
        HashMap<String, NodeInst> diskName = new HashMap<String, NodeInst>();
        for (int line2 = 0; line2 < numStrings; ++line2) {
            String stateInfo;
            String orientString;
            Cell subCell;
            int lastQuote;
            int numPieces;
            String cellString = cc.cellStrings.get(line2);
            char firstChar = cellString.charAt(0);
            if (firstChar != 'N' && firstChar != 'I') continue;
            pieces = this.parseLine(cellString);
            int n = cc.revision < 1 ? 10 : (numPieces = firstChar == 'N' ? 9 : 8);
            if (pieces.size() < numPieces) {
                String lineNumber = "";
                if (this.lineReader != null) {
                    lineNumber = ", line " + this.lineReader.getLineNumber();
                }
                Input.errorLogger.logError(cc.fileName + lineNumber + ", Node instance needs " + numPieces + " fields: " + cellString, cell, -1);
                continue;
            }
            String protoName = this.unQuote(cc.revision, pieces.get(0));
            String diskNodeName = cc.revision >= 1 ? pieces.get(1) : this.unQuote(cc.revision, pieces.get(1));
            String nodeName = diskNodeName;
            if (nodeName.charAt(0) == '\"' && (lastQuote = nodeName.lastIndexOf(34)) > 1) {
                nodeName = nodeName.substring(1, lastQuote);
                if (cc.revision >= 1) {
                    nodeName = this.unQuote(cc.revision, nodeName);
                }
            }
            String nameTextDescriptorInfo = pieces.get(2);
            double x = TextUtils.atof(pieces.get(3));
            double y = TextUtils.atof(pieces.get(4));
            String prefixName = this.lib.getName();
            Comparable<Cell> np = null;
            Library cellLib = this.lib;
            int colonPos = protoName.indexOf(58);
            if (colonPos < 0) {
                if (firstChar == 'I' || cc.revision < 1) {
                    np = this.lib.findNodeProto(protoName);
                } else if (cell.getTechnology() != null) {
                    np = this.findPrimitiveNode(cell.getTechnology(), protoName);
                }
            } else {
                Technology tech;
                prefixName = protoName.substring(0, colonPos);
                protoName = protoName.substring(colonPos + 1);
                if (firstChar == 'N' && (tech = this.findTechnology(prefixName)) != null) {
                    np = this.findPrimitiveNode(tech, protoName);
                }
                if (firstChar == 'I' || cc.revision < 1 && np == null) {
                    if (prefixName.equalsIgnoreCase(this.curLibName)) {
                        np = this.lib.findNodeProto(protoName);
                    } else {
                        cellLib = Library.findLibrary(prefixName);
                        if (cellLib != null) {
                            np = cellLib.findNodeProto(protoName);
                        }
                    }
                }
            }
            if (np != null && np instanceof Cell && !recursiveSetupFlag.contains(subCell = np)) {
                LibraryFiles reader = this;
                if (subCell.getLibrary() != cell.getLibrary()) {
                    reader = this.getReaderForLib(subCell.getLibrary());
                }
                if (reader != null) {
                    ((LibraryFiles)reader).realizeCellsRecursively(subCell, recursiveSetupFlag, null, 0.0);
                }
            }
            EPoint size = EPoint.ORIGIN;
            boolean flipX = false;
            boolean flipY = false;
            String textDescriptorInfo = "";
            if (firstChar == 'N' || cc.revision < 1) {
                double wid = TextUtils.atof(pieces.get(5));
                if (cc.revision < 1 && (wid < 0.0 || wid == 0.0 && 1.0 / wid < 0.0)) {
                    flipX = true;
                    wid = -wid;
                }
                double hei = TextUtils.atof(pieces.get(6));
                if (cc.revision < 1 && (hei < 0.0 || hei == 0.0 && 1.0 / hei < 0.0)) {
                    flipY = true;
                    hei = -hei;
                }
                if (np instanceof PrimitiveNode) {
                    PrimitiveNode pn = (PrimitiveNode)np;
                    size = cc.getSizeCorrector(pn.getTechnology()).getSizeFromDisk(pn, wid, hei);
                }
                orientString = pieces.get(7);
                stateInfo = pieces.get(8);
                if (cc.revision < 1) {
                    textDescriptorInfo = pieces.get(9);
                }
            } else {
                orientString = pieces.get(5);
                stateInfo = pieces.get(6);
                textDescriptorInfo = pieces.get(7);
            }
            int angle = 0;
            for (int i = 0; i < orientString.length(); ++i) {
                char ch = orientString.charAt(i);
                if (ch == 'X') {
                    flipX = !flipX;
                    continue;
                }
                if (ch == 'Y') {
                    flipY = !flipY;
                    continue;
                }
                if (ch == 'R') {
                    angle += 900;
                    continue;
                }
                angle += TextUtils.atoi(orientString.substring(i));
                break;
            }
            if (np == null) {
                Cell dummyCell;
                if (cellLib == null) {
                    Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line2) + ", Creating dummy library " + prefixName, cell, -1);
                    cellLib = Library.newInstance(prefixName, null);
                }
                if ((dummyCell = Cell.makeInstance(cellLib, protoName)) == null) {
                    Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line2) + ", Unable to create dummy cell " + protoName + " in " + cellLib, cell, -1);
                    continue;
                }
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line2) + ", Creating dummy cell " + protoName + " in " + cellLib, cell, -1);
                Rectangle2D bounds = this.externalCells.get(pieces.get(0));
                if (bounds == null) {
                    Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line2) + ", Warning: cannot find information about external cell " + pieces.get(0), cell, -1);
                    NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(0.0, 0.0), 0.0, 0.0, dummyCell);
                } else {
                    NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), dummyCell);
                }
                dummyCell.newVar(IO_TRUE_LIBRARY, (Object)prefixName);
                dummyCell.newVar(IO_DUMMY_OBJECT, (Object)protoName);
                np = dummyCell;
            }
            TextDescriptor nameTextDescriptor = this.loadTextDescriptor(nameTextDescriptorInfo, false, cc.fileName, cc.lineNumber + line2);
            int flags = 0;
            int techBits = 0;
            block34: for (int i = 0; i < stateInfo.length(); ++i) {
                char chr = stateInfo.charAt(i);
                switch (chr) {
                    case 'E': {
                        continue block34;
                    }
                    case 'L': {
                        flags = ImmutableNodeInst.LOCKED.set(flags, true);
                        continue block34;
                    }
                    case 'S': {
                        continue block34;
                    }
                    case 'V': {
                        flags = ImmutableNodeInst.VIS_INSIDE.set(flags, true);
                        continue block34;
                    }
                    case 'W': {
                        continue block34;
                    }
                    case 'A': {
                        flags = ImmutableNodeInst.HARD_SELECT.set(flags, true);
                        continue block34;
                    }
                    default: {
                        if (!Character.isDigit(chr)) continue block34;
                        stateInfo = stateInfo.substring(i);
                        try {
                            techBits = Integer.parseInt(stateInfo);
                        }
                        catch (NumberFormatException e) {
                            Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line2) + " (" + cell + ") bad node bits" + stateInfo, cell, -1);
                        }
                        break block34;
                    }
                }
            }
            TextDescriptor protoTextDescriptor = this.loadTextDescriptor(textDescriptorInfo, false, cc.fileName, cc.lineNumber + line2);
            Orientation orient = Orientation.fromJava(angle, flipX, flipY);
            NodeInst ni = NodeInst.newInstance(cell, np, nodeName, nameTextDescriptor, EPoint.fromLambda(x, y), size, orient, flags, techBits, protoTextDescriptor, Input.errorLogger);
            if (ni == null) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line2) + " (" + cell + ") cannot create node " + protoName, cell, -1);
                continue;
            }
            diskName.put(diskNodeName, ni);
            Variable[] vars = this.readVariables(cc.revision, ni, pieces, numPieces, cc.fileName, cc.lineNumber + line2);
            this.realizeVariables(ni, vars);
        }
        CellId cellId = cell.getId();
        for (line = 0; line < numStrings; ++line) {
            Export pp;
            PortCharacteristic ch;
            String s;
            int numPieces;
            String cellString = cc.cellStrings.get(line);
            if (cellString.charAt(0) != 'E') continue;
            pieces = this.parseLine(cellString);
            if (cc.revision >= 2 && pieces.size() == 1) {
                String exportName = this.unQuote(cc.revision, pieces.get(0));
                cellId.newExportId(exportName);
                continue;
            }
            int n = cc.revision >= 2 ? 6 : (numPieces = cc.revision == 1 ? 5 : 7);
            if (pieces.size() < numPieces) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + ", Export needs " + numPieces + " fields, has " + pieces.size() + ": " + cellString, cell, -1);
                continue;
            }
            int fieldIndex = 0;
            String exportName = this.unQuote(cc.revision, pieces.get(fieldIndex++));
            String exportUserName = null;
            if (cc.revision >= 2 && (s = pieces.get(fieldIndex++)).length() != 0) {
                exportUserName = this.unQuote(cc.revision, s);
            }
            if (exportUserName == null || exportName.equals(exportUserName)) {
                exportName = Name.findName(exportName).toString();
            }
            ExportId exportId = cellId.newExportId(exportName);
            String textDescriptorInfo = pieces.get(fieldIndex++);
            String nodeName = cc.revision >= 1 ? pieces.get(fieldIndex++) : this.unQuote(cc.revision, pieces.get(fieldIndex++));
            String portName = this.unQuote(cc.revision, pieces.get(fieldIndex++));
            Point2D.Double pos = null;
            if (cc.revision < 1) {
                double x = TextUtils.atof(pieces.get(fieldIndex++));
                double y = TextUtils.atof(pieces.get(fieldIndex++));
                pos = new Point2D.Double(x, y);
            }
            String userBits = pieces.get(fieldIndex++);
            assert (fieldIndex == numPieces);
            PortInst pi = this.figureOutPortInst(cell, portName, nodeName, pos, diskName, cc.fileName, cc.lineNumber + line);
            if (pi == null) continue;
            TextDescriptor nameTextDescriptor = this.loadTextDescriptor(textDescriptorInfo, false, cc.fileName, cc.lineNumber + line);
            boolean alwaysDrawn = false;
            boolean bodyOnly = false;
            int slashPos = userBits.indexOf(47);
            if (slashPos >= 0) {
                String extras = userBits.substring(slashPos);
                userBits = userBits.substring(0, slashPos);
                while (extras.length() > 0) {
                    switch (extras.charAt(1)) {
                        case 'A': {
                            alwaysDrawn = true;
                            break;
                        }
                        case 'B': {
                            bodyOnly = true;
                        }
                    }
                    extras = extras.substring(2);
                }
            }
            if ((ch = PortCharacteristic.findCharacteristicShort(userBits)) == null) {
                ch = PortCharacteristic.UNKNOWN;
            }
            if ((pp = Export.newInstance(cell, exportId, exportUserName, nameTextDescriptor, pi, alwaysDrawn, bodyOnly, ch, errorLogger)) == null) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + " (" + cell + ") cannot create export " + exportName, pi.getNodeInst(), cell, null, -1);
                continue;
            }
            Variable[] vars = this.readVariables(cc.revision, pp, pieces, numPieces, cc.fileName, cc.lineNumber + line);
            this.realizeVariables(pp, vars);
        }
        for (line = 0; line < numStrings; ++line) {
            double tailY;
            double tailX;
            double headY;
            double headX;
            int lastQuote;
            String cellString = cc.cellStrings.get(line);
            if (cellString.charAt(0) != 'A') continue;
            pieces = this.parseLine(cellString);
            if (pieces.size() < 13) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + ", Arc instance needs 13 fields: " + cellString, cell, -1);
                continue;
            }
            String protoName = this.unQuote(cc.revision, pieces.get(0));
            ArcProto ap = null;
            int indexOfColon = protoName.indexOf(58);
            Technology tech = cell.getTechnology();
            if (indexOfColon >= 0) {
                tech = this.findTechnology(protoName.substring(0, indexOfColon));
                protoName = protoName.substring(indexOfColon + 1);
            }
            if (tech != null) {
                ap = tech.findArcProto(protoName);
            }
            if (ap == null) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + " (" + cell + ") cannot find arc " + protoName, cell, -1);
                continue;
            }
            String diskArcName = cc.revision >= 1 ? pieces.get(1) : this.unQuote(cc.revision, pieces.get(1));
            String arcName = diskArcName;
            if (arcName.charAt(0) == '\"' && (lastQuote = arcName.lastIndexOf(34)) > 1) {
                arcName = arcName.substring(1, lastQuote);
                if (cc.revision >= 1) {
                    arcName = this.unQuote(cc.revision, arcName);
                }
            }
            long gridExtendOverMin = cc.getSizeCorrector(ap.getTechnology()).getExtendFromDisk(ap, TextUtils.atof(pieces.get(3)));
            String headNodeName = cc.revision >= 1 ? pieces.get(5) : this.unQuote(cc.revision, pieces.get(5));
            String headPortName = this.unQuote(cc.revision, pieces.get(6));
            PortInst headPI = this.figureOutPortInst(cell, headPortName, headNodeName, new Point2D.Double(headX = TextUtils.atof(pieces.get(7)), headY = TextUtils.atof(pieces.get(8))), diskName, cc.fileName, cc.lineNumber + line);
            if (headPI == null) continue;
            String tailNodeName = cc.revision >= 1 ? pieces.get(9) : this.unQuote(cc.revision, pieces.get(9));
            String tailPortName = this.unQuote(cc.revision, pieces.get(10));
            PortInst tailPI = this.figureOutPortInst(cell, tailPortName, tailNodeName, new Point2D.Double(tailX = TextUtils.atof(pieces.get(11)), tailY = TextUtils.atof(pieces.get(12))), diskName, cc.fileName, cc.lineNumber + line);
            if (tailPI == null) continue;
            String stateInfo = pieces.get(4);
            boolean extended = true;
            boolean directional = false;
            boolean reverseEnds = false;
            boolean skipHead = false;
            boolean skipTail = false;
            boolean tailNotExtended = false;
            boolean headNotExtended = false;
            boolean tailArrowed = false;
            boolean headArrowed = false;
            boolean bodyArrowed = false;
            int flags = defaultArcFlags;
            int angle = 0;
            block38: for (int i = 0; i < stateInfo.length(); ++i) {
                char chr = stateInfo.charAt(i);
                switch (chr) {
                    case 'R': {
                        flags = ImmutableArcInst.RIGID.set(flags, true);
                        continue block38;
                    }
                    case 'F': {
                        flags = ImmutableArcInst.FIXED_ANGLE.set(flags, false);
                        continue block38;
                    }
                    case 'S': {
                        flags = ImmutableArcInst.SLIDABLE.set(flags, true);
                        continue block38;
                    }
                    case 'A': {
                        flags = ImmutableArcInst.HARD_SELECT.set(flags, true);
                        continue block38;
                    }
                    case 'N': {
                        flags = ImmutableArcInst.TAIL_NEGATED.set(flags, true);
                        continue block38;
                    }
                    case 'G': {
                        flags = ImmutableArcInst.HEAD_NEGATED.set(flags, true);
                        continue block38;
                    }
                    case 'X': {
                        headArrowed = true;
                        continue block38;
                    }
                    case 'Y': {
                        tailArrowed = true;
                        continue block38;
                    }
                    case 'B': {
                        bodyArrowed = true;
                        continue block38;
                    }
                    case 'I': {
                        headNotExtended = true;
                        continue block38;
                    }
                    case 'J': {
                        tailNotExtended = true;
                        continue block38;
                    }
                    case 'E': {
                        extended = false;
                        continue block38;
                    }
                    case 'D': {
                        directional = true;
                        continue block38;
                    }
                    case 'V': {
                        reverseEnds = true;
                        continue block38;
                    }
                    case 'H': {
                        skipHead = true;
                        continue block38;
                    }
                    case 'T': {
                        skipTail = true;
                        continue block38;
                    }
                    default: {
                        if (!TextUtils.isDigit(chr)) continue block38;
                        angle = TextUtils.atoi(stateInfo.substring(i));
                        break block38;
                    }
                }
            }
            if (!extended || directional) {
                if (!extended) {
                    tailNotExtended = true;
                    headNotExtended = true;
                }
                if (directional) {
                    if (reverseEnds) {
                        tailArrowed = true;
                    } else {
                        headArrowed = true;
                    }
                    bodyArrowed = true;
                }
                if (skipHead) {
                    headNotExtended = false;
                    headArrowed = false;
                }
                if (skipTail) {
                    tailNotExtended = false;
                    tailArrowed = false;
                }
            }
            flags = ImmutableArcInst.HEAD_EXTENDED.set(flags, !headNotExtended);
            flags = ImmutableArcInst.TAIL_EXTENDED.set(flags, !tailNotExtended);
            flags = ImmutableArcInst.HEAD_ARROWED.set(flags, headArrowed);
            flags = ImmutableArcInst.TAIL_ARROWED.set(flags, tailArrowed);
            flags = ImmutableArcInst.BODY_ARROWED.set(flags, bodyArrowed);
            String nameTextDescriptorInfo = pieces.get(2);
            TextDescriptor nameTextDescriptor = this.loadTextDescriptor(nameTextDescriptorInfo, false, cc.fileName, cc.lineNumber + line);
            ArcInst ai = ArcInst.newInstance(cell, ap, arcName, nameTextDescriptor, headPI, tailPI, new EPoint(headX, headY), new EPoint(tailX, tailY), gridExtendOverMin, angle, flags);
            if (ai == null) {
                ArrayList<Geometric> geomList = new ArrayList<Geometric>();
                geomList.add(headPI.getNodeInst());
                geomList.add(tailPI.getNodeInst());
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + " (" + cell + ") cannot create arc " + protoName, geomList, null, cell, 2);
                continue;
            }
            Variable[] vars = this.readVariables(cc.revision, ai, pieces, 13, cc.fileName, cc.lineNumber + line);
            this.realizeVariables(ai, vars);
        }
        cc.filledIn = true;
        cc.cellStrings = null;
    }

    private PortInst figureOutPortInst(Cell cell, String portName, String nodeName, Point2D pos, HashMap<String, NodeInst> diskName, String fileName, int lineNumber) {
        NodeInst ni = diskName.get(nodeName);
        if (ni == null) {
            Input.errorLogger.logError(fileName + ", line " + lineNumber + " (" + cell + ") cannot find node " + nodeName, cell, -1);
            return null;
        }
        PortInst pi = null;
        if (portName.length() == 0) {
            if (ni.getNumPortInsts() > 0) {
                pi = ni.getPortInst(0);
            }
        } else {
            PortProto pp = JELIB.findPortProto(ni.getProto(), portName);
            if (pp != null) {
                pi = ni.findPortInstFromProto(pp);
            }
        }
        if (pi != null) {
            return pi;
        }
        Variable var = null;
        Cell subCell = null;
        if (ni.isCellInstance()) {
            subCell = (Cell)ni.getProto();
            var = subCell.getVar(IO_TRUE_LIBRARY);
            if (pos == null) {
                pos = this.externalExports.get(subCell.getCellName().toString() + ":" + portName);
            }
        }
        if (pos == null) {
            pos = ni.getAnchorCenter().lambdaMutable();
        }
        if (var == null) {
            NodeInst portNI = NodeInst.newInstance(Generic.tech.universalPinNode, pos, 0.0, 0.0, cell);
            if (portNI == null) {
                Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unable to create dummy node in " + cell + " (cannot create source node)", cell, -1);
                return null;
            }
            Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Port " + portName + " on " + ni.getProto() + " renamed or deleted, still used on node " + nodeName + " in " + cell, portNI, cell, null, -1);
            return portNI.getOnlyPortInst();
        }
        String name = portName;
        if (name.length() == 0) {
            name = "X";
        }
        ni.transformIn().transform(pos, pos);
        NodeInst portNI = NodeInst.newInstance(Generic.tech.universalPinNode, pos, 0.0, 0.0, subCell);
        if (portNI == null) {
            Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unable to create export " + name + " on dummy " + subCell + " (cannot create source node)", cell, -1);
            return null;
        }
        PortInst portPI = portNI.getOnlyPortInst();
        Export pp = Export.newInstance(subCell, portPI, name, false);
        if (pp == null) {
            Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unable to create export " + name + " on dummy " + subCell, cell, -1);
            return null;
        }
        pi = ni.findPortInstFromProto(pp);
        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Creating export " + name + " on dummy " + subCell, cell, -1);
        return pi;
    }

    private List<String> parseLine(String line) {
        ArrayList<String> stringPieces = new ArrayList<String>();
        int len = line.length();
        int pos = 1;
        int startPos = 1;
        boolean inQuote = false;
        while (pos < len) {
            char chr;
            if ((chr = line.charAt(pos++)) == this.escapeChar) {
                ++pos;
                continue;
            }
            if (chr == '\"') {
                boolean bl = inQuote = !inQuote;
            }
            if (chr != '|' || inQuote) continue;
            stringPieces.add(line.substring(startPos, pos - 1));
            startPos = pos;
        }
        if (pos > len) {
            pos = len;
        }
        stringPieces.add(line.substring(startPos, pos));
        return stringPieces;
    }

    private String unQuote(int revision, String line) {
        int len = line.length();
        if (revision >= 1) {
            if (len < 2 || line.charAt(0) != '\"') {
                return line;
            }
            int lastQuote = line.lastIndexOf(34);
            if (lastQuote != len - 1) {
                return this.unQuote(revision, line.substring(0, lastQuote + 1)) + line.substring(lastQuote + 1);
            }
            line = line.substring(1, len - 1);
            len -= 2;
        } else if (line.indexOf(this.escapeChar) < 0) {
            return line;
        }
        StringBuffer sb = new StringBuffer();
        assert (len == line.length());
        for (int i = 0; i < len; ++i) {
            char chr = line.charAt(i);
            if (chr == this.escapeChar) {
                if (++i >= len) break;
                chr = line.charAt(i);
                if (chr == 'n' && revision >= 1) {
                    chr = '\n';
                }
                if (chr == 'r' && revision >= 1) {
                    chr = '\r';
                }
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    private Variable[] readVariables(int revision, ElectricObject parentObj, List<String> pieces, int position, String fileName, int lineNumber) {
        this.variablesBuf.clear();
        int total = pieces.size();
        block21: for (int i = position; i < total; ++i) {
            int openPos;
            String piece = pieces.get(i);
            boolean inQuote = false;
            for (openPos = 0; openPos < piece.length(); ++openPos) {
                char chr = piece.charAt(openPos);
                if (chr == this.escapeChar) {
                    ++openPos;
                    continue;
                }
                if (chr == '\"') {
                    boolean bl = inQuote = !inQuote;
                }
                if (chr == '(' && !inQuote) break;
            }
            if (openPos >= piece.length()) {
                Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed variable (no open parenthesis): " + piece, -1);
                continue;
            }
            String varName = this.unQuote(revision, piece.substring(0, openPos));
            Variable.Key varKey = Variable.newKey(varName, parentObj);
            int closePos = piece.indexOf(41, openPos);
            if (closePos < 0) {
                Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed variable (no close parenthesis): " + piece, -1);
                continue;
            }
            String varBits = piece.substring(openPos + 1, closePos);
            int objectPos = closePos + 1;
            if (objectPos >= piece.length()) {
                Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Variable type missing: " + piece, -1);
                continue;
            }
            char varType = piece.charAt(objectPos++);
            switch (varType) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'L': 
                case 'O': 
                case 'P': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'Y': {
                    break;
                }
                default: {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Variable type invalid: " + piece, -1);
                    continue block21;
                }
            }
            Object[] obj = null;
            if (objectPos >= piece.length()) continue;
            if (piece.charAt(objectPos) == '[') {
                ArrayList<Object> objList = new ArrayList<Object>();
                ++objectPos;
                while (objectPos < piece.length()) {
                    int start = objectPos;
                    inQuote = false;
                    while (objectPos < piece.length()) {
                        if (inQuote) {
                            if (piece.charAt(objectPos) == this.escapeChar) {
                                ++objectPos;
                            } else if (piece.charAt(objectPos) == '\"') {
                                inQuote = false;
                            }
                            ++objectPos;
                            continue;
                        }
                        if (piece.charAt(objectPos) == ',' || piece.charAt(objectPos) == ']') break;
                        if (piece.charAt(objectPos) == '\"') {
                            inQuote = true;
                        }
                        ++objectPos;
                    }
                    Object oneObj = this.getVariableValue(revision, piece.substring(start, objectPos), varType, fileName, lineNumber);
                    objList.add(oneObj);
                    if (piece.charAt(objectPos) == ']') break;
                    ++objectPos;
                }
                if (objectPos >= piece.length()) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed array (no closed bracket): " + piece, -1);
                    continue;
                }
                if (objectPos < piece.length() - 1) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed array (extra characters after closed bracket): " + piece, -1);
                    continue;
                }
                int limit = objList.size();
                Object[] objArray = null;
                switch (varType) {
                    case 'B': {
                        objArray = new Boolean[limit];
                        break;
                    }
                    case 'C': {
                        objArray = new CellId[limit];
                        break;
                    }
                    case 'D': {
                        objArray = new Double[limit];
                        break;
                    }
                    case 'E': {
                        objArray = new ExportId[limit];
                        break;
                    }
                    case 'F': {
                        objArray = new Float[limit];
                        break;
                    }
                    case 'G': {
                        objArray = new Long[limit];
                        break;
                    }
                    case 'H': {
                        objArray = new Short[limit];
                        break;
                    }
                    case 'I': {
                        objArray = new Integer[limit];
                        break;
                    }
                    case 'L': {
                        objArray = new LibId[limit];
                        break;
                    }
                    case 'O': {
                        objArray = new Tool[limit];
                        break;
                    }
                    case 'P': {
                        objArray = new PrimitiveNode[limit];
                        break;
                    }
                    case 'R': {
                        objArray = new ArcProto[limit];
                        break;
                    }
                    case 'S': {
                        objArray = new String[limit];
                        break;
                    }
                    case 'T': {
                        objArray = new TechId[limit];
                        break;
                    }
                    case 'V': {
                        objArray = new EPoint[limit];
                        break;
                    }
                    case 'Y': {
                        objArray = new Byte[limit];
                    }
                }
                if (objArray == null && limit > 0) {
                    System.out.println("HHEY, vartype=" + varType + " on line " + lineNumber);
                }
                for (int j = 0; j < limit; ++j) {
                    objArray[j] = objList.get(j);
                }
                obj = objArray;
            } else {
                obj = this.getVariableValue(revision, piece.substring(objectPos), varType, fileName, lineNumber);
                if (obj == null) continue;
            }
            TextDescriptor td = this.loadTextDescriptor(varBits, true, fileName, lineNumber);
            Variable d = Variable.newInstance(varKey, obj, td);
            this.variablesBuf.add(d);
        }
        return this.variablesBuf.toArray(Variable.NULL_ARRAY);
    }

    private TextDescriptor loadTextDescriptor(String varBits, boolean onVar, String fileName, int lineNumber) {
        HashMap<String, TextDescriptor> parsedDescriptors = onVar ? this.parsedDescriptorsT : this.parsedDescriptorsF;
        TextDescriptor td = parsedDescriptors.get(varBits);
        if (td != null) {
            return td;
        }
        boolean error = false;
        this.mtd.setCBits(0, 0, 0);
        if (!onVar) {
            this.mtd.setDisplay(AbstractTextDescriptor.Display.SHOWN);
        }
        double xoff = 0.0;
        double yoff = 0.0;
        block31: for (int j = 0; j < varBits.length(); ++j) {
            char varBit = varBits.charAt(j);
            switch (varBit) {
                case 'D': 
                case 'd': {
                    this.mtd.setDisplay(varBit == 'D' ? AbstractTextDescriptor.Display.SHOWN : AbstractTextDescriptor.Display.HIDDEN);
                    if (++j >= varBits.length()) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Incorrect display specification: " + varBits, -1);
                        error = true;
                        continue block31;
                    }
                    switch (varBits.charAt(j)) {
                        case '5': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.CENT);
                            break;
                        }
                        case '8': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.UP);
                            break;
                        }
                        case '2': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.DOWN);
                            break;
                        }
                        case '4': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.LEFT);
                            break;
                        }
                        case '6': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.RIGHT);
                            break;
                        }
                        case '7': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.UPLEFT);
                            break;
                        }
                        case '9': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.UPRIGHT);
                            break;
                        }
                        case '1': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.DOWNLEFT);
                            break;
                        }
                        case '3': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.DOWNRIGHT);
                            break;
                        }
                        case '0': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.BOXED);
                        }
                    }
                    continue block31;
                }
                case 'N': {
                    this.mtd.setDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                    continue block31;
                }
                case 'A': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad absolute size (semicolon missing): " + varBits, -1);
                        error = true;
                        continue block31;
                    }
                    this.mtd.setAbsSize(TextUtils.atoi(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block31;
                }
                case 'G': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad relative size (semicolon missing): " + varBits, -1);
                        error = true;
                        continue block31;
                    }
                    this.mtd.setRelSize(TextUtils.atof(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block31;
                }
                case 'X': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad X offset (semicolon missing): " + varBits, -1);
                        error = true;
                        continue block31;
                    }
                    xoff = TextUtils.atof(varBits.substring(j + 1, semiPos));
                    j = semiPos;
                    continue block31;
                }
                case 'Y': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad Y offset (semicolon missing): " + varBits, -1);
                        error = true;
                        continue block31;
                    }
                    yoff = TextUtils.atof(varBits.substring(j + 1, semiPos));
                    j = semiPos;
                    continue block31;
                }
                case 'B': {
                    this.mtd.setBold(true);
                    continue block31;
                }
                case 'I': {
                    this.mtd.setItalic(true);
                    continue block31;
                }
                case 'L': {
                    this.mtd.setUnderline(true);
                    continue block31;
                }
                case 'F': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad font (semicolon missing): " + varBits, -1);
                        error = true;
                        continue block31;
                    }
                    AbstractTextDescriptor.ActiveFont af = AbstractTextDescriptor.ActiveFont.findActiveFont(varBits.substring(j + 1, semiPos));
                    if (af != null) {
                        this.mtd.setFace(af.getIndex());
                    }
                    j = semiPos;
                    continue block31;
                }
                case 'C': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad color (semicolon missing): " + varBits, -1);
                        error = true;
                        continue block31;
                    }
                    this.mtd.setColorIndex(TextUtils.atoi(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block31;
                }
                case 'R': {
                    AbstractTextDescriptor.Rotation rot = AbstractTextDescriptor.Rotation.ROT90;
                    if (j + 1 < varBits.length() && varBits.charAt(j + 1) == 'R') {
                        rot = AbstractTextDescriptor.Rotation.ROT180;
                        ++j;
                    }
                    if (j + 1 < varBits.length() && varBits.charAt(j + 1) == 'R') {
                        rot = AbstractTextDescriptor.Rotation.ROT270;
                        ++j;
                    }
                    this.mtd.setRotation(rot);
                    continue block31;
                }
                case 'H': {
                    this.mtd.setInherit(true);
                    continue block31;
                }
                case 'T': {
                    this.mtd.setInterior(true);
                    continue block31;
                }
                case 'P': {
                    this.mtd.setParam(true);
                    continue block31;
                }
                case 'O': {
                    if (++j >= varBits.length()) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad language specification: " + varBits, -1);
                        error = true;
                        continue block31;
                    }
                    char codeLetter = varBits.charAt(j);
                    if (!onVar) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Illegal use of language specification: " + varBits, -1);
                        error = true;
                        continue block31;
                    }
                    if (codeLetter == 'J') {
                        this.mtd.setCode(AbstractTextDescriptor.Code.JAVA);
                        continue block31;
                    }
                    if (codeLetter == 'L') {
                        this.mtd.setCode(AbstractTextDescriptor.Code.SPICE);
                        continue block31;
                    }
                    if (codeLetter == 'T') {
                        this.mtd.setCode(AbstractTextDescriptor.Code.TCL);
                        continue block31;
                    }
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown language specification: " + varBits, -1);
                    error = true;
                    continue block31;
                }
                case 'U': {
                    if (++j >= varBits.length()) {
                        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Bad units specification: " + varBits, -1);
                        error = true;
                        continue block31;
                    }
                    char unitsLetter = varBits.charAt(j);
                    if (unitsLetter == 'R') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.RESISTANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'C') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.CAPACITANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'I') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.INDUCTANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'A') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.CURRENT);
                        continue block31;
                    }
                    if (unitsLetter == 'V') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.VOLTAGE);
                        continue block31;
                    }
                    if (unitsLetter == 'D') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.DISTANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'T') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.TIME);
                        continue block31;
                    }
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown units specification: " + varBits, -1);
                    error = true;
                }
            }
        }
        this.mtd.setOff(xoff, yoff);
        td = TextDescriptor.newTextDescriptor(this.mtd);
        if (!error) {
            parsedDescriptors.put(varBits, td);
        }
        return td;
    }

    private Object getVariableValue(int revision, String piece, char varType, String fileName, int lineNumber) {
        if (revision >= 1) {
            piece = this.unQuote(revision, piece);
        }
        switch (varType) {
            case 'B': {
                return new Boolean(piece.charAt(0) == 'T');
            }
            case 'C': {
                if (piece.length() == 0) {
                    return null;
                }
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed Cell (missing colon): " + piece, -1);
                    break;
                }
                String libName = piece.substring(0, colonPos);
                LibId libId = this.idManager.newLibId(libName);
                String cellName = piece.substring(colonPos + 1);
                int commaPos = cellName.indexOf(44);
                if (commaPos >= 0) {
                    cellName = cellName.substring(0, commaPos);
                }
                return libId.newCellId(CellName.parseName(cellName));
            }
            case 'D': {
                return new Double(TextUtils.atof(piece));
            }
            case 'E': {
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed Export (missing library colon): " + piece, -1);
                    break;
                }
                String libName = piece.substring(0, colonPos);
                LibId libId = this.idManager.newLibId(libName);
                int secondColonPos = piece.indexOf(58, colonPos + 1);
                if (secondColonPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed Export (missing cell colon): " + piece, -1);
                    break;
                }
                String cellName = piece.substring(colonPos + 1, secondColonPos);
                CellId cellId = libId.newCellId(CellName.parseName(cellName));
                String exportName = piece.substring(secondColonPos + 1);
                int commaPos = exportName.indexOf(44);
                if (commaPos >= 0) {
                    exportName = exportName.substring(0, commaPos);
                }
                return cellId.newExportId(exportName);
            }
            case 'F': {
                return new Float((float)TextUtils.atof(piece));
            }
            case 'G': {
                return Long.valueOf(piece);
            }
            case 'H': {
                return new Short((short)TextUtils.atoi(piece));
            }
            case 'I': {
                return new Integer(TextUtils.atoi(piece));
            }
            case 'L': {
                String libName = piece;
                int commaPos = libName.indexOf(44);
                if (commaPos >= 0) {
                    libName = libName.substring(0, commaPos);
                }
                return this.idManager.newLibId(libName);
            }
            case 'O': {
                Tool tool;
                String toolName = piece;
                int commaPos = toolName.indexOf(44);
                if (commaPos >= 0) {
                    toolName = toolName.substring(0, commaPos);
                }
                if ((tool = Tool.findTool(toolName)) == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown Tool: " + piece, -1);
                }
                return tool;
            }
            case 'P': {
                PrimitiveNode np;
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed PrimitiveNode (missing colon): " + piece, -1);
                    break;
                }
                String techName = piece.substring(0, colonPos);
                Technology tech = this.findTechnology(techName);
                if (tech == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown technology: " + techName, -1);
                    break;
                }
                String nodeName = piece.substring(colonPos + 1);
                int commaPos = nodeName.indexOf(44);
                if (commaPos >= 0) {
                    nodeName = nodeName.substring(0, commaPos);
                }
                if ((np = this.findPrimitiveNode(tech, nodeName)) == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown PrimitiveNode: " + piece, -1);
                }
                return np;
            }
            case 'R': {
                ArcProto ap;
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed ArcProto (missing colon): " + piece, -1);
                    break;
                }
                String techName = piece.substring(0, colonPos);
                Technology tech = this.findTechnology(techName);
                if (tech == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown technology: " + techName, -1);
                    break;
                }
                String arcName = piece.substring(colonPos + 1);
                int commaPos = arcName.indexOf(44);
                if (commaPos >= 0) {
                    arcName = arcName.substring(0, commaPos);
                }
                if ((ap = tech.findArcProto(arcName)) == null) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unknown ArcProto: " + piece, -1);
                }
                return ap;
            }
            case 'S': {
                if (revision >= 1) {
                    return piece;
                }
                if (piece.charAt(0) != '\"') {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed string variable (missing open quote): " + piece, -1);
                    break;
                }
                StringBuffer sb = new StringBuffer();
                int len = piece.length();
                int objectPos = 0;
                while (objectPos < len && piece.charAt(++objectPos) != '\"') {
                    if (piece.charAt(objectPos) == '^' && ++objectPos <= len - 2 && piece.charAt(objectPos) == '\\' && piece.charAt(objectPos + 1) == 'n') {
                        sb.append('\n');
                        ++objectPos;
                        continue;
                    }
                    sb.append(piece.charAt(objectPos));
                }
                return sb.toString();
            }
            case 'T': {
                String techName = piece;
                int commaPos = techName.indexOf(44);
                if (commaPos >= 0) {
                    techName = techName.substring(0, commaPos);
                }
                return this.idManager.newTechId(techName);
            }
            case 'V': {
                double x = TextUtils.atof(piece);
                int slashPos = piece.indexOf(47);
                if (slashPos < 0) {
                    Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Badly formed Point2D variable (missing slash): " + piece, -1);
                    break;
                }
                double y = TextUtils.atof(piece.substring(slashPos + 1));
                return new EPoint(x, y);
            }
            case 'Y': {
                return new Byte((byte)TextUtils.atoi(piece));
            }
        }
        return null;
    }

    Technology findTechnology(String techName) {
        Technology tech = Technology.findTechnology(techName);
        if (tech == null && techName.equals("tsmc90")) {
            tech = Technology.findTechnology("cmos90");
        }
        return tech;
    }

    PrimitiveNode findPrimitiveNode(Technology tech, String name) {
        PrimitiveNode pn = tech.findNodeProto(name);
        if (pn != null) {
            return pn;
        }
        return tech.convertOldNodeName(name);
    }

    protected FileType getPreferredFileType() {
        return FileType.JELIB;
    }

    static {
        defaultArcFlags = ImmutableArcInst.HARD_SELECT.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.BODY_ARROWED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.FIXED_ANGLE.set(defaultArcFlags, true);
        defaultArcFlags = ImmutableArcInst.HEAD_NEGATED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.HEAD_EXTENDED.set(defaultArcFlags, true);
        defaultArcFlags = ImmutableArcInst.TAIL_EXTENDED.set(defaultArcFlags, true);
        defaultArcFlags = ImmutableArcInst.TAIL_NEGATED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.RIGID.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.SLIDABLE.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.HEAD_ARROWED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.TAIL_ARROWED.set(defaultArcFlags, false);
    }

    private class CellContents {
        final int revision;
        private final Version version;
        boolean filledIn;
        int lineNumber;
        String groupName;
        List<String> cellStrings = new ArrayList<String>();
        String fileName;
        private HashMap<Technology, Technology.SizeCorrector> sizeCorrectors = new HashMap();

        CellContents(int revision, Version version) {
            this.revision = revision;
            this.version = version;
            this.filledIn = false;
        }

        Technology.SizeCorrector getSizeCorrector(Technology tech) {
            Technology.SizeCorrector corrector = this.sizeCorrectors.get(tech);
            if (corrector == null) {
                corrector = tech.getSizeCorrector(this.version, JELIB.this.projectSettings, true, false);
                this.sizeCorrectors.put(tech, corrector);
            }
            return corrector;
        }
    }
}

