/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StratHashWires
extends Strategy {
    private int numWiresProcessed;
    private int numEquivProcessed;

    private StratHashWires(NccGlobals globals) {
        super(globals);
    }

    private void preamble() {
        this.startTime("StratHashWires", " Wires");
    }

    private void summary(LeafList offspring) {
        this.globals.status2(" processed " + this.numWiresProcessed + " Wires from " + this.numEquivProcessed + " leaf records");
        this.globals.status2(this.offspringStats(offspring));
        this.globals.status2(offspring.sizeInfoString());
        this.elapsedTime();
    }

    @Override
    public LeafList doFor(EquivRecord g) {
        LeafList out;
        if (g.isLeaf()) {
            ++this.numEquivProcessed;
            out = super.doFor(g);
        } else {
            out = super.doFor(g);
        }
        return out;
    }

    @Override
    public Integer doFor(NetObject n) {
        this.error(!(n instanceof Wire), "StratHashWires expects wires only");
        ++this.numWiresProcessed;
        Wire w = (Wire)n;
        return w.computeHashCode();
    }

    public static LeafList doYourJob(Iterator<EquivRecord> it, NccGlobals globals) {
        if (!it.hasNext()) {
            return new LeafList();
        }
        StratHashWires hwa = new StratHashWires(globals);
        hwa.preamble();
        LeafList el = hwa.doFor(it);
        hwa.summary(el);
        return el;
    }

    public static LeafList doYourJob(EquivRecord er, NccGlobals globals) {
        StratHashWires hwa = new StratHashWires(globals);
        return hwa.doFor(er);
    }
}

