/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.Keyword;
import gnu.kawa.io.InPort;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.kawa.lispexpr.ReaderDispatchSyntaxQuote;
import gnu.kawa.util.GeneralHashTable;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.regex.Pattern;

public class ReaderDispatchMisc
extends ReadTableEntry {
    protected int code;
    private static ReaderDispatchMisc instance = new ReaderDispatchMisc();

    public static ReaderDispatchMisc getInstance() {
        return instance;
    }

    public ReaderDispatchMisc() {
        this.code = -1;
    }

    public ReaderDispatchMisc(int code) {
        this.code = code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(Lexer in, int ch, int count) throws IOException, SyntaxException {
        LispReader reader = (LispReader)in;
        char saveReadState = '\u0000';
        if (this.code >= 0) {
            ch = this.code;
        }
        switch (ch) {
            case 58: {
                String name = reader.readTokenString(-1, ReadTable.getCurrent());
                return Keyword.make(name.intern());
            }
            case 92: {
                return LispReader.readCharacter(reader);
            }
            case 33: {
                return LispReader.readSpecial(reader);
            }
            case 70: 
            case 84: {
                int size;
                String name = reader.readTokenString(ch, ReadTable.getCurrent());
                String nameLC = name.toLowerCase();
                if (nameLC.equals("t") || nameLC.equals("true")) {
                    return Boolean.TRUE;
                }
                if (nameLC.equals("f") || nameLC.equals("false")) {
                    return Boolean.FALSE;
                }
                if (nameLC.equals("f32")) {
                    size = 32;
                } else if (nameLC.equals("f64")) {
                    size = 64;
                } else {
                    in.error("unexpected characters following '#'");
                    return Boolean.FALSE;
                }
                return LispReader.readSimpleVector(reader, 'F', reader.read(), size);
            }
            case 83: 
            case 85: {
                return LispReader.readSimpleVector(reader, (char)ch);
            }
            case 82: {
                if (count > 36) {
                    in.error("the radix " + count + " is too big (max is 36)");
                    count = 36;
                }
                return LispReader.readNumberWithRadix(0, reader, count);
            }
            case 88: {
                return LispReader.readNumberWithRadix(0, reader, 16);
            }
            case 68: {
                return LispReader.readNumberWithRadix(0, reader, 10);
            }
            case 79: {
                return LispReader.readNumberWithRadix(0, reader, 8);
            }
            case 66: {
                return LispReader.readNumberWithRadix(0, reader, 2);
            }
            case 69: 
            case 73: {
                reader.tokenBufferAppend(35);
                reader.tokenBufferAppend(ch);
                return LispReader.readNumberWithRadix(2, reader, 0);
            }
            case 47: {
                return ReaderDispatchMisc.readRegex(in, ch, count);
            }
            case 124: {
                ReaderDispatchMisc.readNestedComment(reader);
                return Values.empty;
            }
            case 59: {
                InPort port = reader.getPort();
                if (port instanceof InPort) {
                    saveReadState = port.readState;
                    port.readState = (char)59;
                }
                try {
                    reader.readObject();
                }
                finally {
                    if (port instanceof InPort) {
                        port.readState = saveReadState;
                    }
                }
                return Values.empty;
            }
            case 44: {
                return ReaderDispatchSyntaxQuote.readNamedConstructor(reader);
            }
            case 61: {
                return reader.readObject(count, false);
            }
            case 35: {
                Integer key;
                Lexer object2;
                GeneralHashTable<Integer, Object> map;
                if (in instanceof LispReader && (map = ((LispReader)in).sharedStructureTable) != null && (object2 = map.get(key = Integer.valueOf(count), in)) != in) {
                    return object2;
                }
                in.error("an unrecognized #n# back-reference was read");
                return Boolean.FALSE;
            }
        }
        in.error("An invalid #-construct was read.");
        return Values.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readNestedComment(LispReader reader) throws IOException, SyntaxException {
        InPort port = reader.getPort();
        char saveReadState = '\u0000';
        if (port instanceof InPort) {
            saveReadState = port.readState;
            port.readState = (char)124;
        }
        try {
            reader.readNestedComment('#', '|');
        }
        finally {
            if (port instanceof InPort) {
                port.readState = saveReadState;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern readRegex(Lexer in, int ch, int count) throws IOException, SyntaxException {
        int startPos = in.tokenBufferLength;
        InPort port = in.getPort();
        char saveReadState = '\u0000';
        int flags = 0;
        if (port instanceof InPort) {
            saveReadState = port.readState;
            port.readState = (char)47;
        }
        try {
            int c;
            while (true) {
                if ((c = port.read()) < 0) {
                    in.eofError("unexpected EOF in regex literal");
                }
                if (c == ch) break;
                if (c == 92) {
                    c = port.read();
                    if ((c == 32 || c == 9 || c == 13 || c == 10) && in instanceof LispReader && (c = ((LispReader)in).readEscape(c)) == -2) continue;
                    if (c < 0) {
                        in.eofError("unexpected EOF in regex literal");
                    }
                    if (c != ch) {
                        in.tokenBufferAppend(92);
                    }
                }
                in.tokenBufferAppend(c);
            }
            String pattern = new String(in.tokenBuffer, startPos, in.tokenBufferLength - startPos);
            while (true) {
                if ((c = in.peek()) == 105 || c == 73) {
                    flags |= 0x42;
                } else if (c == 115 || c == 83) {
                    flags |= 0x20;
                } else if (c == 109 || c == 77) {
                    flags |= 8;
                } else {
                    if (!Character.isLetter(c)) break;
                    in.error("unrecognized regex option '" + (char)c + '\'');
                }
                in.skip();
            }
            Pattern pattern2 = Pattern.compile(pattern, flags);
            return pattern2;
        }
        finally {
            in.tokenBufferLength = startPos;
            if (port instanceof InPort) {
                port.readState = saveReadState;
            }
        }
    }
}

