/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BitVector
extends SimpleVector
implements Externalizable {
    boolean[] data;
    protected static boolean[] empty = new boolean[0];

    public BitVector() {
        this.data = empty;
    }

    public BitVector(int size, boolean value) {
        boolean[] array = new boolean[size];
        this.data = array;
        this.size = size;
        if (value) {
            while (--size >= 0) {
                array[size] = true;
            }
        }
    }

    public BitVector(int size) {
        this.data = new boolean[size];
        this.size = size;
    }

    public BitVector(boolean[] data) {
        this.data = data;
        this.size = data.length;
    }

    public BitVector(Sequence seq) {
        this.data = new boolean[seq.size()];
        this.addAll(seq);
    }

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            boolean[] tmp = new boolean[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    @Override
    protected Object getBuffer() {
        return this.data;
    }

    public final boolean booleanAt(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public final boolean booleanAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final Object get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[index]);
    }

    public final Object getBuffer(int index) {
        return Convert.toObject(this.data[index]);
    }

    public void setBuffer(int index, Object value) {
        this.data[index] = Convert.toBoolean(value);
    }

    public final void setBooleanAt(int index, boolean value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[index] = value;
    }

    public final void setBooleanAtBuffer(int index, boolean value) {
        this.data[index] = value;
    }

    @Override
    protected void clearBuffer(int start, int count) {
        while (--count >= 0) {
            this.data[start++] = false;
        }
    }

    @Override
    public int getElementKind() {
        return 27;
    }

    @Override
    public String getTag() {
        return "b";
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int end = iposEnd >>> 1;
        for (int i = iposStart >>> 1; i < end; ++i) {
            out.writeBoolean(this.data[i]);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeBoolean(this.data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        boolean[] data = new boolean[size];
        for (int i = 0; i < size; ++i) {
            data[i] = in.readBoolean();
        }
        this.data = data;
        this.size = size;
    }
}

