mythical_adjectives={
    CAVERNS={
        {adj="cavern",adj_after=false},
        {adj="under",adj_after=false},
        {adj="deep",adj_after=false},
        {adj="below",adj_after=true},
        {adj="cave",adj_after=false},
        {adj="tunnel",adj_after=false},
    },
    CHAOS={
        {adj="chaos",adj_after=false},
        {adj="of chaos",adj_after=true},
        {adj="of change",adj_after=true},
        {adj="maelstrom",adj_after=false},
    },
    DARKNESS={
        {adj="shadow",adj_after=false},
        {adj="of shadow",adj_after=true},
        {adj="dark",adj_after=false},
        {adj="of darkness",adj_after=true},
    },
    DEATH={
        {adj="death",adj_after=false},
        {adj="of death",adj_after=true},
        {adj="bone",adj_after=false},
        {adj="of bones",adj_after=true},
        {adj="grave",adj_after=false},
        {adj="of the grave",adj_after=true},
    },
    DREAMS={
        {adj="dream",adj_after=false},
        {adj="of dreams",adj_after=true},
        {adj="sleeping",adj_after=false},
        {adj="of stone",adj_after=true},
    },
    EARTH={
        {adj="earth",adj_after=false},
        {adj="of earth",adj_after=true},
        {adj="stone",adj_after=false},
        {adj="of stone",adj_after=true},
    },
    FIRE={
        {adj="fire",adj_after=false},
        {adj="of fire",adj_after=true},
        {adj="flame",adj_after=false},
        {adj="of flames",adj_after=true},
        {adj="inferno",adj_after=false},
    },
    JEWELS={
        {adj="gem",adj_after=false},
        {adj="of gems",adj_after=true},
        {adj="jewel",adj_after=false},
        {adj="of jewels",adj_after=true},
        {adj="crystal",adj_after=false},
        {adj="of crystals",adj_after=true},
    },
    LIGHT={
        {adj="light",adj_after=false},
        {adj="of light",adj_after=true},
        {adj="bright",adj_after=false},
        {adj="shining",adj_after=false},
    },
    LIGHTNING={
        {adj="storm",adj_after=false},
        {adj="of storms",adj_after=true},
        {adj="lightning",adj_after=false},
        {adj="of lightning",adj_after=true},
    },
    METALS={
        {adj="metal",adj_after=false},
        {adj="of metal",adj_after=true},
        {adj="steel",adj_after=false},
        {adj="of steel",adj_after=true},
        {adj="iron",adj_after=false},
        {adj="of iron",adj_after=true},
        {adj="bronze",adj_after=false},
        {adj="of bronze",adj_after=true},
        {adj="golden",adj_after=false},
        {adj="of gold",adj_after=true},
        {adj="silver",adj_after=false},
        {adj="of silver",adj_after=true},

    },
    MINERALS={
        {adj="crystal",adj_after=false},
        {adj="of crystal",adj_after=true},
        {adj="stone",adj_after=false},
        {adj="of stone",adj_after=true},
    },
    MIST={
        {adj="shrouded",adj_after=false},
        {adj="mist",adj_after=false},
        {adj="of mist",adj_after=true},
        {adj="fog",adj_after=false},
        {adj="of fog",adj_after=true},
        {adj="hidden",adj_after=false},
    },
    MOON={
        {adj="moon",adj_after=false},
        {adj="of the moon",adj_after=true},
        {adj="lunar",adj_after=false},
        {adj="of the eclipse",adj_after=true},
        {adj="crescent",adj_after=false},
    },
    MOUNTAINS={
        {adj="mountain",adj_after=false},
        {adj="of the mountain",adj_after=true},
        {adj="peak",adj_after=false},
        {adj="of the peak",adj_after=true},
        {adj="summit",adj_after=false},
        {adj="of the heights",adj_after=true},
        {adj="ridge",adj_after=false},
    },
    MUCK={
        {adj="muck",adj_after=false},
        {adj="mud",adj_after=true},
        {adj="of the mud",adj_after=true},
        {adj="swamp",adj_after=false},
        {adj="of the swamp",adj_after=true},
        {adj="marsh",adj_after=false},
        {adj="of the marsh",adj_after=true},
    },
    NIGHTMARES={
        {adj="dread",adj_after=false},
        {adj="of dread",adj_after=true},
        {adj="nightmare",adj_after=false},
        {adj="of nightmares",adj_after=true},
        {adj="fear",adj_after=false},
        {adj="of fear",adj_after=true},
        {adj="terror",adj_after=false},
        {adj="of terror",adj_after=true},
    },
    OCEANS={
        {adj="ocean",adj_after=false},
        {adj="of the ocean",adj_after=true},
        {adj="of oceans",adj_after=true},
        {adj="sea",adj_after=false},
        {adj="of the sea",adj_after=true},
        {adj="of seas",adj_after=true},
        {adj="tidal",adj_after=false},
        {adj="of the tide",adj_after=true},
        {adj="of tides",adj_after=true},
        {adj="brine",adj_after=false},
        {adj="of brine",adj_after=true},
        {adj="foam",adj_after=false},
        {adj="of foam",adj_after=true},
    },
    PLANTS={
        {adj="leaf",adj_after=false},
        {adj="of leaves",adj_after=true},
        {adj="verdant",adj_after=false},
        {adj="grass",adj_after=false},
        {adj="of grasses",adj_after=true},
    },
    SALT={
        {adj="salt",adj_after=false},
        {adj="of salt",adj_after=true},
    },
    SKY={
        {adj="sky",adj_after=false},
        {adj="of the sky",adj_after=true},
        {adj="blue",adj_after=false},
        {adj="cloud",adj_after=false},
        {adj="of the clouds",adj_after=true},
        {adj="of clouds",adj_after=true},
    },
    STARS={
        {adj="star",adj_after=false},
        {adj="of the stars",adj_after=true},
        {adj="of stars",adj_after=true},
    },
    STORMS={
        {adj="storm",adj_after=false},
        {adj="of the storm",adj_after=true},
        {adj="of storms",adj_after=true},
        {adj="tornado",adj_after=false},
        {adj="hurricane",adj_after=false},
        {adj="gale",adj_after=false},
        {adj="of the gale",adj_after=true},
        {adj="of gales",adj_after=true},
        {adj="rain",adj_after=false},
        {adj="of the rain",adj_after=true},
        {adj="of rains",adj_after=true},
    },
    SUN={
        {adj="sun",adj_after=false},
        {adj="of the sun",adj_after=true},
        {adj="day",adj_after=false},
        {adj="bright",adj_after=false},
        {adj="dawn",adj_after=false},
        {adj="of the dawn",adj_after=true},
        {adj="of dawn",adj_after=true},
        {adj="noon",adj_after=false},
        {adj="of the noon",adj_after=true},
        {adj="of noon",adj_after=true},
        {adj="morning",adj_after=false},
    },
    TREES={
        {adj="tree",adj_after=false},
        {adj="of the trees",adj_after=true},
        {adj="of trees",adj_after=true},
        {adj="forest",adj_after=false},
        {adj="of the forest",adj_after=true},
        {adj="of forests",adj_after=true},
        {adj="leaf",adj_after=false},
        {adj="of leaves",adj_after=true},
        {adj="bark",adj_after=false},
        {adj="of bark",adj_after=true},
        {adj="of branches",adj_after=true},
        {adj="root",adj_after=false},
        {adj="of root",adj_after=true},
    },
    VOLCANOS={
        {adj="volcano",adj_after=false},
        {adj="of volcanoes",adj_after=true},
        {adj="magma",adj_after=false},
        {adj="of magma",adj_after=true},
        {adj="lava",adj_after=false},
        {adj="of lava",adj_after=true},
        {adj="of eruptions",adj_after=true},
    },
    WATER={
        {adj="water",adj_after=false},
        {adj="of the waters",adj_after=true},
        {adj="of water",adj_after=true},
        {adj="flowing",adj_after=false},
        {adj="ice",adj_after=false},
        {adj="of ice",adj_after=true},
    },
    WIND={
        {adj="wind",adj_after=false},
        {adj="of the wind",adj_after=true},
        {adj="of wind",adj_after=true},
        {adj="tornado",adj_after=false},
        {adj="hurricane",adj_after=false},
        {adj="gale",adj_after=false},
        {adj="of the gale",adj_after=true},
        {adj="of gales",adj_after=true},
    },
}

mythical_names={
    {
        "servant",
        "follower",
        "cultist",
        "worshipper"
    },
    {
        "adept",
        "priest",
        "cleric",
        "shaman",
    },
    {
        "lord",
        "master",
        "ancient",
        "elder"
    }
}

interactions.mythical.default=function(i,power_level,sphere)
    local name_str,name_plural_str,adj_tbl
    name_str=pick_random(mythical_names[power_level])
    if name_str then
        name_plural_str=name_str.."s"
        adj_tbl=pick_random(mythical_adjectives[sphere])
        if adj_tbl.adj_after then
            name_str = name_str.." "..adj_tbl.adj
            name_plural_str=name_plural_str.." "..adj_tbl.adj
        else
            name_str = adj_tbl.adj.." "..name_str
            name_plural_str=adj_tbl.adj.." "..name_plural_str
        end
    end
    local tbl={}
    tbl[#tbl+1]="[I_EFFECT:ADD_SYNDROME]"
    tbl[#tbl+1]="[IE_TARGET:A]"
    if name_str then tbl[#tbl+1]="[IE_ARENA_NAME:"..capitalize_string_first_word(name_str).."]" end
    tbl[#tbl+1]="[IE_IMMEDIATE]"
    tbl[#tbl+1]="[SYNDROME]"
    tbl[#tbl+1]="[SYN_CLASS:NECROMANCER] for color purposes"
    tbl[#tbl+1]="[SYN_CONCENTRATION_ADDED:1000:0] just in case"
    tbl[#tbl+1]="[CE_DISPLAY_TILE:TILE:152:5:0:1:START:0:ABRUPT]"
    if name_str then tbl[#tbl+1]="[CE_DISPLAY_NAME:NAME:"..name_str..":"..name_plural_str..":"..name_str..":START:0:ABRUPT]" end
    tbl[#tbl+1]="[CE_ADD_TAG:STERILE:EXTRAVISION:NOEXERT:NO_FEVERS:NOFEAR:NO_AGING:NO_EAT:NO_DRINK:NO_SLEEP:NO_PHYS_ATT_GAIN:NO_PHYS_ATT_RUST:START:0:ABRUPT]"
    tbl[#tbl+1]="[CE_CHANGE_PERSONALITY:FACET:CRUELTY:200:FACET:LOVE_PROPENSITY:-200:FACET:HATE_PROPENSITY:200:FACET:CHEER_PROPENSITY:-200:FACET:VIOLENT:200:FACET:ALTRUISM:-200:START:0:ABRUPT]"
    --[[*************************** DREAD LORD POWERS
        //lv 1-3
            //lord
                //all powers at top level
            //priest etc.
                //med power, 2 minor powers
            //cultist etc.
                //1 minor power
    ]]
    return {raws=tbl,weight=1}
end