/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.LangSys;
import jogamp.graph.font.typecast.ot.table.LangSysRecord;

public class Script {
    private final int _defaultLangSysOffset;
    private final int _langSysCount;
    private LangSysRecord[] _langSysRecords;
    private LangSys _defaultLangSys;
    private LangSys[] _langSys;

    protected Script(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        dataInputStream.reset();
        dataInputStream.skipBytes(n);
        this._defaultLangSysOffset = dataInputStream.readUnsignedShort();
        this._langSysCount = dataInputStream.readUnsignedShort();
        if (this._langSysCount > 0) {
            this._langSysRecords = new LangSysRecord[this._langSysCount];
            for (n2 = 0; n2 < this._langSysCount; ++n2) {
                this._langSysRecords[n2] = new LangSysRecord(dataInputStream);
            }
        }
        if (this._langSysCount > 0) {
            this._langSys = new LangSys[this._langSysCount];
            for (n2 = 0; n2 < this._langSysCount; ++n2) {
                dataInputStream.reset();
                dataInputStream.skipBytes(n + this._langSysRecords[n2].getOffset());
                this._langSys[n2] = new LangSys(dataInputStream);
            }
        }
        if (this._defaultLangSysOffset > 0) {
            dataInputStream.reset();
            dataInputStream.skipBytes(n + this._defaultLangSysOffset);
            this._defaultLangSys = new LangSys(dataInputStream);
        }
    }

    public int getLangSysCount() {
        return this._langSysCount;
    }

    public LangSysRecord getLangSysRecord(int n) {
        return this._langSysRecords[n];
    }

    public LangSys getDefaultLangSys() {
        return this._defaultLangSys;
    }

    public LangSys getLangSys(int n) {
        return this._langSys[n];
    }
}

