/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Shift the zero-frequency components of a Fourier transform to the
center of the image.


The Fourier transform produces an image where the zero frequency
components are in the corner of the image, making it difficult to
understand. This filter shifts the component to the center of the
image.


For images with an odd-sized dimension, applying this filter twice
will not produce the same image as the original one without using
SetInverse(true) on one (and only one) of the two filters.
https://doi.org/10.54294/xd0lzg


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ForwardFFTImageFilter , InverseFFTImageFilter

 itk::simple::FFTShift for the procedural interface

 itk::FFTShiftImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFFTShiftImageFilter.h
*/
public class FFTShiftImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected FFTShiftImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.FFTShiftImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(FFTShiftImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(FFTShiftImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::FFTShiftImageFilter::~FFTShiftImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_FFTShiftImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::FFTShiftImageFilter::FFTShiftImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  FFTShiftImageFilter() {
    this(SimpleITKJNI.new_FFTShiftImageFilter(), true);
  }

  /**
Self&amp; itk::simple::FFTShiftImageFilter::SetInverse(bool Inverse)

Set/Get whether the filter must invert the transform or not. This
option has no effect if none of the size of the input image is even,
but is required to restore the original image if at least one of the
dimensions has an odd size.

*/
public  void setInverse(boolean Inverse) {
    SimpleITKJNI.FFTShiftImageFilter_setInverse(swigCPtr, this, Inverse);
  }

  /**
Self&amp; itk::simple::FFTShiftImageFilter::InverseOn()

Set the value of Inverse to true or false respectfully.

*/
public  void inverseOn() {
    SimpleITKJNI.FFTShiftImageFilter_inverseOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FFTShiftImageFilter::InverseOff()
*/
public  void inverseOff() {
    SimpleITKJNI.FFTShiftImageFilter_inverseOff(swigCPtr, this);
  }

  /**
bool itk::simple::FFTShiftImageFilter::GetInverse() const

Set/Get whether the filter must invert the transform or not. This
option has no effect if none of the size of the input image is even,
but is required to restore the original image if at least one of the
dimensions has an odd size.

*/
public  boolean getInverse() {
    return SimpleITKJNI.FFTShiftImageFilter_getInverse(swigCPtr, this);
  }

  /**
std::string itk::simple::FFTShiftImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.FFTShiftImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::FFTShiftImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.FFTShiftImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::FFTShiftImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.FFTShiftImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
