/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import jnr.constants.platform.Signal;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyInteger;
import org.jruby.RubySignal;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.SignalException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"SignalException"}, parent="Exception")
public class RubySignalException
extends RubyException {
    private IRubyObject signo;

    protected RubySignalException(Ruby runtime2, RubyClass exceptionClass) {
        super(runtime2, exceptionClass);
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new SignalException(message2, this);
    }

    static RubyClass define(ThreadContext context, RubyClass Exception2) {
        return (RubyClass)Define.defineClass(context, "SignalException", Exception2, RubySignalException::new).defineMethods(context, RubySignalException.class);
    }

    @JRubyMethod(required=1, optional=2, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        long _signo;
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        int argnum = 1;
        IRubyObject sig = Convert.checkToInteger(context, args2[0]);
        if (sig.isNil()) {
            sig = args2[0];
            Arity.checkArgumentCount(context, args2, 1, argnum);
        } else {
            argnum = 2;
        }
        if (argnum == 2) {
            _signo = ((RubyInteger)sig).asLong(context);
            if (_signo < 0L || _signo > Signal.NSIG.longValue()) {
                throw Error.argumentError(context, "invalid signal number (" + _signo + ")");
            }
            sig = argc > 1 ? args2[1] : Create.newString(context, RubySignal.signmWithPrefix(RubySignal.signo2signm(_signo)));
        } else {
            String signm = sig.toString();
            _signo = RubySignal.signm2signo(RubySignal.signmWithoutPrefix(signm));
            if (_signo == 0L) {
                throw Error.argumentError(context, "unsupported name " + String.valueOf(sig));
            }
            sig = Create.newString(context, RubySignal.signmWithPrefix(signm));
        }
        super.initialize(new IRubyObject[]{sig}, block);
        this.signo = Convert.asFixnum(context, _signo);
        return this;
    }

    @JRubyMethod
    public IRubyObject signo(ThreadContext context) {
        assert (this.signo != null);
        return this.signo == RubyBasicObject.UNDEF ? context.nil : this.signo;
    }

    @Override
    @JRubyMethod(name={"message", "signm"})
    public IRubyObject message(ThreadContext context) {
        return super.message(context);
    }
}

