/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authorization.UserManagedPermissionUtil;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ModelException;
import org.keycloak.models.cache.authorization.CachedStoreFactoryProvider;
import org.keycloak.models.cache.infinispan.authorization.PermissionTicketAdapter;
import org.keycloak.models.cache.infinispan.authorization.PolicyAdapter;
import org.keycloak.models.cache.infinispan.authorization.ResourceAdapter;
import org.keycloak.models.cache.infinispan.authorization.ResourceServerAdapter;
import org.keycloak.models.cache.infinispan.authorization.ScopeAdapter;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedPermissionTicket;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedPolicy;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedResource;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedResourceServer;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedScope;
import org.keycloak.models.cache.infinispan.authorization.entities.PermissionTicketListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.PermissionTicketQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.PermissionTicketResourceListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.PermissionTicketScopeListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.PolicyListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.PolicyQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.PolicyResourceListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.PolicyScopeListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.ResourceListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.ResourceQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.ResourceScopeListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.ScopeListQuery;
import org.keycloak.models.cache.infinispan.authorization.events.PermissionTicketRemovedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.PermissionTicketUpdatedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.PolicyRemovedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.PolicyUpdatedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ResourceRemovedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ResourceServerRemovedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ResourceServerUpdatedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ResourceUpdatedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ScopeRemovedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ScopeUpdatedEvent;
import org.keycloak.models.cache.infinispan.entities.NonExistentItem;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.storage.StorageId;

public class StoreFactoryCacheSession
implements CachedStoreFactoryProvider {
    protected static final Logger logger = Logger.getLogger(StoreFactoryCacheSession.class);
    protected StoreFactoryCacheManager cache;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;
    protected Map<String, ResourceServerAdapter> managedResourceServers = new HashMap<String, ResourceServerAdapter>();
    protected Map<String, ScopeAdapter> managedScopes = new HashMap<String, ScopeAdapter>();
    protected Map<String, ResourceAdapter> managedResources = new HashMap<String, ResourceAdapter>();
    protected Map<String, PolicyAdapter> managedPolicies = new HashMap<String, PolicyAdapter>();
    protected Map<String, PermissionTicketAdapter> managedPermissionTickets = new HashMap<String, PermissionTicketAdapter>();
    protected Set<String> invalidations = new HashSet<String>();
    protected Set<InvalidationEvent> invalidationEvents = new HashSet<InvalidationEvent>();
    protected final long startupRevision;
    protected StoreFactory delegate;
    protected KeycloakSession session;
    protected ResourceServerCache resourceServerCache;
    protected ScopeCache scopeCache;
    protected ResourceCache resourceCache;
    protected PolicyCache policyCache;
    protected PermissionTicketCache permissionTicketCache;

    public StoreFactoryCacheSession(StoreFactoryCacheManager cache, KeycloakSession session) {
        this.cache = cache;
        this.startupRevision = cache.getCurrentCounter();
        this.session = session;
        this.resourceServerCache = new ResourceServerCache();
        this.scopeCache = new ScopeCache();
        this.resourceCache = new ResourceCache();
        this.policyCache = new PolicyCache();
        this.permissionTicketCache = new PermissionTicketCache();
        session.getTransactionManager().enlistPrepare(this.getPrepareTransaction());
        session.getTransactionManager().enlistAfterCompletion(this.getAfterTransaction());
    }

    public ResourceServerStore getResourceServerStore() {
        return this.resourceServerCache;
    }

    public ScopeStore getScopeStore() {
        return this.scopeCache;
    }

    public ResourceStore getResourceStore() {
        return this.resourceCache;
    }

    public PolicyStore getPolicyStore() {
        return this.policyCache;
    }

    public PermissionTicketStore getPermissionTicketStore() {
        return this.permissionTicketCache;
    }

    public void setReadOnly(boolean readOnly) {
        this.getDelegate().setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.getDelegate().isReadOnly();
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    private KeycloakTransaction getPrepareTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                StoreFactoryCacheSession.this.transactionActive = true;
            }

            public void commit() {
            }

            public void rollback() {
                StoreFactoryCacheSession.this.setRollbackOnly = true;
                StoreFactoryCacheSession.this.transactionActive = false;
            }

            public void setRollbackOnly() {
                StoreFactoryCacheSession.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return StoreFactoryCacheSession.this.setRollbackOnly;
            }

            public boolean isActive() {
                return StoreFactoryCacheSession.this.transactionActive;
            }
        };
    }

    private KeycloakTransaction getAfterTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                StoreFactoryCacheSession.this.transactionActive = true;
            }

            public void commit() {
                try {
                    StoreFactoryCacheSession.this.runInvalidations();
                    StoreFactoryCacheSession.this.transactionActive = false;
                }
                finally {
                    StoreFactoryCacheSession.this.cache.endRevisionBatch();
                }
            }

            public void rollback() {
                try {
                    StoreFactoryCacheSession.this.setRollbackOnly = true;
                    StoreFactoryCacheSession.this.runInvalidations();
                    StoreFactoryCacheSession.this.transactionActive = false;
                }
                finally {
                    StoreFactoryCacheSession.this.cache.endRevisionBatch();
                }
            }

            public void setRollbackOnly() {
                StoreFactoryCacheSession.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return StoreFactoryCacheSession.this.setRollbackOnly;
            }

            public boolean isActive() {
                return StoreFactoryCacheSession.this.transactionActive;
            }
        };
    }

    protected void runInvalidations() {
        for (String id : this.invalidations) {
            this.cache.invalidateObject(id);
        }
        this.cache.sendInvalidationEvents(this.session, this.invalidationEvents, "AUTHORIZATION_INVALIDATION_EVENTS");
    }

    public void registerResourceServerInvalidation(String id) {
        this.cache.resourceServerUpdated(id, this.invalidations);
        ResourceServerAdapter adapter = this.managedResourceServers.get(id);
        if (adapter != null) {
            adapter.invalidateFlag();
        }
        this.invalidationEvents.add(ResourceServerUpdatedEvent.create(id));
    }

    public void registerScopeInvalidation(String id, String name, String serverId) {
        this.cache.scopeUpdated(id, name, serverId, this.invalidations);
        ScopeAdapter adapter = this.managedScopes.get(id);
        if (adapter != null) {
            adapter.invalidateFlag();
        }
        this.invalidationEvents.add(ScopeUpdatedEvent.create(id, name, serverId));
    }

    public void registerResourceInvalidation(String id, String name, String type, Set<String> uris, Set<String> scopes, String serverId, String owner) {
        this.cache.resourceUpdated(id, name, type, uris, scopes, serverId, owner, this.invalidations);
        ResourceAdapter adapter = this.managedResources.get(id);
        if (adapter != null) {
            adapter.invalidateFlag();
        }
        this.invalidationEvents.add(ResourceUpdatedEvent.create(id, name, type, uris, owner, scopes, serverId));
    }

    public void registerPolicyInvalidation(String id, String name, Set<String> resources, Set<String> scopes, String defaultResourceType, String serverId) {
        Set<String> resourceTypes = this.getResourceTypes(resources, serverId);
        if (Objects.nonNull(defaultResourceType)) {
            resourceTypes.add(defaultResourceType);
        }
        this.cache.policyUpdated(id, name, resources, resourceTypes, scopes, serverId, this.invalidations);
        PolicyAdapter adapter = this.managedPolicies.get(id);
        if (adapter != null) {
            adapter.invalidateFlag();
        }
        this.invalidationEvents.add(PolicyUpdatedEvent.create(id, name, resources, resourceTypes, scopes, serverId));
    }

    public void registerPermissionTicketInvalidation(String id, String owner, String requester, String resource, String resourceName, String scope, String serverId) {
        this.cache.permissionTicketUpdated(id, owner, requester, resource, resourceName, scope, serverId, this.invalidations);
        PermissionTicketAdapter adapter = this.managedPermissionTickets.get(id);
        if (adapter != null) {
            adapter.invalidateFlag();
        }
        this.invalidationEvents.add(PermissionTicketUpdatedEvent.create(id, owner, requester, resource, resourceName, scope, serverId));
    }

    private Set<String> getResourceTypes(Set<String> resources, String serverId) {
        if (resources == null) {
            return Collections.emptySet();
        }
        ResourceServer resourceServer = this.getResourceServerStore().findById(serverId);
        return resources.stream().map(resourceId -> {
            Resource resource = this.getResourceStore().findById(resourceServer, resourceId);
            if (resource == null) {
                return null;
            }
            return resource.getType();
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public ResourceServerStore getResourceServerStoreDelegate() {
        return this.getDelegate().getResourceServerStore();
    }

    public ScopeStore getScopeStoreDelegate() {
        return this.getDelegate().getScopeStore();
    }

    public ResourceStore getResourceStoreDelegate() {
        return this.getDelegate().getResourceStore();
    }

    public PolicyStore getPolicyStoreDelegate() {
        return this.getDelegate().getPolicyStore();
    }

    public PermissionTicketStore getPermissionTicketStoreDelegate() {
        return this.getDelegate().getPermissionTicketStore();
    }

    public static String getResourceServerByClientCacheKey(String clientId) {
        return "resource.server.client.id." + clientId;
    }

    public static String getScopeByNameCacheKey(String name, String serverId) {
        return "scope.name." + name + "." + serverId;
    }

    public static String getResourceByNameCacheKey(String name, String ownerId, String serverId) {
        return "resource.name." + name + "." + ownerId + "." + serverId;
    }

    public static String getResourceByOwnerCacheKey(String owner, String serverId) {
        return "resource.owner." + owner + "." + serverId;
    }

    public static String getResourceByTypeCacheKey(String type, String serverId) {
        return "resource.type." + type + "." + serverId;
    }

    public static String getResourceByTypeCacheKey(String type, String owner, String serverId) {
        return "resource.type." + type + ".owner." + owner + "." + serverId;
    }

    public static String getResourceByTypeInstanceCacheKey(String type, String serverId) {
        return "resource.type.instance." + type + "." + serverId;
    }

    public static String getResourceByUriCacheKey(String uri, String serverId) {
        return "resource.uri." + uri + "." + serverId;
    }

    public static String getResourceByScopeCacheKey(String scopeId, String serverId) {
        return "resource.scope." + scopeId + "." + serverId;
    }

    public static String getPolicyByNameCacheKey(String name, String serverId) {
        return "policy.name." + name + "." + serverId;
    }

    public static String getPolicyByResource(String resourceId, String serverId) {
        return "policy.resource." + resourceId + "." + serverId;
    }

    public static String getPolicyByResourceType(String type, String serverId) {
        return "policy.resource.type." + type + "." + serverId;
    }

    public static String getPolicyByScope(String scope, String serverId) {
        return "policy.scope." + scope + "." + serverId;
    }

    public static String getPolicyByResourceScope(String scope, String resourceId, String serverId) {
        return "policy.resource. " + resourceId + ".scope." + scope + "." + serverId;
    }

    public static String getPermissionTicketByResource(String resourceId, String serverId) {
        return "permission.ticket.resource." + resourceId + "." + serverId;
    }

    public static String getPermissionTicketByScope(String scopeId, String serverId) {
        return "permission.ticket.scope." + scopeId + "." + serverId;
    }

    public static String getPermissionTicketByGranted(String userId, String serverId) {
        return "permission.ticket.granted." + userId + "." + serverId;
    }

    public static String getPermissionTicketByResourceNameAndGranted(String resourceName, String userId, String serverId) {
        return "permission.ticket.granted." + resourceName + "." + userId + "." + serverId;
    }

    public static String getPermissionTicketByOwner(String owner, String serverId) {
        return "permission.ticket.owner." + owner + "." + serverId;
    }

    public StoreFactory getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = (StoreFactory)this.session.getProvider(StoreFactory.class);
        return this.delegate;
    }

    private void setModelDoesNotExists(String id, Long loaded) {
        if (!this.invalidations.contains(id)) {
            this.cache.addRevisioned(new NonExistentItem(id, loaded), this.startupRevision);
        }
    }

    boolean modelMightExist(String id) {
        return this.invalidations.contains(id) || this.cache.get(id, NonExistentItem.class) == null;
    }

    void cachePolicy(Policy model) {
        String id = model.getId();
        if (this.cache.getCache().containsKey((Object)id)) {
            return;
        }
        if (!this.modelMightExist(id)) {
            return;
        }
        if (this.invalidations.contains(id)) {
            return;
        }
        this.cache.addRevisioned(this.createCachedPolicy(model, id), this.startupRevision);
    }

    CachedPolicy createCachedPolicy(Policy model, String id) {
        Long loaded = this.cache.getCurrentRevision(id);
        return new CachedPolicy(loaded, model);
    }

    void cacheResource(Resource model) {
        String id = model.getId();
        if (this.cache.getCache().containsKey((Object)id)) {
            return;
        }
        Long loaded = this.cache.getCurrentRevision(id);
        if (!this.modelMightExist(id)) {
            return;
        }
        if (this.invalidations.contains(id)) {
            return;
        }
        this.cache.addRevisioned(new CachedResource(loaded, model), this.startupRevision);
    }

    void cacheScope(Scope model) {
        String id = model.getId();
        if (this.cache.getCache().containsKey((Object)id)) {
            return;
        }
        Long loaded = this.cache.getCurrentRevision(id);
        if (!this.modelMightExist(id)) {
            return;
        }
        if (this.invalidations.contains(id)) {
            return;
        }
        this.cache.addRevisioned(new CachedScope(loaded, model), this.startupRevision);
    }

    protected class ResourceServerCache
    implements ResourceServerStore {
        protected ResourceServerCache() {
        }

        public ResourceServer create(ClientModel client) {
            String clientId = client.getId();
            if (!StorageId.isLocalStorage((String)clientId)) {
                throw new ModelException("Creating resource server from federated ClientModel not supported");
            }
            ResourceServer server = StoreFactoryCacheSession.this.getResourceServerStoreDelegate().create(client);
            StoreFactoryCacheSession.this.registerResourceServerInvalidation(server.getId());
            return server;
        }

        public void delete(ClientModel client) {
            String id = client.getId();
            if (id == null) {
                return;
            }
            ResourceServer server = this.findById(id);
            if (server == null) {
                return;
            }
            StoreFactoryCacheSession.this.cache.invalidateObject(id);
            StoreFactoryCacheSession.this.invalidationEvents.add(ResourceServerRemovedEvent.create(id));
            StoreFactoryCacheSession.this.cache.resourceServerRemoval(id, StoreFactoryCacheSession.this.invalidations);
            StoreFactoryCacheSession.this.getResourceServerStoreDelegate().delete(client);
        }

        public ResourceServer findById(String id) {
            if (id == null) {
                return null;
            }
            CachedResourceServer cached = StoreFactoryCacheSession.this.cache.get(id, CachedResourceServer.class);
            if (cached != null) {
                logger.tracev("by id cache hit: {0}", (Object)cached.getId());
            }
            if (cached == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(id);
                if (!StoreFactoryCacheSession.this.modelMightExist(id)) {
                    return null;
                }
                ResourceServer model = StoreFactoryCacheSession.this.getResourceServerStoreDelegate().findById(id);
                if (model == null) {
                    StoreFactoryCacheSession.this.setModelDoesNotExists(id, loaded);
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return model;
                }
                cached = new CachedResourceServer(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(cached, StoreFactoryCacheSession.this.startupRevision);
            } else {
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return StoreFactoryCacheSession.this.getResourceServerStoreDelegate().findById(id);
                }
                if (StoreFactoryCacheSession.this.managedResourceServers.containsKey(id)) {
                    return StoreFactoryCacheSession.this.managedResourceServers.get(id);
                }
            }
            ResourceServerAdapter adapter = new ResourceServerAdapter(cached, StoreFactoryCacheSession.this);
            StoreFactoryCacheSession.this.managedResourceServers.put(id, adapter);
            return adapter;
        }

        public ResourceServer findByClient(ClientModel client) {
            return this.findById(client.getId());
        }
    }

    protected class ScopeCache
    implements ScopeStore {
        protected ScopeCache() {
        }

        public Scope create(ResourceServer resourceServer, String name) {
            return this.create(resourceServer, null, name);
        }

        public Scope create(ResourceServer resourceServer, String id, String name) {
            Scope scope = StoreFactoryCacheSession.this.getScopeStoreDelegate().create(resourceServer, id, name);
            StoreFactoryCacheSession.this.registerScopeInvalidation(scope.getId(), scope.getName(), resourceServer.getId());
            return scope;
        }

        public void delete(String id) {
            if (id == null) {
                return;
            }
            Scope scope = this.findById(null, id);
            if (scope == null) {
                return;
            }
            StoreFactoryCacheSession.this.cache.invalidateObject(id);
            StoreFactoryCacheSession.this.invalidationEvents.add(ScopeRemovedEvent.create(id, scope.getName(), scope.getResourceServer().getId()));
            StoreFactoryCacheSession.this.cache.scopeRemoval(id, scope.getName(), scope.getResourceServer().getId(), StoreFactoryCacheSession.this.invalidations);
            StoreFactoryCacheSession.this.getScopeStoreDelegate().delete(id);
        }

        public Scope findById(ResourceServer resourceServer, String id) {
            if (id == null) {
                return null;
            }
            CachedScope cached = StoreFactoryCacheSession.this.cache.get(id, CachedScope.class);
            if (cached != null) {
                logger.tracev("by id cache hit: {0}", (Object)cached.getId());
            }
            if (cached == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(id);
                if (!StoreFactoryCacheSession.this.modelMightExist(id)) {
                    return null;
                }
                Scope model = StoreFactoryCacheSession.this.getScopeStoreDelegate().findById(resourceServer, id);
                if (model == null) {
                    StoreFactoryCacheSession.this.setModelDoesNotExists(id, loaded);
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return model;
                }
                cached = new CachedScope(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(cached, StoreFactoryCacheSession.this.startupRevision);
            } else {
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return StoreFactoryCacheSession.this.getScopeStoreDelegate().findById(resourceServer, id);
                }
                if (StoreFactoryCacheSession.this.managedScopes.containsKey(id)) {
                    return StoreFactoryCacheSession.this.managedScopes.get(id);
                }
            }
            ScopeAdapter adapter = new ScopeAdapter(cached, StoreFactoryCacheSession.this);
            StoreFactoryCacheSession.this.managedScopes.put(id, adapter);
            return adapter;
        }

        public Scope findByName(ResourceServer resourceServer, String name) {
            if (name == null) {
                return null;
            }
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getScopeByNameCacheKey(name, resourceServerId);
            ScopeListQuery query = StoreFactoryCacheSession.this.cache.get(cacheKey, ScopeListQuery.class);
            if (query != null) {
                logger.tracev("scope by name cache hit: {0}", (Object)name);
            }
            if (query == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(cacheKey);
                Scope model = StoreFactoryCacheSession.this.getScopeStoreDelegate().findByName(resourceServer, name);
                if (model == null) {
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(model.getId())) {
                    return model;
                }
                query = new ScopeListQuery(loaded, cacheKey, model.getId(), resourceServerId);
                StoreFactoryCacheSession.this.cache.addRevisioned(query, StoreFactoryCacheSession.this.startupRevision);
                return model;
            }
            if (StoreFactoryCacheSession.this.invalidations.contains(cacheKey)) {
                return StoreFactoryCacheSession.this.getScopeStoreDelegate().findByName(resourceServer, name);
            }
            String id = query.getScopes().iterator().next();
            if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                return StoreFactoryCacheSession.this.getScopeStoreDelegate().findByName(resourceServer, name);
            }
            return this.findById(resourceServer, id);
        }

        public List<Scope> findByResourceServer(ResourceServer resourceServer) {
            return StoreFactoryCacheSession.this.getScopeStoreDelegate().findByResourceServer(resourceServer);
        }

        public List<Scope> findByResourceServer(ResourceServer resourceServer, Map<Scope.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
            return StoreFactoryCacheSession.this.getScopeStoreDelegate().findByResourceServer(resourceServer, attributes, firstResult, maxResults);
        }
    }

    protected class ResourceCache
    implements ResourceStore {
        protected ResourceCache() {
        }

        public Resource create(ResourceServer resourceServer, String id, String name, String owner) {
            Resource resource = StoreFactoryCacheSession.this.getResourceStoreDelegate().create(resourceServer, id, name, owner);
            Resource cached = this.findById(resourceServer, resource.getId());
            StoreFactoryCacheSession.this.registerResourceInvalidation(resource.getId(), resource.getName(), resource.getType(), resource.getUris(), resource.getScopes().stream().map(Scope::getId).collect(Collectors.toSet()), resourceServer.getId(), resource.getOwner());
            if (cached == null) {
                cached = this.findById(resourceServer, resource.getId());
            }
            return cached;
        }

        public void delete(String id) {
            if (id == null) {
                return;
            }
            Resource resource = this.findById(null, id);
            if (resource == null) {
                return;
            }
            StoreFactoryCacheSession.this.cache.invalidateObject(id);
            StoreFactoryCacheSession.this.invalidationEvents.add(ResourceRemovedEvent.create(id, resource.getName(), resource.getType(), resource.getUris(), resource.getOwner(), resource.getScopes().stream().map(Scope::getId).collect(Collectors.toSet()), resource.getResourceServer().getId()));
            StoreFactoryCacheSession.this.cache.resourceRemoval(id, resource.getName(), resource.getType(), resource.getUris(), resource.getOwner(), resource.getScopes().stream().map(Scope::getId).collect(Collectors.toSet()), resource.getResourceServer().getId(), StoreFactoryCacheSession.this.invalidations);
            StoreFactoryCacheSession.this.getResourceStoreDelegate().delete(id);
        }

        public Resource findById(ResourceServer resourceServer, String id) {
            if (id == null) {
                return null;
            }
            CachedResource cached = StoreFactoryCacheSession.this.cache.get(id, CachedResource.class);
            if (cached != null) {
                logger.tracev("by id cache hit: {0}", (Object)cached.getId());
            }
            if (cached == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(id);
                if (!StoreFactoryCacheSession.this.modelMightExist(id)) {
                    return null;
                }
                Resource model = StoreFactoryCacheSession.this.getResourceStoreDelegate().findById(resourceServer, id);
                if (model == null) {
                    StoreFactoryCacheSession.this.setModelDoesNotExists(id, loaded);
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return model;
                }
                cached = new CachedResource(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(cached, StoreFactoryCacheSession.this.startupRevision);
            } else {
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return StoreFactoryCacheSession.this.getResourceStoreDelegate().findById(resourceServer, id);
                }
                if (StoreFactoryCacheSession.this.managedResources.containsKey(id)) {
                    return StoreFactoryCacheSession.this.managedResources.get(id);
                }
            }
            ResourceAdapter adapter = new ResourceAdapter(cached, StoreFactoryCacheSession.this);
            StoreFactoryCacheSession.this.managedResources.put(id, adapter);
            return adapter;
        }

        public Resource findByName(ResourceServer resourceServer, String name, String ownerId) {
            if (name == null) {
                return null;
            }
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getResourceByNameCacheKey(name, ownerId, resourceServerId);
            List result = this.cacheQuery(cacheKey, ResourceListQuery.class, () -> {
                Resource resource = StoreFactoryCacheSession.this.getResourceStoreDelegate().findByName(resourceServer, name, ownerId);
                if (resource == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(resource);
            }, (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(Resource::getId).collect(Collectors.toSet()), resourceServerId), resourceServer);
            if (result.isEmpty()) {
                return null;
            }
            return (Resource)result.get(0);
        }

        public List<Resource> findByOwner(ResourceServer resourceServer, String ownerId) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getResourceByOwnerCacheKey(ownerId, resourceServerId);
            return this.cacheQuery(cacheKey, ResourceListQuery.class, () -> StoreFactoryCacheSession.this.getResourceStoreDelegate().findByOwner(resourceServer, ownerId), (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(Resource::getId).collect(Collectors.toSet()), resourceServerId), resourceServer);
        }

        public void findByOwner(ResourceServer resourceServer, String ownerId, final Consumer<Resource> consumer) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getResourceByOwnerCacheKey(ownerId, resourceServerId);
            this.cacheQuery(cacheKey, ResourceListQuery.class, () -> {
                final ArrayList resources = new ArrayList();
                StoreFactoryCacheSession.this.getResourceStoreDelegate().findByOwner(resourceServer, ownerId, (Consumer)new Consumer<Resource>(){

                    @Override
                    public void accept(Resource resource) {
                        consumer.andThen(resources::add).andThen(StoreFactoryCacheSession.this::cacheResource).accept(resource);
                    }
                });
                return resources;
            }, (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(Resource::getId).collect(Collectors.toSet()), resourceServerId), resourceServer, consumer);
        }

        public List<Resource> findByResourceServer(ResourceServer resourceServer) {
            return StoreFactoryCacheSession.this.getResourceStoreDelegate().findByResourceServer(resourceServer);
        }

        public List<Resource> find(ResourceServer resourceServer, Map<Resource.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
            return StoreFactoryCacheSession.this.getResourceStoreDelegate().find(resourceServer, attributes, firstResult, maxResults);
        }

        public List<Resource> findByScopes(ResourceServer resourceServer, Set<Scope> scopes) {
            if (scopes == null) {
                return null;
            }
            ArrayList<Resource> result = new ArrayList<Resource>();
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            for (Scope scope : scopes) {
                String cacheKey = StoreFactoryCacheSession.getResourceByScopeCacheKey(scope.getId(), resourceServerId);
                result.addAll(this.cacheQuery(cacheKey, ResourceScopeListQuery.class, () -> StoreFactoryCacheSession.this.getResourceStoreDelegate().findByScopes(resourceServer, Collections.singleton(scope)), (revision, resources) -> new ResourceScopeListQuery((Long)revision, cacheKey, scope.getId(), resources.stream().map(Resource::getId).collect(Collectors.toSet()), resourceServerId), resourceServer));
            }
            return result;
        }

        public void findByScopes(ResourceServer resourceServer, Set<Scope> scopes, final Consumer<Resource> consumer) {
            if (scopes == null) {
                return;
            }
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            for (Scope scope : scopes) {
                String cacheKey = StoreFactoryCacheSession.getResourceByScopeCacheKey(scope.getId(), resourceServerId);
                this.cacheQuery(cacheKey, ResourceScopeListQuery.class, () -> {
                    final ArrayList resources = new ArrayList();
                    StoreFactoryCacheSession.this.getResourceStoreDelegate().findByScopes(resourceServer, Collections.singleton(scope), (Consumer)new Consumer<Resource>(){

                        @Override
                        public void accept(Resource resource) {
                            consumer.andThen(resources::add).andThen(StoreFactoryCacheSession.this::cacheResource).accept(resource);
                        }
                    });
                    return resources;
                }, (revision, resources) -> new ResourceScopeListQuery((Long)revision, cacheKey, scope.getId(), resources.stream().map(Resource::getId).collect(Collectors.toSet()), resourceServerId), resourceServer, consumer);
            }
        }

        public List<Resource> findByType(ResourceServer resourceServer, String type) {
            if (type == null) {
                return Collections.emptyList();
            }
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getResourceByTypeCacheKey(type, resourceServerId);
            return this.cacheQuery(cacheKey, ResourceListQuery.class, () -> StoreFactoryCacheSession.this.getResourceStoreDelegate().findByType(resourceServer, type), (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(Resource::getId).collect(Collectors.toSet()), resourceServerId), resourceServer);
        }

        public void findByType(ResourceServer resourceServer, String type, final Consumer<Resource> consumer) {
            if (type == null) {
                return;
            }
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getResourceByTypeCacheKey(type, resourceServerId);
            this.cacheQuery(cacheKey, ResourceListQuery.class, () -> {
                final ArrayList resources = new ArrayList();
                StoreFactoryCacheSession.this.getResourceStoreDelegate().findByType(resourceServer, type, (Consumer)new Consumer<Resource>(){

                    @Override
                    public void accept(Resource resource) {
                        consumer.andThen(resources::add).andThen(StoreFactoryCacheSession.this::cacheResource).accept(resource);
                    }
                });
                return resources;
            }, (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(Resource::getId).collect(Collectors.toSet()), resourceServerId), resourceServer, consumer);
        }

        public void findByType(ResourceServer resourceServer, String type, String owner, final Consumer<Resource> consumer) {
            if (type == null) {
                return;
            }
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getResourceByTypeCacheKey(type, owner, resourceServerId);
            this.cacheQuery(cacheKey, ResourceListQuery.class, () -> {
                final ArrayList resources = new ArrayList();
                StoreFactoryCacheSession.this.getResourceStoreDelegate().findByType(resourceServer, type, owner, (Consumer)new Consumer<Resource>(){

                    @Override
                    public void accept(Resource resource) {
                        consumer.andThen(resources::add).andThen(StoreFactoryCacheSession.this::cacheResource).accept(resource);
                    }
                });
                return resources;
            }, (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(Resource::getId).collect(Collectors.toSet()), resourceServerId), resourceServer, consumer);
        }

        public void findByTypeInstance(ResourceServer resourceServer, String type, final Consumer<Resource> consumer) {
            if (type == null) {
                return;
            }
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getResourceByTypeInstanceCacheKey(type, resourceServerId);
            this.cacheQuery(cacheKey, ResourceListQuery.class, () -> {
                final ArrayList resources = new ArrayList();
                StoreFactoryCacheSession.this.getResourceStoreDelegate().findByTypeInstance(resourceServer, type, (Consumer)new Consumer<Resource>(){

                    @Override
                    public void accept(Resource resource) {
                        consumer.andThen(resources::add).andThen(StoreFactoryCacheSession.this::cacheResource).accept(resource);
                    }
                });
                return resources;
            }, (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(Resource::getId).collect(Collectors.toSet()), resourceServerId), resourceServer, consumer);
        }

        private <R extends Resource, Q extends ResourceQuery> List<R> cacheQuery(String cacheKey, Class<Q> queryType, Supplier<List<R>> resultSupplier, BiFunction<Long, List<R>, Q> querySupplier, ResourceServer resourceServer, Consumer<R> consumer) {
            return this.cacheQuery(cacheKey, queryType, resultSupplier, querySupplier, resourceServer, consumer, false);
        }

        private <R extends Resource, Q extends ResourceQuery> List<R> cacheQuery(String cacheKey, Class<Q> queryType, Supplier<List<R>> resultSupplier, BiFunction<Long, List<R>, Q> querySupplier, ResourceServer resourceServer) {
            return this.cacheQuery(cacheKey, queryType, resultSupplier, querySupplier, resourceServer, null, true);
        }

        private <R extends Resource, Q extends ResourceQuery> List<R> cacheQuery(String cacheKey, Class<Q> queryType, Supplier<List<R>> resultSupplier, BiFunction<Long, List<R>, Q> querySupplier, ResourceServer resourceServer, Consumer<R> consumer, boolean cacheResult) {
            ResourceQuery query = (ResourceQuery)StoreFactoryCacheSession.this.cache.get(cacheKey, queryType);
            if (query != null) {
                logger.tracev("cache hit for key: {0}", (Object)cacheKey);
            }
            List<Object> model = Collections.emptyList();
            if (query == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(cacheKey);
                model = resultSupplier.get();
                if (model == null) {
                    return null;
                }
                if (!StoreFactoryCacheSession.this.invalidations.contains(cacheKey)) {
                    query = (ResourceQuery)querySupplier.apply(loaded, model);
                    StoreFactoryCacheSession.this.cache.addRevisioned(query, StoreFactoryCacheSession.this.startupRevision);
                }
            } else if (query.isInvalid(StoreFactoryCacheSession.this.invalidations)) {
                model = resultSupplier.get();
            } else {
                cacheResult = false;
                Set<String> resources = query.getResources();
                if (consumer != null) {
                    resources.stream().map(resourceId -> this.findById(resourceServer, (String)resourceId)).filter(Objects::nonNull).forEach(consumer);
                } else {
                    model = resources.stream().map(resourceId -> this.findById(resourceServer, (String)resourceId)).filter(Objects::nonNull).collect(Collectors.toList());
                }
            }
            if (cacheResult) {
                model.forEach(StoreFactoryCacheSession.this::cacheResource);
            }
            return model;
        }
    }

    protected class PolicyCache
    implements PolicyStore {
        protected PolicyCache() {
        }

        public Policy create(ResourceServer resourceServer, AbstractPolicyRepresentation representation) {
            Policy policy = StoreFactoryCacheSession.this.getPolicyStoreDelegate().create(resourceServer, representation);
            Policy cached = this.findById(resourceServer, policy.getId());
            StoreFactoryCacheSession.this.registerPolicyInvalidation(policy.getId(), representation.getName(), representation.getResources(), representation.getScopes(), null, resourceServer.getId());
            if (cached == null) {
                cached = this.findById(resourceServer, policy.getId());
            }
            return cached;
        }

        public void delete(String id) {
            if (id == null) {
                return;
            }
            Policy policy = this.findById(null, id);
            if (policy == null) {
                return;
            }
            StoreFactoryCacheSession.this.cache.invalidateObject(id);
            Set<String> resources = policy.getResources().stream().map(Resource::getId).collect(Collectors.toSet());
            ResourceServer resourceServer = policy.getResourceServer();
            Set<String> resourceTypes = StoreFactoryCacheSession.this.getResourceTypes(resources, resourceServer.getId());
            String defaultResourceType = (String)policy.getConfig().get("defaultResourceType");
            if (Objects.nonNull(defaultResourceType)) {
                resourceTypes.add(defaultResourceType);
            }
            Set<String> scopes = policy.getScopes().stream().map(Scope::getId).collect(Collectors.toSet());
            StoreFactoryCacheSession.this.invalidationEvents.add(PolicyRemovedEvent.create(id, policy.getName(), resources, resourceTypes, scopes, resourceServer.getId()));
            StoreFactoryCacheSession.this.cache.policyRemoval(id, policy.getName(), resources, resourceTypes, scopes, resourceServer.getId(), StoreFactoryCacheSession.this.invalidations);
            StoreFactoryCacheSession.this.getPolicyStoreDelegate().delete(id);
        }

        public Policy findById(ResourceServer resourceServer, String id) {
            if (id == null) {
                return null;
            }
            CachedPolicy cached = StoreFactoryCacheSession.this.cache.get(id, CachedPolicy.class);
            if (cached != null) {
                logger.tracev("by id cache hit: {0}", (Object)cached.getId());
            }
            if (cached == null) {
                if (!StoreFactoryCacheSession.this.modelMightExist(id)) {
                    return null;
                }
                Policy model = StoreFactoryCacheSession.this.getPolicyStoreDelegate().findById(resourceServer, id);
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(id);
                if (model == null) {
                    StoreFactoryCacheSession.this.setModelDoesNotExists(id, loaded);
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return model;
                }
                cached = new CachedPolicy(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(cached, StoreFactoryCacheSession.this.startupRevision);
            } else {
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findById(resourceServer, id);
                }
                if (StoreFactoryCacheSession.this.managedPolicies.containsKey(id)) {
                    return StoreFactoryCacheSession.this.managedPolicies.get(id);
                }
            }
            PolicyAdapter adapter = new PolicyAdapter(cached, StoreFactoryCacheSession.this);
            StoreFactoryCacheSession.this.managedPolicies.put(id, adapter);
            return adapter;
        }

        public Policy findByName(ResourceServer resourceServer, String name) {
            if (name == null) {
                return null;
            }
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getPolicyByNameCacheKey(name, resourceServerId);
            List result = this.cacheQuery(cacheKey, PolicyListQuery.class, () -> {
                Policy policy = StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByName(resourceServer, name);
                if (policy == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(policy);
            }, (revision, policies) -> new PolicyListQuery((Long)revision, cacheKey, policies.stream().map(Policy::getId).collect(Collectors.toSet()), resourceServerId), resourceServer);
            if (result.isEmpty()) {
                return null;
            }
            return (Policy)result.get(0);
        }

        public List<Policy> findByResourceServer(ResourceServer resourceServer) {
            return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByResourceServer(resourceServer);
        }

        public List<Policy> find(ResourceServer resourceServer, Map<Policy.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
            return StoreFactoryCacheSession.this.getPolicyStoreDelegate().find(resourceServer, attributes, firstResult, maxResults);
        }

        public List<Policy> findByResource(ResourceServer resourceServer, Resource resource) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getPolicyByResource(resource.getId(), resourceServerId);
            return this.cacheQuery(cacheKey, PolicyResourceListQuery.class, () -> StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByResource(resourceServer, resource), (revision, policies) -> new PolicyResourceListQuery((Long)revision, cacheKey, resource.getId(), policies.stream().map(Policy::getId).collect(Collectors.toSet()), resourceServerId), resourceServer);
        }

        public void findByResource(ResourceServer resourceServer, Resource resource, final Consumer<Policy> consumer) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getPolicyByResource(resource.getId(), resourceServerId);
            this.cacheQuery(cacheKey, PolicyResourceListQuery.class, () -> {
                final ArrayList policies = new ArrayList();
                StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByResource(resourceServer, resource, (Consumer)new Consumer<Policy>(){

                    @Override
                    public void accept(Policy policy) {
                        consumer.andThen(policies::add).andThen(StoreFactoryCacheSession.this::cachePolicy).accept(policy);
                    }
                });
                return policies;
            }, (revision, policies) -> new PolicyResourceListQuery((Long)revision, cacheKey, resource.getId(), policies.stream().map(Policy::getId).collect(Collectors.toSet()), resourceServerId), resourceServer, consumer);
        }

        public List<Policy> findByResourceType(ResourceServer resourceServer, String resourceType) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getPolicyByResourceType(resourceType, resourceServerId);
            return this.cacheQuery(cacheKey, PolicyResourceListQuery.class, () -> StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByResourceType(resourceServer, resourceType), (revision, policies) -> new PolicyResourceListQuery((Long)revision, cacheKey, resourceType, policies.stream().map(Policy::getId).collect(Collectors.toSet()), resourceServerId), resourceServer);
        }

        public void findByResourceType(ResourceServer resourceServer, String resourceType, final Consumer<Policy> consumer) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getPolicyByResourceType(resourceType, resourceServerId);
            this.cacheQuery(cacheKey, PolicyResourceListQuery.class, () -> {
                final ArrayList policies = new ArrayList();
                StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByResourceType(resourceServer, resourceType, (Consumer)new Consumer<Policy>(){

                    @Override
                    public void accept(Policy policy) {
                        consumer.andThen(policies::add).andThen(StoreFactoryCacheSession.this::cachePolicy).accept(policy);
                    }
                });
                return policies;
            }, (revision, policies) -> new PolicyResourceListQuery((Long)revision, cacheKey, resourceType, policies.stream().map(Policy::getId).collect(Collectors.toSet()), resourceServerId), resourceServer, consumer);
        }

        public List<Policy> findByScopes(ResourceServer resourceServer, List<Scope> scopes) {
            if (scopes == null) {
                return null;
            }
            HashSet result = new HashSet();
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            for (Scope scope : scopes) {
                String cacheKey = StoreFactoryCacheSession.getPolicyByScope(scope.getId(), resourceServerId);
                result.addAll(this.cacheQuery(cacheKey, PolicyScopeListQuery.class, () -> StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByScopes(resourceServer, Collections.singletonList(scope)), (revision, resources) -> new PolicyScopeListQuery((Long)revision, cacheKey, scope.getId(), resources.stream().map(resource -> resource.getId()).collect(Collectors.toSet()), resourceServerId), resourceServer));
            }
            return new ArrayList<Policy>(result);
        }

        public List<Policy> findByScopes(ResourceServer resourceServer, Resource resource, List<Scope> scopes) {
            if (scopes == null) {
                return null;
            }
            HashSet result = new HashSet();
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            for (Scope scope : scopes) {
                String cacheKey = StoreFactoryCacheSession.getPolicyByResourceScope(scope.getId(), resource == null ? null : resource.getId(), resourceServerId);
                result.addAll(this.cacheQuery(cacheKey, PolicyScopeListQuery.class, () -> StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByScopes(resourceServer, resource, Collections.singletonList(scope)), (revision, resources) -> new PolicyScopeListQuery((Long)revision, cacheKey, scope.getId(), resources.stream().map(Policy::getId).collect(Collectors.toSet()), resourceServerId), resourceServer));
            }
            return new ArrayList<Policy>(result);
        }

        public void findByScopes(ResourceServer resourceServer, Resource resource, List<Scope> scopes, Consumer<Policy> consumer) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String resourceId = resource == null ? null : resource.getId();
            for (Scope scope : scopes) {
                String cacheKey = StoreFactoryCacheSession.getPolicyByResourceScope(scope.getId(), resourceId, resourceServerId);
                this.cacheQuery(cacheKey, PolicyScopeListQuery.class, () -> {
                    ArrayList policies = new ArrayList();
                    StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByScopes(resourceServer, resource, Collections.singletonList(scope), policy -> consumer.andThen(policies::add).andThen(StoreFactoryCacheSession.this::cachePolicy).accept((Policy)policy));
                    return policies;
                }, (revision, resources) -> new PolicyScopeListQuery((Long)revision, cacheKey, scope.getId(), resources.stream().map(Policy::getId).collect(Collectors.toSet()), resourceServerId), resourceServer, consumer);
            }
        }

        public List<Policy> findByType(ResourceServer resourceServer, String type) {
            return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByType(resourceServer, type);
        }

        public List<Policy> findDependentPolicies(ResourceServer resourceServer, String id) {
            return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findDependentPolicies(resourceServer, id);
        }

        public Stream<Policy> findDependentPolicies(ResourceServer resourceServer, String resourceType, String associatedPolicyType, String configKey, String configValue) {
            return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findDependentPolicies(resourceServer, resourceType, associatedPolicyType, configKey, configValue);
        }

        public Stream<Policy> findDependentPolicies(ResourceServer resourceServer, String resourceType, String associatedPolicyType, String configKey, List<String> configValue) {
            return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findDependentPolicies(resourceServer, resourceType, associatedPolicyType, configKey, configValue);
        }

        private <R extends Policy, Q extends PolicyQuery> List<R> cacheQuery(String cacheKey, Class<Q> queryType, Supplier<List<R>> resultSupplier, BiFunction<Long, List<R>, Q> querySupplier, ResourceServer resourceServer) {
            return this.cacheQuery(cacheKey, queryType, resultSupplier, querySupplier, resourceServer, null, true);
        }

        private <R extends Policy, Q extends PolicyQuery> List<R> cacheQuery(String cacheKey, Class<Q> queryType, Supplier<List<R>> resultSupplier, BiFunction<Long, List<R>, Q> querySupplier, ResourceServer resourceServer, Consumer<R> consumer) {
            return this.cacheQuery(cacheKey, queryType, resultSupplier, querySupplier, resourceServer, consumer, false);
        }

        private <R extends Policy, Q extends PolicyQuery> List<R> cacheQuery(String cacheKey, Class<Q> queryType, Supplier<List<R>> resultSupplier, BiFunction<Long, List<R>, Q> querySupplier, ResourceServer resourceServer, Consumer<R> consumer, boolean cacheResults) {
            PolicyQuery query = (PolicyQuery)StoreFactoryCacheSession.this.cache.get(cacheKey, queryType);
            if (query != null) {
                logger.tracev("cache hit for key: {0}", (Object)cacheKey);
            }
            List<Object> model = Collections.emptyList();
            if (query == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(cacheKey);
                model = resultSupplier.get();
                if (model == null) {
                    return null;
                }
                if (!StoreFactoryCacheSession.this.invalidations.contains(cacheKey)) {
                    query = (PolicyQuery)querySupplier.apply(loaded, model);
                    StoreFactoryCacheSession.this.cache.addRevisioned(query, StoreFactoryCacheSession.this.startupRevision);
                }
            } else if (query.isInvalid(StoreFactoryCacheSession.this.invalidations)) {
                model = resultSupplier.get();
            } else {
                cacheResults = false;
                Set<String> policies = query.getPolicies();
                if (consumer != null) {
                    for (String id : policies) {
                        consumer.accept(this.findById(resourceServer, id));
                    }
                } else {
                    model = policies.stream().map(resourceId -> this.findById(resourceServer, (String)resourceId)).filter(Objects::nonNull).collect(Collectors.toList());
                }
            }
            if (cacheResults) {
                model.forEach(StoreFactoryCacheSession.this::cachePolicy);
            }
            return model;
        }
    }

    protected class PermissionTicketCache
    implements PermissionTicketStore {
        protected PermissionTicketCache() {
        }

        public long count(ResourceServer resourceServer, Map<PermissionTicket.FilterOption, String> attributes) {
            return StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().count(resourceServer, attributes);
        }

        public PermissionTicket create(ResourceServer resourceServer, Resource resource, Scope scope, String requester) {
            PermissionTicket created = StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().create(resourceServer, resource, scope, requester);
            StoreFactoryCacheSession.this.registerPermissionTicketInvalidation(created.getId(), created.getOwner(), created.getRequester(), created.getResource().getId(), created.getResource().getName(), scope == null ? null : scope.getId(), created.getResourceServer().getId());
            return created;
        }

        public void delete(String id) {
            if (id == null) {
                return;
            }
            PermissionTicket permission = this.findById(null, id);
            if (permission == null) {
                return;
            }
            StoreFactoryCacheSession.this.cache.invalidateObject(id);
            String scopeId = null;
            if (permission.getScope() != null) {
                scopeId = permission.getScope().getId();
            }
            StoreFactoryCacheSession.this.invalidationEvents.add(PermissionTicketRemovedEvent.create(id, permission.getOwner(), permission.getRequester(), permission.getResource().getId(), permission.getResource().getName(), scopeId, permission.getResourceServer().getId()));
            StoreFactoryCacheSession.this.cache.permissionTicketRemoval(id, permission.getOwner(), permission.getRequester(), permission.getResource().getId(), permission.getResource().getName(), scopeId, permission.getResourceServer().getId(), StoreFactoryCacheSession.this.invalidations);
            StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().delete(id);
            UserManagedPermissionUtil.removePolicy((PermissionTicket)permission, (StoreFactory)StoreFactoryCacheSession.this);
        }

        public PermissionTicket findById(ResourceServer resourceServer, String id) {
            if (id == null) {
                return null;
            }
            CachedPermissionTicket cached = StoreFactoryCacheSession.this.cache.get(id, CachedPermissionTicket.class);
            if (cached != null) {
                logger.tracev("by id cache hit: {0}", (Object)cached.getId());
            }
            if (cached == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(id);
                if (!StoreFactoryCacheSession.this.modelMightExist(id)) {
                    return null;
                }
                PermissionTicket model = StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().findById(resourceServer, id);
                if (model == null) {
                    StoreFactoryCacheSession.this.setModelDoesNotExists(id, loaded);
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return model;
                }
                cached = new CachedPermissionTicket(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(cached, StoreFactoryCacheSession.this.startupRevision);
            } else {
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().findById(resourceServer, id);
                }
                if (StoreFactoryCacheSession.this.managedPermissionTickets.containsKey(id)) {
                    return StoreFactoryCacheSession.this.managedPermissionTickets.get(id);
                }
            }
            PermissionTicketAdapter adapter = new PermissionTicketAdapter(cached, StoreFactoryCacheSession.this);
            StoreFactoryCacheSession.this.managedPermissionTickets.put(id, adapter);
            return adapter;
        }

        public List<PermissionTicket> findByResource(ResourceServer resourceServer, Resource resource) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getPermissionTicketByResource(resource.getId(), resourceServerId);
            return this.cacheQuery(cacheKey, PermissionTicketResourceListQuery.class, () -> StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().findByResource(resourceServer, resource), (revision, permissions) -> new PermissionTicketResourceListQuery((Long)revision, cacheKey, resource.getId(), permissions.stream().map(PermissionTicket::getId).collect(Collectors.toSet()), resourceServerId), resourceServer);
        }

        public List<PermissionTicket> findByScope(ResourceServer resourceServer, Scope scope) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getPermissionTicketByScope(scope.getId(), resourceServerId);
            return this.cacheQuery(cacheKey, PermissionTicketScopeListQuery.class, () -> StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().findByScope(resourceServer, scope), (revision, permissions) -> new PermissionTicketScopeListQuery((Long)revision, cacheKey, scope.getId(), permissions.stream().map(PermissionTicket::getId).collect(Collectors.toSet()), resourceServerId), resourceServer);
        }

        public List<PermissionTicket> find(ResourceServer resourceServer, Map<PermissionTicket.FilterOption, String> attributes, Integer firstResult, Integer maxResult) {
            return StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().find(resourceServer, attributes, firstResult, maxResult);
        }

        public List<PermissionTicket> findGranted(ResourceServer resourceServer, String userId) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getPermissionTicketByGranted(userId, resourceServerId);
            return this.cacheQuery(cacheKey, PermissionTicketListQuery.class, () -> StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().findGranted(resourceServer, userId), (revision, permissions) -> new PermissionTicketListQuery((Long)revision, cacheKey, permissions.stream().map(PermissionTicket::getId).collect(Collectors.toSet()), resourceServerId), resourceServer);
        }

        public List<PermissionTicket> findGranted(ResourceServer resourceServer, String resourceName, String userId) {
            String resourceServerId = resourceServer == null ? null : resourceServer.getId();
            String cacheKey = StoreFactoryCacheSession.getPermissionTicketByResourceNameAndGranted(resourceName, userId, resourceServerId);
            return this.cacheQuery(cacheKey, PermissionTicketListQuery.class, () -> StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().findGranted(resourceServer, resourceName, userId), (revision, permissions) -> new PermissionTicketResourceListQuery((Long)revision, cacheKey, resourceName, permissions.stream().map(PermissionTicket::getId).collect(Collectors.toSet()), resourceServerId), resourceServer);
        }

        public List<Resource> findGrantedResources(String requester, String name, Integer first, Integer max) {
            return StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().findGrantedResources(requester, name, first, max);
        }

        public List<Resource> findGrantedOwnerResources(String owner, Integer firstResult, Integer maxResults) {
            return StoreFactoryCacheSession.this.getPermissionTicketStoreDelegate().findGrantedOwnerResources(owner, firstResult, maxResults);
        }

        private <R, Q extends PermissionTicketQuery> List<R> cacheQuery(String cacheKey, Class<Q> queryType, Supplier<List<R>> resultSupplier, BiFunction<Long, List<R>, Q> querySupplier, ResourceServer resourceServer) {
            PermissionTicketQuery query = (PermissionTicketQuery)StoreFactoryCacheSession.this.cache.get(cacheKey, queryType);
            if (query != null) {
                logger.tracev("cache hit for key: {0}", (Object)cacheKey);
            }
            if (query == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(cacheKey);
                List<R> model = resultSupplier.get();
                if (model == null) {
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(cacheKey)) {
                    return model;
                }
                query = (PermissionTicketQuery)querySupplier.apply(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(query, StoreFactoryCacheSession.this.startupRevision);
                return model;
            }
            if (query.isInvalid(StoreFactoryCacheSession.this.invalidations)) {
                return resultSupplier.get();
            }
            return query.getPermissions().stream().map(resourceId -> this.findById(resourceServer, (String)resourceId)).collect(Collectors.toList());
        }
    }
}

