/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinator;
import org.hibernate.sql.model.ModelMutationLogging;

public abstract class AbstractUpdateRowsCoordinator
implements UpdateRowsCoordinator {
    private final CollectionMutationTarget mutationTarget;
    private final SessionFactoryImplementor sessionFactory;
    protected final MutationExecutorService mutationExecutorService;

    public AbstractUpdateRowsCoordinator(CollectionMutationTarget mutationTarget, SessionFactoryImplementor sessionFactory) {
        this.mutationTarget = mutationTarget;
        this.sessionFactory = sessionFactory;
        this.mutationExecutorService = sessionFactory.getServiceRegistry().getService(MutationExecutorService.class);
    }

    public String toString() {
        return "UpdateRowsCoordinator(" + this.getMutationTarget().getRolePath() + ")";
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public void updateRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Updating collection rows - %s#%s", (Object)this.mutationTarget.getRolePath(), key);
        int count = this.doUpdate(key, collection, session);
        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Updated %s collection rows - %s#%s", count, (Object)this.mutationTarget.getRolePath(), key);
    }

    protected abstract int doUpdate(Object var1, PersistentCollection<?> var2, SharedSessionContractImplementor var3);
}

