/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene103.blocktree;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.lucene103.blocktree.FieldReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.internal.hppc.IntCursor;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.FileTypeHint;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public final class Lucene103BlockTreeTermsReader
extends FieldsProducer {
    static final String TERMS_EXTENSION = "tim";
    static final String TERMS_CODEC_NAME = "BlockTreeTermsDict";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    static final String TERMS_INDEX_EXTENSION = "tip";
    static final String TERMS_INDEX_CODEC_NAME = "BlockTreeTermsIndex";
    static final String TERMS_META_EXTENSION = "tmd";
    static final String TERMS_META_CODEC_NAME = "BlockTreeTermsMeta";
    final IndexInput termsIn;
    final IndexInput indexIn;
    final PostingsReaderBase postingsReader;
    private final FieldInfos fieldInfos;
    private final IntObjectHashMap<FieldReader> fieldMap;
    private final List<String> fieldList;
    final String segment;
    final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene103BlockTreeTermsReader(PostingsReaderBase postingsReader, SegmentReadState state) throws IOException {
        boolean success = false;
        this.postingsReader = postingsReader;
        this.segment = state.segmentInfo.name;
        try {
            long termsLength;
            long indexLength;
            IntObjectHashMap<FieldReader> fieldMap;
            block27: {
                String termsName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_EXTENSION);
                this.termsIn = state.directory.openInput(termsName, state.context.withHints(FileTypeHint.DATA));
                this.version = CodecUtil.checkIndexHeader(this.termsIn, TERMS_CODEC_NAME, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                String indexName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_INDEX_EXTENSION);
                this.indexIn = state.directory.openInput(indexName, state.context.withHints(FileTypeHint.INDEX));
                CodecUtil.checkIndexHeader(this.indexIn, TERMS_INDEX_CODEC_NAME, this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                String metaName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_META_EXTENSION);
                fieldMap = null;
                Throwable priorE = null;
                indexLength = -1L;
                termsLength = -1L;
                try (ChecksumIndexInput metaIn = state.directory.openChecksumInput(metaName);){
                    block26: {
                        try {
                            CodecUtil.checkIndexHeader(metaIn, TERMS_META_CODEC_NAME, this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                            postingsReader.init(metaIn, state);
                            int numFields = metaIn.readVInt();
                            if (numFields < 0) {
                                throw new CorruptIndexException("invalid numFields: " + numFields, metaIn);
                            }
                            fieldMap = new IntObjectHashMap<FieldReader>(numFields);
                            for (int i = 0; i < numFields; ++i) {
                                int field = metaIn.readVInt();
                                long numTerms = metaIn.readVLong();
                                if (numTerms <= 0L) {
                                    throw new CorruptIndexException("Illegal numTerms for field number: " + field, metaIn);
                                }
                                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                                if (fieldInfo == null) {
                                    throw new CorruptIndexException("invalid field number: " + field, metaIn);
                                }
                                long sumTotalTermFreq = metaIn.readVLong();
                                long sumDocFreq = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? sumTotalTermFreq : metaIn.readVLong();
                                int docCount = metaIn.readVInt();
                                BytesRef minTerm = Lucene103BlockTreeTermsReader.readBytesRef(metaIn);
                                BytesRef maxTerm = Lucene103BlockTreeTermsReader.readBytesRef(metaIn);
                                if (numTerms == 1L) {
                                    assert (maxTerm.equals(minTerm));
                                    maxTerm = minTerm;
                                }
                                if (docCount < 0 || docCount > state.segmentInfo.maxDoc()) {
                                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + state.segmentInfo.maxDoc(), metaIn);
                                }
                                if (sumDocFreq < (long)docCount) {
                                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount, metaIn);
                                }
                                if (sumTotalTermFreq < sumDocFreq) {
                                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq, metaIn);
                                }
                                FieldReader previous = fieldMap.put(fieldInfo.number, new FieldReader(this, fieldInfo, numTerms, sumTotalTermFreq, sumDocFreq, docCount, metaIn, this.indexIn, minTerm, maxTerm));
                                if (previous == null) continue;
                                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, metaIn);
                            }
                            indexLength = metaIn.readLong();
                            termsLength = metaIn.readLong();
                            if (metaIn == null) break block26;
                        }
                        catch (Throwable exception) {
                            try {
                                priorE = exception;
                                break block27;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (metaIn != null) {
                                    CodecUtil.checkFooter(metaIn, priorE);
                                } else if (priorE != null) {
                                    IOUtils.rethrowAlways(priorE);
                                }
                            }
                        }
                        CodecUtil.checkFooter(metaIn, priorE);
                        break block27;
                    }
                    if (priorE != null) {
                        IOUtils.rethrowAlways(priorE);
                    }
                }
            }
            CodecUtil.retrieveChecksum(this.indexIn, indexLength);
            CodecUtil.retrieveChecksum(this.termsIn, termsLength);
            this.fieldInfos = state.fieldInfos;
            this.fieldMap = fieldMap;
            this.fieldList = Lucene103BlockTreeTermsReader.sortFieldNames(fieldMap, state.fieldInfos);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(new Closeable[]{this});
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        int numBytes = in.readVInt();
        if (numBytes < 0) {
            throw new CorruptIndexException("invalid bytes length: " + numBytes, in);
        }
        BytesRef bytes = new BytesRef(numBytes);
        bytes.length = numBytes;
        in.readBytes(bytes.bytes, 0, numBytes);
        return bytes;
    }

    private static List<String> sortFieldNames(IntObjectHashMap<FieldReader> fieldMap, FieldInfos fieldInfos) {
        ArrayList<String> fieldNames = new ArrayList<String>(fieldMap.size());
        for (IntCursor fieldNumber : fieldMap.keys()) {
            fieldNames.add(fieldInfos.fieldInfo((int)fieldNumber.value).name);
        }
        fieldNames.sort(null);
        return Collections.unmodifiableList(fieldNames);
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.indexIn, this.termsIn, this.postingsReader);
        }
        finally {
            this.fieldMap.clear();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.fieldList.iterator();
    }

    @Override
    public Terms terms(String field) throws IOException {
        assert (field != null);
        FieldInfo fieldInfo = this.fieldInfos.fieldInfo(field);
        return fieldInfo == null ? null : (Terms)this.fieldMap.get(fieldInfo.number);
    }

    @Override
    public int size() {
        return this.fieldMap.size();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.indexIn);
        CodecUtil.checksumEntireFile(this.termsIn);
        this.postingsReader.checkIntegrity();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fieldMap.size() + ",delegate=" + String.valueOf(this.postingsReader) + ")";
    }
}

