/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VpcAttributeName {
    ENABLE_DNS_SUPPORT("enableDnsSupport"),
    ENABLE_DNS_HOSTNAMES("enableDnsHostnames"),
    ENABLE_NETWORK_ADDRESS_USAGE_METRICS("enableNetworkAddressUsageMetrics"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VpcAttributeName> VALUE_MAP;
    private final String value;

    private VpcAttributeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VpcAttributeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VpcAttributeName> knownValues() {
        EnumSet<VpcAttributeName> knownValues = EnumSet.allOf(VpcAttributeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VpcAttributeName.class, VpcAttributeName::toString);
    }
}

