/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLOntologyIRIChanger {
    @Nonnull
    private final OWLOntologyManager owlOntologyManager;

    public OWLOntologyIRIChanger(@Nonnull OWLOntologyManager owlOntologyManager) {
        this.owlOntologyManager = OWLAPIPreconditions.checkNotNull(owlOntologyManager, "owlOntologyManager cannot be null");
    }

    @Nonnull
    public List<OWLOntologyChange> getChanges(@Nonnull OWLOntology ontology, @Nonnull IRI newIRI) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.add(new SetOntologyID(ontology, new OWLOntologyID(newIRI, (IRI)ontology.getOntologyID().getVersionIRI().orNull())));
        for (OWLOntology ont : this.owlOntologyManager.getOntologies()) {
            assert (ont != null);
            for (OWLImportsDeclaration decl : ont.getImportsDeclarations()) {
                if (!decl.getIRI().equals(ontology.getOntologyID().getOntologyIRI().get())) continue;
                changes.add(new RemoveImport(ont, decl));
                changes.add(new AddImport(ont, this.owlOntologyManager.getOWLDataFactory().getOWLImportsDeclaration(newIRI)));
            }
        }
        return changes;
    }
}

