/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.owl.ui.prefix.PrefixMapping;
import org.protege.editor.owl.ui.prefix.PrefixMappingEditorView;

public class PrefixMappingEditor {
    @Nonnull
    private final PrefixMappingEditorView view;

    public PrefixMappingEditor(@Nonnull PrefixMappingEditorView view) {
        this.view = (PrefixMappingEditorView)Preconditions.checkNotNull((Object)view);
        this.view.setPrefixNameChangedHandler(() -> {});
    }

    public PrefixMappingEditorView asJComponent() {
        return this.view.asJComponent();
    }

    public void clear() {
        this.view.clear();
    }

    public void setPrefixMapping(@Nonnull PrefixMapping prefixMapping) {
        this.view.setPrefixName(prefixMapping.getPrefixName());
        this.view.setPrefix(prefixMapping.getPrefix());
    }

    public Optional<PrefixMapping> getPrefixMapping() {
        String prefix;
        Object prefixName = this.view.getPrefixName().replace(" ", "");
        if (!((String)prefixName).endsWith(":")) {
            prefixName = (String)prefixName + ":";
        }
        if ((prefix = this.view.getPrefix().replace(" ", "")).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(PrefixMapping.get((String)prefixName, prefix));
    }
}

