/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.util;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.ui.util.SuggestOracle;
import org.protege.editor.owl.ui.util.SuggestionToString;

public class SuggestField<T>
extends JComponent {
    private static final int POPUP_WIDTH = 300;
    private static final int POPUP_HEIGHT = 150;
    private final JTextField textField;
    private final JList<T> suggestList = new JList();
    @Nonnull
    private SuggestOracle<T> suggestOracle = query -> Stream.empty();
    @Nonnull
    private SuggestionToString<T> suggestionToString = Object::toString;
    private JWindow window;
    private boolean completing = false;
    private ChangeListener changeListener = event -> {};

    public SuggestField(@Nonnull String placeholderText) {
        this.textField = new AugmentedJTextField(placeholderText);
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "North");
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SuggestField.this.processKeyPressed(e);
            }
        };
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SuggestField.this.hidePopupWindow();
            }
        });
        this.suggestList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SuggestField.this.completeWithPopupSelection();
                }
            }
        });
        this.textField.addKeyListener(keyListener);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SuggestField.this.handleDocumentChanged(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SuggestField.this.handleDocumentChanged(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    @Nonnull
    public String getText() {
        return this.textField.getText();
    }

    public void setChangeListener(@Nonnull ChangeListener changeListener) {
        this.changeListener = (ChangeListener)Preconditions.checkNotNull((Object)changeListener);
    }

    public void setSuggestOracle(@Nonnull SuggestOracle<T> suggestOracle) {
        this.suggestOracle = (SuggestOracle)Preconditions.checkNotNull(suggestOracle);
    }

    public void setSuggestionToString(@Nonnull SuggestionToString<T> suggestionToString) {
        this.suggestionToString = (SuggestionToString)Preconditions.checkNotNull(suggestionToString);
    }

    public void setRenderer(@Nonnull ListCellRenderer<T> renderer) {
        this.suggestList.setCellRenderer((ListCellRenderer)Preconditions.checkNotNull(renderer));
    }

    private void handleDocumentChanged(DocumentEvent e) {
        this.changeListener.stateChanged(new ChangeEvent(this));
        if (this.completing) {
            return;
        }
        String enteredText = this.textField.getText();
        if (enteredText.isEmpty()) {
            this.hidePopupWindow();
            return;
        }
        Vector matchedLangCodes = this.suggestOracle.getMatches(enteredText).collect(Collectors.toCollection(Vector::new));
        this.suggestList.setListData(matchedLangCodes);
        if (!matchedLangCodes.isEmpty()) {
            this.showPopupWindow();
        }
    }

    private void hidePopupWindow() {
        this.getPopupWindow().ifPresent(w -> w.setVisible(false));
    }

    private void showPopupWindow() {
        Optional<JWindow> popupWindow = this.getPopupWindow();
        popupWindow.ifPresent(w -> {
            Point location = new Point(0, 0);
            SwingUtilities.convertPointToScreen(location, this);
            location.y = location.y + this.getHeight() + 2;
            w.setLocation(location);
            w.setVisible(true);
        });
    }

    private void processKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            e.consume();
            this.completeWithPopupSelection();
        } else if (e.getKeyCode() == 10) {
            this.getPopupWindow().ifPresent(w -> {
                e.consume();
                this.completeWithPopupSelection();
            });
        } else if (e.getKeyCode() == 40) {
            this.getPopupWindow().ifPresent(w -> {
                e.consume();
                this.incrementSelection();
            });
        } else if (e.getKeyCode() == 38) {
            this.getPopupWindow().ifPresent(w -> {
                e.consume();
                this.decrementSelection();
            });
        }
    }

    private void completeWithPopupSelection() {
        try {
            this.completing = true;
            this.hidePopupWindow();
            T sel = this.suggestList.getSelectedValue();
            if (sel == null) {
                return;
            }
            this.textField.setText(this.suggestionToString.toString(sel));
        }
        finally {
            this.completing = false;
        }
    }

    @Nonnull
    private Optional<JWindow> getPopupWindow() {
        if (this.window != null) {
            return Optional.of(this.window);
        }
        Window topLevelAncestor = (Window)this.textField.getTopLevelAncestor();
        if (topLevelAncestor == null) {
            return Optional.empty();
        }
        this.window = new JWindow(topLevelAncestor);
        this.window.setFocusableWindowState(false);
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().add(ComponentFactory.createScrollPane(this.suggestList));
        this.window.setSize(new Dimension(300, 150));
        return Optional.of(this.window);
    }

    private void incrementSelection() {
        int size = this.suggestList.getModel().getSize();
        if (size == 0) {
            return;
        }
        int selIndex = this.suggestList.getSelectedIndex() + 1;
        if (selIndex >= size) {
            selIndex = size - 1;
        }
        this.suggestList.setSelectedIndex(selIndex);
        this.suggestList.scrollRectToVisible(this.suggestList.getCellBounds(selIndex, selIndex));
    }

    private void decrementSelection() {
        int size = this.suggestList.getModel().getSize();
        if (size == 0) {
            return;
        }
        int selIndex = this.suggestList.getSelectedIndex() - 1;
        if (selIndex < 0) {
            selIndex = 0;
        }
        this.suggestList.setSelectedIndex(selIndex);
        this.suggestList.scrollRectToVisible(this.suggestList.getCellBounds(selIndex, selIndex));
    }

    public void clear() {
        this.textField.setText("");
        this.hidePopupWindow();
    }

    public void setText(@Nonnull String langCode) {
        this.textField.setText(langCode);
    }
}

