/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;

public class Effect
extends FreeColSpecObjectType {
    public static final String TAG = "effect";
    public static final String DAMAGED_UNIT = "model.disaster.effect.damagedUnit";
    public static final String LOSS_OF_UNIT = "model.disaster.effect.lossOfUnit";
    public static final String LOSS_OF_MONEY = "model.disaster.effect.lossOfMoney";
    public static final String LOSS_OF_GOODS = "model.disaster.effect.lossOfGoods";
    public static final String LOSS_OF_TILE_PRODUCTION = "model.disaster.effect.lossOfTileProduction";
    public static final String LOSS_OF_BUILDING = "model.disaster.effect.lossOfBuilding";
    public static final String LOSS_OF_BUILDING_PRODUCTION = "model.disaster.effect.lossOfBuildingProduction";
    private int probability;
    private static final String PROBABILITY_TAG = "probability";

    protected Effect() {
    }

    public Effect(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this.setSpecification(specification);
        this.readFromXML(xr);
    }

    public Effect(Effect template) {
        this.setId(template.getId());
        this.setSpecification(template.getSpecification());
        this.probability = template.probability;
        this.copyScopes(template.getScopeList());
        this.addFeatures(template);
    }

    public final int getProbability() {
        return this.probability;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Effect o = this.copyInCast(other, Effect.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.probability = o.getProbability();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(PROBABILITY_TAG, this.probability);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.probability = xr.getAttribute(PROBABILITY_TAG, 0);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append('[').append(this.getId()).append(" probability=").append(this.probability).append('%');
        for (Scope scope : this.getScopeList()) {
            sb.append(' ').append(scope);
        }
        sb.append(']');
        return sb.toString();
    }
}

