/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.EventQueue;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JFilterableComboBox<V>
extends JComboBox<V> {
    private static final long serialVersionUID = 1L;
    private final Supplier<Stream<V>> itemSupplier;
    private boolean filterIsRunning;
    private Predicate<String> acceptAll;
    private BiPredicate<V, String> acceptItem;
    private BiPredicate<V, String> selectItem;

    public JFilterableComboBox(Supplier<Stream<V>> itemSupplier, Predicate<String> acceptAll, BiPredicate<V, String> acceptItem, BiPredicate<V, String> selectItem) {
        this.itemSupplier = itemSupplier;
        this.acceptAll = acceptAll;
        this.acceptItem = acceptItem;
        this.selectItem = selectItem;
        final Timer timer = new Timer(200, x -> this.updateListItems(false));
        timer.setRepeats(false);
        final DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateList();
            }

            private void updateList() {
                if (!JFilterableComboBox.this.filterIsRunning) {
                    JFilterableComboBox.this.resetSelectedItem();
                    timer.restart();
                }
            }
        };
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JFilterableComboBox.this.resetSelectedItem();
                JFilterableComboBox.this.updateListItems(false);
                JTextField textField = (JTextField)JFilterableComboBox.this.getEditor().getEditorComponent();
                textField.getDocument().addDocumentListener(documentListener);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JTextField textField = (JTextField)JFilterableComboBox.this.getEditor().getEditorComponent();
                textField.getDocument().removeDocumentListener(documentListener);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!JFilterableComboBox.this.isPopupVisible()) {
                    EventQueue.invokeLater(this::showPopup);
                }
            }

            private void showPopup() {
                if (JFilterableComboBox.this.isShowing()) {
                    JFilterableComboBox.this.showPopup();
                }
            }
        });
    }

    @Override
    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        if (!this.filterIsRunning) {
            super.configureEditor(anEditor, anItem);
        }
    }

    public boolean isFilterRunning() {
        return this.filterIsRunning;
    }

    private void resetSelectedItem() {
        if (this.filterIsRunning) {
            return;
        }
        this.filterIsRunning = true;
        this.setSelectedItem(null);
        this.filterIsRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListItems(boolean init) {
        if (this.filterIsRunning) {
            return;
        }
        this.filterIsRunning = true;
        ((DefaultComboBoxModel)this.getModel()).removeAllElements();
        try {
            ComboBoxModel model = this.getModel();
            JTextField textField = (JTextField)this.getEditor().getEditorComponent();
            String text = textField.getText();
            Stream<V> tagStream = this.itemSupplier.get();
            Stream<V> addedItems = init || this.acceptAll.test(text) ? tagStream : tagStream.filter(item -> this.acceptItem.test(item, text));
            AtomicInteger index = new AtomicInteger(-1);
            addedItems.forEach(arg_0 -> this.lambda$updateListItems$2((DefaultComboBoxModel)model, index, text, arg_0));
            int firstMatchingIndex = index.get();
            if (firstMatchingIndex >= 0) {
                this.setSelectedIndex(firstMatchingIndex);
            }
        }
        finally {
            this.filterIsRunning = false;
        }
    }

    @Override
    public DefaultComboBoxModel<V> getModel() {
        return (DefaultComboBoxModel)super.getModel();
    }

    private /* synthetic */ void lambda$updateListItems$2(DefaultComboBoxModel model, AtomicInteger index, String text, Object item) {
        model.addElement(item);
        if (index.get() == -1 && this.selectItem.test(item, text)) {
            index.set(model.getSize() - 1);
        }
    }
}

