/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Table;
import generic.End;
import ghidra.util.database.AbstractDirectedRecordIterator;
import ghidra.util.database.BackwardRecordIterator;
import ghidra.util.database.DirectedIterator;
import ghidra.util.database.FieldSpan;
import ghidra.util.database.ForwardRecordIterator;
import ghidra.util.database.KeySpan;
import java.io.IOException;

public interface DirectedRecordIterator
extends DirectedIterator<DBRecord> {
    public static final DirectedRecordIterator EMPTY = new AbstractDirectedRecordIterator(null){

        @Override
        public boolean hasNext() throws IOException {
            return false;
        }

        @Override
        public DBRecord next() throws IOException {
            return null;
        }
    };

    public static DirectedRecordIterator getIterator(Table table, KeySpan keySpan, DirectedIterator.Direction direction) throws IOException {
        if (keySpan.isEmpty()) {
            return EMPTY;
        }
        long min = (Long)keySpan.min();
        long max = (Long)keySpan.max();
        if (direction == DirectedIterator.Direction.FORWARD) {
            return new ForwardRecordIterator(table.iterator(min, max, min));
        }
        return new BackwardRecordIterator(table.iterator(min, max, max));
    }

    private static DirectedRecordIterator applyBegFilter(final DirectedRecordIterator it, final int columnIndex, final Field exclude) throws IOException {
        return new DirectedRecordIterator(){
            DBRecord next = this.findFirst();

            private DBRecord findFirst() throws IOException {
                DBRecord r = null;
                while (it.hasNext()) {
                    r = (DBRecord)it.next();
                    if (r.getFieldValue(columnIndex).equals((Object)exclude)) continue;
                    return r;
                }
                return null;
            }

            @Override
            public DBRecord next() throws IOException {
                DBRecord ret = this.next;
                this.next = (DBRecord)it.next();
                return ret;
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.next != null;
            }

            @Override
            public boolean delete() throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static DirectedRecordIterator applyEndFilter(final DirectedRecordIterator it, final int columnIndex, final Field exclude) throws IOException {
        return new DirectedRecordIterator(){
            DBRecord next;
            {
                this.next = (DBRecord)it.next();
            }

            @Override
            public DBRecord next() throws IOException {
                DBRecord ret = this.next;
                this.next = (DBRecord)it.next();
                return ret;
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.next != null && !this.next.getFieldValue(columnIndex).equals((Object)exclude);
            }

            @Override
            public boolean delete() throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static DirectedRecordIterator applyFilters(DirectedRecordIterator it, int columnIndex, Field beg, Field end) throws IOException {
        if (beg != null) {
            it = DirectedRecordIterator.applyBegFilter(it, columnIndex, beg);
        }
        if (end != null) {
            it = DirectedRecordIterator.applyEndFilter(it, columnIndex, end);
        }
        return it;
    }

    public static DirectedRecordIterator getIndexIterator(Table table, int columnIndex, FieldSpan fieldSpan, DirectedIterator.Direction direction) throws IOException {
        Field excludeUpper;
        Field field;
        Field field2;
        Object object = fieldSpan.min();
        if (object instanceof End.Point) {
            End.Point pt = (End.Point)object;
            field2 = (Field)pt.val();
        } else {
            field2 = null;
        }
        Field lower = field2;
        Object object2 = fieldSpan.max();
        if (object2 instanceof End.Point) {
            End.Point pt = (End.Point)object2;
            field = (Field)pt.val();
        } else {
            field = null;
        }
        Field upper = field;
        RecordIterator it = table.indexIterator(columnIndex, lower, upper, direction == DirectedIterator.Direction.FORWARD);
        Field excludeLower = !((End)fieldSpan.min()).isInclusive() ? lower : null;
        Object object3 = excludeUpper = !((End)fieldSpan.max()).isInclusive() ? upper : null;
        if (direction == DirectedIterator.Direction.FORWARD) {
            return DirectedRecordIterator.applyFilters(new ForwardRecordIterator(it), columnIndex, excludeLower, excludeUpper);
        }
        return DirectedRecordIterator.applyFilters(new BackwardRecordIterator(it), columnIndex, excludeUpper, excludeLower);
    }
}

