/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.rect;

import ghidra.util.database.spatial.rect.EuclideanSpace2D;
import ghidra.util.database.spatial.rect.Rectangle2D;

public abstract class ImmutableRectangle2D<X, Y, R extends Rectangle2D<X, Y, R>>
implements Rectangle2D<X, Y, R> {
    protected final X x1;
    protected final X x2;
    protected final Y y1;
    protected final Y y2;
    protected final EuclideanSpace2D<X, Y> space;

    public ImmutableRectangle2D(X x1, X x2, Y y1, Y y2, EuclideanSpace2D<X, Y> space) {
        assert (space.compareX(x1, x2) <= 0);
        assert (space.compareY(y1, y2) <= 0);
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.space = space;
    }

    public String toString() {
        return String.format("rect[%s-%s]x[%s-%s]", this.x1, this.x2, this.y1, this.y2);
    }

    @Override
    public String description() {
        return this.toString();
    }

    @Override
    public X getX1() {
        return this.x1;
    }

    @Override
    public X getX2() {
        return this.x2;
    }

    @Override
    public Y getY1() {
        return this.y1;
    }

    @Override
    public Y getY2() {
        return this.y2;
    }

    @Override
    public EuclideanSpace2D<X, Y> getSpace() {
        return this.space;
    }

    public boolean equals(Object obj) {
        return this.doEquals(obj);
    }

    public int hashCode() {
        return this.doHashCode();
    }
}

