/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import com.sun.msv.verifier.jarv.TheFactoryImpl;
import generic.jar.ResourceFile;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.io.InputStream;
import java.io.StringReader;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import utilities.util.FileResolutionResult;
import utilities.util.FileUtilities;

public class SleighLanguageValidator {
    private static final ResourceFile ldefsRelaxSchemaFile;
    private static final ResourceFile pspecRelaxSchemaFile;
    private static final ResourceFile cspecRelaxSchemaFile;
    public static final int CSPEC_TYPE = 1;
    public static final int PSPEC_TYPE = 2;
    public static final int LDEFS_TYPE = 3;
    public static final int CSPECTAG_TYPE = 4;
    private static final String LANGUAGE_TYPESTRING = "language definitions";
    private static final String COMPILER_TYPESTRING = "compiler specification";
    private static final String PROCESSOR_TYPESTRING = "processor specification";
    private int verifierType;
    private Verifier verifier;

    public SleighLanguageValidator(int type) {
        this.verifierType = type;
        ResourceFile schemaFile = null;
        switch (type) {
            case 1: 
            case 4: {
                schemaFile = cspecRelaxSchemaFile;
                break;
            }
            case 2: {
                schemaFile = pspecRelaxSchemaFile;
                break;
            }
            case 3: {
                schemaFile = ldefsRelaxSchemaFile;
                break;
            }
            default: {
                throw new SleighException("Bad verifier type");
            }
        }
        this.verifier = null;
        try {
            this.verifier = SleighLanguageValidator.getVerifier(schemaFile);
        }
        catch (Exception e) {
            throw new SleighException("Error creating verifier", e);
        }
    }

    private String getTypeString() {
        if (this.verifierType == 2) {
            return PROCESSOR_TYPESTRING;
        }
        if (this.verifierType == 3) {
            return LANGUAGE_TYPESTRING;
        }
        return COMPILER_TYPESTRING;
    }

    public void verify(ResourceFile specFile) throws SleighException {
        FileResolutionResult result = FileUtilities.existsAndIsCaseDependent((ResourceFile)specFile);
        if (!result.isOk()) {
            throw new SleighException(String.valueOf(specFile) + " is not properly case dependent: " + result.getMessage());
        }
        try (InputStream in = specFile.getInputStream();){
            this.verifier.setErrorHandler((ErrorHandler)new VerifierErrorHandler(specFile));
            this.verifier.verify(new InputSource(in));
        }
        catch (Exception e) {
            throw new SleighException("Invalid " + this.getTypeString() + " file: " + specFile.getAbsolutePath(), e);
        }
    }

    public void verify(String title, String document) throws SleighException {
        if (this.verifierType != 4) {
            throw new SleighException("Only cspec tag verification is supported");
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<compiler_spec>\n");
        buffer.append("<default_proto>\n");
        buffer.append("<prototype name=\"a\" extrapop=\"0\" stackshift=\"0\">\n");
        buffer.append("<input/><output/>\n");
        buffer.append("</prototype>\n");
        buffer.append("</default_proto>\n");
        buffer.append(document);
        buffer.append("</compiler_spec>\n");
        VerifierErrorHandler errorHandler = new VerifierErrorHandler(title, 6);
        StringReader reader = new StringReader(buffer.toString());
        this.verifier.setErrorHandler((ErrorHandler)errorHandler);
        try {
            this.verifier.verify(new InputSource(reader));
        }
        catch (Exception e) {
            throw new SleighException("Invalid " + this.getTypeString() + ": " + title, e);
        }
    }

    public static void validateLdefsFile(ResourceFile ldefsFile) throws SleighException {
        SleighLanguageValidator.validateSleighFile(ldefsRelaxSchemaFile, ldefsFile, LANGUAGE_TYPESTRING);
    }

    public static void validatePspecFile(ResourceFile pspecFile) throws SleighException {
        SleighLanguageValidator.validateSleighFile(pspecRelaxSchemaFile, pspecFile, PROCESSOR_TYPESTRING);
    }

    public static void validateCspecFile(ResourceFile cspecFile) throws SleighException {
        SleighLanguageValidator.validateSleighFile(cspecRelaxSchemaFile, cspecFile, COMPILER_TYPESTRING);
    }

    private static void validateSleighFile(ResourceFile relaxSchemaFile, ResourceFile fileToValidate, String type) throws SleighException {
        FileResolutionResult result = FileUtilities.existsAndIsCaseDependent((ResourceFile)fileToValidate);
        if (!result.isOk()) {
            throw new SleighException(String.valueOf(fileToValidate) + " is not properly case dependent: " + result.getMessage());
        }
        Verifier verifier = null;
        try {
            verifier = SleighLanguageValidator.getVerifier(relaxSchemaFile);
        }
        catch (Exception e) {
            throw new SleighException("Error creating verifier", e);
        }
        try (InputStream in = fileToValidate.getInputStream();){
            verifier.setErrorHandler((ErrorHandler)new VerifierErrorHandler(fileToValidate));
            verifier.verify(new InputSource(in));
        }
        catch (Exception e) {
            throw new SleighException("Invalid " + type + " file: " + fileToValidate.getAbsolutePath(), e);
        }
    }

    private static Verifier getVerifier(ResourceFile relaxSchemaFile) throws Exception {
        TheFactoryImpl factory = new TheFactoryImpl();
        Schema schema = factory.compileSchema(relaxSchemaFile.toURL().toExternalForm());
        Verifier verifier = schema.newVerifier();
        return verifier;
    }

    static {
        ResourceFile file = null;
        try {
            file = Application.getModuleDataFile((String)"languages/language_definitions.rxg");
        }
        catch (Exception e) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find language_definitions.rxg", (Throwable)e);
        }
        if (file == null) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find language_definitions.rxg");
        }
        ldefsRelaxSchemaFile = file;
        file = null;
        try {
            file = Application.getModuleDataFile((String)"languages/processor_spec.rxg");
        }
        catch (Exception e) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find processor_spec.rxg", (Throwable)e);
        }
        if (file == null) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find processor_spec.rxg");
        }
        pspecRelaxSchemaFile = file;
        file = null;
        try {
            file = Application.getModuleDataFile((String)"languages/compiler_spec.rxg");
        }
        catch (Exception e) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find compiler_spec.rxg", (Throwable)e);
        }
        if (file == null) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find compiler_spec.rxg");
        }
        cspecRelaxSchemaFile = file;
    }

    private static class VerifierErrorHandler
    implements ErrorHandler {
        final String documentTitle;
        int lineNumberBase;

        public VerifierErrorHandler(ResourceFile file) {
            this.documentTitle = file.toString();
            this.lineNumberBase = 0;
        }

        public VerifierErrorHandler(String title, int base) {
            this.documentTitle = title;
            this.lineNumberBase = base;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.error(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            int lineno = e.getLineNumber() - this.lineNumberBase;
            Msg.error(SleighLanguageValidator.class, (Object)("Error validating " + this.documentTitle + "  at " + lineno + ":" + e.getColumnNumber()), (Throwable)e);
            throw e;
        }

        @Override
        public void warning(SAXParseException e) {
        }
    }
}

