/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.LocalVariable;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableImpl;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.InvalidInputException;

public class LocalVariableImpl
extends VariableImpl
implements LocalVariable {
    private int firstUseOffset;

    public LocalVariableImpl(String name, DataType dataType, int stackOffset, Program program) throws InvalidInputException {
        this(name, 0, dataType, null, null, stackOffset, null, false, program, null);
    }

    public LocalVariableImpl(String name, DataType dataType, int stackOffset, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, 0, dataType, null, null, stackOffset, null, false, program, sourceType);
    }

    public LocalVariableImpl(String name, int firstUseOffset, DataType dataType, Register register, Program program) throws InvalidInputException {
        this(name, firstUseOffset, dataType, null, null, null, register, false, program, null);
    }

    public LocalVariableImpl(String name, int firstUseOffset, DataType dataType, Register register, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, firstUseOffset, dataType, null, null, null, register, false, program, sourceType);
    }

    public LocalVariableImpl(String name, int firstUseOffset, DataType dataType, Address storageAddr, Program program) throws InvalidInputException {
        this(name, firstUseOffset, dataType, null, storageAddr, null, null, false, program, null);
    }

    public LocalVariableImpl(String name, int firstUseOffset, DataType dataType, Address storageAddr, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, firstUseOffset, dataType, null, storageAddr, null, null, false, program, sourceType);
    }

    public LocalVariableImpl(String name, int firstUseOffset, DataType dataType, VariableStorage storage, Program program) throws InvalidInputException {
        this(name, firstUseOffset, dataType, storage, null, null, null, false, program, null);
    }

    public LocalVariableImpl(String name, int firstUseOffset, DataType dataType, VariableStorage storage, boolean force, Program program) throws InvalidInputException {
        this(name, firstUseOffset, dataType, storage, null, null, null, force, program, null);
    }

    public LocalVariableImpl(String name, int firstUseOffset, DataType dataType, VariableStorage storage, boolean force, Program program, SourceType sourceType) throws InvalidInputException {
        this(name, firstUseOffset, dataType, storage, null, null, null, force, program, sourceType);
    }

    private LocalVariableImpl(String name, int firstUseOffset, DataType dataType, VariableStorage storage, Address storageAddr, Integer stackOffset, Register register, boolean force, Program program, SourceType sourceType) throws InvalidInputException {
        super(name, dataType, storage, storageAddr, stackOffset, register, force, program, sourceType);
        this.firstUseOffset = firstUseOffset;
        if (this.hasStackStorage() && firstUseOffset != 0) {
            throw new InvalidInputException("Stack-based variable must have firstUseOffset of 0");
        }
    }

    @Override
    public int getFirstUseOffset() {
        return this.firstUseOffset;
    }

    @Override
    public boolean setFirstUseOffset(int firstUseOffset) {
        this.firstUseOffset = firstUseOffset;
        return true;
    }
}

