/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import ghidra.app.plugin.core.reloc.GenericRefernenceBaseRelocationFixupHandler;
import ghidra.app.plugin.core.reloc.RelocationFixupHandler;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;

public class RelocationFixupCommand
extends BackgroundCommand<Program> {
    private RelocationFixupHandler relocationHandler;
    private RelocationFixupHandler genericHandler;
    private Address oldImageBase;
    private Address newImageBase;
    private boolean hasUnhandledRelocations;

    public RelocationFixupCommand(RelocationFixupHandler handler, Address oldImageBase, Address newImageBase) {
        super("Relocation Fixup", true, true, true);
        this.relocationHandler = handler;
        this.oldImageBase = oldImageBase;
        this.newImageBase = newImageBase;
        this.genericHandler = new GenericRefernenceBaseRelocationFixupHandler();
    }

    public boolean applyTo(Program program, TaskMonitor monitor) {
        RelocationTable relocationTable = program.getRelocationTable();
        Iterator iterator = relocationTable.getRelocations();
        while (iterator.hasNext()) {
            Relocation relocation = (Relocation)iterator.next();
            try {
                if (this.processRelocation(program, relocation)) continue;
                this.markAsUnhandled(program, relocation, "Unhandled relocation type");
            }
            catch (MemoryAccessException e) {
                this.markAsUnhandled(program, relocation, "Memory access Exception");
            }
            catch (CodeUnitInsertionException e) {
                this.markAsUnhandled(program, relocation, "Error re-creating instruction");
            }
        }
        if (this.hasUnhandledRelocations) {
            Msg.showError((Object)((Object)this), null, (String)"Unhandled Relocation Fixups", (Object)"One or more relocation fix-ups were not handled for the image rebase.\nBookmarks were created with the category \"Unhandled Image Base Relocation Fixup\"");
        }
        return true;
    }

    private boolean processRelocation(Program program, Relocation relocation) throws MemoryAccessException, CodeUnitInsertionException {
        if (this.relocationHandler != null && this.relocationHandler.processRelocation(program, relocation, this.oldImageBase, this.newImageBase)) {
            return true;
        }
        return this.genericHandler.processRelocation(program, relocation, this.oldImageBase, this.newImageBase);
    }

    private void markAsUnhandled(Program program, Relocation relocation, String reason) {
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        Address address = relocation.getAddress();
        bookmarkManager.setBookmark(address, "Error", "Unhandled Image Base Relocation Fixup", "Unhandled Elf relocation fixup (type = " + relocation.getType() + ") at address: " + String.valueOf(address) + ". Reason = " + reason);
        this.hasUnhandledRelocations = true;
    }
}

