/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import ghidra.app.plugin.core.compositeeditor.CompositeViewerDataTypeManager;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AlignmentType;
import ghidra.program.model.data.BadDataType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.InternalDataTypeComponent;
import ghidra.program.model.data.PackingType;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.help.UnsupportedOperationException;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;

class StackFrameDataType
implements Structure {
    private static String STACK_STRUCTURE_NAME = "{{STACK_FRAME}}";
    private static final String UNKNOWN_PREFIX = "unknown_";
    private static final String STACK_PREFIX = "stack_";
    private static final String SERIALIZATION_START = "_{{";
    private static final String SERIALIZATION_END = "}}_";
    private final DataTypeManager dtm;
    private Structure wrappedStruct;
    private int returnAddressOffset;
    private boolean growsNegative;
    private Function function;
    private int negativeLength;
    private int positiveLength;
    private int parameterOffset;

    StackFrameDataType(Function function) {
        this.dtm = function.getProgram().getDataTypeManager();
        this.initializeFromStackFrame(function.getStackFrame());
    }

    private StackFrameDataType(StackFrameDataType stackDt, DataTypeManager dtm) {
        this.dtm = dtm;
        this.returnAddressOffset = stackDt.returnAddressOffset;
        this.growsNegative = stackDt.growsNegative;
        this.function = stackDt.function;
        this.negativeLength = stackDt.negativeLength;
        this.positiveLength = stackDt.positiveLength;
        this.parameterOffset = stackDt.parameterOffset;
        this.wrappedStruct = new StructureDataType(STACK_STRUCTURE_NAME, stackDt.getLength(), dtm);
        for (StackComponentWrapper wrappedDtc : stackDt.getDefinedComponents()) {
            DataTypeComponent dtc = wrappedDtc.dtc;
            this.wrappedStruct.replaceAtOffset(dtc.getOffset(), dtc.getDataType(), dtc.getLength(), dtc.getFieldName(), dtc.getComment());
        }
    }

    private void initializeFromStackFrame(StackFrame stack) {
        this.returnAddressOffset = stack.getReturnAddressOffset();
        this.growsNegative = stack.growsNegative();
        this.function = stack.getFunction();
        this.parameterOffset = stack.getParameterOffset();
        int paramSize = stack.getParameterSize();
        int localSize = stack.getLocalSize();
        if (this.growsNegative) {
            this.negativeLength = localSize;
            this.positiveLength = paramSize;
        } else {
            this.negativeLength = paramSize;
            this.positiveLength = localSize;
        }
        this.wrappedStruct = new StructureDataType(STACK_STRUCTURE_NAME, stack.getFrameSize(), this.dtm);
        Variable[] stackVars = stack.getStackVariables();
        for (int i = stackVars.length - 1; i >= 0; --i) {
            Variable var = stackVars[i];
            VariableStorage storage = var.getVariableStorage();
            Varnode stackVarnode = storage.getLastVarnode();
            int length = stackVarnode.getSize();
            int offset = (int)stackVarnode.getOffset();
            if (offset < this.parameterOffset - this.negativeLength || offset + length - 1 > this.positiveLength + this.parameterOffset) continue;
            String comment = StackFrameDataType.buildComment(var);
            DataType dt = var.getDataType();
            if (dt == DataType.DEFAULT) {
                length = 1;
                dt = BadDataType.dataType;
            }
            this.doReplaceAtOffset(offset, dt, length, var.getName(), comment);
        }
    }

    private static String buildComment(Variable var) {
        String nonStackStoragePart = StackFrameDataType.getNonStackPartialSerializedStorage(var);
        String comment = var.getComment();
        if (nonStackStoragePart != null) {
            comment = StringUtils.join((Object[])new String[]{nonStackStoragePart, comment});
        }
        return comment;
    }

    private static String getNonStackPartialSerializedStorage(Variable var) {
        VariableStorage storage = var.getVariableStorage();
        if (storage.getVarnodeCount() < 2) {
            return null;
        }
        Varnode[] varnodes = storage.getVarnodes();
        Varnode[] partialVarnodes = new Varnode[varnodes.length - 1];
        System.arraycopy(varnodes, 0, partialVarnodes, 0, partialVarnodes.length);
        String serializationString = VariableStorage.getSerializationString((Varnode[])partialVarnodes);
        return SERIALIZATION_START + serializationString + SERIALIZATION_END;
    }

    Variable[] getStackVariables() {
        StackComponentWrapper[] definedComponents = this.getDefinedComponents();
        Variable[] vars = new Variable[definedComponents.length];
        for (int i = 0; i < vars.length; ++i) {
            StackComponentWrapper dtc = definedComponents[i];
            String fieldName = dtc.getFieldName();
            VariableStorage storage = dtc.getVariableStorage();
            try {
                vars[i] = new LocalVariableImpl(fieldName, 0, dtc.getDataType(), storage, this.function.getProgram());
            }
            catch (InvalidInputException e) {
                try {
                    vars[i] = new LocalVariableImpl(fieldName, 0, null, storage, this.function.getProgram());
                }
                catch (InvalidInputException e1) {
                    throw new AssertException();
                }
            }
            vars[i].setComment(dtc.getComment());
        }
        return vars;
    }

    void resolveWrappedComposite(CompositeViewerDataTypeManager<StackFrameDataType> viewDTM) {
        this.wrappedStruct = (Structure)viewDTM.resolve((DataType)this.wrappedStruct, null);
    }

    Function getFunction() {
        return this.function;
    }

    public boolean growsNegative() {
        return this.growsNegative;
    }

    public int getParameterOffset() {
        return this.parameterOffset;
    }

    public int getNegativeLength() {
        return this.negativeLength;
    }

    public int getPositiveLength() {
        return this.positiveLength;
    }

    public int getFrameSize() {
        return this.wrappedStruct.getLength();
    }

    public int getLocalSize() {
        return this.growsNegative ? this.negativeLength : this.positiveLength;
    }

    public int getParameterSize() {
        return this.growsNegative ? this.positiveLength : this.negativeLength;
    }

    public boolean setLocalSize(int size) {
        return this.adjustStackFrameSize(size, this.getLocalSize(), this.growsNegative);
    }

    public boolean setParameterSize(int newParamSize) {
        return this.adjustStackFrameSize(newParamSize, this.getParameterSize(), !this.growsNegative);
    }

    public int getReturnAddressOffset() {
        return this.returnAddressOffset;
    }

    private boolean adjustStackFrameSize(int newSize, int oldSize, boolean isNegative) {
        boolean shrinking;
        if (newSize < 0) {
            return false;
        }
        int delta = newSize - oldSize;
        if (delta == 0) {
            return true;
        }
        boolean bl = shrinking = delta < 0;
        if (!shrinking) {
            this.growStructure(isNegative ? -delta : delta);
            return true;
        }
        if (isNegative) {
            int oldOffset = this.getMinOffset();
            int newOffset = oldOffset - delta;
            this.deleteRange(oldOffset, newOffset - 1);
        } else {
            int oldOffset = this.getMaxOffset();
            int newOffset = oldOffset + delta;
            this.deleteRange(newOffset + 1, oldOffset);
        }
        return true;
    }

    private void deleteRange(int minOffset, int maxOffset) throws IndexOutOfBoundsException {
        StackComponentWrapper dtc = this.getComponentContaining(minOffset);
        if (dtc == null) {
            return;
        }
        int space = maxOffset - minOffset + 1;
        while (dtc != null && space > 0) {
            int ordinal = dtc.getOrdinal();
            int len = dtc.getLength();
            if (len <= space) {
                space -= len;
                this.delete(ordinal);
                int minOffsetLimit = this.parameterOffset - this.negativeLength;
                if (minOffset < minOffsetLimit) {
                    minOffset = minOffsetLimit;
                }
            } else {
                this.clearComponent(ordinal);
            }
            dtc = this.getComponentContaining(minOffset);
        }
    }

    int getMinOffset() {
        return this.parameterOffset - this.negativeLength;
    }

    int getMaxOffset() {
        return this.parameterOffset + this.positiveLength - 1;
    }

    public StackComponentWrapper setOffset(int ordinal, int newOffset) throws InvalidInputException, IndexOutOfBoundsException {
        StackComponentWrapper comp = this.getComponent(ordinal);
        int oldOffset = comp.getOffset();
        int compLength = comp.getLength();
        if (newOffset == oldOffset) {
            return comp;
        }
        if (oldOffset >= this.parameterOffset && newOffset < this.parameterOffset || oldOffset < this.parameterOffset && newOffset + compLength - 1 >= this.parameterOffset) {
            throw new InvalidInputException("Cannot move a stack variable/parameter across the parameter offset.");
        }
        if (oldOffset >= 0 && newOffset < 0 || oldOffset < 0 && newOffset + compLength - 1 >= 0) {
            throw new InvalidInputException("Cannot move a stack variable/parameter across the 0-offset point.");
        }
        StackComponentWrapper existing = this.getComponentContaining(newOffset);
        if (existing == null) {
            throw new InvalidInputException(StackFrameDataType.getHexString(newOffset, true) + " is not an offset in this stack frame.");
        }
        if (!existing.isUndefined() && existing.getOffset() != comp.getOffset()) {
            throw new InvalidInputException("There is already another stack variable at offset " + StackFrameDataType.getHexString(newOffset, true) + ".");
        }
        DataType dt = comp.getDataType();
        String fieldName = comp.getFieldName();
        String comment = comp.getComment();
        this.clearComponent(ordinal);
        int mrl = this.getMaxLength(newOffset);
        if (mrl != -1 && compLength > mrl) {
            this.doReplaceAtOffset(oldOffset, dt, compLength, fieldName, comment);
            throw new InvalidInputException(dt.getDisplayName() + " doesn't fit at offset " + StackFrameDataType.getHexString(newOffset, true) + ". It needs " + compLength + " bytes, but " + mrl + " bytes are available.");
        }
        StackComponentWrapper newComp = this.doReplaceAtOffset(newOffset, dt, compLength, fieldName, comment);
        return newComp;
    }

    public boolean setName(int ordinal, String name) throws IndexOutOfBoundsException {
        StackComponentWrapper comp = this.getComponent(ordinal);
        String fieldName = comp.getFieldName();
        if (name != null && ((name = name.trim()).length() == 0 || this.isDefaultName(name))) {
            name = null;
        }
        if (SystemUtilities.isEqual((Object)name, (Object)fieldName)) {
            return false;
        }
        if (!this.canDefineComponent(comp.getDataType(), comp.getLength(), name, comp.getComment())) {
            this.clearComponent(ordinal);
        } else if (comp.isUndefined()) {
            comp = this.replace(comp.getOrdinal(), DataType.DEFAULT, 1, name, null);
        } else {
            try {
                comp.dtc.setFieldName(name);
            }
            catch (DuplicateNameException e) {
                return false;
            }
        }
        return true;
    }

    public boolean setComment(int ordinal, String comment) throws IndexOutOfBoundsException {
        StackComponentWrapper comp = this.getComponent(ordinal);
        String oldComment = comp.getComment();
        if (comment != null && (comment = comment.trim()).length() == 0) {
            comment = null;
        }
        if (comment == null ? oldComment == null : comment.equals(oldComment)) {
            return false;
        }
        if (!this.canDefineComponent(comp.getDataType(), comp.getLength(), comp.getFieldName(), comment)) {
            this.clearComponent(ordinal);
        } else if (comp.isUndefined()) {
            this.replace(comp.getOrdinal(), DataType.DEFAULT, 1, null, comment);
        } else {
            String partialSerializedStorage = comp.getPartialStorageSerialization(true);
            comment = StringUtils.join((Object[])new String[]{partialSerializedStorage, comment});
            comp.dtc.setComment(comment);
        }
        return true;
    }

    private boolean canDefineComponent(DataType dt, int length, String newName, String comment) {
        if (comment != null && (comment = comment.trim()).length() == 0) {
            comment = null;
        }
        return !dt.isEquivalent(DataType.DEFAULT) || newName != null && newName.length() != 0 || comment != null;
    }

    public StackComponentWrapper setDataType(int ordinal, DataType dataType, int length) throws IndexOutOfBoundsException {
        StackComponentWrapper stackDtc = this.getComponent(ordinal);
        return this.replace(ordinal, dataType, length, stackDtc.getFieldName(), stackDtc.getComment());
    }

    public int getMaxLength(int stackOffset) {
        int structOffset = this.computeStructOffsetFromStackOffset(stackOffset, true);
        DataTypeComponent dtc = this.wrappedStruct.getComponentContaining(structOffset);
        int nextDefinedOffset = this.wrappedStruct.getLength();
        if (dtc != null && (dtc = this.wrappedStruct.getDefinedComponentAtOrAfterOffset(dtc.getEndOffset() + 1)) != null) {
            nextDefinedOffset = dtc.getOffset();
        }
        int nextStackOffset = this.computeStackOffsetFromStructOffset(nextDefinedOffset);
        if (stackOffset < 0 && nextStackOffset > 0) {
            nextStackOffset = 0;
        }
        if (stackOffset < this.parameterOffset && nextStackOffset >= this.parameterOffset) {
            nextStackOffset = this.parameterOffset;
        }
        return nextStackOffset - stackOffset;
    }

    boolean isDefaultName(String varName) {
        if (varName == null) {
            return false;
        }
        if (varName.startsWith(STACK_PREFIX)) {
            varName = varName.substring(STACK_PREFIX.length());
        }
        return SymbolUtilities.isDefaultLocalStackName((String)varName) || SymbolUtilities.isDefaultParameterName((String)varName);
    }

    public String getDefaultName(StackComponentWrapper stackComponent) {
        boolean isLocal;
        int offset = stackComponent.getOffset();
        int paramBaseOffset = this.getParameterOffset();
        boolean bl = this.growsNegative ? offset < paramBaseOffset : (isLocal = offset >= paramBaseOffset);
        if (isLocal) {
            return SymbolUtilities.getDefaultLocalName((Program)this.function.getProgram(), (int)offset, (int)0);
        }
        int index = this.getParameterIndex(stackComponent);
        if (index >= 0) {
            return STACK_PREFIX + SymbolUtilities.getDefaultParamName((int)index);
        }
        return UNKNOWN_PREFIX + Integer.toHexString(Math.abs(offset));
    }

    private int getParameterIndex(StackComponentWrapper stackElement) {
        int structOffset = stackElement.getOffset();
        StackComponentWrapper[] definedComponents = this.getDefinedComponents();
        int numComps = definedComponents.length;
        int firstIndex = -1;
        if (this.growsNegative) {
            for (int i = 0; i < numComps; ++i) {
                StackComponentWrapper dtc = definedComponents[i];
                int currentOffset = dtc.getOffset();
                if (currentOffset < this.parameterOffset) continue;
                if (firstIndex < 0) {
                    firstIndex = i;
                }
                if (currentOffset != structOffset) continue;
                return i - firstIndex;
            }
        } else {
            for (int i = numComps - 1; i >= 0; --i) {
                StackComponentWrapper dtc = definedComponents[i];
                int currentOffset = dtc.getOffset();
                if (currentOffset >= this.parameterOffset) continue;
                if (firstIndex < 0) {
                    firstIndex = i;
                }
                if (currentOffset != structOffset) continue;
                return firstIndex - i;
            }
        }
        return 0;
    }

    public boolean isStackVariable(int ordinal) {
        StackComponentWrapper stackElement = this.getDefinedComponentAtOrdinal(ordinal);
        return stackElement != null;
    }

    boolean isParameterOffset(int stackOffset) {
        int paramStart = this.getParameterOffset();
        return this.growsNegative && stackOffset >= paramStart || !this.growsNegative && stackOffset < paramStart;
    }

    boolean isProtectedParameterOffset(int stackOffset) {
        return this.isParameterOffset(stackOffset) && !this.function.hasCustomVariableStorage();
    }

    public static String getHexString(int offset, boolean showPrefix) {
        String prefix = showPrefix ? "0x" : "";
        return offset >= 0 ? prefix + Integer.toHexString(offset) : "-" + prefix + Integer.toHexString(-offset);
    }

    private int computeStructOffsetFromStackOffset(int stackOffset, boolean doCheckDefinedOffset) {
        int structOffset = stackOffset + this.negativeLength - this.parameterOffset;
        if (doCheckDefinedOffset && (structOffset < 0 || structOffset >= this.wrappedStruct.getLength())) {
            throw new IllegalArgumentException("Offset " + StackFrameDataType.getHexString(stackOffset, true) + " is not a defined within the stack frame");
        }
        return structOffset;
    }

    private int computeStackOffsetFromStructOffset(int structOffset) {
        return structOffset - this.negativeLength + this.parameterOffset;
    }

    public StackComponentWrapper getDefinedComponentAtOffset(int stackOffset) {
        StackComponentWrapper stackDtc = this.getDefinedComponentAtOrAfterOffset(stackOffset);
        if (stackDtc != null && stackDtc.getOffset() == stackOffset) {
            return stackDtc;
        }
        return null;
    }

    public StackComponentWrapper getDefinedComponentAtOrdinal(int ordinal) throws IndexOutOfBoundsException {
        DataTypeComponent dtc = this.wrappedStruct.getComponent(ordinal);
        return dtc != null && !dtc.isUndefined() ? new StackComponentWrapper(dtc) : null;
    }

    private void validateStackComponentDataType(DataType dataType) {
        if (DataTypeComponent.usesZeroLengthComponent((DataType)dataType)) {
            throw new IllegalArgumentException("Zero-length datatype not permitted: " + dataType.getName());
        }
        if (dataType instanceof BitFieldDataType) {
            throw new IllegalArgumentException("Bitfield not permitted: " + dataType.getName());
        }
    }

    public StackFrameDataType clone(DataTypeManager dataMgr) {
        if (this.dtm == dataMgr) {
            return this;
        }
        return this.copy(dataMgr);
    }

    public StackFrameDataType copy(DataTypeManager dataMgr) {
        return new StackFrameDataType(this, dataMgr);
    }

    public DataTypeManager getDataTypeManager() {
        return this.dtm;
    }

    public DataOrganization getDataOrganization() {
        return this.wrappedStruct.getDataOrganization();
    }

    public int getLength() {
        return this.wrappedStruct.getLength();
    }

    public String getName() {
        return this.function.getName();
    }

    public String getPathName() {
        return this.getName();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public boolean isEquivalent(DataType dt) {
        StackFrameDataType stackDt;
        block3: {
            block2: {
                if (!(dt instanceof StackFrameDataType)) break block2;
                stackDt = (StackFrameDataType)dt;
                if (this.function == stackDt.function) break block3;
            }
            throw new IllegalStateException("Expected the same function for supported use");
        }
        return this.wrappedStruct.isEquivalent((DataType)stackDt.wrappedStruct);
    }

    public String getDescription() {
        return "Stack Frame: " + this.getName();
    }

    public int getAlignedLength() {
        return this.getLength();
    }

    public boolean isZeroLength() {
        return false;
    }

    public boolean isNotYetDefined() {
        return false;
    }

    public PackingType getPackingType() {
        return PackingType.DISABLED;
    }

    public int getNumComponents() {
        return this.wrappedStruct.getNumComponents();
    }

    public int getNumDefinedComponents() {
        return this.wrappedStruct.getNumDefinedComponents();
    }

    public CategoryPath getCategoryPath() {
        return CategoryPath.ROOT;
    }

    public DataTypePath getDataTypePath() {
        return new DataTypePath(CategoryPath.ROOT, this.getName());
    }

    public StackComponentWrapper[] getDefinedComponents() {
        DataTypeComponent[] components = this.wrappedStruct.getDefinedComponents();
        StackComponentWrapper[] wrappedComponents = new StackComponentWrapper[components.length];
        for (int i = 0; i < components.length; ++i) {
            wrappedComponents[i] = new StackComponentWrapper(components[i]);
        }
        return wrappedComponents;
    }

    public StackComponentWrapper getDefinedComponentAtOrAfterOffset(int stackOffset) {
        int structOffset = this.computeStructOffsetFromStackOffset(stackOffset, false);
        DataTypeComponent dtc = this.wrappedStruct.getDefinedComponentAtOrAfterOffset(structOffset);
        return dtc != null ? new StackComponentWrapper(dtc) : null;
    }

    public StackComponentWrapper getComponentContaining(int stackOffset) {
        int structOffset = this.computeStructOffsetFromStackOffset(stackOffset, false);
        DataTypeComponent dtc = this.wrappedStruct.getComponentContaining(structOffset);
        return dtc != null ? new StackComponentWrapper(dtc) : null;
    }

    public StackComponentWrapper getComponent(int ordinal) throws IndexOutOfBoundsException {
        DataTypeComponent dtc = this.wrappedStruct.getComponent(ordinal);
        return new StackComponentWrapper(dtc);
    }

    public void clearComponent(int ordinal) throws IndexOutOfBoundsException {
        this.wrappedStruct.clearComponent(ordinal);
    }

    public void clearAtOffset(int stackOffset) {
        int structOffset = this.computeStructOffsetFromStackOffset(stackOffset, true);
        this.wrappedStruct.clearAtOffset(structOffset);
    }

    public void delete(int ordinal) throws IndexOutOfBoundsException {
        StackComponentWrapper dtc = this.getComponent(ordinal);
        if (dtc == null) {
            return;
        }
        int stackOffset = dtc.getOffset();
        int len = dtc.getLength();
        this.wrappedStruct.delete(ordinal);
        Range r = Range.between((Comparable)Integer.valueOf(stackOffset), (Comparable)Integer.valueOf(stackOffset + len - 1));
        if (r.contains((Object)this.parameterOffset)) {
            int negLenReduction = this.parameterOffset - stackOffset;
            this.negativeLength -= negLenReduction;
            this.positiveLength -= len - negLenReduction;
        } else if (r.isBefore((Object)this.parameterOffset)) {
            this.negativeLength -= len;
        } else {
            this.positiveLength -= len;
        }
    }

    public StackComponentWrapper[] getComponents() {
        DataTypeComponent[] components = this.wrappedStruct.getComponents();
        StackComponentWrapper[] wrappedComponents = new StackComponentWrapper[components.length];
        for (int i = 0; i < components.length; ++i) {
            wrappedComponents[i] = new StackComponentWrapper(components[i]);
        }
        return wrappedComponents;
    }

    public StackComponentWrapper getComponentAt(int stackOffset) {
        int structOffset = this.computeStructOffsetFromStackOffset(stackOffset, false);
        DataTypeComponent dtc = this.wrappedStruct.getComponentAt(structOffset);
        return dtc != null ? new StackComponentWrapper(dtc) : null;
    }

    public void growStructure(int amount) {
        if (amount < 0) {
            this.negativeLength -= amount;
            this.wrappedStruct.insert(0, Undefined.getUndefinedDataType((int)(-amount)));
            this.wrappedStruct.clearComponent(0);
        } else {
            this.positiveLength += amount;
            this.wrappedStruct.growStructure(amount);
        }
    }

    void checkForStackGrowth() {
        int delta = this.wrappedStruct.getLength() - this.positiveLength - this.negativeLength;
        if (delta > 0) {
            this.positiveLength += delta;
        }
    }

    private StackComponentWrapper doReplaceAtOffset(int stackOffset, DataType dataType, int length, String name, String comment) throws IllegalArgumentException {
        int structOffset = this.computeStructOffsetFromStackOffset(stackOffset, true);
        this.validateStackComponentDataType(dataType);
        if (dataType == DataType.DEFAULT) {
            dataType = BadDataType.dataType;
            length = 1;
        }
        if (name != null && this.isDefaultName(name)) {
            name = null;
        }
        DataTypeComponent dtc = this.wrappedStruct.replaceAtOffset(structOffset, dataType, length, name, comment);
        this.checkForStackGrowth();
        return new StackComponentWrapper(dtc);
    }

    public StackComponentWrapper replace(int ordinal, DataType dataType, int length, String name, String comment) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.validateStackComponentDataType(dataType);
        if (dataType == DataType.DEFAULT) {
            dataType = BadDataType.dataType;
            length = 1;
        }
        if (name != null && this.isDefaultName(name)) {
            name = null;
        }
        DataTypeComponent dtc = this.wrappedStruct.replace(ordinal, dataType, length, name, comment);
        this.checkForStackGrowth();
        return new StackComponentWrapper(dtc);
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    public void setLength(int length) {
        throw new UnsupportedOperationException();
    }

    public void setDescription(String desc) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent add(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent add(DataType dataType, int length) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent add(DataType dataType, String name, String comment) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent add(DataType dataType, int length, String name, String comment) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent addBitField(DataType baseDataType, int bitSize, String componentName, String comment) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent insert(int ordinal, DataType dataType) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent insert(int ordinal, DataType dataType, int length) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String name, String comment) {
        throw new UnsupportedOperationException();
    }

    public void deleteAtOffset(int stackOffset) {
        throw new UnsupportedOperationException();
    }

    public void delete(Set<Integer> ordinals) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    public void deleteAll() {
        throw new UnsupportedOperationException();
    }

    public StackComponentWrapper replaceAtOffset(int stackOffset, DataType dataType, int length, String newName, String comment) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public StackComponentWrapper replace(int ordinal, DataType dataType, int length) throws IndexOutOfBoundsException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent insertAtOffset(int offset, DataType dataType, int length) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponentImpl insertAtOffset(int offset, DataType dataType, int length, String newName, String comment) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent insertBitField(int ordinal, int byteWidth, int bitOffset, DataType baseDataType, int bitSize, String componentName, String comment) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent insertBitFieldAt(int byteOffset, int byteWidth, int bitOffset, DataType baseDataType, int bitSize, String componentName, String comment) {
        throw new UnsupportedOperationException();
    }

    public boolean isPartOf(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    public void dataTypeAlignmentChanged(DataType dt) {
        throw new UnsupportedOperationException();
    }

    public void repack() {
        throw new UnsupportedOperationException();
    }

    public void setPackingEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    public int getExplicitPackingValue() {
        throw new UnsupportedOperationException();
    }

    public void setExplicitPackingValue(int packingValue) {
        throw new UnsupportedOperationException();
    }

    public void setToDefaultPacking() {
        throw new UnsupportedOperationException();
    }

    public int getAlignment() {
        throw new UnsupportedOperationException();
    }

    public AlignmentType getAlignmentType() {
        throw new UnsupportedOperationException();
    }

    public int getExplicitMinimumAlignment() {
        throw new UnsupportedOperationException();
    }

    public void setExplicitMinimumAlignment(int minAlignment) {
        throw new UnsupportedOperationException();
    }

    public void setToDefaultAligned() {
        throw new UnsupportedOperationException();
    }

    public void setToMachineAligned() {
        throw new UnsupportedOperationException();
    }

    public boolean hasLanguageDependantLength() {
        throw new UnsupportedOperationException();
    }

    public SettingsDefinition[] getSettingsDefinitions() {
        throw new UnsupportedOperationException();
    }

    public TypeDefSettingsDefinition[] getTypeDefSettingsDefinitions() {
        throw new UnsupportedOperationException();
    }

    public Settings getDefaultSettings() {
        throw new UnsupportedOperationException();
    }

    public void setCategoryPath(CategoryPath path) {
        throw new UnsupportedOperationException();
    }

    public void setNameAndCategory(CategoryPath path, String name) {
        throw new UnsupportedOperationException();
    }

    public String getMnemonic(Settings settings) {
        throw new UnsupportedOperationException();
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        throw new UnsupportedOperationException();
    }

    public boolean isEncodable() {
        throw new UnsupportedOperationException();
    }

    public byte[] encodeValue(Object value, MemBuffer buf, Settings settings, int length) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getValueClass(Settings settings) {
        throw new UnsupportedOperationException();
    }

    public String getDefaultLabelPrefix() {
        throw new UnsupportedOperationException();
    }

    public String getDefaultAbbreviatedLabelPrefix() {
        throw new UnsupportedOperationException();
    }

    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        throw new UnsupportedOperationException();
    }

    public String getDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutOffset) {
        throw new UnsupportedOperationException();
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        throw new UnsupportedOperationException();
    }

    public byte[] encodeRepresentation(String repr, MemBuffer buf, Settings settings, int length) {
        throw new UnsupportedOperationException();
    }

    public boolean isDeleted() {
        return this.function.isDeleted();
    }

    public void dataTypeSizeChanged(DataType dt) {
        throw new UnsupportedOperationException();
    }

    public void dataTypeDeleted(DataType dt) {
        throw new UnsupportedOperationException();
    }

    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        throw new UnsupportedOperationException();
    }

    public void dataTypeNameChanged(DataType dt, String oldName) {
        throw new UnsupportedOperationException();
    }

    public void addParent(DataType dt) {
        throw new UnsupportedOperationException();
    }

    public void removeParent(DataType dt) {
        throw new UnsupportedOperationException();
    }

    public Collection<DataType> getParents() {
        throw new UnsupportedOperationException();
    }

    public boolean dependsOn(DataType dt) {
        throw new UnsupportedOperationException();
    }

    public SourceArchive getSourceArchive() {
        throw new UnsupportedOperationException();
    }

    public void setSourceArchive(SourceArchive archive) {
        throw new UnsupportedOperationException();
    }

    public long getLastChangeTime() {
        throw new UnsupportedOperationException();
    }

    public long getLastChangeTimeInSourceArchive() {
        throw new UnsupportedOperationException();
    }

    public UniversalID getUniversalID() {
        throw new UnsupportedOperationException();
    }

    public void replaceWith(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    public void setLastChangeTime(long lastChangeTime) {
        throw new UnsupportedOperationException();
    }

    public void setLastChangeTimeInSourceArchive(long lastChangeTimeInSourceArchive) {
        throw new UnsupportedOperationException();
    }

    public List<DataTypeComponent> getComponentsContaining(int offset) {
        throw new UnsupportedOperationException();
    }

    public DataTypeComponent getDataTypeAt(int offset) {
        throw new UnsupportedOperationException();
    }

    class StackComponentWrapper
    implements DataTypeComponent {
        final DataTypeComponent dtc;

        StackComponentWrapper(DataTypeComponent dtc) {
            this.dtc = dtc;
            if (dtc instanceof StackComponentWrapper) {
                throw new IllegalArgumentException();
            }
        }

        public DataType getDataType() {
            DataType dt = this.dtc.getDataType();
            if (dt instanceof BadDataType && this.getLength() == 1) {
                return DataType.DEFAULT;
            }
            return dt;
        }

        public DataType getParent() {
            return StackFrameDataType.this;
        }

        public boolean isBitFieldComponent() {
            return false;
        }

        public boolean isZeroBitFieldComponent() {
            return false;
        }

        public int getOrdinal() {
            return this.dtc.getOrdinal();
        }

        boolean isParameter() {
            int paramStart = StackFrameDataType.this.getParameterOffset();
            int stackOffset = this.getOffset();
            return StackFrameDataType.this.growsNegative && stackOffset >= paramStart || !StackFrameDataType.this.growsNegative && stackOffset < paramStart;
        }

        boolean isProtectedParameter() {
            return this.isParameter() && !StackFrameDataType.this.function.hasCustomVariableStorage();
        }

        public int getOffset() {
            return StackFrameDataType.this.computeStackOffsetFromStructOffset(this.dtc.getOffset());
        }

        public int getEndOffset() {
            return StackFrameDataType.this.computeStackOffsetFromStructOffset(this.dtc.getEndOffset());
        }

        public int getLength() {
            return this.dtc.getLength();
        }

        public void setComment(String comment) {
            throw new UnsupportedOperationException();
        }

        public String getComment() {
            int ix;
            String comment = this.dtc.getComment();
            if (comment != null && comment.startsWith(StackFrameDataType.SERIALIZATION_START) && (ix = comment.indexOf(StackFrameDataType.SERIALIZATION_END)) > 0) {
                comment = comment.substring(ix + StackFrameDataType.SERIALIZATION_END.length());
            }
            return StringUtils.isBlank((CharSequence)comment) ? null : comment;
        }

        private String getPartialStorageSerialization(boolean stripStartEnd) {
            int ix;
            String comment = this.dtc.getComment();
            if (comment != null && comment.startsWith(StackFrameDataType.SERIALIZATION_START) && (ix = comment.indexOf(StackFrameDataType.SERIALIZATION_END)) > 0) {
                int startIx = stripStartEnd ? StackFrameDataType.SERIALIZATION_START.length() : 0;
                int endIx = ix + (stripStartEnd ? 0 : StackFrameDataType.SERIALIZATION_END.length());
                return comment.substring(startIx, endIx);
            }
            return null;
        }

        private VariableStorage getVariableStorage() {
            ProgramArchitecture programArchitecture = StackFrameDataType.this.dtm.getProgramArchitecture();
            Varnode[] partialStorage = null;
            String partialSerializedStorage = this.getPartialStorageSerialization(true);
            if (partialSerializedStorage != null) {
                try {
                    partialStorage = VariableStorage.deserialize((ProgramArchitecture)programArchitecture, (String)partialSerializedStorage).getVarnodes();
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
            try {
                Address stackAddr = programArchitecture.getAddressFactory().getStackSpace().getAddress((long)this.getOffset());
                Varnode stackVarnode = new Varnode(stackAddr, this.getLength());
                if (partialStorage != null) {
                    Varnode[] joinedVarnodes = new Varnode[partialStorage.length + 1];
                    System.arraycopy(partialStorage, 0, joinedVarnodes, 0, partialStorage.length);
                    joinedVarnodes[partialStorage.length] = stackVarnode;
                    return new VariableStorage(programArchitecture, joinedVarnodes);
                }
                return new VariableStorage(programArchitecture, new Varnode[]{stackVarnode});
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Failed to build variable: " + e.getMessage()));
                try {
                    return new VariableStorage(programArchitecture, this.getOffset(), 1);
                }
                catch (InvalidInputException e1) {
                    throw new AssertException((Throwable)e1);
                }
            }
        }

        public Settings getDefaultSettings() {
            return this.dtc.getDefaultSettings();
        }

        public String getFieldName() {
            return this.dtc.getFieldName();
        }

        public void setFieldName(String fieldName) throws DuplicateNameException {
            throw new UnsupportedOperationException();
        }

        public boolean isEquivalent(DataTypeComponent otherDtc) {
            throw new UnsupportedOperationException();
        }

        public boolean isUndefined() {
            return this.dtc.isUndefined();
        }

        public String toString() {
            return InternalDataTypeComponent.toString((DataTypeComponent)this);
        }
    }
}

