/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.golang.GoVerSet;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.Complex8DataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;

public class GoRegisterInfo {
    private final GoVerSet validVersions;
    private final List<Register> intRegisters;
    private final List<Register> floatRegisters;
    private final int stackInitialOffset;
    private final int maxAlign;
    private final Register currentGoroutineRegister;
    private final Register zeroRegister;
    private final boolean zeroRegisterIsBuiltin;
    private final Register duffzeroDestParam;
    private final Register duffzeroZeroParam;
    private final RegType duffzeroZeroParamType;
    private final Register closureContextRegister;

    GoRegisterInfo(List<Register> intRegisters, List<Register> floatRegisters, int stackInitialOffset, int maxAlign, Register currentGoroutineRegister, Register zeroRegister, boolean zeroRegisterIsBuiltin, Register duffzeroDestParam, Register duffzeroZeroParam, RegType duffzeroZeroParamType, Register closureContextRegister, GoVerSet validVersions) {
        this.validVersions = validVersions;
        this.intRegisters = intRegisters;
        this.floatRegisters = floatRegisters;
        this.stackInitialOffset = stackInitialOffset;
        this.maxAlign = maxAlign;
        this.currentGoroutineRegister = currentGoroutineRegister;
        this.zeroRegister = zeroRegister;
        this.zeroRegisterIsBuiltin = zeroRegisterIsBuiltin;
        this.duffzeroDestParam = duffzeroDestParam;
        this.duffzeroZeroParam = duffzeroZeroParam;
        this.duffzeroZeroParamType = duffzeroZeroParamType;
        this.closureContextRegister = closureContextRegister;
    }

    public GoVerSet getValidVersions() {
        return this.validVersions;
    }

    public int getIntRegisterSize() {
        return this.maxAlign;
    }

    public int getMaxAlign() {
        return this.maxAlign;
    }

    public Register getCurrentGoroutineRegister() {
        return this.currentGoroutineRegister;
    }

    public Register getZeroRegister() {
        return this.zeroRegister;
    }

    public boolean isZeroRegisterIsBuiltin() {
        return this.zeroRegisterIsBuiltin;
    }

    public List<Register> getIntRegisters() {
        return this.intRegisters;
    }

    public List<Register> getFloatRegisters() {
        return this.floatRegisters;
    }

    public int getStackInitialOffset() {
        return this.stackInitialOffset;
    }

    public boolean hasAbiInternalParamRegisters() {
        return !this.intRegisters.isEmpty() || !this.floatRegisters.isEmpty();
    }

    public List<Variable> getDuffzeroParams(Program program) {
        if (this.duffzeroDestParam == null) {
            return List.of();
        }
        try {
            ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
            Pointer voidPtr = dtm.getPointer((DataType)VoidDataType.dataType);
            ArrayList<Variable> params = new ArrayList<Variable>();
            params.add((Variable)new ParameterImpl("dest", -2, (DataType)voidPtr, this.getStorageForReg(program, this.duffzeroDestParam, voidPtr.getLength()), true, program, SourceType.ANALYSIS));
            if (this.duffzeroZeroParam != null && this.duffzeroZeroParamType != null) {
                int regSize = this.duffzeroZeroParam.getMinimumByteSize();
                DataType dt = switch (this.duffzeroZeroParamType.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 1 -> AbstractFloatDataType.getFloatDataType((int)regSize, (DataTypeManager)dtm);
                    case 0 -> AbstractIntegerDataType.getUnsignedDataType((int)regSize, (DataTypeManager)dtm);
                };
                params.add((Variable)new ParameterImpl("zeroValue", -2, dt, this.getStorageForReg(program, this.duffzeroZeroParam, regSize), true, program, SourceType.ANALYSIS));
            }
            return params;
        }
        catch (InvalidInputException e) {
            return List.of();
        }
    }

    public Register getClosureContextRegister() {
        return this.closureContextRegister;
    }

    private VariableStorage getStorageForReg(Program program, Register reg, int len) throws InvalidInputException {
        return new VariableStorage((ProgramArchitecture)program, (Varnode[])DWARFUtil.convertRegisterListToVarnodeStorage(List.of(reg), len).toArray(Varnode[]::new));
    }

    public int getAlignmentForType(DataType dt) {
        while (dt instanceof TypeDef || dt instanceof Array) {
            if (dt instanceof TypeDef) {
                TypeDef td = (TypeDef)dt;
                dt = td.getBaseDataType();
            }
            if (!(dt instanceof Array)) continue;
            Array a = (Array)dt;
            dt = a.getDataType();
        }
        if (GoRegisterInfo.isIntType(dt) && GoRegisterInfo.isIntrinsicSize(dt.getLength())) {
            return Math.min(this.maxAlign, dt.getLength());
        }
        if (dt instanceof Complex8DataType) {
            return 4;
        }
        if (dt instanceof AbstractFloatDataType) {
            return Math.min(this.maxAlign, dt.getLength());
        }
        return this.maxAlign;
    }

    static boolean isIntType(DataType dt) {
        return dt instanceof AbstractIntegerDataType || dt instanceof WideCharDataType || dt instanceof WideChar16DataType || dt instanceof WideChar32DataType || dt instanceof Enum || dt instanceof BooleanDataType;
    }

    static boolean isIntrinsicSize(int size) {
        return Integer.bitCount(size) == 1;
    }

    public static enum RegType {
        INT,
        FLOAT;

    }
}

