/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexTypeDefOrRef;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableInterfaceImpl
extends CliAbstractTable {
    public CliTableInterfaceImpl(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliInterfaceImplRow(this.readTableIndex(reader, CliTypeTable.TypeDef), CliIndexTypeDefOrRef.readCodedIndex(reader, stream)));
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "InterfaceImpl Row", 0);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.TypeDef), "Class", "index into TypeDef table");
        rowDt.add(CliIndexTypeDefOrRef.toDataType(this.metadataStream), "Interface", "index into TypeDef/TypeRef/TypeSpec - TypeDefOrRef coded");
        return rowDt;
    }

    public class CliInterfaceImplRow
    extends CliAbstractTableRow {
        public int classIndex;
        public int interfaceIndex;

        public CliInterfaceImplRow(int classIndex, int interfaceIndex) {
            this.classIndex = classIndex;
            this.interfaceIndex = interfaceIndex;
        }

        @Override
        public String getRepresentation() {
            String interfaceRep;
            try {
                interfaceRep = CliTableInterfaceImpl.this.getRowRepresentationSafe(CliIndexTypeDefOrRef.getTableName(this.interfaceIndex), CliIndexTypeDefOrRef.getRowIndex(this.interfaceIndex));
            }
            catch (InvalidInputException e) {
                interfaceRep = Integer.toHexString(this.interfaceIndex);
            }
            return String.format("Class %s implements Interface %s", CliTableInterfaceImpl.this.getRowRepresentationSafe(CliTypeTable.TypeDef, this.classIndex), interfaceRep);
        }
    }
}

