/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import java.util.HashMap;
import java.util.Map;

public class ReturnDescriptionMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 13;
    private boolean varargsPushedRightToLeft;
    private boolean returneeCleansUpStack;
    private Style style;
    private int bytesRemaining;

    public ReturnDescriptionMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        int flags = reader.parseUnsignedShortVal();
        this.processFlags(flags);
        this.style = Style.fromValue(reader.parseUnsignedByteVal());
        this.bytesRemaining = reader.getLimit() - reader.getIndex();
    }

    @Override
    public int getPdbId() {
        return 13;
    }

    public Style getStyle() {
        return this.style;
    }

    public boolean isVarargsPushedRightToLeft() {
        return this.varargsPushedRightToLeft;
    }

    public boolean isReturneeCleansUpStack() {
        return this.returneeCleansUpStack;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s, ", this.getSymbolTypeName()));
        builder.append((Object)this.style);
        builder.append(this.varargsPushedRightToLeft ? ", varargs right-to-left" : ", varargs left-to-right");
        builder.append(this.returneeCleansUpStack ? ", returnee cleans stack" : ", caller cleans stack");
        builder.append(String.format("; byte length of remaining method data = %d", this.bytesRemaining));
    }

    @Override
    protected String getSymbolTypeName() {
        return "RETURN";
    }

    private void processFlags(int val) {
        this.varargsPushedRightToLeft = (val & 1) == 1;
        this.returneeCleansUpStack = ((val >>= 1) & 1) == 1;
    }

    public static enum Style {
        UNKNOWN("unknown return", -1),
        VOID("void return", 0),
        RETURN_DATA_IN_REGISTERS("return data in registers", 1),
        INDIRECT_CALLER_ALLOCATED_NEAR("indirected caller-allocated near", 2),
        INDIRECT_CALLER_ALLOCATED_FAR("indirect caller-allocated far", 3),
        INDIRECT_RETURNEE_ALLOCATED_NEAR("indirect returnee allocated near", 4),
        INDIRECT_RETURNEE_ALLOCATED_FAR("indirect returnee allocated far", 5),
        UNUSED("unused", 6);

        private static final Map<Integer, Style> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static Style fromValue(int val) {
            return BY_VALUE.getOrDefault(val, UNKNOWN);
        }

        private Style(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Style>();
            for (Style val : Style.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

