/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.Map;

public class VbtManager {
    private DataTypeManager dtm;
    private PointerDataType fallbackVbptr;
    protected Map<Address, VirtualBaseTable> vbtByAddress;

    VbtManager(DataTypeManager dtm) {
        this.dtm = dtm;
        this.vbtByAddress = new HashMap<Address, VirtualBaseTable>();
        this.fallbackVbptr = new PointerDataType((DataType)new IntegerDataType(dtm));
    }

    PointerDataType getFallbackVbptr() {
        return this.fallbackVbptr;
    }

    long getOffset(Address address, int ordinal) throws PdbException {
        VirtualBaseTableEntry entry;
        VirtualBaseTable table = this.vbtByAddress.get(address);
        if (table == null) {
            table = this.createVirtualBaseTable(address);
        }
        if ((entry = table.getEntry(ordinal)) == null) {
            throw new PdbException("Virtual Base Table Entry does not exist for ordinal: " + ordinal);
        }
        return entry.getOffset();
    }

    VirtualBaseTable createVirtualBaseTable(Address address) {
        VirtualBaseTable vbt = this.vbtByAddress.get(address);
        if (vbt != null) {
            String message = "PDB: warning virtual base table already exists for address: " + String.valueOf(address);
            PdbLog.message(message);
            Msg.info((Object)this, (Object)message);
        } else {
            vbt = new VirtualBaseTable();
            this.vbtByAddress.put(address, vbt);
        }
        return vbt;
    }

    static class VirtualBaseTable {
        int maxSeen = -1;
        Map<Integer, VirtualBaseTableEntry> entryByOrdinal = new HashMap<Integer, VirtualBaseTableEntry>();

        VirtualBaseTable() {
        }

        VirtualBaseTableEntry getEntry(int ordinal) throws PdbException {
            return this.entryByOrdinal.get(ordinal);
        }

        long getOffset(int ordinal) throws PdbException {
            VirtualBaseTableEntry entry = this.getEntry(ordinal);
            if (entry == null) {
                throw new PdbException("No entry in Virtual Base Table for ordinal: " + ordinal);
            }
            return entry.getOffset();
        }

        void addEntry(int ordinal, VirtualBaseTableEntry entry) {
            this.entryByOrdinal.put(ordinal, entry);
            this.maxSeen = Integer.max(this.maxSeen, ordinal);
        }

        int getMaxOrdinal() {
            return this.maxSeen;
        }
    }

    static class VirtualBaseTableEntry {
        long offset;

        VirtualBaseTableEntry(long offset) {
            this.offset = offset;
        }

        long getOffset() {
            return this.offset;
        }
    }
}

