/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.CustomOption;
import ghidra.framework.options.GProperties;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.WrappedOption;
import ghidra.util.Msg;

public class WrappedCustomOption
implements WrappedOption {
    private CustomOption value;
    private boolean valid = true;

    public WrappedCustomOption(CustomOption value) {
        this();
        this.value = value;
    }

    public WrappedCustomOption() {
    }

    @Override
    public void readState(SaveState saveState) {
        String customOptionClassName = saveState.getString("CUSTOM OPTION CLASS", null);
        this.valid = false;
        try {
            Class<?> c = Class.forName(customOptionClassName);
            this.value = (CustomOption)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.value.readState((GProperties)saveState);
            this.valid = true;
        }
        catch (ClassNotFoundException e) {
            Msg.info((Object)this, (Object)"Custom option class '%s' does not exist".formatted(customOptionClassName));
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Can't create customOption instance for: " + customOptionClassName), (Throwable)e);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void writeState(SaveState saveState) {
        saveState.putString("CUSTOM OPTION CLASS", this.value.getClass().getName());
        this.value.writeState((GProperties)saveState);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public OptionType getOptionType() {
        return OptionType.CUSTOM_TYPE;
    }
}

