/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.SystemUtilities;
import ghidra.util.TrackedTaskListener;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class TaskUtilities {
    private static Map<Task, TaskMonitor> runningTasks = new ConcurrentHashMap<Task, TaskMonitor>();
    private static List<TrackedTaskListener> listeners = new CopyOnWriteArrayList<TrackedTaskListener>();

    public static void addTrackedTaskListener(TrackedTaskListener listener) {
        listeners.remove(listener);
        listeners.add(listener);
    }

    public static void removeTrackedTaskListener(TrackedTaskListener listener) {
        listeners.remove(listener);
    }

    public static void addTrackedTask(Task task, TaskMonitor monitor) {
        if (!SystemUtilities.isInTestingMode()) {
            return;
        }
        if (runningTasks.containsKey(task)) {
            return;
        }
        runningTasks.put(task, monitor);
        for (TrackedTaskListener listener : listeners) {
            listener.taskAdded(task);
        }
    }

    public static void removeTrackedTask(Task task) {
        if (!SystemUtilities.isInTestingMode()) {
            return;
        }
        runningTasks.remove(task);
        for (TrackedTaskListener listener : listeners) {
            listener.taskRemoved(task);
        }
    }

    public static boolean isExecutingTasks() {
        if (SystemUtilities.isInTestingMode()) {
            return runningTasks.size() > 0;
        }
        return false;
    }

    public static boolean isTaskRunning(String title) {
        Task[] tasks;
        if (!SystemUtilities.isInTestingMode()) {
            return false;
        }
        for (Task task : tasks = runningTasks.keySet().toArray(new Task[runningTasks.size()])) {
            if (!task.getTaskTitle().equals(title)) continue;
            return true;
        }
        return false;
    }
}

