/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.analyzer;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.cdex.CDexConstants;
import ghidra.file.formats.android.dex.analyzer.DexAnalysisState;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.dex.format.ClassDefItem;
import ghidra.file.formats.android.dex.format.CodeItem;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.EncodedCatchHandler;
import ghidra.file.formats.android.dex.format.EncodedCatchHandlerList;
import ghidra.file.formats.android.dex.format.EncodedMethod;
import ghidra.file.formats.android.dex.format.EncodedTypeAddressPair;
import ghidra.file.formats.android.dex.format.StringIDItem;
import ghidra.file.formats.android.dex.format.TypeIDItem;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class DexExceptionHandlersAnalyzer
extends FileFormatAnalyzer {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("DEX: exception handler markup");
        AddressSet disassembleSet = new AddressSet();
        disassembleSet.add(this.computeExceptionSet(program, monitor));
        DisassembleCommand dCommand = new DisassembleCommand((AddressSetView)disassembleSet, null, true);
        dCommand.applyTo(program, monitor);
        return true;
    }

    public boolean canAnalyze(Program program) {
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        return DexConstants.isDexFile((ByteProvider)provider) || CDexConstants.isCDEX(program);
    }

    @Override
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.BYTE_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Disassembles the exception handlers in a DEX/CDEX file";
    }

    public String getName() {
        return "Android DEX/CDEX Exception Handlers";
    }

    @Override
    public AnalysisPriority getPriority() {
        return new AnalysisPriority(0x7FFFFFFE);
    }

    public boolean isPrototype() {
        return false;
    }

    private AddressSetView computeExceptionSet(Program program, TaskMonitor monitor) throws Exception {
        AddressSet set = new AddressSet();
        DexHeader header = null;
        DexAnalysisState analysisState = DexAnalysisState.getState(program);
        header = analysisState.getHeader();
        Address address = this.toAddr(program, 0x50000000L);
        for (ClassDefItem item : header.getClassDefs()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            ClassDataItem classDataItem = item.getClassDataItem();
            if (classDataItem == null) continue;
            set.add(this.processMethods(program, address, header, item, classDataItem.getDirectMethods(), monitor));
            set.add(this.processMethods(program, address, header, item, classDataItem.getVirtualMethods(), monitor));
        }
        return set;
    }

    private AddressSetView processMethods(Program program, Address baseAddress, DexHeader header, ClassDefItem item, List<EncodedMethod> methods, TaskMonitor monitor) throws Exception {
        AddressSet set = new AddressSet();
        monitor.setMaximum((long)methods.size());
        monitor.setProgress(0L);
        for (int i = 0; i < methods.size(); ++i) {
            EncodedCatchHandlerList handlerList;
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            EncodedMethod method = methods.get(i);
            Address codeAddress = baseAddress.add((long)method.getCodeOffset());
            CodeItem codeItem = method.getCodeItem();
            if (codeItem == null || (handlerList = codeItem.getHandlerList()) == null) continue;
            for (EncodedCatchHandler handler : handlerList.getHandlers()) {
                monitor.checkCancelled();
                List<EncodedTypeAddressPair> pairs = handler.getPairs();
                for (EncodedTypeAddressPair pair : pairs) {
                    monitor.checkCancelled();
                    int catchTypeIndex = pair.getTypeIndex();
                    TypeIDItem catchTypeIDItem = header.getTypes().get(catchTypeIndex);
                    StringIDItem catchStringItem = header.getStrings().get(catchTypeIDItem.getDescriptorIndex());
                    String catchString = catchStringItem.getStringDataItem().getString();
                    Address catchAddress = codeAddress.add((long)(pair.getAddress() * 2));
                    this.createCatchSymbol(program, catchString, catchAddress);
                    set.add(catchAddress);
                }
                if (handler.getSize() > 0) continue;
                Address catchAllAddress = codeAddress.add((long)(handler.getCatchAllAddress() * 2));
                this.createCatchSymbol(program, "CatchAll", catchAllAddress);
                set.add(catchAllAddress);
            }
        }
        return set;
    }

    private void createCatchSymbol(Program program, String catchName, Address catchAddress) {
        Namespace catchNameSpace = DexUtil.getOrCreateNameSpace(program, "CatchHandlers");
        try {
            program.getSymbolTable().createLabel(catchAddress, catchName, catchNameSpace, SourceType.ANALYSIS);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Error creating label", (Throwable)e);
        }
    }
}

