/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MemoryInfo
implements StructConverter {
    public static final String NAME = "MINIDUMP_MEMORY_INFO";
    private long baseAddress;
    private long allocationBase;
    private int allocationProtect;
    private long regionSize;
    private int state;
    private int protect;
    private int type;
    private DumpFileReader reader;
    private long index;

    MemoryInfo(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setBaseAddress(this.reader.readNextLong());
        this.setAllocationBase(this.reader.readNextLong());
        this.setAllocationProtect(this.reader.readNextInt());
        this.reader.readNextInt();
        this.setRegionSize(this.reader.readNextLong());
        this.setState(this.reader.readNextInt());
        this.setProtect(this.reader.readNextInt());
        this.setType(this.reader.readNextInt());
        this.reader.readNextInt();
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(QWORD, 8, "BaseAddress", null);
        struct.add(QWORD, 8, "AllocationBase", null);
        struct.add(DWORD, 4, "AllocationProtect", null);
        struct.add(DWORD, 4, "__alignment1", null);
        struct.add(QWORD, 8, "RegionSize", null);
        struct.add(DWORD, 4, "State", null);
        struct.add(DWORD, 4, "Protect", null);
        struct.add(DWORD, 4, "Type", null);
        struct.add(DWORD, 4, "__alignment2", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(long baseAddress) {
        this.baseAddress = baseAddress;
    }

    public long getAllocationBase() {
        return this.allocationBase;
    }

    public void setAllocationBase(long allocationBase) {
        this.allocationBase = allocationBase;
    }

    public int getAllocationProtect() {
        return this.allocationProtect;
    }

    public void setAllocationProtect(int allocationProtect) {
        this.allocationProtect = allocationProtect;
    }

    public long getRegionSize() {
        return this.regionSize;
    }

    public void setRegionSize(long regionSize) {
        this.regionSize = regionSize;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getProtect() {
        return this.protect;
    }

    public void setProtect(int protect) {
        this.protect = protect;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getComment() {
        Object comment = "";
        if ((this.state & 0x1000) > 0) {
            comment = (String)comment + "COMMIT ";
        }
        if ((this.state & 0x10000) > 0) {
            comment = (String)comment + "FREE ";
        }
        if ((this.state & 0x2000) > 0) {
            comment = (String)comment + "RESERVE ";
        }
        if ((this.type & 0x1000000) > 0) {
            comment = (String)comment + "IMAGE ";
        }
        if ((this.type & 0x40000) > 0) {
            comment = (String)comment + "MAPPED ";
        }
        if ((this.type & 0x20000) > 0) {
            comment = (String)comment + "PRIVATE ";
        }
        return comment;
    }
}

