/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.ext4.Ext4DxEntry;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4DxRoot
implements StructConverter {
    private int dot_inode;
    private short dot_rec_len;
    private byte dot_name_len;
    private byte dot_file_type;
    private byte[] dot_name;
    private int dotdot_inode;
    private short dotdot_rec_len;
    private byte dotdot_name_len;
    private byte dotdot_file_type;
    private byte[] dotdot_name;
    private int dx_root_info_reserved_zero;
    private byte dx_root_info_hash_version;
    private byte dx_root_info_info_length;
    private byte dx_root_info_indirect_levels;
    private byte dx_root_info_unused_flags;
    private short limit;
    private short count;
    private int block;
    private Ext4DxEntry[] entries;

    public Ext4DxRoot(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4DxRoot(BinaryReader reader) throws IOException {
        this.dot_inode = reader.readNextInt();
        this.dot_rec_len = reader.readNextShort();
        this.dot_name_len = reader.readNextByte();
        this.dot_file_type = reader.readNextByte();
        this.dot_name = reader.readNextByteArray(4);
        this.dotdot_inode = reader.readNextInt();
        this.dotdot_rec_len = reader.readNextShort();
        this.dotdot_name_len = reader.readNextByte();
        this.dotdot_file_type = reader.readNextByte();
        this.dotdot_name = reader.readNextByteArray(4);
        this.dx_root_info_reserved_zero = reader.readNextInt();
        this.dx_root_info_hash_version = reader.readNextByte();
        this.dx_root_info_info_length = reader.readNextByte();
        this.dx_root_info_indirect_levels = reader.readNextByte();
        this.dx_root_info_unused_flags = reader.readNextByte();
        this.limit = reader.readNextShort();
        this.count = reader.readNextShort();
        this.block = reader.readNextInt();
        this.entries = new Ext4DxEntry[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.entries[i] = new Ext4DxEntry(reader);
        }
    }

    public int getDot_inode() {
        return this.dot_inode;
    }

    public short getDot_rec_len() {
        return this.dot_rec_len;
    }

    public byte getDot_name_len() {
        return this.dot_name_len;
    }

    public byte getDot_file_type() {
        return this.dot_file_type;
    }

    public byte[] getDot_name() {
        return this.dot_name;
    }

    public int getDotdot_inode() {
        return this.dotdot_inode;
    }

    public short getDotdot_rec_len() {
        return this.dotdot_rec_len;
    }

    public byte getDotdot_name_len() {
        return this.dotdot_name_len;
    }

    public byte getDotdot_file_type() {
        return this.dotdot_file_type;
    }

    public byte[] getDotdot_name() {
        return this.dotdot_name;
    }

    public int getDx_root_info_reserved_zero() {
        return this.dx_root_info_reserved_zero;
    }

    public byte getDx_root_info_hash_version() {
        return this.dx_root_info_hash_version;
    }

    public byte getDx_root_info_info_length() {
        return this.dx_root_info_info_length;
    }

    public byte getDx_root_info_indirect_levels() {
        return this.dx_root_info_indirect_levels;
    }

    public byte getDx_root_info_unused_flags() {
        return this.dx_root_info_unused_flags;
    }

    public short getLimit() {
        return this.limit;
    }

    public short getCount() {
        return this.count;
    }

    public int getBlock() {
        return this.block;
    }

    public Ext4DxEntry[] getEntries() {
        return this.entries;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("dx_root", 0);
        structure.add(DWORD, "dot_inode", null);
        structure.add(WORD, "dot_rec_len", null);
        structure.add(BYTE, "dot_name_len", null);
        structure.add(BYTE, "dot_file_type", null);
        structure.add((DataType)new ArrayDataType(BYTE, 4, BYTE.getLength()), "dot_name", null);
        structure.add(DWORD, "dotdot_inode", null);
        structure.add(WORD, "dotdot_rec_len", null);
        structure.add(BYTE, "dotdot_name_len", null);
        structure.add(BYTE, "dotdot_file_type", null);
        structure.add((DataType)new ArrayDataType(BYTE, 4, BYTE.getLength()), "dotdot_name", null);
        structure.add(DWORD, "dx_root_info_reserved_zero", null);
        structure.add(BYTE, "dx_root_info_hash_version", null);
        structure.add(BYTE, "dx_root_info_info_length", null);
        structure.add(BYTE, "dx_root_info_indirect_levels", null);
        structure.add(BYTE, "dx_root_info_unused_flags", null);
        structure.add(WORD, "limit", null);
        structure.add(WORD, "count", null);
        structure.add(DWORD, "block", null);
        structure.add((DataType)new ArrayDataType(this.entries[0].toDataType(), (int)this.count, this.entries[0].toDataType().getLength()), "entries", null);
        return structure;
    }
}

