/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.file.formats.android.oat.oatdexfile;

import java.io.IOException;

import ghidra.app.util.bin.BinaryReader;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;

/**
 * Note: actual data structure seen in firmware does not contain the "canonical_dex_file_location_" field.
 * <br>
 * <a href="https://android.googlesource.com/platform/art/+/refs/heads/marshmallow-release/runtime/oat_file.h#405">marshmallow-release/runtime/oat_file.h</a>
 */
class OatDexFile_Marshmallow extends OatDexFile_Lollipop {

	OatDexFile_Marshmallow(BinaryReader reader) throws IOException {
		super(reader);
	}

	@Override
	public DataType toDataType() throws DuplicateNameException, IOException {
		DataType dataType = super.toDataType();
		try {
			dataType.setName(OatDexFile_Marshmallow.class.getSimpleName() + "_" +
				oat_class_offsets_pointer_.length);
		}
		catch (Exception e) {
			//ignore
		}
		return dataType;
	}

}
