/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocAndFloatFeatureBuffer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleScorable;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

class BatchScoreBulkScorer
extends BulkScorer {
    private final SimpleScorable scorable = new SimpleScorable();
    private final DocAndFloatFeatureBuffer buffer = new DocAndFloatFeatureBuffer();
    private final Scorer scorer;

    BatchScoreBulkScorer(Scorer scorer) {
        this.scorer = scorer;
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        if (collector.competitiveIterator() != null) {
            return new Weight.DefaultBulkScorer(this.scorer).score(collector, acceptDocs, min, max);
        }
        collector.setScorer(this.scorable);
        this.scorer.setMinCompetitiveScore(this.scorable.minCompetitiveScore);
        if (this.scorer.docID() < min) {
            this.scorer.iterator().advance(min);
        }
        this.scorer.nextDocsAndScores(max, acceptDocs, this.buffer);
        while (this.buffer.size > 0) {
            int size = this.buffer.size;
            for (int i = 0; i < size; ++i) {
                this.scorable.score = this.buffer.features[i];
                float score = this.scorable.score;
                if (!(score >= this.scorable.minCompetitiveScore)) continue;
                collector.collect(this.buffer.docs[i]);
            }
            this.scorer.setMinCompetitiveScore(this.scorable.minCompetitiveScore);
            this.scorer.nextDocsAndScores(max, acceptDocs, this.buffer);
        }
        return this.scorer.docID();
    }

    @Override
    public long cost() {
        return this.scorer.iterator().cost();
    }
}

