/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ism.AddPolicyResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class AddPolicyRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, AddPolicyRequest> {
    @Nullable
    private final String index;
    @Nonnull
    private final String policyId;
    public static final JsonpDeserializer<AddPolicyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AddPolicyRequest::setupAddPolicyRequestDeserializer);
    public static final Endpoint<AddPolicyRequest, AddPolicyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<AddPolicyRequest, AddPolicyResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_plugins/_ism/add";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ism/add/");
            SimpleEndpoint.pathEncode(request.index, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, AddPolicyResponse._DESERIALIZER);

    private AddPolicyRequest(Builder builder) {
        super(builder);
        this.index = builder.index;
        this.policyId = ApiTypeHelper.requireNonNull(builder.policyId, this, "policyId");
    }

    public static AddPolicyRequest of(Function<Builder, ObjectBuilder<AddPolicyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final String policyId() {
        return this.policyId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("policy_id");
        generator.write(this.policyId);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAddPolicyRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::policyId, JsonpDeserializer.stringDeserializer(), "policy_id");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + this.policyId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddPolicyRequest other = (AddPolicyRequest)o;
        return Objects.equals(this.index, other.index) && this.policyId.equals(other.policyId);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, AddPolicyRequest> {
        @Nullable
        private String index;
        private String policyId;

        public Builder() {
        }

        private Builder(AddPolicyRequest o) {
            super(o);
            this.index = o.index;
            this.policyId = o.policyId;
        }

        private Builder(Builder o) {
            super(o);
            this.index = o.index;
            this.policyId = o.policyId;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder policyId(String value) {
            this.policyId = value;
            return this;
        }

        @Override
        @Nonnull
        public AddPolicyRequest build() {
            this._checkSingleUse();
            return new AddPolicyRequest(this);
        }
    }
}

