/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TenantPermission
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, TenantPermission> {
    @Nonnull
    private final List<String> allowedActions;
    @Nonnull
    private final List<String> tenantPatterns;
    public static final JsonpDeserializer<TenantPermission> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TenantPermission::setupTenantPermissionDeserializer);

    private TenantPermission(Builder builder) {
        this.allowedActions = ApiTypeHelper.unmodifiable(builder.allowedActions);
        this.tenantPatterns = ApiTypeHelper.unmodifiable(builder.tenantPatterns);
    }

    public static TenantPermission of(Function<Builder, ObjectBuilder<TenantPermission>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> allowedActions() {
        return this.allowedActions;
    }

    @Nonnull
    public final List<String> tenantPatterns() {
        return this.tenantPatterns;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.allowedActions)) {
            generator.writeKey("allowed_actions");
            generator.writeStartArray();
            for (String item0 : this.allowedActions) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.tenantPatterns)) {
            generator.writeKey("tenant_patterns");
            generator.writeStartArray();
            for (String item0 : this.tenantPatterns) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTenantPermissionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowedActions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "allowed_actions");
        op.add(Builder::tenantPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tenant_patterns");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowedActions);
        result = 31 * result + Objects.hashCode(this.tenantPatterns);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantPermission other = (TenantPermission)o;
        return Objects.equals(this.allowedActions, other.allowedActions) && Objects.equals(this.tenantPatterns, other.tenantPatterns);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, TenantPermission> {
        @Nullable
        private List<String> allowedActions;
        @Nullable
        private List<String> tenantPatterns;

        public Builder() {
        }

        private Builder(TenantPermission o) {
            this.allowedActions = Builder._listCopy(o.allowedActions);
            this.tenantPatterns = Builder._listCopy(o.tenantPatterns);
        }

        private Builder(Builder o) {
            this.allowedActions = Builder._listCopy(o.allowedActions);
            this.tenantPatterns = Builder._listCopy(o.tenantPatterns);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder allowedActions(List<String> list) {
            this.allowedActions = Builder._listAddAll(this.allowedActions, list);
            return this;
        }

        @Nonnull
        public final Builder allowedActions(String value, String ... values) {
            this.allowedActions = Builder._listAdd(this.allowedActions, value, values);
            return this;
        }

        @Nonnull
        public final Builder tenantPatterns(List<String> list) {
            this.tenantPatterns = Builder._listAddAll(this.tenantPatterns, list);
            return this;
        }

        @Nonnull
        public final Builder tenantPatterns(String value, String ... values) {
            this.tenantPatterns = Builder._listAdd(this.tenantPatterns, value, values);
            return this;
        }

        @Override
        @Nonnull
        public TenantPermission build() {
            this._checkSingleUse();
            return new TenantPermission(this);
        }
    }
}

